//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/indexedDB/PBackgroundIndexedDBUtilsChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ProfilerMarkers.h"
#include "mozilla/dom/indexedDB/ActorsChild.h"
#include "mozilla/dom/quota/SerializationHelpers.h"

#include "mozilla/ipc/PBackgroundChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace indexedDB {


auto PBackgroundIndexedDBUtilsChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundIndexedDBUtilsChild::PBackgroundIndexedDBUtilsChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PBackgroundIndexedDBUtilsChild);
}

PBackgroundIndexedDBUtilsChild::~PBackgroundIndexedDBUtilsChild()
{
    MOZ_COUNT_DTOR(PBackgroundIndexedDBUtilsChild);
}

auto PBackgroundIndexedDBUtilsChild::ActorAlloc() -> void
{
}

auto PBackgroundIndexedDBUtilsChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PBackgroundIndexedDBUtilsChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundIndexedDBUtilsChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundIndexedDBUtilsChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundIndexedDBUtilsChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PBackgroundIndexedDBUtilsChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBackgroundIndexedDBUtilsChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBackgroundIndexedDBUtilsChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PBackgroundIndexedDBUtilsChild::SendDeleteMe() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIndexedDBUtils::Msg_DeleteMe(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIndexedDBUtils", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIndexedDBUtilsChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIndexedDBUtils::Msg_DeleteMe", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIndexedDBUtilsChild::SendGetFileReferences(
        const PersistenceType& persistenceType,
        const nsACString& origin,
        const nsAString& databaseName,
        const int64_t& fileId,
        int32_t* refCnt,
        int32_t* dBRefCnt,
        bool* result) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIndexedDBUtils::Msg_GetFileReferences(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), persistenceType);
    // Sentinel = 'persistenceType'
    ((&(writer__)))->WriteSentinel(853345864);
    IPC::WriteParam((&(writer__)), origin);
    // Sentinel = 'origin'
    ((&(writer__)))->WriteSentinel(150143625);
    IPC::WriteParam((&(writer__)), databaseName);
    // Sentinel = 'databaseName'
    ((&(writer__)))->WriteSentinel(517211319);
    IPC::WriteParam((&(writer__)), fileId);
    // Sentinel = 'fileId'
    ((&(writer__)))->WriteSentinel(139199054);



    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIndexedDBUtils", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIndexedDBUtilsChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIndexedDBUtils::Msg_GetFileReferences", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PBackgroundIndexedDBUtils::Msg_GetFileReferences", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIndexedDBUtils", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIndexedDBUtilsChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__refCnt__reply = IPC::ReadParam<int32_t>((&(reader__)));
    if (!maybe__refCnt__reply) {
        FatalError("Error deserializing 'int32_t'");
        return false;

    }
    auto& refCnt__reply = *maybe__refCnt__reply;
    // Sentinel = 'refCnt'
    if ((!(((&(reader__)))->ReadSentinel(140247651)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
        return false;
    }
    auto maybe__dBRefCnt__reply = IPC::ReadParam<int32_t>((&(reader__)));
    if (!maybe__dBRefCnt__reply) {
        FatalError("Error deserializing 'int32_t'");
        return false;

    }
    auto& dBRefCnt__reply = *maybe__dBRefCnt__reply;
    // Sentinel = 'dBRefCnt'
    if ((!(((&(reader__)))->ReadSentinel(210502377)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
        return false;
    }
    auto maybe__result__reply = IPC::ReadParam<bool>((&(reader__)));
    if (!maybe__result__reply) {
        FatalError("Error deserializing 'bool'");
        return false;

    }
    auto& result__reply = *maybe__result__reply;
    // Sentinel = 'result'
    if ((!(((&(reader__)))->ReadSentinel(153223840)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
        return false;
    }
    (*(refCnt)) = std::move(refCnt__reply);
    (*(dBRefCnt)) = std::move(dBRefCnt__reply);
    (*(result)) = std::move(result__reply);
    reader__.EndRead();

    return true;
}

auto PBackgroundIndexedDBUtilsChild::SendDoMaintenance(
        mozilla::ipc::ResolveCallback<nsresult>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIndexedDBUtils::Msg_DoMaintenance(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIndexedDBUtils", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIndexedDBUtilsChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIndexedDBUtils::Msg_DoMaintenance", OTHER);

    int32_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PBackgroundIndexedDBUtils::Reply_DoMaintenance__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__rv = IPC::ReadParam<nsresult>(aReader);
            if (!maybe__rv) {
                (aReader)->FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& rv = *maybe__rv;
            // Sentinel = 'rv'
            if ((!((aReader)->ReadSentinel(22806761)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(rv));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PBackgroundIndexedDBUtilsChild::SendDoMaintenance() -> RefPtr<DoMaintenancePromise>
{
    RefPtr<MozPromise<nsresult, ResponseRejectReason, true>::Private> promise__ = new MozPromise<nsresult, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendDoMaintenance([promise__](nsresult&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PBackgroundIndexedDBUtilsChild::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBackgroundIndexedDBUtilsChild::OnMessageReceived(const Message& msg__) -> PBackgroundIndexedDBUtilsChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundIndexedDBUtils::Reply_DoMaintenance__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIndexedDBUtils", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIndexedDBUtilsChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PBackgroundIndexedDBUtils::Msg_DoMaintenance", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PBackgroundIndexedDBUtils::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIndexedDBUtils", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIndexedDBUtilsChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIndexedDBUtils::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<indexedDB::BackgroundUtilsChild*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundIndexedDBUtilsChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundIndexedDBUtilsChild::Result
{
    return MsgNotKnown;
}



} // namespace indexedDB
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIndexedDBUtilsChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIndexedDBUtilsChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundIndexedDBUtils", PBackgroundIndexedDBUtilsMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::indexedDB::PBackgroundIndexedDBUtilsChild*>(actor.ref());
    }
    return {};
}

} // namespace IPC
