//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/indexedDB/PBackgroundIDBTransactionParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/indexedDB/ActorsChild.h"
#include "mozilla/dom/indexedDB/Key.h"
#include "mozilla/dom/indexedDB/KeyPath.h"
#include "mozilla/dom/indexedDB/SerializationHelpers.h"
#include "mozilla/dom/quota/SerializationHelpers.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/dom/indexedDB/PBackgroundIDBCursorParent.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBDatabaseParent.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBDatabaseFileParent.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBRequestParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace indexedDB {


auto PBackgroundIDBTransactionParent::RecvPBackgroundIDBCursorConstructor(
        PBackgroundIDBCursorParent* actor,
        const int64_t& requestId,
        const OpenCursorParams& params) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PBackgroundIDBTransactionParent::RecvPBackgroundIDBRequestConstructor(
        PBackgroundIDBRequestParent* actor,
        const int64_t& requestId,
        const RequestParams& params) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundIDBTransactionParent::PBackgroundIDBTransactionParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBackgroundIDBTransactionParent);
}

PBackgroundIDBTransactionParent::~PBackgroundIDBTransactionParent()
{
    MOZ_COUNT_DTOR(PBackgroundIDBTransactionParent);
}

auto PBackgroundIDBTransactionParent::ActorAlloc() -> void
{
    AddRef();
}

auto PBackgroundIDBTransactionParent::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundIDBTransactionParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundIDBTransactionParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundIDBTransactionParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundIDBTransactionParent::Manager() const -> PBackgroundIDBDatabaseParent*
{
    return static_cast<PBackgroundIDBDatabaseParent*>(IProtocol::Manager());
}

auto PBackgroundIDBTransactionParent::ManagedPBackgroundIDBCursorParent(nsTArray<PBackgroundIDBCursorParent*>& aArr) const -> void
{
    mManagedPBackgroundIDBCursorParent.ToArray(aArr);
}

auto PBackgroundIDBTransactionParent::ManagedPBackgroundIDBCursorParent() const -> const ManagedContainer<PBackgroundIDBCursorParent>&
{
    return mManagedPBackgroundIDBCursorParent;
}

auto PBackgroundIDBTransactionParent::ManagedPBackgroundIDBRequestParent(nsTArray<PBackgroundIDBRequestParent*>& aArr) const -> void
{
    mManagedPBackgroundIDBRequestParent.ToArray(aArr);
}

auto PBackgroundIDBTransactionParent::ManagedPBackgroundIDBRequestParent() const -> const ManagedContainer<PBackgroundIDBRequestParent>&
{
    return mManagedPBackgroundIDBRequestParent;
}

auto PBackgroundIDBTransactionParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PBackgroundIDBCursorMsgStart,
        PBackgroundIDBRequestMsgStart
    };
    return sIds;
}

auto PBackgroundIDBTransactionParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PBackgroundIDBCursorMsgStart:
        return (&(mManagedPBackgroundIDBCursorParent));
    case PBackgroundIDBRequestMsgStart:
        return (&(mManagedPBackgroundIDBRequestParent));
    default:
        return nullptr;
    }
}

auto PBackgroundIDBTransactionParent::OpenPBackgroundIDBCursorEndpoint(PBackgroundIDBCursorParent* aActor) -> ManagedEndpoint<PBackgroundIDBCursorChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBCursorParent actor");
        return ManagedEndpoint<PBackgroundIDBCursorChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBCursorParent actor");
        return ManagedEndpoint<PBackgroundIDBCursorChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBCursorChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBTransactionParent::BindPBackgroundIDBCursorEndpoint(
        ManagedEndpoint<PBackgroundIDBCursorParent> aEndpoint,
        PBackgroundIDBCursorParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBTransactionParent::OpenPBackgroundIDBRequestEndpoint(PBackgroundIDBRequestParent* aActor) -> ManagedEndpoint<PBackgroundIDBRequestChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBRequestParent actor");
        return ManagedEndpoint<PBackgroundIDBRequestChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBRequestParent actor");
        return ManagedEndpoint<PBackgroundIDBRequestChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBRequestChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBTransactionParent::BindPBackgroundIDBRequestEndpoint(
        ManagedEndpoint<PBackgroundIDBRequestParent> aEndpoint,
        PBackgroundIDBRequestParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBTransactionParent::Send__delete__(PBackgroundIDBTransactionParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBTransaction::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBTransactionParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBackgroundIDBTransactionParent::SendComplete(const nsresult& result) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBTransaction::Msg_Complete(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), result);
    // Sentinel = 'result'
    ((&(writer__)))->WriteSentinel(153223840);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBTransactionParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg_Complete", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBTransactionParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PBackgroundIDBRequestMsgStart:
        this->DeallocPBackgroundIDBRequestParent(static_cast<PBackgroundIDBRequestParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PBackgroundIDBTransactionParent::OnMessageReceived(const Message& msg__) -> PBackgroundIDBTransactionParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundIDBTransaction::Msg_DeleteMe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg_DeleteMe", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteMe();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBTransaction::Msg_Commit__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg_Commit", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__lastRequest = IPC::ReadParam<mozilla::Maybe<int64_t>>((&(reader__)));
            if (!maybe__lastRequest) {
                FatalError("Error deserializing 'int64_t?'");
                return MsgValueError;

            }
            auto& lastRequest = *maybe__lastRequest;
            // Sentinel = 'lastRequest'
            if ((!(((&(reader__)))->ReadSentinel(458359966)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCommit(std::move(lastRequest));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBTransaction::Msg_Abort__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg_Abort", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__resultCode = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__resultCode) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& resultCode = *maybe__resultCode;
            // Sentinel = 'resultCode'
            if ((!(((&(reader__)))->ReadSentinel(388498459)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvAbort(std::move(resultCode));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBTransaction::Msg_PBackgroundIDBCursorConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg_PBackgroundIDBCursorConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__requestId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__requestId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& requestId = *maybe__requestId;
            // Sentinel = 'requestId'
            if ((!(((&(reader__)))->ReadSentinel(320799671)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__params = IPC::ReadParam<OpenCursorParams>((&(reader__)));
            if (!maybe__params) {
                FatalError("Error deserializing 'OpenCursorParams'");
                return MsgValueError;

            }
            auto& params = *maybe__params;
            // Sentinel = 'params'
            if ((!(((&(reader__)))->ReadSentinel(146997893)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OpenCursorParams'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PBackgroundIDBCursorParent> actor = (this)->AllocPBackgroundIDBCursorParent(requestId, params);
            if (!actor) {
                NS_WARNING("Cannot bind null PBackgroundIDBCursorParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PBackgroundIDBCursorParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (this)->RecvPBackgroundIDBCursorConstructor(actor, std::move(requestId), std::move(params));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBTransaction::Msg_PBackgroundIDBRequestConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBTransactionParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg_PBackgroundIDBRequestConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__requestId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__requestId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& requestId = *maybe__requestId;
            // Sentinel = 'requestId'
            if ((!(((&(reader__)))->ReadSentinel(320799671)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__params = IPC::ReadParam<RequestParams>((&(reader__)));
            if (!maybe__params) {
                FatalError("Error deserializing 'RequestParams'");
                return MsgValueError;

            }
            auto& params = *maybe__params;
            // Sentinel = 'params'
            if ((!(((&(reader__)))->ReadSentinel(146997893)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RequestParams'");
                return MsgValueError;
            }
            reader__.EndRead();
            PBackgroundIDBRequestParent* actor = (this)->AllocPBackgroundIDBRequestParent(requestId, params);
            if (!actor) {
                NS_WARNING("Cannot bind null PBackgroundIDBRequestParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PBackgroundIDBRequestParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (this)->RecvPBackgroundIDBRequestConstructor(std::move(actor), std::move(requestId), std::move(params));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBTransaction::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundIDBTransactionParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundIDBTransactionParent::Result
{
    return MsgNotKnown;
}



} // namespace indexedDB
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBTransactionParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBTransactionParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundIDBTransaction", PBackgroundIDBTransactionMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::indexedDB::PBackgroundIDBTransactionParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
