//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/indexedDB/PBackgroundIDBDatabaseParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/RemoteLazyInputStream.h"
#include "mozilla/dom/indexedDB/ActorsChild.h"
#include "mozilla/dom/indexedDB/Key.h"
#include "mozilla/dom/indexedDB/KeyPath.h"
#include "mozilla/dom/indexedDB/SerializationHelpers.h"
#include "mozilla/dom/quota/SerializationHelpers.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/dom/indexedDB/PBackgroundIDBDatabaseFileParent.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBFactoryParent.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBTransactionParent.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBVersionChangeTransactionParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace indexedDB {


auto PBackgroundIDBDatabaseParent::RecvPBackgroundIDBDatabaseFileConstructor(
        PBackgroundIDBDatabaseFileParent* actor,
        const IPCBlob& blob) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PBackgroundIDBDatabaseParent::RecvPBackgroundIDBTransactionConstructor(
        PBackgroundIDBTransactionParent* actor,
        nsTArray<nsString>&& objectStoreNames,
        const Mode& mode,
        const Durability& durability) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundIDBDatabaseParent::PBackgroundIDBDatabaseParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PBackgroundIDBDatabaseParent);
}

PBackgroundIDBDatabaseParent::~PBackgroundIDBDatabaseParent()
{
    MOZ_COUNT_DTOR(PBackgroundIDBDatabaseParent);
}

auto PBackgroundIDBDatabaseParent::ActorAlloc() -> void
{
    AddRef();
}

auto PBackgroundIDBDatabaseParent::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundIDBDatabaseParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundIDBDatabaseParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundIDBDatabaseParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundIDBDatabaseParent::Manager() const -> PBackgroundIDBFactoryParent*
{
    return static_cast<PBackgroundIDBFactoryParent*>(IProtocol::Manager());
}

auto PBackgroundIDBDatabaseParent::ManagedPBackgroundIDBDatabaseFileParent(nsTArray<PBackgroundIDBDatabaseFileParent*>& aArr) const -> void
{
    mManagedPBackgroundIDBDatabaseFileParent.ToArray(aArr);
}

auto PBackgroundIDBDatabaseParent::ManagedPBackgroundIDBDatabaseFileParent() const -> const ManagedContainer<PBackgroundIDBDatabaseFileParent>&
{
    return mManagedPBackgroundIDBDatabaseFileParent;
}

auto PBackgroundIDBDatabaseParent::ManagedPBackgroundIDBTransactionParent(nsTArray<PBackgroundIDBTransactionParent*>& aArr) const -> void
{
    mManagedPBackgroundIDBTransactionParent.ToArray(aArr);
}

auto PBackgroundIDBDatabaseParent::ManagedPBackgroundIDBTransactionParent() const -> const ManagedContainer<PBackgroundIDBTransactionParent>&
{
    return mManagedPBackgroundIDBTransactionParent;
}

auto PBackgroundIDBDatabaseParent::ManagedPBackgroundIDBVersionChangeTransactionParent(nsTArray<PBackgroundIDBVersionChangeTransactionParent*>& aArr) const -> void
{
    mManagedPBackgroundIDBVersionChangeTransactionParent.ToArray(aArr);
}

auto PBackgroundIDBDatabaseParent::ManagedPBackgroundIDBVersionChangeTransactionParent() const -> const ManagedContainer<PBackgroundIDBVersionChangeTransactionParent>&
{
    return mManagedPBackgroundIDBVersionChangeTransactionParent;
}

auto PBackgroundIDBDatabaseParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PBackgroundIDBDatabaseFileMsgStart,
        PBackgroundIDBTransactionMsgStart,
        PBackgroundIDBVersionChangeTransactionMsgStart
    };
    return sIds;
}

auto PBackgroundIDBDatabaseParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PBackgroundIDBDatabaseFileMsgStart:
        return (&(mManagedPBackgroundIDBDatabaseFileParent));
    case PBackgroundIDBTransactionMsgStart:
        return (&(mManagedPBackgroundIDBTransactionParent));
    case PBackgroundIDBVersionChangeTransactionMsgStart:
        return (&(mManagedPBackgroundIDBVersionChangeTransactionParent));
    default:
        return nullptr;
    }
}

auto PBackgroundIDBDatabaseParent::OpenPBackgroundIDBDatabaseFileEndpoint(PBackgroundIDBDatabaseFileParent* aActor) -> ManagedEndpoint<PBackgroundIDBDatabaseFileChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBDatabaseFileParent actor");
        return ManagedEndpoint<PBackgroundIDBDatabaseFileChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBDatabaseFileParent actor");
        return ManagedEndpoint<PBackgroundIDBDatabaseFileChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBDatabaseFileChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBDatabaseParent::BindPBackgroundIDBDatabaseFileEndpoint(
        ManagedEndpoint<PBackgroundIDBDatabaseFileParent> aEndpoint,
        PBackgroundIDBDatabaseFileParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBDatabaseParent::OpenPBackgroundIDBTransactionEndpoint(PBackgroundIDBTransactionParent* aActor) -> ManagedEndpoint<PBackgroundIDBTransactionChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBTransactionParent actor");
        return ManagedEndpoint<PBackgroundIDBTransactionChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBTransactionParent actor");
        return ManagedEndpoint<PBackgroundIDBTransactionChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBTransactionChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBDatabaseParent::BindPBackgroundIDBTransactionEndpoint(
        ManagedEndpoint<PBackgroundIDBTransactionParent> aEndpoint,
        PBackgroundIDBTransactionParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBDatabaseParent::OpenPBackgroundIDBVersionChangeTransactionEndpoint(PBackgroundIDBVersionChangeTransactionParent* aActor) -> ManagedEndpoint<PBackgroundIDBVersionChangeTransactionChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBVersionChangeTransactionParent actor");
        return ManagedEndpoint<PBackgroundIDBVersionChangeTransactionChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBVersionChangeTransactionParent actor");
        return ManagedEndpoint<PBackgroundIDBVersionChangeTransactionChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBVersionChangeTransactionChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBDatabaseParent::BindPBackgroundIDBVersionChangeTransactionEndpoint(
        ManagedEndpoint<PBackgroundIDBVersionChangeTransactionParent> aEndpoint,
        PBackgroundIDBVersionChangeTransactionParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBDatabaseParent::Send__delete__(PBackgroundIDBDatabaseParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBDatabase::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBDatabaseParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PBackgroundIDBDatabaseParent::SendVersionChange(
        const uint64_t& oldVersion,
        const mozilla::Maybe<uint64_t>& newVersion) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBDatabase::Msg_VersionChange(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), oldVersion);
    // Sentinel = 'oldVersion'
    ((&(writer__)))->WriteSentinel(378602534);
    IPC::WriteParam((&(writer__)), newVersion);
    // Sentinel = 'newVersion'
    ((&(writer__)))->WriteSentinel(383779889);




    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBDatabaseParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_VersionChange", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBDatabaseParent::SendInvalidate() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBDatabase::Msg_Invalidate(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBDatabaseParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_Invalidate", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBDatabaseParent::SendCloseAfterInvalidationComplete() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBDatabase::Msg_CloseAfterInvalidationComplete(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};





    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBDatabaseParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_CloseAfterInvalidationComplete", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBDatabaseParent::SendPBackgroundIDBVersionChangeTransactionConstructor(
        PBackgroundIDBVersionChangeTransactionParent* actor,
        const uint64_t& currentVersion,
        const uint64_t& requestedVersion,
        const int64_t& nextObjectStoreId,
        const int64_t& nextIndexId) -> PBackgroundIDBVersionChangeTransactionParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PBackgroundIDBVersionChangeTransactionParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBVersionChangeTransactionParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBDatabase::Msg_PBackgroundIDBVersionChangeTransactionConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), actor);
    // Sentinel = 'actor'
    ((&(writer__)))->WriteSentinel(102892058);
    IPC::WriteParam((&(writer__)), currentVersion);
    // Sentinel = 'currentVersion'
    ((&(writer__)))->WriteSentinel(744228330);
    IPC::WriteParam((&(writer__)), requestedVersion);
    // Sentinel = 'requestedVersion'
    ((&(writer__)))->WriteSentinel(962660025);
    IPC::WriteParam((&(writer__)), nextObjectStoreId);
    // Sentinel = 'nextObjectStoreId'
    ((&(writer__)))->WriteSentinel(1046087377);
    IPC::WriteParam((&(writer__)), nextIndexId);
    // Sentinel = 'nextIndexId'
    ((&(writer__)))->WriteSentinel(453510245);




    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBDatabaseParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_PBackgroundIDBVersionChangeTransactionConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PBackgroundIDBVersionChangeTransactionParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PBackgroundIDBDatabaseParent::DeallocManagee(
        int32_t aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PBackgroundIDBDatabaseFileMsgStart:
        this->DeallocPBackgroundIDBDatabaseFileParent(static_cast<PBackgroundIDBDatabaseFileParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PBackgroundIDBDatabaseParent::OnMessageReceived(const Message& msg__) -> PBackgroundIDBDatabaseParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Msg_DeleteMe__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBDatabaseParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_DeleteMe", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteMe();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Msg_Blocked__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBDatabaseParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_Blocked", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvBlocked();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Msg_Close__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBDatabaseParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_Close", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvClose();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Msg_PBackgroundIDBDatabaseFileConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBDatabaseParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_PBackgroundIDBDatabaseFileConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__blob = IPC::ReadParam<IPCBlob>((&(reader__)));
            if (!maybe__blob) {
                FatalError("Error deserializing 'IPCBlob'");
                return MsgValueError;

            }
            auto& blob = *maybe__blob;
            // Sentinel = 'blob'
            if ((!(((&(reader__)))->ReadSentinel(68157856)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IPCBlob'");
                return MsgValueError;
            }
            reader__.EndRead();
            PBackgroundIDBDatabaseFileParent* actor = (this)->AllocPBackgroundIDBDatabaseFileParent(blob);
            if (!actor) {
                NS_WARNING("Cannot bind null PBackgroundIDBDatabaseFileParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PBackgroundIDBDatabaseFileParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (this)->RecvPBackgroundIDBDatabaseFileConstructor(std::move(actor), std::move(blob));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Msg_PBackgroundIDBTransactionConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBDatabaseParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_PBackgroundIDBTransactionConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__handle__ = IPC::ReadParam<ActorHandle>((&(reader__)));
            if (!maybe__handle__) {
                FatalError("Error deserializing 'ActorHandle'");
                return MsgValueError;

            }
            auto& handle__ = *maybe__handle__;
            // Sentinel = 'actor'
            if ((!(((&(reader__)))->ReadSentinel(102892058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorHandle'");
                return MsgValueError;
            }
            auto maybe__objectStoreNames = IPC::ReadParam<nsTArray<nsString>>((&(reader__)));
            if (!maybe__objectStoreNames) {
                FatalError("Error deserializing 'nsString[]'");
                return MsgValueError;

            }
            auto& objectStoreNames = *maybe__objectStoreNames;
            // Sentinel = 'objectStoreNames'
            if ((!(((&(reader__)))->ReadSentinel(924780153)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString[]'");
                return MsgValueError;
            }
            auto maybe__mode = IPC::ReadParam<Mode>((&(reader__)));
            if (!maybe__mode) {
                FatalError("Error deserializing 'Mode'");
                return MsgValueError;

            }
            auto& mode = *maybe__mode;
            // Sentinel = 'mode'
            if ((!(((&(reader__)))->ReadSentinel(70386086)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Mode'");
                return MsgValueError;
            }
            auto maybe__durability = IPC::ReadParam<Durability>((&(reader__)));
            if (!maybe__durability) {
                FatalError("Error deserializing 'Durability'");
                return MsgValueError;

            }
            auto& durability = *maybe__durability;
            // Sentinel = 'durability'
            if ((!(((&(reader__)))->ReadSentinel(384500794)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Durability'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PBackgroundIDBTransactionParent> actor = (this)->AllocPBackgroundIDBTransactionParent(objectStoreNames, mode, durability);
            if (!actor) {
                NS_WARNING("Cannot bind null PBackgroundIDBTransactionParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, (handle__).mId)) {
                NS_WARNING("Failed to bind PBackgroundIDBTransactionParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (this)->RecvPBackgroundIDBTransactionConstructor(actor, std::move(objectStoreNames), std::move(mode), std::move(durability));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Reply_PBackgroundIDBVersionChangeTransactionConstructor__ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundIDBDatabaseParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundIDBDatabaseParent::Result
{
    return MsgNotKnown;
}



} // namespace indexedDB
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBDatabaseParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    MOZ_RELEASE_ASSERT(
        aWriter->GetActor(),
        "Cannot serialize managed actors without an actor");

    int32_t id;
    if (!aVar) {
        id = 0;  // kNullActorId
    } else {
        id = aVar->Id();
        if (id == 1) {  // kFreedActorId
            aVar->FatalError("Actor has been |delete|d");
        }
        MOZ_RELEASE_ASSERT(
            aWriter->GetActor()->GetIPCChannel() == aVar->GetIPCChannel(),
            "Actor must be from the same channel as the"
            " actor it's being sent over");
        MOZ_RELEASE_ASSERT(
            aVar->CanSend(),
            "Actor must still be open when sending");
    }

    IPC::WriteParam(aWriter, id);
}

auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBDatabaseParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    MOZ_RELEASE_ASSERT(
        aReader->GetActor(),
        "Cannot deserialize managed actors without an actor");
    mozilla::Maybe<mozilla::ipc::IProtocol*> actor = aReader->GetActor()
        ->ReadActor(aReader, true, "PBackgroundIDBDatabase", PBackgroundIDBDatabaseMsgStart);
    if (actor.isSome()) {
        return static_cast<::mozilla::dom::indexedDB::PBackgroundIDBDatabaseParent*>(actor.ref());
    }
    return {};
}

} // namespace IPC
