/* THIS FILE IS AUTOGENERATED FROM VideoFrame.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "VideoFrameBinding.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "jsfriendapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMRect.h"
#include "mozilla/dom/HTMLCanvasElement.h"
#include "mozilla/dom/HTMLImageElement.h"
#include "mozilla/dom/HTMLVideoElement.h"
#include "mozilla/dom/ImageBitmap.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/OffscreenCanvas.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/SVGImageElement.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionTypes.h"
#include "mozilla/dom/VideoColorSpace.h"
#include "mozilla/dom/VideoFrame.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsThreadUtils.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<AlphaOption>::Values[2];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, AlphaOption aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<AlphaOption>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<AlphaOption>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<AlphaOption>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<VideoPixelFormat>::Values[23];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, VideoPixelFormat aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<VideoPixelFormat>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<VideoPixelFormat>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<VideoPixelFormat>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}



PlaneLayout::PlaneLayout()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
PlaneLayout::InitIds(JSContext* cx, PlaneLayoutAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->stride_id.init(cx, "stride") ||
      !atomsCache->offset_id.init(cx, "offset")) {
    return false;
  }
  return true;
}

bool
PlaneLayout::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  PlaneLayoutAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<PlaneLayoutAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->offset_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'offset' member of PlaneLayout", &mOffset)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'offset' member of PlaneLayout");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->stride_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'stride' member of PlaneLayout", &mStride)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'stride' member of PlaneLayout");
  }
  return true;
}

bool
PlaneLayout::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
PlaneLayout::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  PlaneLayoutAtoms* atomsCache = GetAtomCache<PlaneLayoutAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mOffset;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->offset_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mStride;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->stride_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
PlaneLayout::TraceDictionary(JSTracer* trc)
{
}

PlaneLayout&
PlaneLayout::operator=(const PlaneLayout& aOther)
{
  DictionaryBase::operator=(aOther);
  mOffset = aOther.mOffset;
  mStride = aOther.mStride;
  return *this;
}



VideoFrameInit::VideoFrameInit()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
VideoFrameInit::InitIds(JSContext* cx, VideoFrameInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->visibleRect_id.init(cx, "visibleRect") ||
      !atomsCache->timestamp_id.init(cx, "timestamp") ||
      !atomsCache->duration_id.init(cx, "duration") ||
      !atomsCache->displayWidth_id.init(cx, "displayWidth") ||
      !atomsCache->displayHeight_id.init(cx, "displayHeight") ||
      !atomsCache->alpha_id.init(cx, "alpha")) {
    return false;
  }
  return true;
}

bool
VideoFrameInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  VideoFrameInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<VideoFrameInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->alpha_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<AlphaOption>::Values,
                                                                         "AlphaOption", "'alpha' member of VideoFrameInit",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mAlpha = static_cast<AlphaOption>(index);
    }
  } else {
    mAlpha = AlphaOption::Keep;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->displayHeight_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mDisplayHeight.Construct();
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'displayHeight' member of VideoFrameInit", &(mDisplayHeight.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->displayWidth_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mDisplayWidth.Construct();
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'displayWidth' member of VideoFrameInit", &(mDisplayWidth.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->duration_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mDuration.Construct();
    if (!ValueToPrimitive<uint64_t, eDefault>(cx, temp.ref(), "'duration' member of VideoFrameInit", &(mDuration.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->timestamp_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mTimestamp.Construct();
    if (!ValueToPrimitive<int64_t, eDefault>(cx, temp.ref(), "'timestamp' member of VideoFrameInit", &(mTimestamp.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->visibleRect_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mVisibleRect.Construct();
    if (!(mVisibleRect.Value()).Init(cx, temp.ref(), "'visibleRect' member of VideoFrameInit", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
VideoFrameInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
VideoFrameInit::TraceDictionary(JSTracer* trc)
{
}

VideoFrameInit&
VideoFrameInit::operator=(const VideoFrameInit& aOther)
{
  DictionaryBase::operator=(aOther);
  mAlpha = aOther.mAlpha;
  mDisplayHeight.Reset();
  if (aOther.mDisplayHeight.WasPassed()) {
    mDisplayHeight.Construct(aOther.mDisplayHeight.Value());
  }
  mDisplayWidth.Reset();
  if (aOther.mDisplayWidth.WasPassed()) {
    mDisplayWidth.Construct(aOther.mDisplayWidth.Value());
  }
  mDuration.Reset();
  if (aOther.mDuration.WasPassed()) {
    mDuration.Construct(aOther.mDuration.Value());
  }
  mTimestamp.Reset();
  if (aOther.mTimestamp.WasPassed()) {
    mTimestamp.Construct(aOther.mTimestamp.Value());
  }
  mVisibleRect.Reset();
  if (aOther.mVisibleRect.WasPassed()) {
    mVisibleRect.Construct(aOther.mVisibleRect.Value());
  }
  return *this;
}



VideoFrameBufferInit::VideoFrameBufferInit()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
VideoFrameBufferInit::InitIds(JSContext* cx, VideoFrameBufferInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->visibleRect_id.init(cx, "visibleRect") ||
      !atomsCache->timestamp_id.init(cx, "timestamp") ||
      !atomsCache->layout_id.init(cx, "layout") ||
      !atomsCache->format_id.init(cx, "format") ||
      !atomsCache->duration_id.init(cx, "duration") ||
      !atomsCache->displayWidth_id.init(cx, "displayWidth") ||
      !atomsCache->displayHeight_id.init(cx, "displayHeight") ||
      !atomsCache->colorSpace_id.init(cx, "colorSpace") ||
      !atomsCache->codedWidth_id.init(cx, "codedWidth") ||
      !atomsCache->codedHeight_id.init(cx, "codedHeight")) {
    return false;
  }
  return true;
}

bool
VideoFrameBufferInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  VideoFrameBufferInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<VideoFrameBufferInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->codedHeight_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'codedHeight' member of VideoFrameBufferInit", &mCodedHeight)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'codedHeight' member of VideoFrameBufferInit");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->codedWidth_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'codedWidth' member of VideoFrameBufferInit", &mCodedWidth)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'codedWidth' member of VideoFrameBufferInit");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->colorSpace_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mColorSpace.Construct();
    if (!(mColorSpace.Value()).Init(cx, temp.ref(), "'colorSpace' member of VideoFrameBufferInit", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->displayHeight_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mDisplayHeight.Construct();
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'displayHeight' member of VideoFrameBufferInit", &(mDisplayHeight.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->displayWidth_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mDisplayWidth.Construct();
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'displayWidth' member of VideoFrameBufferInit", &(mDisplayWidth.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->duration_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mDuration.Construct();
    if (!ValueToPrimitive<uint64_t, eEnforceRange>(cx, temp.ref(), "'duration' member of VideoFrameBufferInit", &(mDuration.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->format_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<VideoPixelFormat>::Values,
                                                                         "VideoPixelFormat", "'format' member of VideoFrameBufferInit",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mFormat = static_cast<VideoPixelFormat>(index);
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'format' member of VideoFrameBufferInit");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->layout_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mLayout.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'layout' member of VideoFrameBufferInit", "sequence");
        return false;
      }
      Sequence<PlaneLayout> &arr = (mLayout.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        PlaneLayout* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        PlaneLayout& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'layout' member of VideoFrameBufferInit", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'layout' member of VideoFrameBufferInit", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->timestamp_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int64_t, eEnforceRange>(cx, temp.ref(), "'timestamp' member of VideoFrameBufferInit", &mTimestamp)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'timestamp' member of VideoFrameBufferInit");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->visibleRect_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mVisibleRect.Construct();
    if (!(mVisibleRect.Value()).Init(cx, temp.ref(), "'visibleRect' member of VideoFrameBufferInit", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
VideoFrameBufferInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
VideoFrameBufferInit::TraceDictionary(JSTracer* trc)
{
}

VideoFrameBufferInit&
VideoFrameBufferInit::operator=(const VideoFrameBufferInit& aOther)
{
  DictionaryBase::operator=(aOther);
  mCodedHeight = aOther.mCodedHeight;
  mCodedWidth = aOther.mCodedWidth;
  mColorSpace.Reset();
  if (aOther.mColorSpace.WasPassed()) {
    mColorSpace.Construct(aOther.mColorSpace.Value());
  }
  mDisplayHeight.Reset();
  if (aOther.mDisplayHeight.WasPassed()) {
    mDisplayHeight.Construct(aOther.mDisplayHeight.Value());
  }
  mDisplayWidth.Reset();
  if (aOther.mDisplayWidth.WasPassed()) {
    mDisplayWidth.Construct(aOther.mDisplayWidth.Value());
  }
  mDuration.Reset();
  if (aOther.mDuration.WasPassed()) {
    mDuration.Construct(aOther.mDuration.Value());
  }
  mFormat = aOther.mFormat;
  mLayout.Reset();
  if (aOther.mLayout.WasPassed()) {
    mLayout.Construct(aOther.mLayout.Value());
  }
  mTimestamp = aOther.mTimestamp;
  mVisibleRect.Reset();
  if (aOther.mVisibleRect.WasPassed()) {
    mVisibleRect.Construct(aOther.mVisibleRect.Value());
  }
  return *this;
}



VideoFrameCopyToOptions::VideoFrameCopyToOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
VideoFrameCopyToOptions::InitIds(JSContext* cx, VideoFrameCopyToOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->rect_id.init(cx, "rect") ||
      !atomsCache->layout_id.init(cx, "layout") ||
      !atomsCache->format_id.init(cx, "format") ||
      !atomsCache->colorSpace_id.init(cx, "colorSpace")) {
    return false;
  }
  return true;
}

bool
VideoFrameCopyToOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  VideoFrameCopyToOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<VideoFrameCopyToOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->colorSpace_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mColorSpace.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<PredefinedColorSpace>::Values,
                                                                         "PredefinedColorSpace", "'colorSpace' member of VideoFrameCopyToOptions",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mColorSpace.Value()) = static_cast<PredefinedColorSpace>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->format_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mFormat.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<VideoPixelFormat>::Values,
                                                                         "VideoPixelFormat", "'format' member of VideoFrameCopyToOptions",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mFormat.Value()) = static_cast<VideoPixelFormat>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->layout_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mLayout.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'layout' member of VideoFrameCopyToOptions", "sequence");
        return false;
      }
      Sequence<PlaneLayout> &arr = (mLayout.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        PlaneLayout* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        PlaneLayout& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'layout' member of VideoFrameCopyToOptions", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'layout' member of VideoFrameCopyToOptions", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->rect_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mRect.Construct();
    if (!(mRect.Value()).Init(cx, temp.ref(), "'rect' member of VideoFrameCopyToOptions", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
VideoFrameCopyToOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
VideoFrameCopyToOptions::TraceDictionary(JSTracer* trc)
{
}

VideoFrameCopyToOptions&
VideoFrameCopyToOptions::operator=(const VideoFrameCopyToOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mColorSpace.Reset();
  if (aOther.mColorSpace.WasPassed()) {
    mColorSpace.Construct(aOther.mColorSpace.Value());
  }
  mFormat.Reset();
  if (aOther.mFormat.WasPassed()) {
    mFormat.Construct(aOther.mFormat.Value());
  }
  mLayout.Reset();
  if (aOther.mLayout.WasPassed()) {
    mLayout.Construct(aOther.mLayout.Value());
  }
  mRect.Reset();
  if (aOther.mRect.WasPassed()) {
    mRect.Construct(aOther.mRect.Value());
  }
  return *this;
}


namespace VideoFrame_Binding {

MOZ_CAN_RUN_SCRIPT static bool
get_format(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "format", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  Nullable<VideoPixelFormat> result(MOZ_KnownLive(self)->GetFormat());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  } else {
    if (!ToJSValue(cx, result.Value(), args.rval())) {
      return false;
    }
    return true;
  }
}

static const JSJitInfo format_getterinfo = {
  { get_format },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_codedWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "codedWidth", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->CodedWidth());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo codedWidth_getterinfo = {
  { get_codedWidth },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_codedHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "codedHeight", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->CodedHeight());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo codedHeight_getterinfo = {
  { get_codedHeight },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_codedRect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "codedRect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::DOMRectReadOnly>(MOZ_KnownLive(self)->GetCodedRect()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo codedRect_getterinfo = {
  { get_codedRect },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_visibleRect(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "visibleRect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::DOMRectReadOnly>(MOZ_KnownLive(self)->GetVisibleRect()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo visibleRect_getterinfo = {
  { get_visibleRect },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_displayWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "displayWidth", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->DisplayWidth());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo displayWidth_getterinfo = {
  { get_displayWidth },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_displayHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "displayHeight", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->DisplayHeight());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo displayHeight_getterinfo = {
  { get_displayHeight },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_duration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "duration", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  Nullable<uint64_t> result(MOZ_KnownLive(self)->GetDuration());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  args.rval().set(JS_NumberValue(double(result.Value())));
  return true;
}

static const JSJitInfo duration_getterinfo = {
  { get_duration },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_timestamp(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "timestamp", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  int64_t result(MOZ_KnownLive(self)->Timestamp());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

static const JSJitInfo timestamp_getterinfo = {
  { get_timestamp },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_colorSpace(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "colorSpace", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::VideoColorSpace>(MOZ_KnownLive(self)->ColorSpace()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo colorSpace_getterinfo = {
  { get_colorSpace },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
allocationSize(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "VideoFrame.allocationSize");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "allocationSize", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  binding_detail::FastVideoFrameCopyToOptions arg0;
  if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", false)) {
    return false;
  }
  FastErrorResult rv;
  uint32_t result(MOZ_KnownLive(self)->AllocationSize(Constify(arg0), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame.allocationSize"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo allocationSize_methodinfo = {
  { (JSJitGetterOp)allocationSize },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
copyTo(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "VideoFrame.copyTo");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "copyTo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  if (!args.requireAtLeast(cx, "VideoFrame.copyTo", 1)) {
    return false;
  }
  MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  binding_detail::FastVideoFrameCopyToOptions arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->CopyTo(Constify(arg0), Constify(arg1), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame.copyTo"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
copyTo_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = copyTo(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo copyTo_methodinfo = {
  { (JSJitGetterOp)copyTo_promiseWrapper },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clone(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "clone", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(MOZ_KnownLive(self)->Clone(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame.clone"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo clone_methodinfo = {
  { (JSJitGetterOp)clone },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
close(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "close", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::VideoFrame*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Close())>, "Should be returning void here");
  MOZ_KnownLive(self)->Close();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo close_methodinfo = {
  { (JSJitGetterOp)close },
  { prototypes::id::VideoFrame },
  { PrototypeTraits<prototypes::id::VideoFrame>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::VideoFrame* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::VideoFrame>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::VideoFrame>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("allocationSize", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&allocationSize_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("copyTo", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&copyTo_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clone", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clone_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("close", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&close_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("format", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &format_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("codedWidth", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &codedWidth_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("codedHeight", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &codedHeight_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("codedRect", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &codedRect_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("visibleRect", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &visibleRect_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("displayWidth", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &displayWidth_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("displayHeight", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &displayHeight_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("duration", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &duration_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("timestamp", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &timestamp_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("colorSpace", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &colorSpace_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(10 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[14];
static PropertyInfo sNativeProperties_propertyInfos[14];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  14,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[4] }
  }
};
static_assert(14 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::VideoFrame,
  constructors::id::VideoFrame,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "VideoFrame constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "VideoFrame", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "VideoFrame");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::VideoFrame,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  unsigned argcount = std::min(args.length(), 2u);
  switch (argcount) {
    case 1: {
      if (args[0].isObject()) {
        do {
          NonNull<mozilla::dom::HTMLImageElement> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLImageElement, mozilla::dom::HTMLImageElement>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::SVGImageElement> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::SVGImageElement, mozilla::dom::SVGImageElement>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLCanvasElement> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLCanvasElement, mozilla::dom::HTMLCanvasElement>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLVideoElement> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLVideoElement, mozilla::dom::HTMLVideoElement>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::OffscreenCanvas> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::OffscreenCanvas, mozilla::dom::OffscreenCanvas>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageBitmap> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageBitmap, mozilla::dom::ImageBitmap>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::VideoFrame> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::VideoFrame, mozilla::dom::VideoFrame>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
      }
      return cx.ThrowErrorMessage<MSG_OVERLOAD_RESOLUTION_FAILED>("1", "1");
      break;
    }
    case 2: {
      if (args[0].isObject()) {
        do {
          NonNull<mozilla::dom::HTMLImageElement> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLImageElement, mozilla::dom::HTMLImageElement>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::SVGImageElement> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::SVGImageElement, mozilla::dom::SVGImageElement>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLCanvasElement> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLCanvasElement, mozilla::dom::HTMLCanvasElement>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLVideoElement> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLVideoElement, mozilla::dom::HTMLVideoElement>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::OffscreenCanvas> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::OffscreenCanvas, mozilla::dom::OffscreenCanvas>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageBitmap> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageBitmap, mozilla::dom::ImageBitmap>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::VideoFrame> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::VideoFrame, mozilla::dom::VideoFrame>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameInit arg1;
          if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          RootedSpiderMonkeyInterface<ArrayBufferView> arg0(cx);
          if (!arg0.Init(&args[0].toObject())) {
            break;
          }
          if (JS::IsLargeArrayBufferView(arg0.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 1");
            return false;
          }
          if (JS::IsResizableArrayBufferView(arg0.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 1");
            return false;
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameBufferInit arg1;
          if (!arg1.Init(cx, args[1], "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
            if (!arg0.WrapIntoNewCompartment(cx)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, Constify(arg0), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          RootedSpiderMonkeyInterface<ArrayBuffer> arg0(cx);
          if (!arg0.Init(&args[0].toObject())) {
            break;
          }
          if (JS::IsLargeArrayBufferMaybeShared(arg0.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 1");
            return false;
          }
          if (JS::IsResizableArrayBufferMaybeShared(arg0.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 1");
            return false;
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          binding_detail::FastVideoFrameBufferInit arg1;
          if (!arg1.Init(cx, args[1], "Argument 2", false)) {
            return false;
          }
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
            if (!arg0.WrapIntoNewCompartment(cx)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::VideoFrame>(mozilla::dom::VideoFrame::Constructor(global, Constify(arg0), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "VideoFrame constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
      }
      return cx.ThrowErrorMessage<MSG_OVERLOAD_RESOLUTION_FAILED>("1", "2");
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::VideoFrame>::Depth,
  prototypes::id::VideoFrame,
  true,
  1,
  "VideoFrame",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "VideoFramePrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::VideoFrame,
  PrototypeTraits<prototypes::id::VideoFrame>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  if (!NS_IsMainThread()) {
    const char* name = JS::GetClass(aObj)->name;
    if (strcmp(name, "DedicatedWorkerGlobalScope")) {
      return false;
    }
  }

  return mozilla::dom::VideoFrame::PrefEnabled(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<mozilla::dom::VideoFrame>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "VideoFrame",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::VideoFrame>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::VideoFrame, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::VideoFrame>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::VideoFrame>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::VideoFrame>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::VideoFrame>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::VideoFrame* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::VideoFrame>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::VideoFrame*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::VideoFrame> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::VideoFrame);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::VideoFrame);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 1, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "VideoFrame",
                              ShouldExpose<VideoFrame_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::VideoFrame,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::VideoFrame,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace VideoFrame_Binding



} // namespace dom


} // namespace mozilla
