/* THIS FILE IS AUTOGENERATED FROM URLSearchParams.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "MainThreadUtils.h"
#include "URLSearchParamsBinding.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/Symbol.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/IterableIterator.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/URLSearchParams.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


bool
UTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::TrySetToUTF8StringSequenceSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::AutoSequence<Sequence<nsCString>>& memberSlot = RawSetAsUTF8StringSequenceSequence();
    JS::ForOfIterator iter(cx);
    if (!iter.init(value, JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      DestroyUTF8StringSequenceSequence();
      tryNext = true;
      return true;
    }
    binding_detail::AutoSequence<Sequence<nsCString>> &arr = memberSlot;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      Sequence<nsCString>* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      Sequence<nsCString>& slot = *slotPtr;
      if (temp.isObject()) {
        JS::ForOfIterator iter1(cx);
        if (!iter1.init(temp, JS::ForOfIterator::AllowNonIterable)) {
          return false;
        }
        if (!iter1.valueIsIterable()) {
          cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Element of sequence<sequence<USVString>> branch of (sequence<sequence<USVString>> or record<USVString, USVString> or USVString)", "sequence");
          return false;
        }
        Sequence<nsCString> &arr1 = slot;
        JS::Rooted<JS::Value> temp1(cx);
        while (true) {
          bool done1;
          if (!iter1.next(&temp1, &done1)) {
            return false;
          }
          if (done1) {
            break;
          }
          nsCString* slotPtr1 = arr1.AppendElement(mozilla::fallible);
          if (!slotPtr1) {
            JS_ReportOutOfMemory(cx);
            return false;
          }
          nsCString& slot1 = *slotPtr1;
          if (!ConvertJSValueToString(cx, temp1, eStringify, eStringify, slot1)) {
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Element of sequence<sequence<USVString>> branch of (sequence<sequence<USVString>> or record<USVString, USVString> or USVString)", "sequence");
        return false;
      }
    }
  }
  return true;
}

bool
UTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::TrySetToUTF8StringSequenceSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToUTF8StringSequenceSequence(cx, value, tryNext, passedToJSImpl);
}







bool
UTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::TrySetToUTF8StringUTF8StringRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    Record<nsCString, nsCString>& memberSlot = RawSetAsUTF8StringUTF8StringRecord();
    auto& recordEntries = memberSlot.Entries();

    JS::Rooted<JSObject*> recordObj(cx, &value.toObject());
    JS::RootedVector<jsid> ids(cx);
    if (!js::GetPropertyKeys(cx, recordObj,
                             JSITER_OWNONLY | JSITER_HIDDEN | JSITER_SYMBOLS, &ids)) {
      return false;
    }
    if (!recordEntries.SetCapacity(ids.length(), mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    JS::Rooted<JS::Value> propNameValue(cx);
    JS::Rooted<JS::Value> temp(cx);
    JS::Rooted<jsid> curId(cx);
    JS::Rooted<JS::Value> idVal(cx);
    // Use a hashset to keep track of ids seen, to avoid
    // introducing nasty O(N^2) behavior scanning for them all the
    // time.  Ideally we'd use a data structure with O(1) lookup
    // _and_ ordering for the MozMap, but we don't have one lying
    // around.
    nsTHashtable<nsCStringHashKey> idsSeen;
    for (size_t i = 0; i < ids.length(); ++i) {
      curId = ids[i];

      JS::Rooted<mozilla::Maybe<JS::PropertyDescriptor>> desc(cx);
      if (!JS_GetOwnPropertyDescriptorById(cx, recordObj, curId,
                                           &desc)) {
        return false;
      }

      if (desc.isNothing() || !desc->enumerable()) {
        continue;
      }

      idVal = js::IdToValue(curId);
      nsCString propName;
      // This will just throw if idVal is a Symbol, like the spec says
      // to do.
      if (!ConvertJSValueToString(cx, idVal, "key of record<USVString, USVString> branch of (sequence<sequence<USVString>> or record<USVString, USVString> or USVString)", propName)) {
        return false;
      }

      if (!JS_GetPropertyById(cx, recordObj, curId, &temp)) {
        return false;
      }

      Record<nsCString, nsCString>::EntryType* entry;
      if (!idsSeen.EnsureInserted(propName)) {
        // Find the existing entry.
        auto idx = recordEntries.IndexOf(propName);
        MOZ_ASSERT(idx != recordEntries.NoIndex,
                   "Why is it not found?");
        // Now blow it away to make it look like it was just added
        // to the array, because it's not obvious that it's
        // safe to write to its already-initialized mValue via our
        // normal codegen conversions.  For example, the value
        // could be a union and this would change its type, but
        // codegen assumes we won't do that.
        entry = recordEntries.ReconstructElementAt(idx);
      } else {
        // Safe to do an infallible append here, because we did a
        // SetCapacity above to the right capacity.
        entry = recordEntries.AppendElement();
      }
      entry->mKey = propName;
      nsCString& slot = entry->mValue;
      if (!ConvertJSValueToString(cx, temp, eStringify, eStringify, slot)) {
        return false;
      }
    }
  }
  return true;
}

bool
UTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::TrySetToUTF8StringUTF8StringRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToUTF8StringUTF8StringRecord(cx, value, tryNext, passedToJSImpl);
}







bool
UTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char>& memberSlot = RawSetAsUTF8String();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}








bool
UTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToUTF8StringSequenceSequence(cx, value, tryNext, passedToJSImpl)) || !tryNext;
    if (!done) {
      done = (failed = !TrySetToUTF8StringUTF8StringRecord(cx, value, tryNext, passedToJSImpl)) || !tryNext;
    }
  }
  if (!done) {
    do {
      done = (failed = !TrySetToUTF8String(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "sequence<sequence<USVString>>, record<USVString, USVString>");
    return false;
  }
  return true;
}

bool
UTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
UTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eUTF8StringSequenceSequence: {

      uint32_t length = mValue.mUTF8StringSequenceSequence.Value().Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {

            uint32_t length = mValue.mUTF8StringSequenceSequence.Value()[sequenceIdx0].Length();
            JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
            if (!returnArray) {
              return false;
            }
            // Scope for 'tmp'
            {
              JS::Rooted<JS::Value> tmp(cx);
              for (uint32_t sequenceIdx1 = 0; sequenceIdx1 < length; ++sequenceIdx1) {
                // Control block to let us common up the JS_DefineElement calls when there
                // are different ways to succeed at wrapping the object.
                do {
                  if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8StringSequenceSequence.Value()[sequenceIdx0][sequenceIdx1], &tmp)) {
                    return false;
                  }
                  break;
                } while (false);
                if (!JS_DefineElement(cx, returnArray, sequenceIdx1, tmp,
                                      JSPROP_ENUMERATE)) {
                  return false;
                }
              }
            }
            tmp.setObject(*returnArray);
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      rval.setObject(*returnArray);
      return true;
    }
    case eUTF8StringUTF8StringRecord: {

      JS::Rooted<JSObject*> returnObj(cx, JS_NewPlainObject(cx));
      if (!returnObj) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (auto& entry : mValue.mUTF8StringUTF8StringRecord.Value().Entries()) {
          auto& recordValue0 = entry.mValue;
          // Control block to let us common up the JS_DefineUCProperty calls when there
          // are different ways to succeed at wrapping the value.
          do {
            if (!NonVoidUTF8StringToJsval(cx, recordValue0, &tmp)) {
              return false;
            }
            break;
          } while (false);
          NS_ConvertUTF8toUTF16 expandedKey(entry.mKey);
          if (!JS_DefineUCProperty(cx, returnObj,
                                   expandedKey.BeginReading(),
                                   expandedKey.Length(), tmp,
                                   JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      rval.setObject(*returnObj);
      return true;
    }
    case eUTF8String: {
      if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8String.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String(OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eUTF8StringSequenceSequence: {
      mType = eUTF8StringSequenceSequence;
      mValue.mUTF8StringSequenceSequence.SetValue(std::move(aOther.mValue.mUTF8StringSequenceSequence.Value()));
      break;
    }
    case eUTF8StringUTF8StringRecord: {
      mType = eUTF8StringUTF8StringRecord;
      mValue.mUTF8StringUTF8StringRecord.SetValue(std::move(aOther.mValue.mUTF8StringUTF8StringRecord.Value()));
      break;
    }
    case eUTF8String: {
      mType = eUTF8String;
      mValue.mUTF8String.SetValue(std::move(aOther.mValue.mUTF8String.Value()));
      break;
    }
  }
}


bool
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::TrySetToUTF8StringSequenceSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    Sequence<Sequence<nsCString>>& memberSlot = RawSetAsUTF8StringSequenceSequence();
    JS::ForOfIterator iter(cx);
    if (!iter.init(value, JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      DestroyUTF8StringSequenceSequence();
      tryNext = true;
      return true;
    }
    Sequence<Sequence<nsCString>> &arr = memberSlot;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      Sequence<nsCString>* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      Sequence<nsCString>& slot = *slotPtr;
      if (temp.isObject()) {
        JS::ForOfIterator iter1(cx);
        if (!iter1.init(temp, JS::ForOfIterator::AllowNonIterable)) {
          return false;
        }
        if (!iter1.valueIsIterable()) {
          cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Element of sequence<sequence<USVString>> branch of (sequence<sequence<USVString>> or record<USVString, USVString> or USVString)", "sequence");
          return false;
        }
        Sequence<nsCString> &arr1 = slot;
        JS::Rooted<JS::Value> temp1(cx);
        while (true) {
          bool done1;
          if (!iter1.next(&temp1, &done1)) {
            return false;
          }
          if (done1) {
            break;
          }
          nsCString* slotPtr1 = arr1.AppendElement(mozilla::fallible);
          if (!slotPtr1) {
            JS_ReportOutOfMemory(cx);
            return false;
          }
          nsCString& slot1 = *slotPtr1;
          if (!ConvertJSValueToString(cx, temp1, eStringify, eStringify, slot1)) {
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Element of sequence<sequence<USVString>> branch of (sequence<sequence<USVString>> or record<USVString, USVString> or USVString)", "sequence");
        return false;
      }
    }
  }
  return true;
}

bool
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::TrySetToUTF8StringSequenceSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToUTF8StringSequenceSequence(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] Sequence<Sequence<nsCString>>&
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::RawSetAsUTF8StringSequenceSequence()
{
  if (mType == eUTF8StringSequenceSequence) {
    return mValue.mUTF8StringSequenceSequence.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eUTF8StringSequenceSequence;
  return mValue.mUTF8StringSequenceSequence.SetValue();
}

[[nodiscard]] Sequence<Sequence<nsCString>>&
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::SetAsUTF8StringSequenceSequence()
{
  if (mType == eUTF8StringSequenceSequence) {
    return mValue.mUTF8StringSequenceSequence.Value();
  }
  Uninit();
  mType = eUTF8StringSequenceSequence;
  return mValue.mUTF8StringSequenceSequence.SetValue();
}


void
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::DestroyUTF8StringSequenceSequence()
{
  MOZ_RELEASE_ASSERT(IsUTF8StringSequenceSequence(), "Wrong type!");
  mValue.mUTF8StringSequenceSequence.Destroy();
  mType = eUninitialized;
}



bool
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::TrySetToUTF8StringUTF8StringRecord(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    Record<nsCString, nsCString>& memberSlot = RawSetAsUTF8StringUTF8StringRecord();
    auto& recordEntries = memberSlot.Entries();

    JS::Rooted<JSObject*> recordObj(cx, &value.toObject());
    JS::RootedVector<jsid> ids(cx);
    if (!js::GetPropertyKeys(cx, recordObj,
                             JSITER_OWNONLY | JSITER_HIDDEN | JSITER_SYMBOLS, &ids)) {
      return false;
    }
    if (!recordEntries.SetCapacity(ids.length(), mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    JS::Rooted<JS::Value> propNameValue(cx);
    JS::Rooted<JS::Value> temp(cx);
    JS::Rooted<jsid> curId(cx);
    JS::Rooted<JS::Value> idVal(cx);
    // Use a hashset to keep track of ids seen, to avoid
    // introducing nasty O(N^2) behavior scanning for them all the
    // time.  Ideally we'd use a data structure with O(1) lookup
    // _and_ ordering for the MozMap, but we don't have one lying
    // around.
    nsTHashtable<nsCStringHashKey> idsSeen;
    for (size_t i = 0; i < ids.length(); ++i) {
      curId = ids[i];

      JS::Rooted<mozilla::Maybe<JS::PropertyDescriptor>> desc(cx);
      if (!JS_GetOwnPropertyDescriptorById(cx, recordObj, curId,
                                           &desc)) {
        return false;
      }

      if (desc.isNothing() || !desc->enumerable()) {
        continue;
      }

      idVal = js::IdToValue(curId);
      nsCString propName;
      // This will just throw if idVal is a Symbol, like the spec says
      // to do.
      if (!ConvertJSValueToString(cx, idVal, "key of record<USVString, USVString> branch of (sequence<sequence<USVString>> or record<USVString, USVString> or USVString)", propName)) {
        return false;
      }

      if (!JS_GetPropertyById(cx, recordObj, curId, &temp)) {
        return false;
      }

      Record<nsCString, nsCString>::EntryType* entry;
      if (!idsSeen.EnsureInserted(propName)) {
        // Find the existing entry.
        auto idx = recordEntries.IndexOf(propName);
        MOZ_ASSERT(idx != recordEntries.NoIndex,
                   "Why is it not found?");
        // Now blow it away to make it look like it was just added
        // to the array, because it's not obvious that it's
        // safe to write to its already-initialized mValue via our
        // normal codegen conversions.  For example, the value
        // could be a union and this would change its type, but
        // codegen assumes we won't do that.
        entry = recordEntries.ReconstructElementAt(idx);
      } else {
        // Safe to do an infallible append here, because we did a
        // SetCapacity above to the right capacity.
        entry = recordEntries.AppendElement();
      }
      entry->mKey = propName;
      nsCString& slot = entry->mValue;
      if (!ConvertJSValueToString(cx, temp, eStringify, eStringify, slot)) {
        return false;
      }
    }
  }
  return true;
}

bool
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::TrySetToUTF8StringUTF8StringRecord(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToUTF8StringUTF8StringRecord(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] Record<nsCString, nsCString>&
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::RawSetAsUTF8StringUTF8StringRecord()
{
  if (mType == eUTF8StringUTF8StringRecord) {
    return mValue.mUTF8StringUTF8StringRecord.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eUTF8StringUTF8StringRecord;
  return mValue.mUTF8StringUTF8StringRecord.SetValue();
}

[[nodiscard]] Record<nsCString, nsCString>&
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::SetAsUTF8StringUTF8StringRecord()
{
  if (mType == eUTF8StringUTF8StringRecord) {
    return mValue.mUTF8StringUTF8StringRecord.Value();
  }
  Uninit();
  mType = eUTF8StringUTF8StringRecord;
  return mValue.mUTF8StringUTF8StringRecord.SetValue();
}


void
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::DestroyUTF8StringUTF8StringRecord()
{
  MOZ_RELEASE_ASSERT(IsUTF8StringUTF8StringRecord(), "Wrong type!");
  mValue.mUTF8StringUTF8StringRecord.Destroy();
  mType = eUninitialized;
}



bool
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsCString& memberSlot = RawSetAsUTF8String();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsCString&
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::RawSetAsUTF8String()
{
  if (mType == eUTF8String) {
    return mValue.mUTF8String.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eUTF8String;
  return mValue.mUTF8String.SetValue();
}

[[nodiscard]] nsCString&
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::SetAsUTF8String()
{
  if (mType == eUTF8String) {
    return mValue.mUTF8String.Value();
  }
  Uninit();
  mType = eUTF8String;
  return mValue.mUTF8String.SetValue();
}



void
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::DestroyUTF8String()
{
  MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
  mValue.mUTF8String.Destroy();
  mType = eUninitialized;
}



bool
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToUTF8StringSequenceSequence(cx, value, tryNext, passedToJSImpl)) || !tryNext;
    if (!done) {
      done = (failed = !TrySetToUTF8StringUTF8StringRecord(cx, value, tryNext, passedToJSImpl)) || !tryNext;
    }
  }
  if (!done) {
    do {
      done = (failed = !TrySetToUTF8String(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "sequence<sequence<USVString>>, record<USVString, USVString>");
    return false;
  }
  return true;
}

bool
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eUTF8StringSequenceSequence: {
      DestroyUTF8StringSequenceSequence();
      break;
    }
    case eUTF8StringUTF8StringRecord: {
      DestroyUTF8StringUTF8StringRecord();
      break;
    }
    case eUTF8String: {
      DestroyUTF8String();
      break;
    }
  }
}

bool
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eUTF8StringSequenceSequence: {

      uint32_t length = mValue.mUTF8StringSequenceSequence.Value().Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {

            uint32_t length = mValue.mUTF8StringSequenceSequence.Value()[sequenceIdx0].Length();
            JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
            if (!returnArray) {
              return false;
            }
            // Scope for 'tmp'
            {
              JS::Rooted<JS::Value> tmp(cx);
              for (uint32_t sequenceIdx1 = 0; sequenceIdx1 < length; ++sequenceIdx1) {
                // Control block to let us common up the JS_DefineElement calls when there
                // are different ways to succeed at wrapping the object.
                do {
                  if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8StringSequenceSequence.Value()[sequenceIdx0][sequenceIdx1], &tmp)) {
                    return false;
                  }
                  break;
                } while (false);
                if (!JS_DefineElement(cx, returnArray, sequenceIdx1, tmp,
                                      JSPROP_ENUMERATE)) {
                  return false;
                }
              }
            }
            tmp.setObject(*returnArray);
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      rval.setObject(*returnArray);
      return true;
    }
    case eUTF8StringUTF8StringRecord: {

      JS::Rooted<JSObject*> returnObj(cx, JS_NewPlainObject(cx));
      if (!returnObj) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (auto& entry : mValue.mUTF8StringUTF8StringRecord.Value().Entries()) {
          auto& recordValue0 = entry.mValue;
          // Control block to let us common up the JS_DefineUCProperty calls when there
          // are different ways to succeed at wrapping the value.
          do {
            if (!NonVoidUTF8StringToJsval(cx, recordValue0, &tmp)) {
              return false;
            }
            break;
          } while (false);
          NS_ConvertUTF8toUTF16 expandedKey(entry.mKey);
          if (!JS_DefineUCProperty(cx, returnObj,
                                   expandedKey.BeginReading(),
                                   expandedKey.Length(), tmp,
                                   JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      rval.setObject(*returnObj);
      return true;
    }
    case eUTF8String: {
      if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8String.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String&
OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String::operator=(OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String&& aOther)
{
  this->~OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String();
  new (this) OwningUTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String (std::move(aOther));
  return *this;
}



namespace URLSearchParamsIterator_Binding {

static bool
Wrap(JSContext* aCx, mozilla::dom::IterableIterator<mozilla::dom::URLSearchParams>* aObject, JS::MutableHandle<JSObject*> aReflector);

} // namespace URLSearchParamsIterator_Binding


namespace URLSearchParams_Binding {

MOZ_CAN_RUN_SCRIPT static bool
get_size(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "size", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLSearchParams*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->Size());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo size_getterinfo = {
  { get_size },
  { prototypes::id::URLSearchParams },
  { PrototypeTraits<prototypes::id::URLSearchParams>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
append(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "append", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLSearchParams*>(void_self);
  if (!args.requireAtLeast(cx, "URLSearchParams.append", 2)) {
    return false;
  }
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  binding_detail::FakeString<char> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Append(Constify(arg0), Constify(arg1)))>, "Should be returning void here");
  MOZ_KnownLive(self)->Append(Constify(arg0), Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo append_methodinfo = {
  { (JSJitGetterOp)append },
  { prototypes::id::URLSearchParams },
  { PrototypeTraits<prototypes::id::URLSearchParams>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
_delete_(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "delete", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLSearchParams*>(void_self);
  if (!args.requireAtLeast(cx, "URLSearchParams.delete", 1)) {
    return false;
  }
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Optional<nsACString> arg1;
  binding_detail::FakeString<char> arg1_holder;
  if (args.hasDefined(1)) {
    if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1_holder)) {
      return false;
    }
    arg1 = &arg1_holder;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Delete(Constify(arg0), Constify(arg1)))>, "Should be returning void here");
  MOZ_KnownLive(self)->Delete(Constify(arg0), Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo delete_methodinfo = {
  { (JSJitGetterOp)_delete_ },
  { prototypes::id::URLSearchParams },
  { PrototypeTraits<prototypes::id::URLSearchParams>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "get", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLSearchParams*>(void_self);
  if (!args.requireAtLeast(cx, "URLSearchParams.get", 1)) {
    return false;
  }
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Get(Constify(arg0), result))>, "Should be returning void here");
  MOZ_KnownLive(self)->Get(Constify(arg0), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!UTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo get_methodinfo = {
  { (JSJitGetterOp)get },
  { prototypes::id::URLSearchParams },
  { PrototypeTraits<prototypes::id::URLSearchParams>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getAll(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "getAll", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLSearchParams*>(void_self);
  if (!args.requireAtLeast(cx, "URLSearchParams.getAll", 1)) {
    return false;
  }
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  nsTArray<nsCString> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetAll(Constify(arg0), result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetAll(Constify(arg0), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!NonVoidUTF8StringToJsval(cx, result[sequenceIdx0], &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getAll_methodinfo = {
  { (JSJitGetterOp)getAll },
  { prototypes::id::URLSearchParams },
  { PrototypeTraits<prototypes::id::URLSearchParams>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
has(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "has", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLSearchParams*>(void_self);
  if (!args.requireAtLeast(cx, "URLSearchParams.has", 1)) {
    return false;
  }
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Optional<nsACString> arg1;
  binding_detail::FakeString<char> arg1_holder;
  if (args.hasDefined(1)) {
    if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1_holder)) {
      return false;
    }
    arg1 = &arg1_holder;
  }
  bool result(MOZ_KnownLive(self)->Has(Constify(arg0), Constify(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo has_methodinfo = {
  { (JSJitGetterOp)has },
  { prototypes::id::URLSearchParams },
  { PrototypeTraits<prototypes::id::URLSearchParams>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
set(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "set", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLSearchParams*>(void_self);
  if (!args.requireAtLeast(cx, "URLSearchParams.set", 2)) {
    return false;
  }
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  binding_detail::FakeString<char> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Set(Constify(arg0), Constify(arg1)))>, "Should be returning void here");
  MOZ_KnownLive(self)->Set(Constify(arg0), Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo set_methodinfo = {
  { (JSJitGetterOp)set },
  { prototypes::id::URLSearchParams },
  { PrototypeTraits<prototypes::id::URLSearchParams>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
sort(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "sort", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLSearchParams*>(void_self);
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Sort(rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Sort(rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "URLSearchParams.sort"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo sort_methodinfo = {
  { (JSJitGetterOp)sort },
  { prototypes::id::URLSearchParams },
  { PrototypeTraits<prototypes::id::URLSearchParams>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
__stringifier(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "__stringifier", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLSearchParams*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Stringify(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->Stringify(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo __stringifier_methodinfo = {
  { (JSJitGetterOp)__stringifier },
  { prototypes::id::URLSearchParams },
  { PrototypeTraits<prototypes::id::URLSearchParams>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
entries(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "entries", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLSearchParams*>(void_self);
  typedef mozilla::dom::binding_detail::WrappableIterableIterator<mozilla::dom::URLSearchParams, &URLSearchParamsIterator_Binding::Wrap> itrType;
  RefPtr<itrType> result(new itrType(self,
                                     itrType::IteratorType::Entries));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!WrapNewBindingNonWrapperCachedObject(cx, obj, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo::ArgType entries_methodinfo_argTypes[] = { JSJitInfo::ArgTypeListEnd };
static const JSTypedMethodJitInfo entries_methodinfo = {
  {
    { (JSJitGetterOp)entries },
    { prototypes::id::URLSearchParams },
    { PrototypeTraits<prototypes::id::URLSearchParams>::Depth },
    JSJitInfo::Method,
    JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
    JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
    false,  /* isInfallible. False in setters. */
    false,  /* isMovable.  Not relevant for setters. */
    false, /* isEliminatable.  Not relevant for setters. */
    false, /* isAlwaysInSlot.  Only relevant for getters. */
    false, /* isLazilyCachedInSlot.  Only relevant for getters. */
    true,  /* isTypedMethod.  Only relevant for methods. */
    0   /* Reserved slot index, if we're stored in a slot, else 0. */
  },
  entries_methodinfo_argTypes
};

MOZ_CAN_RUN_SCRIPT static bool
keys(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "keys", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLSearchParams*>(void_self);
  typedef mozilla::dom::binding_detail::WrappableIterableIterator<mozilla::dom::URLSearchParams, &URLSearchParamsIterator_Binding::Wrap> itrType;
  RefPtr<itrType> result(new itrType(self,
                                     itrType::IteratorType::Keys));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!WrapNewBindingNonWrapperCachedObject(cx, obj, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo::ArgType keys_methodinfo_argTypes[] = { JSJitInfo::ArgTypeListEnd };
static const JSTypedMethodJitInfo keys_methodinfo = {
  {
    { (JSJitGetterOp)keys },
    { prototypes::id::URLSearchParams },
    { PrototypeTraits<prototypes::id::URLSearchParams>::Depth },
    JSJitInfo::Method,
    JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
    JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
    false,  /* isInfallible. False in setters. */
    false,  /* isMovable.  Not relevant for setters. */
    false, /* isEliminatable.  Not relevant for setters. */
    false, /* isAlwaysInSlot.  Only relevant for getters. */
    false, /* isLazilyCachedInSlot.  Only relevant for getters. */
    true,  /* isTypedMethod.  Only relevant for methods. */
    0   /* Reserved slot index, if we're stored in a slot, else 0. */
  },
  keys_methodinfo_argTypes
};

MOZ_CAN_RUN_SCRIPT static bool
values(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "values", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLSearchParams*>(void_self);
  typedef mozilla::dom::binding_detail::WrappableIterableIterator<mozilla::dom::URLSearchParams, &URLSearchParamsIterator_Binding::Wrap> itrType;
  RefPtr<itrType> result(new itrType(self,
                                     itrType::IteratorType::Values));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!WrapNewBindingNonWrapperCachedObject(cx, obj, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo::ArgType values_methodinfo_argTypes[] = { JSJitInfo::ArgTypeListEnd };
static const JSTypedMethodJitInfo values_methodinfo = {
  {
    { (JSJitGetterOp)values },
    { prototypes::id::URLSearchParams },
    { PrototypeTraits<prototypes::id::URLSearchParams>::Depth },
    JSJitInfo::Method,
    JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
    JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
    false,  /* isInfallible. False in setters. */
    false,  /* isMovable.  Not relevant for setters. */
    false, /* isEliminatable.  Not relevant for setters. */
    false, /* isAlwaysInSlot.  Only relevant for getters. */
    false, /* isLazilyCachedInSlot.  Only relevant for getters. */
    true,  /* isTypedMethod.  Only relevant for methods. */
    0   /* Reserved slot index, if we're stored in a slot, else 0. */
  },
  values_methodinfo_argTypes
};

MOZ_CAN_RUN_SCRIPT static bool
forEach(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "URLSearchParams.forEach");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "forEach", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLSearchParams*>(void_self);
  JS::Rooted<JSObject*> arg0(cx);
  if (args.get(0).isObject()) {
    arg0 = &args.get(0).toObject();
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  JS::Rooted<JS::Value> arg1(cx);
  if (args.hasDefined(1)) {
    arg1 = args.get(1);
  } else {
    arg1 = JS::UndefinedValue();
  }
  if (!JS::IsCallable(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
    return false;
  }
  JS::RootedValueArray<3> callArgs(cx);
  callArgs[2].setObject(*obj);
  JS::Rooted<JS::Value> ignoredReturnVal(cx);
  auto GetKeyAtIndex = &mozilla::dom::URLSearchParams::GetKeyAtIndex;
  auto GetValueAtIndex = &mozilla::dom::URLSearchParams::GetValueAtIndex;
  for (size_t i = 0; i < self->GetIterableLength(); ++i) {
    if (!CallIterableGetter(cx, GetValueAtIndex, self, i,
                            callArgs[0])) {
      return false;
    }
    if (!CallIterableGetter(cx, GetKeyAtIndex, self, i,
                            callArgs[1])) {
      return false;
    }
    if (!JS::Call(cx, arg1, arg0, JS::HandleValueArray(callArgs),
                  &ignoredReturnVal)) {
      return false;
    }
  }
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo forEach_methodinfo = {
  { (JSJitGetterOp)forEach },
  { prototypes::id::URLSearchParams },
  { PrototypeTraits<prototypes::id::URLSearchParams>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::URLSearchParams* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::URLSearchParams>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::URLSearchParams>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("append", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&append_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("delete", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&delete_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("get", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&get_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getAll", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getAll_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("has", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&has_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("set", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&set_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("sort", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&sort_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("entries", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&entries_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("keys", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&keys_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("values", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&values_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("forEach", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&forEach_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("toString", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&__stringifier_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(12 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("size", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &size_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[13];
static PropertyInfo sNativeProperties_propertyInfos[13];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  7,
  13,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[12] }
  }
};
static_assert(7 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.iteratorAliasMethodIndex) - 1),
    "We have an iterator alias index that is oversized");
static_assert(13 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::URLSearchParams,
  constructors::id::URLSearchParams,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "URLSearchParams constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParams", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "URLSearchParams");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::URLSearchParams,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  UTF8StringSequenceSequenceOrUTF8StringUTF8StringRecordOrUTF8String arg0;
  if (!(args.hasDefined(0))) {
    arg0.SetStringLiteral("");
  } else {
    if (!arg0.Init(cx, args[0], "Argument 1", false)) {
      return false;
    }
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::URLSearchParams>(mozilla::dom::URLSearchParams::Constructor(global, Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "URLSearchParams constructor"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::URLSearchParams>::Depth,
  prototypes::id::URLSearchParams,
  true,
  0,
  "URLSearchParams",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "URLSearchParamsPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::URLSearchParams,
  PrototypeTraits<prototypes::id::URLSearchParams>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<mozilla::dom::URLSearchParams>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "URLSearchParams",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::URLSearchParams>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::URLSearchParams, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::URLSearchParams>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::URLSearchParams>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::URLSearchParams>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::URLSearchParams>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::URLSearchParams* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::URLSearchParams>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::URLSearchParams*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::URLSearchParams> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::URLSearchParams);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::URLSearchParams);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "URLSearchParams",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);

  JS::AssertObjectIsNotGray(*protoCache);
  JS::Handle<JSObject*> proto = JS::Handle<JSObject*>::fromMarkedLocation(protoCache->unsafeAddress());
  if (!proto) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  // Set up aliases on the interface prototype object we just created.
  JS::Rooted<JS::Value> aliasedVal(aCx);

  if (!JS_GetProperty(aCx, proto, "entries", &aliasedVal)) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }
  JS::Rooted<jsid> iteratorId(aCx, JS::GetWellKnownSymbolKey(aCx, JS::SymbolCode::iterator));
  if (!JS_DefinePropertyById(aCx, proto, iteratorId, aliasedVal, 0)) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::URLSearchParams,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::URLSearchParams,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace URLSearchParams_Binding



namespace URLSearchParamsIterator_Binding {

MOZ_CAN_RUN_SCRIPT static bool
next(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLSearchParamsIterator", "next", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::IterableIterator<mozilla::dom::URLSearchParams>*>(void_self);
  FastErrorResult rv;
  JS::Rooted<JSObject*> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Next(cx, &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Next(cx, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "URLSearchParamsIterator.next"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeObjectToActiveJS(result);
  args.rval().setObject(*result);
  if (!MaybeWrapObjectValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo next_methodinfo = {
  { (JSJitGetterOp)next },
  { prototypes::id::URLSearchParamsIterator },
  { PrototypeTraits<prototypes::id::URLSearchParamsIterator>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::IterableIterator<mozilla::dom::URLSearchParams>* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::IterableIterator<mozilla::dom::URLSearchParams>>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::IterableIterator<mozilla::dom::URLSearchParams>>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("next", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&next_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[1];
static PropertyInfo sNativeProperties_propertyInfos[1];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  1,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(1 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::URLSearchParamsIterator,
  constructors::id::_ID_Count,
  &DefaultXrayExpandoObjectClass
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "URLSearchParams IteratorPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::URLSearchParamsIterator,
  PrototypeTraits<prototypes::id::URLSearchParamsIterator>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmIteratorPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "URLSearchParams Iterator",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::URLSearchParamsIterator, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::IterableIterator<mozilla::dom::URLSearchParams>>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::IterableIterator<mozilla::dom::URLSearchParams>>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::IterableIterator<mozilla::dom::URLSearchParams>>::Get(),
  nullptr,
  nullptr
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

static bool
Wrap(JSContext* aCx, mozilla::dom::IterableIterator<mozilla::dom::URLSearchParams>* aObject, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::IterableIterator<mozilla::dom::URLSearchParams>*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));

  JS::Rooted<JSObject*> global(aCx, JS::CurrentGlobalOrNull(aCx));
  JS::Handle<JSObject*> proto = GetProtoObjectHandle(aCx);
  if (!proto) {
    return false;
  }

  BindingJSObjectCreator<mozilla::dom::IterableIterator<mozilla::dom::URLSearchParams>> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }



  creator.InitializationSucceeded();
  return true;
}

static void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::URLSearchParamsIterator);
  JS::Heap<JSObject*>* interfaceCache = nullptr;

  JS::Rooted<JSObject*> parentProto(aCx, JS::GetRealmIteratorPrototype(aCx));
  if (!parentProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              nullptr, nullptr, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "URLSearchParams Iterator",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::URLSearchParamsIterator,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

} // namespace URLSearchParamsIterator_Binding



} // namespace mozilla::dom
