/* THIS FILE IS AUTOGENERATED FROM TreeContentView.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "MainThreadUtils.h"
#include "TreeContentViewBinding.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DataTransfer.h"
#include "mozilla/dom/Element.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/XULTreeElement.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "nsITreeSelection.h"
#include "nsTreeColumns.h"
#include "nsTreeContentView.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace TreeContentView_Binding {

MOZ_CAN_RUN_SCRIPT static bool
getItemAtIndex(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "getItemAtIndex", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.getItemAtIndex", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->GetItemAtIndex(arg0, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.getItemAtIndex"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getItemAtIndex_methodinfo = {
  { (JSJitGetterOp)getItemAtIndex },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getIndexOfItem(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.getIndexOfItem");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "getIndexOfItem", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.getIndexOfItem", 1)) {
    return false;
  }
  mozilla::dom::Element* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  int32_t result(MOZ_KnownLive(self)->GetIndexOfItem(MOZ_KnownLive(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo getIndexOfItem_methodinfo = {
  { (JSJitGetterOp)getIndexOfItem },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_rowCount(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "rowCount", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  int32_t result(MOZ_KnownLive(self)->RowCount());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo rowCount_getterinfo = {
  { get_rowCount },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_selection(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "selection", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  auto result(StrongOrRawPtr<nsITreeSelection>(MOZ_KnownLive(self)->GetSelection()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result, &NS_GET_IID(nsITreeSelection), args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_selection(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "TreeContentView.selection setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "selection", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  nsITreeSelection* arg0;
  RefPtr<nsITreeSelection> arg0_holder;
  if (args[0].isObject()) {
    JS::Rooted<JSObject*> source(cx, &args[0].toObject());
    if (NS_FAILED(UnwrapArg<nsITreeSelection>(cx, source, getter_AddRefs(arg0_holder)))) {
      cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Value being assigned", "nsITreeSelection");
      return false;
    }
    MOZ_ASSERT(arg0_holder);
    arg0 = arg0_holder;
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Value being assigned");
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetSelection(MOZ_KnownLive(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetSelection(MOZ_KnownLive(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.selection setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo selection_getterinfo = {
  { get_selection },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo selection_setterinfo = {
  { (JSJitGetterOp)set_selection },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getRowProperties(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "getRowProperties", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.getRowProperties", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetRowProperties(arg0, result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetRowProperties(arg0, result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.getRowProperties"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getRowProperties_methodinfo = {
  { (JSJitGetterOp)getRowProperties },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getCellProperties(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.getCellProperties");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "getCellProperties", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.getCellProperties", 2)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  NonNull<nsTreeColumn> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TreeColumn, nsTreeColumn>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "TreeColumn");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetCellProperties(arg0, MOZ_KnownLive(NonNullHelper(arg1)), result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetCellProperties(arg0, MOZ_KnownLive(NonNullHelper(arg1)), result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.getCellProperties"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getCellProperties_methodinfo = {
  { (JSJitGetterOp)getCellProperties },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getColumnProperties(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.getColumnProperties");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "getColumnProperties", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.getColumnProperties", 1)) {
    return false;
  }
  NonNull<nsTreeColumn> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TreeColumn, nsTreeColumn>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "TreeColumn");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetColumnProperties(MOZ_KnownLive(NonNullHelper(arg0)), result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetColumnProperties(MOZ_KnownLive(NonNullHelper(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getColumnProperties_methodinfo = {
  { (JSJitGetterOp)getColumnProperties },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isContainer(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "isContainer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.isContainer", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->IsContainer(arg0, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.isContainer"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isContainer_methodinfo = {
  { (JSJitGetterOp)isContainer },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isContainerOpen(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "isContainerOpen", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.isContainerOpen", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->IsContainerOpen(arg0, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.isContainerOpen"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isContainerOpen_methodinfo = {
  { (JSJitGetterOp)isContainerOpen },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isContainerEmpty(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "isContainerEmpty", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.isContainerEmpty", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->IsContainerEmpty(arg0, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.isContainerEmpty"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isContainerEmpty_methodinfo = {
  { (JSJitGetterOp)isContainerEmpty },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isSeparator(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "isSeparator", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.isSeparator", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->IsSeparator(arg0, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.isSeparator"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isSeparator_methodinfo = {
  { (JSJitGetterOp)isSeparator },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isSorted(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "isSorted", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  bool result(MOZ_KnownLive(self)->IsSorted());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isSorted_methodinfo = {
  { (JSJitGetterOp)isSorted },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
canDrop(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.canDrop");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "canDrop", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.canDrop", 3)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  mozilla::dom::DataTransfer* arg2;
  if (args[2].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::DataTransfer, mozilla::dom::DataTransfer>(args[2], arg2, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 3", "DataTransfer");
        return false;
      }
    }
  } else if (args[2].isNullOrUndefined()) {
    arg2 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
    return false;
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->CanDrop(arg0, arg1, MOZ_KnownLive(Constify(arg2)), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.canDrop"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo canDrop_methodinfo = {
  { (JSJitGetterOp)canDrop },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
drop(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.drop");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "drop", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.drop", 3)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  mozilla::dom::DataTransfer* arg2;
  if (args[2].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::DataTransfer, mozilla::dom::DataTransfer>(args[2], arg2, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 3", "DataTransfer");
        return false;
      }
    }
  } else if (args[2].isNullOrUndefined()) {
    arg2 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Drop(arg0, arg1, MOZ_KnownLive(Constify(arg2)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Drop(arg0, arg1, MOZ_KnownLive(Constify(arg2)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.drop"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo drop_methodinfo = {
  { (JSJitGetterOp)drop },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getParentIndex(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "getParentIndex", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.getParentIndex", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  int32_t result(MOZ_KnownLive(self)->GetParentIndex(arg0, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.getParentIndex"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo getParentIndex_methodinfo = {
  { (JSJitGetterOp)getParentIndex },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
hasNextSibling(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "hasNextSibling", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.hasNextSibling", 2)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->HasNextSibling(arg0, arg1, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.hasNextSibling"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo hasNextSibling_methodinfo = {
  { (JSJitGetterOp)hasNextSibling },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getLevel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "getLevel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.getLevel", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  int32_t result(MOZ_KnownLive(self)->GetLevel(arg0, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.getLevel"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo getLevel_methodinfo = {
  { (JSJitGetterOp)getLevel },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getImageSrc(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.getImageSrc");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "getImageSrc", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.getImageSrc", 2)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  NonNull<nsTreeColumn> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TreeColumn, nsTreeColumn>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "TreeColumn");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetImageSrc(arg0, MOZ_KnownLive(NonNullHelper(arg1)), result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetImageSrc(arg0, MOZ_KnownLive(NonNullHelper(arg1)), result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.getImageSrc"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getImageSrc_methodinfo = {
  { (JSJitGetterOp)getImageSrc },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getCellValue(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.getCellValue");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "getCellValue", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.getCellValue", 2)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  NonNull<nsTreeColumn> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TreeColumn, nsTreeColumn>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "TreeColumn");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetCellValue(arg0, MOZ_KnownLive(NonNullHelper(arg1)), result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetCellValue(arg0, MOZ_KnownLive(NonNullHelper(arg1)), result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.getCellValue"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getCellValue_methodinfo = {
  { (JSJitGetterOp)getCellValue },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getCellText(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.getCellText");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "getCellText", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.getCellText", 2)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  NonNull<nsTreeColumn> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TreeColumn, nsTreeColumn>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "TreeColumn");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetCellText(arg0, MOZ_KnownLive(NonNullHelper(arg1)), result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetCellText(arg0, MOZ_KnownLive(NonNullHelper(arg1)), result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.getCellText"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getCellText_methodinfo = {
  { (JSJitGetterOp)getCellText },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setTree(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.setTree");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "setTree", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.setTree", 1)) {
    return false;
  }
  mozilla::dom::XULTreeElement* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::XULTreeElement, mozilla::dom::XULTreeElement>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "XULTreeElement");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetTree(MOZ_KnownLive(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetTree(MOZ_KnownLive(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.setTree"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setTree_methodinfo = {
  { (JSJitGetterOp)setTree },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
toggleOpenState(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "toggleOpenState", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.toggleOpenState", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ToggleOpenState(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->ToggleOpenState(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.toggleOpenState"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo toggleOpenState_methodinfo = {
  { (JSJitGetterOp)toggleOpenState },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
cycleHeader(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.cycleHeader");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "cycleHeader", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.cycleHeader", 1)) {
    return false;
  }
  NonNull<nsTreeColumn> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TreeColumn, nsTreeColumn>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "TreeColumn");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CycleHeader(MOZ_KnownLive(NonNullHelper(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CycleHeader(MOZ_KnownLive(NonNullHelper(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.cycleHeader"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo cycleHeader_methodinfo = {
  { (JSJitGetterOp)cycleHeader },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
selectionChanged(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "selectionChanged", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SelectionChanged())>, "Should be returning void here");
  MOZ_KnownLive(self)->SelectionChanged();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo selectionChanged_methodinfo = {
  { (JSJitGetterOp)selectionChanged },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
cycleCell(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.cycleCell");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "cycleCell", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.cycleCell", 2)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  NonNull<nsTreeColumn> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TreeColumn, nsTreeColumn>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "TreeColumn");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CycleCell(arg0, MOZ_KnownLive(NonNullHelper(arg1))))>, "Should be returning void here");
  MOZ_KnownLive(self)->CycleCell(arg0, MOZ_KnownLive(NonNullHelper(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo cycleCell_methodinfo = {
  { (JSJitGetterOp)cycleCell },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isEditable(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.isEditable");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "isEditable", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.isEditable", 2)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  NonNull<nsTreeColumn> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TreeColumn, nsTreeColumn>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "TreeColumn");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->IsEditable(arg0, MOZ_KnownLive(NonNullHelper(arg1)), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.isEditable"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isEditable_methodinfo = {
  { (JSJitGetterOp)isEditable },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setCellValue(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.setCellValue");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "setCellValue", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.setCellValue", 3)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  NonNull<nsTreeColumn> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TreeColumn, nsTreeColumn>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "TreeColumn");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  binding_detail::FakeString<char16_t> arg2;
  if (!ConvertJSValueToString(cx, args[2], eStringify, eStringify, arg2)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetCellValue(arg0, MOZ_KnownLive(NonNullHelper(arg1)), NonNullHelper(Constify(arg2)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetCellValue(arg0, MOZ_KnownLive(NonNullHelper(arg1)), NonNullHelper(Constify(arg2)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.setCellValue"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setCellValue_methodinfo = {
  { (JSJitGetterOp)setCellValue },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setCellText(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TreeContentView.setCellText");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TreeContentView", "setCellText", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsTreeContentView*>(void_self);
  if (!args.requireAtLeast(cx, "TreeContentView.setCellText", 3)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  NonNull<nsTreeColumn> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TreeColumn, nsTreeColumn>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "TreeColumn");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  binding_detail::FakeString<char16_t> arg2;
  if (!ConvertJSValueToString(cx, args[2], eStringify, eStringify, arg2)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetCellText(arg0, MOZ_KnownLive(NonNullHelper(arg1)), NonNullHelper(Constify(arg2)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetCellText(arg0, MOZ_KnownLive(NonNullHelper(arg1)), NonNullHelper(Constify(arg2)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "TreeContentView.setCellText"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setCellText_methodinfo = {
  { (JSJitGetterOp)setCellText },
  { prototypes::id::TreeContentView },
  { PrototypeTraits<prototypes::id::TreeContentView>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  nsTreeContentView* self = UnwrapPossiblyNotInitializedDOMObject<nsTreeContentView>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<nsTreeContentView>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("getItemAtIndex", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getItemAtIndex_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getIndexOfItem", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getIndexOfItem_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getRowProperties", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getRowProperties_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getCellProperties", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getCellProperties_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getColumnProperties", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getColumnProperties_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isContainer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isContainer_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isContainerOpen", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isContainerOpen_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isContainerEmpty", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isContainerEmpty_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isSeparator", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isSeparator_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isSorted", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isSorted_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("canDrop", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&canDrop_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("drop", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&drop_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getParentIndex", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getParentIndex_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("hasNextSibling", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&hasNextSibling_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getLevel", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getLevel_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getImageSrc", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getImageSrc_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getCellValue", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getCellValue_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getCellText", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getCellText_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setTree", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setTree_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("toggleOpenState", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&toggleOpenState_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cycleHeader", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&cycleHeader_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("selectionChanged", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&selectionChanged_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cycleCell", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&cycleCell_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isEditable", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isEditable_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setCellValue", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setCellValue_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setCellText", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setCellText_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(26 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("rowCount", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &rowCount_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("selection", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &selection_getterinfo, GenericSetter<NormalThisPolicy>, &selection_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const ConstantSpec sConstants_specs[] = {
  { "DROP_BEFORE", JS::Int32Value(-1) },
  { "DROP_ON", JS::Int32Value(0) },
  { "DROP_AFTER", JS::Int32Value(1) },
  { 0, JS::UndefinedValue() }
};


static const Prefable<const ConstantSpec> sConstants[] = {
  { nullptr, &sConstants_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[31];
static PropertyInfo sNativeProperties_propertyInfos[31];

static const NativePropertiesN<3> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  true,  2 /* sConstants */,
  -1,
  31,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[26] },
    { sConstants, &sNativeProperties_propertyInfos[28] }
  }
};
static_assert(31 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::TreeContentView,
  constructors::id::TreeContentView,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::TreeContentView>::Depth,
  prototypes::id::TreeContentView,
  true,
  0,
  "TreeContentView",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "TreeContentViewPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::TreeContentView,
  PrototypeTraits<prototypes::id::TreeContentView>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return nsContentUtils::ThreadsafeIsSystemCaller(aCx);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<nsTreeContentView>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "TreeContentView",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<nsTreeContentView>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::TreeContentView, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, nsTreeContentView>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<nsTreeContentView>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<nsTreeContentView>::Get(),
  nullptr,
  NativeTypeHelpers<nsTreeContentView>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, nsTreeContentView* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, nsTreeContentView>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), nsTreeContentView*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<nsTreeContentView> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::TreeContentView);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::TreeContentView);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "TreeContentView",
                              ShouldExpose<TreeContentView_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::TreeContentView,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::TreeContentView,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace TreeContentView_Binding



} // namespace mozilla::dom
