/* THIS FILE IS AUTOGENERATED FROM SubtleCrypto.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "SubtleCryptoBinding.h"
#include "WrapperFactory.h"
#include "XrayWrapper.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsfriendapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CryptoKey.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/StructuredCloneTags.h"
#include "mozilla/dom/SubtleCrypto.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionTypes.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



Algorithm::Algorithm()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
Algorithm::InitIds(JSContext* cx, AlgorithmAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->name_id.init(cx, "name")) {
    return false;
  }
  return true;
}

bool
Algorithm::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  AlgorithmAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<AlgorithmAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->name_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mName)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'name' member of Algorithm");
  }
  return true;
}

bool
Algorithm::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
Algorithm::TraceDictionary(JSTracer* trc)
{
}

Algorithm&
Algorithm::operator=(const Algorithm& aOther)
{
  DictionaryBase::operator=(aOther);
  mName = aOther.mName;
  return *this;
}



CryptoKeyPair::CryptoKeyPair()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
CryptoKeyPair::InitIds(JSContext* cx, CryptoKeyPairAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->publicKey_id.init(cx, "publicKey") ||
      !atomsCache->privateKey_id.init(cx, "privateKey")) {
    return false;
  }
  return true;
}

bool
CryptoKeyPair::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
CryptoKeyPair::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  CryptoKeyPairAtoms* atomsCache = GetAtomCache<CryptoKeyPairAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    OwningNonNull<mozilla::dom::CryptoKey> const & currentValue = mPrivateKey;
    if (!GetOrCreateDOMReflector(cx, currentValue, &temp)) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->privateKey_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    OwningNonNull<mozilla::dom::CryptoKey> const & currentValue = mPublicKey;
    if (!GetOrCreateDOMReflector(cx, currentValue, &temp)) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->publicKey_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
CryptoKeyPair::TraceDictionary(JSTracer* trc)
{
}



CryptoKeyPair&
CryptoKeyPair::operator=(const CryptoKeyPair& aOther)
{
  DictionaryBase::operator=(aOther);
  mPrivateKey = aOther.mPrivateKey;
  mPublicKey = aOther.mPublicKey;
  return *this;
}


bool
ObjectOrString::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char16_t>& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}








bool
ObjectOrString::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    if (!SetToObject(cx, &value.toObject(), passedToJSImpl)) {
      return false;
    }
    done = true;
  } else {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "object");
    return false;
  }
  return true;
}

bool
ObjectOrString::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
ObjectOrString::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eObject: {
      JS::ExposeObjectToActiveJS(mValue.mObject.Value());
      rval.setObject(*mValue.mObject.Value());
      if (!MaybeWrapObjectValue(cx, rval)) {
        return false;
      }
      return true;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningObjectOrString::OwningObjectOrString(OwningObjectOrString&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eObject: {
      mType = eObject;
      mValue.mObject.SetValue(std::move(aOther.mValue.mObject.Value()));
      break;
    }
    case eString: {
      mType = eString;
      mValue.mString.SetValue(std::move(aOther.mValue.mString.Value()));
      break;
    }
  }
}



[[nodiscard]] JSObject*&
OwningObjectOrString::RawSetAsObject()
{
  if (mType == eObject) {
    return mValue.mObject.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eObject;
  return mValue.mObject.SetValue();
}

[[nodiscard]] JSObject*&
OwningObjectOrString::SetAsObject()
{
  if (mType == eObject) {
    return mValue.mObject.Value();
  }
  Uninit();
  mType = eObject;
  return mValue.mObject.SetValue();
}


void
OwningObjectOrString::DestroyObject()
{
  MOZ_RELEASE_ASSERT(IsObject(), "Wrong type!");
  mValue.mObject.Destroy();
  mType = eUninitialized;
}



bool
OwningObjectOrString::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsString& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsString&
OwningObjectOrString::RawSetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eString;
  return mValue.mString.SetValue();
}

[[nodiscard]] nsString&
OwningObjectOrString::SetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  Uninit();
  mType = eString;
  return mValue.mString.SetValue();
}



void
OwningObjectOrString::DestroyString()
{
  MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
  mValue.mString.Destroy();
  mType = eUninitialized;
}



bool
OwningObjectOrString::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    if (!SetToObject(cx, &value.toObject(), passedToJSImpl)) {
      return false;
    }
    done = true;
  } else {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "object");
    return false;
  }
  return true;
}

bool
OwningObjectOrString::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningObjectOrString::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eObject: {
      DestroyObject();
      break;
    }
    case eString: {
      DestroyString();
      break;
    }
  }
}

bool
OwningObjectOrString::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eObject: {
      JS::ExposeObjectToActiveJS(mValue.mObject.Value());
      rval.setObject(*mValue.mObject.Value());
      if (!MaybeWrapObjectValue(cx, rval)) {
        return false;
      }
      return true;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

void
OwningObjectOrString::TraceUnion(JSTracer* trc)
{
  switch (mType) {
    case eObject: {
      JS::TraceRoot(trc, &mValue.mObject.Value(), "mValue.mObject");
      break;
    }
    default: {
    }
  }
}

OwningObjectOrString&
OwningObjectOrString::operator=(OwningObjectOrString&& aOther)
{
  this->~OwningObjectOrString();
  new (this) OwningObjectOrString (std::move(aOther));
  return *this;
}




RsaOtherPrimesInfo::RsaOtherPrimesInfo()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RsaOtherPrimesInfo::InitIds(JSContext* cx, RsaOtherPrimesInfoAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->t_id.init(cx, "t") ||
      !atomsCache->r_id.init(cx, "r") ||
      !atomsCache->d_id.init(cx, "d")) {
    return false;
  }
  return true;
}

bool
RsaOtherPrimesInfo::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RsaOtherPrimesInfoAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RsaOtherPrimesInfoAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->d_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mD)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'d' member of RsaOtherPrimesInfo");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->r_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mR)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'r' member of RsaOtherPrimesInfo");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->t_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mT)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'t' member of RsaOtherPrimesInfo");
  }
  return true;
}

bool
RsaOtherPrimesInfo::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RsaOtherPrimesInfo::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RsaOtherPrimesInfoAtoms* atomsCache = GetAtomCache<RsaOtherPrimesInfoAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mD;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->d_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mR;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->r_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mT;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->t_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RsaOtherPrimesInfo::TraceDictionary(JSTracer* trc)
{
}

RsaOtherPrimesInfo&
RsaOtherPrimesInfo::operator=(const RsaOtherPrimesInfo& aOther)
{
  DictionaryBase::operator=(aOther);
  mD = aOther.mD;
  mR = aOther.mR;
  mT = aOther.mT;
  return *this;
}



AesCbcParams::AesCbcParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
AesCbcParams::InitIds(JSContext* cx, AesCbcParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->iv_id.init(cx, "iv")) {
    return false;
  }
  return true;
}

bool
AesCbcParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  AesCbcParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<AesCbcParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->iv_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!mIv.Init(cx, temp.ref(), "'iv' member of AesCbcParams", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'iv' member of AesCbcParams");
  }
  return true;
}

bool
AesCbcParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
AesCbcParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
  mIv.TraceUnion(trc);
}



AesCtrParams::AesCtrParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
AesCtrParams::InitIds(JSContext* cx, AesCtrParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->length_id.init(cx, "length") ||
      !atomsCache->counter_id.init(cx, "counter")) {
    return false;
  }
  return true;
}

bool
AesCtrParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  AesCtrParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<AesCtrParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->counter_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!mCounter.Init(cx, temp.ref(), "'counter' member of AesCtrParams", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'counter' member of AesCtrParams");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->length_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint8_t, eEnforceRange>(cx, temp.ref(), "'length' member of AesCtrParams", &mLength)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'length' member of AesCtrParams");
  }
  return true;
}

bool
AesCtrParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
AesCtrParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
  mCounter.TraceUnion(trc);
}



AesDerivedKeyParams::AesDerivedKeyParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
AesDerivedKeyParams::InitIds(JSContext* cx, AesDerivedKeyParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->length_id.init(cx, "length")) {
    return false;
  }
  return true;
}

bool
AesDerivedKeyParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  AesDerivedKeyParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<AesDerivedKeyParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->length_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'length' member of AesDerivedKeyParams", &mLength)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'length' member of AesDerivedKeyParams");
  }
  return true;
}

bool
AesDerivedKeyParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
AesDerivedKeyParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
}

AesDerivedKeyParams&
AesDerivedKeyParams::operator=(const AesDerivedKeyParams& aOther)
{
  Algorithm::operator=(aOther);
  mLength = aOther.mLength;
  return *this;
}



AesGcmParams::AesGcmParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
AesGcmParams::InitIds(JSContext* cx, AesGcmParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->tagLength_id.init(cx, "tagLength") ||
      !atomsCache->iv_id.init(cx, "iv") ||
      !atomsCache->additionalData_id.init(cx, "additionalData")) {
    return false;
  }
  return true;
}

bool
AesGcmParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  AesGcmParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<AesGcmParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->additionalData_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mAdditionalData.Construct();
    if (!(mAdditionalData.Value()).Init(cx, temp.ref(), "'additionalData' member of AesGcmParams", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->iv_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!mIv.Init(cx, temp.ref(), "'iv' member of AesGcmParams", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'iv' member of AesGcmParams");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->tagLength_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mTagLength.Construct();
    if (!ValueToPrimitive<uint8_t, eEnforceRange>(cx, temp.ref(), "'tagLength' member of AesGcmParams", &(mTagLength.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
AesGcmParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
AesGcmParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
  if (mAdditionalData.WasPassed()) {
    mAdditionalData.Value().TraceUnion(trc);
  }

  mIv.TraceUnion(trc);
}



AesKeyGenParams::AesKeyGenParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
AesKeyGenParams::InitIds(JSContext* cx, AesKeyGenParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->length_id.init(cx, "length")) {
    return false;
  }
  return true;
}

bool
AesKeyGenParams::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!Algorithm::Init(nullptr, JS::NullHandleValue)) {
    return false;
  }

  return true;
}

void
AesKeyGenParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
}

AesKeyGenParams&
AesKeyGenParams::operator=(const AesKeyGenParams& aOther)
{
  Algorithm::operator=(aOther);
  mLength = aOther.mLength;
  return *this;
}



DhImportKeyParams::DhImportKeyParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
DhImportKeyParams::InitIds(JSContext* cx, DhImportKeyParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->prime_id.init(cx, "prime") ||
      !atomsCache->generator_id.init(cx, "generator")) {
    return false;
  }
  return true;
}

bool
DhImportKeyParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  DhImportKeyParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<DhImportKeyParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->generator_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      if (!mGenerator.Init(&temp.ref().toObject())) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'generator' member of DhImportKeyParams", "Uint8Array");
        return false;
      }
      if (JS::IsArrayBufferViewShared(mGenerator.Obj())) {
        cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_SHARED>("'generator' member of DhImportKeyParams");
        return false;
      }
      if (JS::IsLargeArrayBufferView(mGenerator.Obj())) {
        cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("'generator' member of DhImportKeyParams");
        return false;
      }
      if (JS::IsResizableArrayBufferView(mGenerator.Obj())) {
        cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("'generator' member of DhImportKeyParams");
        return false;
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'generator' member of DhImportKeyParams");
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'generator' member of DhImportKeyParams");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->prime_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      if (!mPrime.Init(&temp.ref().toObject())) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'prime' member of DhImportKeyParams", "Uint8Array");
        return false;
      }
      if (JS::IsArrayBufferViewShared(mPrime.Obj())) {
        cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_SHARED>("'prime' member of DhImportKeyParams");
        return false;
      }
      if (JS::IsLargeArrayBufferView(mPrime.Obj())) {
        cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("'prime' member of DhImportKeyParams");
        return false;
      }
      if (JS::IsResizableArrayBufferView(mPrime.Obj())) {
        cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("'prime' member of DhImportKeyParams");
        return false;
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'prime' member of DhImportKeyParams");
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'prime' member of DhImportKeyParams");
  }
  return true;
}

bool
DhImportKeyParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
DhImportKeyParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
  mGenerator.TraceSelf(trc);

  mPrime.TraceSelf(trc);
}



EcKeyGenParams::EcKeyGenParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
EcKeyGenParams::InitIds(JSContext* cx, EcKeyGenParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->namedCurve_id.init(cx, "namedCurve")) {
    return false;
  }
  return true;
}

bool
EcKeyGenParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  EcKeyGenParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<EcKeyGenParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->namedCurve_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mNamedCurve)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'namedCurve' member of EcKeyGenParams");
  }
  return true;
}

bool
EcKeyGenParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
EcKeyGenParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
}

EcKeyGenParams&
EcKeyGenParams::operator=(const EcKeyGenParams& aOther)
{
  Algorithm::operator=(aOther);
  mNamedCurve = aOther.mNamedCurve;
  return *this;
}



EcKeyImportParams::EcKeyImportParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
EcKeyImportParams::InitIds(JSContext* cx, EcKeyImportParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->namedCurve_id.init(cx, "namedCurve")) {
    return false;
  }
  return true;
}

bool
EcKeyImportParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  EcKeyImportParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<EcKeyImportParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->namedCurve_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mNamedCurve.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mNamedCurve.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
EcKeyImportParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
EcKeyImportParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
}

EcKeyImportParams&
EcKeyImportParams::operator=(const EcKeyImportParams& aOther)
{
  Algorithm::operator=(aOther);
  mNamedCurve.Reset();
  if (aOther.mNamedCurve.WasPassed()) {
    mNamedCurve.Construct(aOther.mNamedCurve.Value());
  }
  return *this;
}



EcdhKeyDeriveParams::EcdhKeyDeriveParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
EcdhKeyDeriveParams::InitIds(JSContext* cx, EcdhKeyDeriveParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->public_id.init(cx, "public")) {
    return false;
  }
  return true;
}

bool
EcdhKeyDeriveParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  EcdhKeyDeriveParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<EcdhKeyDeriveParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->public_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      static_assert(IsRefcounted<mozilla::dom::CryptoKey>::value, "We can only store refcounted classes.");
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::CryptoKey, mozilla::dom::CryptoKey>(temp.ptr(), mPublic, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'public' member of EcdhKeyDeriveParams", "CryptoKey");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'public' member of EcdhKeyDeriveParams");
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'public' member of EcdhKeyDeriveParams");
  }
  return true;
}

bool
EcdhKeyDeriveParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
EcdhKeyDeriveParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
}



EcdhKeyDeriveParams&
EcdhKeyDeriveParams::operator=(const EcdhKeyDeriveParams& aOther)
{
  Algorithm::operator=(aOther);
  mPublic = aOther.mPublic;
  return *this;
}



EcdsaParams::EcdsaParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
EcdsaParams::InitIds(JSContext* cx, EcdsaParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->hash_id.init(cx, "hash")) {
    return false;
  }
  return true;
}

bool
EcdsaParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  EcdsaParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<EcdsaParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->hash_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!mHash.Init(cx, temp.ref(), "'hash' member of EcdsaParams", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'hash' member of EcdsaParams");
  }
  return true;
}

bool
EcdsaParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
EcdsaParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
  mHash.TraceUnion(trc);
}



HkdfParams::HkdfParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
HkdfParams::InitIds(JSContext* cx, HkdfParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->salt_id.init(cx, "salt") ||
      !atomsCache->info_id.init(cx, "info") ||
      !atomsCache->hash_id.init(cx, "hash")) {
    return false;
  }
  return true;
}

bool
HkdfParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  HkdfParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<HkdfParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->hash_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!mHash.Init(cx, temp.ref(), "'hash' member of HkdfParams", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'hash' member of HkdfParams");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->info_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!mInfo.Init(cx, temp.ref(), "'info' member of HkdfParams", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'info' member of HkdfParams");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->salt_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!mSalt.Init(cx, temp.ref(), "'salt' member of HkdfParams", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'salt' member of HkdfParams");
  }
  return true;
}

bool
HkdfParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
HkdfParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
  mHash.TraceUnion(trc);

  mInfo.TraceUnion(trc);

  mSalt.TraceUnion(trc);
}



HmacImportParams::HmacImportParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
HmacImportParams::InitIds(JSContext* cx, HmacImportParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->hash_id.init(cx, "hash")) {
    return false;
  }
  return true;
}

bool
HmacImportParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  HmacImportParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<HmacImportParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->hash_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!mHash.Init(cx, temp.ref(), "'hash' member of HmacImportParams", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'hash' member of HmacImportParams");
  }
  return true;
}

bool
HmacImportParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
HmacImportParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
  mHash.TraceUnion(trc);
}



HmacKeyGenParams::HmacKeyGenParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
HmacKeyGenParams::InitIds(JSContext* cx, HmacKeyGenParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->length_id.init(cx, "length") ||
      !atomsCache->hash_id.init(cx, "hash")) {
    return false;
  }
  return true;
}

bool
HmacKeyGenParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  HmacKeyGenParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<HmacKeyGenParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->hash_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!mHash.Init(cx, temp.ref(), "'hash' member of HmacKeyGenParams", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'hash' member of HmacKeyGenParams");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->length_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mLength.Construct();
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'length' member of HmacKeyGenParams", &(mLength.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
HmacKeyGenParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
HmacKeyGenParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
  mHash.TraceUnion(trc);
}



JsonWebKey::JsonWebKey()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
JsonWebKey::InitIds(JSContext* cx, JsonWebKeyAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->y_id.init(cx, "y") ||
      !atomsCache->x_id.init(cx, "x") ||
      !atomsCache->use_id.init(cx, "use") ||
      !atomsCache->qi_id.init(cx, "qi") ||
      !atomsCache->q_id.init(cx, "q") ||
      !atomsCache->p_id.init(cx, "p") ||
      !atomsCache->oth_id.init(cx, "oth") ||
      !atomsCache->n_id.init(cx, "n") ||
      !atomsCache->kty_id.init(cx, "kty") ||
      !atomsCache->key_ops_id.init(cx, "key_ops") ||
      !atomsCache->k_id.init(cx, "k") ||
      !atomsCache->ext_id.init(cx, "ext") ||
      !atomsCache->e_id.init(cx, "e") ||
      !atomsCache->dq_id.init(cx, "dq") ||
      !atomsCache->dp_id.init(cx, "dp") ||
      !atomsCache->d_id.init(cx, "d") ||
      !atomsCache->crv_id.init(cx, "crv") ||
      !atomsCache->alg_id.init(cx, "alg")) {
    return false;
  }
  return true;
}

bool
JsonWebKey::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  JsonWebKeyAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<JsonWebKeyAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->alg_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mAlg.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mAlg.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->crv_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mCrv.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mCrv.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->d_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mD.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mD.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->dp_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mDp.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mDp.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->dq_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mDq.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mDq.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->e_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mE.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mE.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->ext_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mExt.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'ext' member of JsonWebKey", &(mExt.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->k_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mK.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mK.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->key_ops_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mKey_ops.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'key_ops' member of JsonWebKey", "sequence");
        return false;
      }
      Sequence<nsString> &arr = (mKey_ops.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        nsString* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        nsString& slot = *slotPtr;
        if (!ConvertJSValueToString(cx, temp, eStringify, eStringify, slot)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'key_ops' member of JsonWebKey", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->kty_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mKty)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'kty' member of JsonWebKey");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->n_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mN.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mN.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->oth_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mOth.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'oth' member of JsonWebKey", "sequence");
        return false;
      }
      Sequence<RsaOtherPrimesInfo> &arr = (mOth.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        RsaOtherPrimesInfo* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        RsaOtherPrimesInfo& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'oth' member of JsonWebKey", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'oth' member of JsonWebKey", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->p_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mP.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mP.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->q_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mQ.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mQ.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->qi_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mQi.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mQi.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->use_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mUse.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mUse.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->x_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mX.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mX.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->y_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mY.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mY.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
JsonWebKey::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
JsonWebKey::Init(const nsAString& aJSON)
{
  AutoJSAPI jsapi;
  JSObject* cleanGlobal = SimpleGlobalObject::Create(SimpleGlobalObject::GlobalType::BindingDetail);
  if (!cleanGlobal) {
    return false;
  }
  if (!jsapi.Init(cleanGlobal)) {
    return false;
  }
  JSContext* cx = jsapi.cx();
  JS::Rooted<JS::Value> json(cx);
  bool ok = ParseJSON(cx, aJSON, &json);
  NS_ENSURE_TRUE(ok, false);
  return Init(cx, json);
}

bool
JsonWebKey::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  JsonWebKeyAtoms* atomsCache = GetAtomCache<JsonWebKeyAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mAlg.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mAlg.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->alg_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mCrv.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mCrv.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->crv_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mD.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mD.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->d_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mDp.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mDp.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->dp_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mDq.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mDq.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->dq_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mE.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mE.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->e_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mExt.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mExt.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->ext_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mK.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mK.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->k_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mKey_ops.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<nsString> const & currentValue = mKey_ops.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!xpc::NonVoidStringToJsval(cx, currentValue[sequenceIdx0], &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->key_ops_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mKty;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->kty_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mN.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mN.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->n_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mOth.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<RsaOtherPrimesInfo> const & currentValue = mOth.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->oth_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mP.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mP.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->p_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mQ.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mQ.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->q_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mQi.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mQi.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->qi_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mUse.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mUse.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->use_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mX.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mX.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->x_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mY.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mY.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->y_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

bool
JsonWebKey::ToJSON(nsAString& aJSON) const
{
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext *cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here
  // because we'll only be creating objects, in ways that have no
  // side-effects, followed by a call to JS::ToJSONMaybeSafely,
  // which likewise guarantees no side-effects for the sorts of
  // things we will pass it.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    JS_ReportOutOfMemory(cx);
    return false;
  }
  JSAutoRealm ar(cx, scope);
  JS::Rooted<JS::Value> val(cx);
  if (!ToObjectInternal(cx, &val)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &val.toObject());
  return StringifyToJSON(cx, obj, aJSON);
}

void
JsonWebKey::TraceDictionary(JSTracer* trc)
{
}

JsonWebKey&
JsonWebKey::operator=(const JsonWebKey& aOther)
{
  DictionaryBase::operator=(aOther);
  mAlg.Reset();
  if (aOther.mAlg.WasPassed()) {
    mAlg.Construct(aOther.mAlg.Value());
  }
  mCrv.Reset();
  if (aOther.mCrv.WasPassed()) {
    mCrv.Construct(aOther.mCrv.Value());
  }
  mD.Reset();
  if (aOther.mD.WasPassed()) {
    mD.Construct(aOther.mD.Value());
  }
  mDp.Reset();
  if (aOther.mDp.WasPassed()) {
    mDp.Construct(aOther.mDp.Value());
  }
  mDq.Reset();
  if (aOther.mDq.WasPassed()) {
    mDq.Construct(aOther.mDq.Value());
  }
  mE.Reset();
  if (aOther.mE.WasPassed()) {
    mE.Construct(aOther.mE.Value());
  }
  mExt.Reset();
  if (aOther.mExt.WasPassed()) {
    mExt.Construct(aOther.mExt.Value());
  }
  mK.Reset();
  if (aOther.mK.WasPassed()) {
    mK.Construct(aOther.mK.Value());
  }
  mKey_ops.Reset();
  if (aOther.mKey_ops.WasPassed()) {
    mKey_ops.Construct(aOther.mKey_ops.Value());
  }
  mKty = aOther.mKty;
  mN.Reset();
  if (aOther.mN.WasPassed()) {
    mN.Construct(aOther.mN.Value());
  }
  mOth.Reset();
  if (aOther.mOth.WasPassed()) {
    mOth.Construct(aOther.mOth.Value());
  }
  mP.Reset();
  if (aOther.mP.WasPassed()) {
    mP.Construct(aOther.mP.Value());
  }
  mQ.Reset();
  if (aOther.mQ.WasPassed()) {
    mQ.Construct(aOther.mQ.Value());
  }
  mQi.Reset();
  if (aOther.mQi.WasPassed()) {
    mQi.Construct(aOther.mQi.Value());
  }
  mUse.Reset();
  if (aOther.mUse.WasPassed()) {
    mUse.Construct(aOther.mUse.Value());
  }
  mX.Reset();
  if (aOther.mX.WasPassed()) {
    mX.Construct(aOther.mX.Value());
  }
  mY.Reset();
  if (aOther.mY.WasPassed()) {
    mY.Construct(aOther.mY.Value());
  }
  return *this;
}



Pbkdf2Params::Pbkdf2Params()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
Pbkdf2Params::InitIds(JSContext* cx, Pbkdf2ParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->salt_id.init(cx, "salt") ||
      !atomsCache->iterations_id.init(cx, "iterations") ||
      !atomsCache->hash_id.init(cx, "hash")) {
    return false;
  }
  return true;
}

bool
Pbkdf2Params::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  Pbkdf2ParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<Pbkdf2ParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->hash_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!mHash.Init(cx, temp.ref(), "'hash' member of Pbkdf2Params", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'hash' member of Pbkdf2Params");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->iterations_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'iterations' member of Pbkdf2Params", &mIterations)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'iterations' member of Pbkdf2Params");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->salt_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!mSalt.Init(cx, temp.ref(), "'salt' member of Pbkdf2Params", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'salt' member of Pbkdf2Params");
  }
  return true;
}

bool
Pbkdf2Params::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
Pbkdf2Params::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
  mHash.TraceUnion(trc);

  mSalt.TraceUnion(trc);
}



RsaHashedImportParams::RsaHashedImportParams()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
RsaHashedImportParams::InitIds(JSContext* cx, RsaHashedImportParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->hash_id.init(cx, "hash")) {
    return false;
  }
  return true;
}

bool
RsaHashedImportParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RsaHashedImportParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RsaHashedImportParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->hash_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!mHash.Init(cx, temp.ref(), "'hash' member of RsaHashedImportParams", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'hash' member of RsaHashedImportParams");
  }
  return true;
}

bool
RsaHashedImportParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
RsaHashedImportParams::TraceDictionary(JSTracer* trc)
{
  mHash.TraceUnion(trc);
}



RsaHashedKeyGenParams::RsaHashedKeyGenParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
RsaHashedKeyGenParams::InitIds(JSContext* cx, RsaHashedKeyGenParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->publicExponent_id.init(cx, "publicExponent") ||
      !atomsCache->modulusLength_id.init(cx, "modulusLength") ||
      !atomsCache->hash_id.init(cx, "hash")) {
    return false;
  }
  return true;
}

bool
RsaHashedKeyGenParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RsaHashedKeyGenParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RsaHashedKeyGenParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->hash_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!mHash.Init(cx, temp.ref(), "'hash' member of RsaHashedKeyGenParams", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'hash' member of RsaHashedKeyGenParams");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->modulusLength_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'modulusLength' member of RsaHashedKeyGenParams", &mModulusLength)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'modulusLength' member of RsaHashedKeyGenParams");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->publicExponent_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      if (!mPublicExponent.Init(&temp.ref().toObject())) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'publicExponent' member of RsaHashedKeyGenParams", "Uint8Array");
        return false;
      }
      if (JS::IsArrayBufferViewShared(mPublicExponent.Obj())) {
        cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_SHARED>("'publicExponent' member of RsaHashedKeyGenParams");
        return false;
      }
      if (JS::IsLargeArrayBufferView(mPublicExponent.Obj())) {
        cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("'publicExponent' member of RsaHashedKeyGenParams");
        return false;
      }
      if (JS::IsResizableArrayBufferView(mPublicExponent.Obj())) {
        cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("'publicExponent' member of RsaHashedKeyGenParams");
        return false;
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'publicExponent' member of RsaHashedKeyGenParams");
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'publicExponent' member of RsaHashedKeyGenParams");
  }
  return true;
}

bool
RsaHashedKeyGenParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
RsaHashedKeyGenParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
  mHash.TraceUnion(trc);

  mPublicExponent.TraceSelf(trc);
}



RsaOaepParams::RsaOaepParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
RsaOaepParams::InitIds(JSContext* cx, RsaOaepParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->label_id.init(cx, "label")) {
    return false;
  }
  return true;
}

bool
RsaOaepParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RsaOaepParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RsaOaepParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->label_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mLabel.Construct();
    if (!(mLabel.Value()).Init(cx, temp.ref(), "'label' member of RsaOaepParams", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
RsaOaepParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
RsaOaepParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
  if (mLabel.WasPassed()) {
    mLabel.Value().TraceUnion(trc);
  }
}



RsaPssParams::RsaPssParams()
  : Algorithm(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RsaPssParams::InitIds(JSContext* cx, RsaPssParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->saltLength_id.init(cx, "saltLength")) {
    return false;
  }
  return true;
}

bool
RsaPssParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RsaPssParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RsaPssParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!Algorithm::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->saltLength_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'saltLength' member of RsaPssParams", &mSaltLength)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'saltLength' member of RsaPssParams");
  }
  return true;
}

bool
RsaPssParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
RsaPssParams::TraceDictionary(JSTracer* trc)
{
  Algorithm::TraceDictionary(trc);
}

RsaPssParams&
RsaPssParams::operator=(const RsaPssParams& aOther)
{
  Algorithm::operator=(aOther);
  mSaltLength = aOther.mSaltLength;
  return *this;
}



HmacDerivedKeyParams::HmacDerivedKeyParams()
  : HmacImportParams(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
HmacDerivedKeyParams::InitIds(JSContext* cx, HmacDerivedKeyParamsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->length_id.init(cx, "length")) {
    return false;
  }
  return true;
}

bool
HmacDerivedKeyParams::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  HmacDerivedKeyParamsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<HmacDerivedKeyParamsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!HmacImportParams::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->length_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mLength.Construct();
    if (!ValueToPrimitive<uint32_t, eEnforceRange>(cx, temp.ref(), "'length' member of HmacDerivedKeyParams", &(mLength.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
HmacDerivedKeyParams::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
HmacDerivedKeyParams::TraceDictionary(JSTracer* trc)
{
  HmacImportParams::TraceDictionary(trc);
}


namespace CryptoKey_Binding {

MOZ_CAN_RUN_SCRIPT static bool
get_type(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CryptoKey", "type", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CryptoKey*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetType(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetType(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo type_getterinfo = {
  { get_type },
  { prototypes::id::CryptoKey },
  { PrototypeTraits<prototypes::id::CryptoKey>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_extractable(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CryptoKey", "extractable", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CryptoKey*>(void_self);
  bool result(MOZ_KnownLive(self)->Extractable());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo extractable_getterinfo = {
  { get_extractable },
  { prototypes::id::CryptoKey },
  { PrototypeTraits<prototypes::id::CryptoKey>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_algorithm(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CryptoKey", "algorithm", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CryptoKey*>(void_self);
  // Have to either root across the getter call or reget after.
  bool isXray;
  JS::Rooted<JSObject*> slotStorage(cx, GetCachedSlotStorageObject(cx, obj, &isXray));
  if (!slotStorage) {
    return false;
  }
  const size_t slotIndex = isXray ? (DOM_EXPANDO_RESERVED_SLOTS + 0) : (DOM_INSTANCE_RESERVED_SLOTS + 0);
  MOZ_ASSERT(slotIndex < JSCLASS_RESERVED_SLOTS(JS::GetClass(slotStorage)));
  {
    // Scope for cachedVal
    JS::Value cachedVal = JS::GetReservedSlot(slotStorage, slotIndex);
    if (!cachedVal.isUndefined()) {
      args.rval().set(cachedVal);
      // The cached value is in the compartment of slotStorage,
      // so wrap into the caller compartment as needed.
      return MaybeWrapObjectValue(cx, args.rval());
    }
  }

  FastErrorResult rv;
  JS::Rooted<JSObject*> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetAlgorithm(cx, &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetAlgorithm(cx, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CryptoKey.algorithm getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  {
    JS::Rooted<JSObject*> conversionScope(cx, isXray ? JS::CurrentGlobalOrNull(cx) : slotStorage);
    JSAutoRealm ar(cx, conversionScope);
    do { // block we break out of when done wrapping
      JS::ExposeObjectToActiveJS(result);
      args.rval().setObject(*result);
      if (!MaybeWrapObjectValue(cx, args.rval())) {
        return false;
      }
      break;
    } while (false);
  }
  { // And now store things in the realm of our slotStorage.
    JSAutoRealm ar(cx, slotStorage);
    // Make a copy so that we don't do unnecessary wrapping on args.rval().
    JS::Rooted<JS::Value> storedVal(cx, args.rval());
    if (!MaybeWrapObjectValue(cx, &storedVal)) {
      return false;
    }
    JS::SetReservedSlot(slotStorage, slotIndex, storedVal);
    if (!isXray) {
      // In the Xray case we don't need to do this, because getting the
      // expando object already preserved our wrapper.
      PreserveWrapper(self);
    }
  }
  // And now make sure args.rval() is in the caller realm.
  return MaybeWrapObjectValue(cx, args.rval());
}

static const JSJitInfo algorithm_getterinfo = {
  { get_algorithm },
  { prototypes::id::CryptoKey },
  { PrototypeTraits<prototypes::id::CryptoKey>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  true, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  (DOM_INSTANCE_RESERVED_SLOTS + 0)   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) <= JSJitInfo::maxSlotIndex, "We won't fit");
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) < 3, "There is no slot for us");

MOZ_CAN_RUN_SCRIPT static bool
get_usages(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CryptoKey", "usages", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CryptoKey*>(void_self);
  // Have to either root across the getter call or reget after.
  bool isXray;
  JS::Rooted<JSObject*> slotStorage(cx, GetCachedSlotStorageObject(cx, obj, &isXray));
  if (!slotStorage) {
    return false;
  }
  const size_t slotIndex = isXray ? (DOM_EXPANDO_RESERVED_SLOTS + 1) : (DOM_INSTANCE_RESERVED_SLOTS + 1);
  MOZ_ASSERT(slotIndex < JSCLASS_RESERVED_SLOTS(JS::GetClass(slotStorage)));
  {
    // Scope for cachedVal
    JS::Value cachedVal = JS::GetReservedSlot(slotStorage, slotIndex);
    if (!cachedVal.isUndefined()) {
      args.rval().set(cachedVal);
      // The cached value is in the compartment of slotStorage,
      // so wrap into the caller compartment as needed.
      return MaybeWrapNonDOMObjectValue(cx, args.rval());
    }
  }

  nsTArray<nsString> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetUsages(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetUsages(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  {
    JS::Rooted<JSObject*> conversionScope(cx, isXray ? JS::CurrentGlobalOrNull(cx) : slotStorage);
    JSAutoRealm ar(cx, conversionScope);
    do { // block we break out of when done wrapping

      uint32_t length = result.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!xpc::NonVoidStringToJsval(cx, result[sequenceIdx0], &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      args.rval().setObject(*returnArray);
      break;
    } while (false);
    JS::Rooted<JSObject*> rvalObj(cx, &args.rval().toObject());
    if (!JS_FreezeObject(cx, rvalObj)) {
      return false;
    }
  }
  { // And now store things in the realm of our slotStorage.
    JSAutoRealm ar(cx, slotStorage);
    // Make a copy so that we don't do unnecessary wrapping on args.rval().
    JS::Rooted<JS::Value> storedVal(cx, args.rval());
    if (!MaybeWrapNonDOMObjectValue(cx, &storedVal)) {
      return false;
    }
    JS::SetReservedSlot(slotStorage, slotIndex, storedVal);
    if (!isXray) {
      // In the Xray case we don't need to do this, because getting the
      // expando object already preserved our wrapper.
      PreserveWrapper(self);
    }
  }
  // And now make sure args.rval() is in the caller realm.
  return MaybeWrapNonDOMObjectValue(cx, args.rval());
}

static const JSJitInfo usages_getterinfo = {
  { get_usages },
  { prototypes::id::CryptoKey },
  { PrototypeTraits<prototypes::id::CryptoKey>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  true, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  (DOM_INSTANCE_RESERVED_SLOTS + 1)   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 1) <= JSJitInfo::maxSlotIndex, "We won't fit");
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 1) < 3, "There is no slot for us");

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::CryptoKey* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::CryptoKey>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::CryptoKey>(self);
  }
}

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("type", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &type_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("extractable", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &extractable_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("algorithm", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &algorithm_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("usages", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &usages_getterinfo, nullptr, nullptr),
  JS_PS_END
};

static const PrefableDisablers sAttributes_disablers0 = {
  WebIDLPrefIndex::NoPref, 0, true, OriginTrial(0), nullptr
};

static const Prefable<const JSPropertySpec> sAttributes[] = {
  { &sAttributes_disablers0, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[4];
static PropertyInfo sNativeProperties_propertyInfos[4];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  false, 0,
  true,  0 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  4,
  sNativeProperties_sortedPropertyIndices,
  {
    { sAttributes, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(4 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

// This may allocate too many slots, because we only really need
// slots for our non-interface-typed members that we cache.  But
// allocating slots only for those would make the slot index
// computations much more complicated, so let's do this the simple
// way for now.
DEFINE_XRAY_EXPANDO_CLASS_WITH_OPS(static, sXrayExpandoObjectClass, 2,
                                   &xpc::XrayExpandoObjectClassOps);

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::CryptoKey,
  constructors::id::CryptoKey,
  &sXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::CryptoKey>::Depth,
  prototypes::id::CryptoKey,
  true,
  0,
  "CryptoKey",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "CryptoKeyPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::CryptoKey,
  PrototypeTraits<prototypes::id::CryptoKey>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return mozilla::dom::IsSecureContextOrObjectIsFromSecureContext(aCx, aObj);
}

static bool
Serialize(JSContext* aCx, JSStructuredCloneWriter* aWriter, JS::Handle<JSObject*> aObj)
{
  MOZ_ASSERT(IsDOMObject(aObj), "Non-DOM object passed");
  MOZ_ASSERT(GetDOMClass(aObj)->mSerializer == &Serialize,
             "Wrong object passed");
  return JS_WriteUint32Pair(aWriter, SCTAG_DOM_CRYPTOKEY, 0) &&
         UnwrapDOMObject<mozilla::dom::CryptoKey>(aObj)->WriteStructuredClone(aCx, aWriter);
}

JSObject*
Deserialize(JSContext* aCx, nsIGlobalObject* aGlobal, JSStructuredCloneReader* aReader)
{
  // Protect the result from a moving GC in ~RefPtr
  JS::Rooted<JSObject*> result(aCx);
  {  // Scope for the RefPtr
    RefPtr<mozilla::dom::CryptoKey> obj = mozilla::dom::CryptoKey::ReadStructuredClone(aCx, aGlobal, aReader);
    if (!obj) {
      return nullptr;
    }
    result = obj->WrapObject(aCx, nullptr);
    if (!result) {
      return nullptr;
    }
  }
  return result;
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<mozilla::dom::CryptoKey>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "CryptoKey",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(3),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::CryptoKey>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::CryptoKey, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::CryptoKey>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::CryptoKey>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::CryptoKey>::Get(),
  Serialize,
  NativeTypeHelpers<mozilla::dom::CryptoKey>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(3 >= 3,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::CryptoKey* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::CryptoKey>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::CryptoKey*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::CryptoKey> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::CryptoKey);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::CryptoKey);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "CryptoKey",
                              ShouldExpose<CryptoKey_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::CryptoKey,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::CryptoKey,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace CryptoKey_Binding



namespace SubtleCrypto_Binding {

MOZ_CAN_RUN_SCRIPT static bool
encrypt(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SubtleCrypto.encrypt");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SubtleCrypto", "encrypt", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::SubtleCrypto*>(void_self);
  if (!args.requireAtLeast(cx, "SubtleCrypto.encrypt", 3)) {
    return false;
  }
  ObjectOrString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  NonNull<mozilla::dom::CryptoKey> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CryptoKey, mozilla::dom::CryptoKey>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "CryptoKey");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  ArrayBufferViewOrArrayBuffer arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Encrypt(cx, Constify(arg0), MOZ_KnownLive(NonNullHelper(arg1)), Constify(arg2), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SubtleCrypto.encrypt"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
encrypt_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = encrypt(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo encrypt_methodinfo = {
  { (JSJitGetterOp)encrypt_promiseWrapper },
  { prototypes::id::SubtleCrypto },
  { PrototypeTraits<prototypes::id::SubtleCrypto>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
decrypt(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SubtleCrypto.decrypt");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SubtleCrypto", "decrypt", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::SubtleCrypto*>(void_self);
  if (!args.requireAtLeast(cx, "SubtleCrypto.decrypt", 3)) {
    return false;
  }
  ObjectOrString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  NonNull<mozilla::dom::CryptoKey> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CryptoKey, mozilla::dom::CryptoKey>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "CryptoKey");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  ArrayBufferViewOrArrayBuffer arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Decrypt(cx, Constify(arg0), MOZ_KnownLive(NonNullHelper(arg1)), Constify(arg2), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SubtleCrypto.decrypt"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
decrypt_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = decrypt(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo decrypt_methodinfo = {
  { (JSJitGetterOp)decrypt_promiseWrapper },
  { prototypes::id::SubtleCrypto },
  { PrototypeTraits<prototypes::id::SubtleCrypto>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
sign(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SubtleCrypto.sign");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SubtleCrypto", "sign", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::SubtleCrypto*>(void_self);
  if (!args.requireAtLeast(cx, "SubtleCrypto.sign", 3)) {
    return false;
  }
  ObjectOrString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  NonNull<mozilla::dom::CryptoKey> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CryptoKey, mozilla::dom::CryptoKey>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "CryptoKey");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  ArrayBufferViewOrArrayBuffer arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Sign(cx, Constify(arg0), MOZ_KnownLive(NonNullHelper(arg1)), Constify(arg2), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SubtleCrypto.sign"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
sign_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = sign(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo sign_methodinfo = {
  { (JSJitGetterOp)sign_promiseWrapper },
  { prototypes::id::SubtleCrypto },
  { PrototypeTraits<prototypes::id::SubtleCrypto>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
verify(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SubtleCrypto.verify");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SubtleCrypto", "verify", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::SubtleCrypto*>(void_self);
  if (!args.requireAtLeast(cx, "SubtleCrypto.verify", 4)) {
    return false;
  }
  ObjectOrString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  NonNull<mozilla::dom::CryptoKey> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CryptoKey, mozilla::dom::CryptoKey>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "CryptoKey");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  ArrayBufferViewOrArrayBuffer arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  ArrayBufferViewOrArrayBuffer arg3;
  if (!arg3.Init(cx, args[3], "Argument 4", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Verify(cx, Constify(arg0), MOZ_KnownLive(NonNullHelper(arg1)), Constify(arg2), Constify(arg3), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SubtleCrypto.verify"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
verify_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = verify(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo verify_methodinfo = {
  { (JSJitGetterOp)verify_promiseWrapper },
  { prototypes::id::SubtleCrypto },
  { PrototypeTraits<prototypes::id::SubtleCrypto>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
digest(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SubtleCrypto.digest");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SubtleCrypto", "digest", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::SubtleCrypto*>(void_self);
  if (!args.requireAtLeast(cx, "SubtleCrypto.digest", 2)) {
    return false;
  }
  ObjectOrString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  ArrayBufferViewOrArrayBuffer arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Digest(cx, Constify(arg0), Constify(arg1), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SubtleCrypto.digest"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
digest_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = digest(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo digest_methodinfo = {
  { (JSJitGetterOp)digest_promiseWrapper },
  { prototypes::id::SubtleCrypto },
  { PrototypeTraits<prototypes::id::SubtleCrypto>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
generateKey(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SubtleCrypto.generateKey");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SubtleCrypto", "generateKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::SubtleCrypto*>(void_self);
  if (!args.requireAtLeast(cx, "SubtleCrypto.generateKey", 3)) {
    return false;
  }
  ObjectOrString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  binding_detail::AutoSequence<nsString> arg2;
  if (args[2].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[2], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 3", "sequence");
      return false;
    }
    binding_detail::AutoSequence<nsString> &arr = arg2;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      nsString* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      nsString& slot = *slotPtr;
      if (!ConvertJSValueToString(cx, temp, eStringify, eStringify, slot)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 3", "sequence");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->GenerateKey(cx, Constify(arg0), arg1, Constify(arg2), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SubtleCrypto.generateKey"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
generateKey_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = generateKey(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo generateKey_methodinfo = {
  { (JSJitGetterOp)generateKey_promiseWrapper },
  { prototypes::id::SubtleCrypto },
  { PrototypeTraits<prototypes::id::SubtleCrypto>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
deriveKey(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SubtleCrypto.deriveKey");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SubtleCrypto", "deriveKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::SubtleCrypto*>(void_self);
  if (!args.requireAtLeast(cx, "SubtleCrypto.deriveKey", 5)) {
    return false;
  }
  ObjectOrString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  NonNull<mozilla::dom::CryptoKey> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CryptoKey, mozilla::dom::CryptoKey>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "CryptoKey");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  ObjectOrString arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  bool arg3;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  binding_detail::AutoSequence<nsString> arg4;
  if (args[4].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[4], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 5", "sequence");
      return false;
    }
    binding_detail::AutoSequence<nsString> &arr = arg4;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      nsString* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      nsString& slot = *slotPtr;
      if (!ConvertJSValueToString(cx, temp, eStringify, eStringify, slot)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 5", "sequence");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->DeriveKey(cx, Constify(arg0), MOZ_KnownLive(NonNullHelper(arg1)), Constify(arg2), arg3, Constify(arg4), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SubtleCrypto.deriveKey"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
deriveKey_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = deriveKey(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo deriveKey_methodinfo = {
  { (JSJitGetterOp)deriveKey_promiseWrapper },
  { prototypes::id::SubtleCrypto },
  { PrototypeTraits<prototypes::id::SubtleCrypto>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
deriveBits(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SubtleCrypto.deriveBits");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SubtleCrypto", "deriveBits", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::SubtleCrypto*>(void_self);
  if (!args.requireAtLeast(cx, "SubtleCrypto.deriveBits", 2)) {
    return false;
  }
  ObjectOrString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  NonNull<mozilla::dom::CryptoKey> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CryptoKey, mozilla::dom::CryptoKey>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "CryptoKey");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  Nullable<uint32_t> arg2;
  if (!(args.hasDefined(2)) || args[2].isNullOrUndefined()) {
    arg2.SetNull();
  } else if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2.SetValue())) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->DeriveBits(cx, Constify(arg0), MOZ_KnownLive(NonNullHelper(arg1)), Constify(arg2), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SubtleCrypto.deriveBits"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
deriveBits_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = deriveBits(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo deriveBits_methodinfo = {
  { (JSJitGetterOp)deriveBits_promiseWrapper },
  { prototypes::id::SubtleCrypto },
  { PrototypeTraits<prototypes::id::SubtleCrypto>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
importKey(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SubtleCrypto.importKey");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SubtleCrypto", "importKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::SubtleCrypto*>(void_self);
  if (!args.requireAtLeast(cx, "SubtleCrypto.importKey", 5)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  JS::Rooted<JSObject*> arg1(cx);
  if (args[1].isObject()) {
    arg1 = &args[1].toObject();
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  ObjectOrString arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  bool arg3;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  binding_detail::AutoSequence<nsString> arg4;
  if (args[4].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[4], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 5", "sequence");
      return false;
    }
    binding_detail::AutoSequence<nsString> &arr = arg4;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      nsString* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      nsString& slot = *slotPtr;
      if (!ConvertJSValueToString(cx, temp, eStringify, eStringify, slot)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 5", "sequence");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->ImportKey(cx, NonNullHelper(Constify(arg0)), arg1, Constify(arg2), arg3, Constify(arg4), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SubtleCrypto.importKey"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
importKey_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = importKey(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo importKey_methodinfo = {
  { (JSJitGetterOp)importKey_promiseWrapper },
  { prototypes::id::SubtleCrypto },
  { PrototypeTraits<prototypes::id::SubtleCrypto>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
exportKey(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SubtleCrypto.exportKey");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SubtleCrypto", "exportKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::SubtleCrypto*>(void_self);
  if (!args.requireAtLeast(cx, "SubtleCrypto.exportKey", 2)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  NonNull<mozilla::dom::CryptoKey> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CryptoKey, mozilla::dom::CryptoKey>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "CryptoKey");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->ExportKey(NonNullHelper(Constify(arg0)), MOZ_KnownLive(NonNullHelper(arg1)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SubtleCrypto.exportKey"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
exportKey_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = exportKey(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo exportKey_methodinfo = {
  { (JSJitGetterOp)exportKey_promiseWrapper },
  { prototypes::id::SubtleCrypto },
  { PrototypeTraits<prototypes::id::SubtleCrypto>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
wrapKey(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SubtleCrypto.wrapKey");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SubtleCrypto", "wrapKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::SubtleCrypto*>(void_self);
  if (!args.requireAtLeast(cx, "SubtleCrypto.wrapKey", 4)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  NonNull<mozilla::dom::CryptoKey> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CryptoKey, mozilla::dom::CryptoKey>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "CryptoKey");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  NonNull<mozilla::dom::CryptoKey> arg2;
  if (args[2].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CryptoKey, mozilla::dom::CryptoKey>(args[2], arg2, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 3", "CryptoKey");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
    return false;
  }
  ObjectOrString arg3;
  if (!arg3.Init(cx, args[3], "Argument 4", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->WrapKey(cx, NonNullHelper(Constify(arg0)), MOZ_KnownLive(NonNullHelper(arg1)), MOZ_KnownLive(NonNullHelper(arg2)), Constify(arg3), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SubtleCrypto.wrapKey"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
wrapKey_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = wrapKey(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo wrapKey_methodinfo = {
  { (JSJitGetterOp)wrapKey_promiseWrapper },
  { prototypes::id::SubtleCrypto },
  { PrototypeTraits<prototypes::id::SubtleCrypto>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
unwrapKey(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SubtleCrypto.unwrapKey");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SubtleCrypto", "unwrapKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::SubtleCrypto*>(void_self);
  if (!args.requireAtLeast(cx, "SubtleCrypto.unwrapKey", 7)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  ArrayBufferViewOrArrayBuffer arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  NonNull<mozilla::dom::CryptoKey> arg2;
  if (args[2].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CryptoKey, mozilla::dom::CryptoKey>(args[2], arg2, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 3", "CryptoKey");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
    return false;
  }
  ObjectOrString arg3;
  if (!arg3.Init(cx, args[3], "Argument 4", false)) {
    return false;
  }
  ObjectOrString arg4;
  if (!arg4.Init(cx, args[4], "Argument 5", false)) {
    return false;
  }
  bool arg5;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  }
  binding_detail::AutoSequence<nsString> arg6;
  if (args[6].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[6], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 7", "sequence");
      return false;
    }
    binding_detail::AutoSequence<nsString> &arr = arg6;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      nsString* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      nsString& slot = *slotPtr;
      if (!ConvertJSValueToString(cx, temp, eStringify, eStringify, slot)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 7", "sequence");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->UnwrapKey(cx, NonNullHelper(Constify(arg0)), Constify(arg1), MOZ_KnownLive(NonNullHelper(arg2)), Constify(arg3), Constify(arg4), arg5, Constify(arg6), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SubtleCrypto.unwrapKey"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
unwrapKey_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = unwrapKey(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo unwrapKey_methodinfo = {
  { (JSJitGetterOp)unwrapKey_promiseWrapper },
  { prototypes::id::SubtleCrypto },
  { PrototypeTraits<prototypes::id::SubtleCrypto>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::SubtleCrypto* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::SubtleCrypto>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::SubtleCrypto>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("encrypt", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&encrypt_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("decrypt", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&decrypt_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("sign", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&sign_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("verify", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&verify_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("digest", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&digest_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("generateKey", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&generateKey_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deriveKey", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&deriveKey_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deriveBits", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&deriveBits_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("importKey", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&importKey_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("exportKey", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&exportKey_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("wrapKey", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&wrapKey_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("unwrapKey", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&unwrapKey_methodinfo), 7, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};

static const PrefableDisablers sMethods_disablers0 = {
  WebIDLPrefIndex::NoPref, 0, true, OriginTrial(0), nullptr
};

static const Prefable<const JSFunctionSpec> sMethods[] = {
  { &sMethods_disablers0, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(12 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[12];
static PropertyInfo sNativeProperties_propertyInfos[12];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  12,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(12 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::SubtleCrypto,
  constructors::id::SubtleCrypto,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::SubtleCrypto>::Depth,
  prototypes::id::SubtleCrypto,
  true,
  0,
  "SubtleCrypto",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "SubtleCryptoPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::SubtleCrypto,
  PrototypeTraits<prototypes::id::SubtleCrypto>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return mozilla::dom::IsSecureContextOrObjectIsFromSecureContext(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<mozilla::dom::SubtleCrypto>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "SubtleCrypto",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::SubtleCrypto>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::SubtleCrypto, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::SubtleCrypto>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::SubtleCrypto>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::SubtleCrypto>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::SubtleCrypto>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::SubtleCrypto* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::SubtleCrypto>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::SubtleCrypto*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::SubtleCrypto> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::SubtleCrypto);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::SubtleCrypto);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "SubtleCrypto",
                              ShouldExpose<SubtleCrypto_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::SubtleCrypto,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::SubtleCrypto,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace SubtleCrypto_Binding



} // namespace mozilla::dom
