/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM ScrollViewChangeEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "ScrollViewChangeEvent.h"
#include "ScrollViewChangeEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScrollViewChangeEvent.h"

namespace mozilla::dom {


ScrollViewChangeEvent::ScrollViewChangeEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

ScrollViewChangeEvent::~ScrollViewChangeEvent()
{
}

ScrollViewChangeEvent*
ScrollViewChangeEvent::AsScrollViewChangeEvent()
{
  return this;
}

JSObject*
ScrollViewChangeEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return ScrollViewChangeEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<ScrollViewChangeEvent>
ScrollViewChangeEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const ScrollViewChangeEventInit& aEventInit)
{
  RefPtr<ScrollViewChangeEvent> e = new ScrollViewChangeEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInit.mBubbles, aEventInit.mCancelable);
  e->mState = aEventInit.mState;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInit.mComposed);
  return e.forget();
}

already_AddRefed<ScrollViewChangeEvent>
ScrollViewChangeEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const ScrollViewChangeEventInit& aEventInit)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInit);
}

ScrollState
ScrollViewChangeEvent::State() const
{
  return mState;
}


} // namespace mozilla::dom
