/* THIS FILE IS AUTOGENERATED FROM PeerConnectionObserver.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "DOMMediaStream.h"
#include "MainThreadUtils.h"
#include "PeerConnectionObserverBinding.h"
#include "RTCPeerConnectionBinding.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsfriendapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RTCRtpReceiver.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "nsDOMDataChannel.h"
#include "nsIGlobalObject.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



PCErrorData::PCErrorData()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
PCErrorData::InitIds(JSContext* cx, PCErrorDataAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->name_id.init(cx, "name") ||
      !atomsCache->message_id.init(cx, "message")) {
    return false;
  }
  return true;
}

bool
PCErrorData::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  PCErrorDataAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<PCErrorDataAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->message_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mMessage)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'message' member of PCErrorData");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->name_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<PCError>::Values,
                                                                         "PCError", "'name' member of PCErrorData",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mName = static_cast<PCError>(index);
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'name' member of PCErrorData");
  }
  return true;
}

bool
PCErrorData::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
PCErrorData::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  PCErrorDataAtoms* atomsCache = GetAtomCache<PCErrorDataAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mMessage;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->message_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    PCError const & currentValue = mName;
    if (!ToJSValue(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->name_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
PCErrorData::TraceDictionary(JSTracer* trc)
{
}

PCErrorData&
PCErrorData::operator=(const PCErrorData& aOther)
{
  DictionaryBase::operator=(aOther);
  mMessage = aOther.mMessage;
  mName = aOther.mName;
  return *this;
}


namespace PeerConnectionObserver_Binding {

MOZ_CAN_RUN_SCRIPT static bool
onCreateOfferSuccess(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "onCreateOfferSuccess", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  if (!args.requireAtLeast(cx, "PeerConnectionObserver.onCreateOfferSuccess", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->OnCreateOfferSuccess(NonNullHelper(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->OnCreateOfferSuccess(NonNullHelper(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.onCreateOfferSuccess"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo onCreateOfferSuccess_methodinfo = {
  { (JSJitGetterOp)onCreateOfferSuccess },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
onCreateOfferError(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "PeerConnectionObserver.onCreateOfferError");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "onCreateOfferError", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  if (!args.requireAtLeast(cx, "PeerConnectionObserver.onCreateOfferError", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  binding_detail::FastPCErrorData arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", true)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->OnCreateOfferError(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->OnCreateOfferError(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.onCreateOfferError"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo onCreateOfferError_methodinfo = {
  { (JSJitGetterOp)onCreateOfferError },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
onCreateAnswerSuccess(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "onCreateAnswerSuccess", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  if (!args.requireAtLeast(cx, "PeerConnectionObserver.onCreateAnswerSuccess", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->OnCreateAnswerSuccess(NonNullHelper(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->OnCreateAnswerSuccess(NonNullHelper(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.onCreateAnswerSuccess"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo onCreateAnswerSuccess_methodinfo = {
  { (JSJitGetterOp)onCreateAnswerSuccess },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
onCreateAnswerError(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "PeerConnectionObserver.onCreateAnswerError");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "onCreateAnswerError", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  if (!args.requireAtLeast(cx, "PeerConnectionObserver.onCreateAnswerError", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  binding_detail::FastPCErrorData arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", true)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->OnCreateAnswerError(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->OnCreateAnswerError(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.onCreateAnswerError"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo onCreateAnswerError_methodinfo = {
  { (JSJitGetterOp)onCreateAnswerError },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
onSetDescriptionSuccess(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "onSetDescriptionSuccess", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->OnSetDescriptionSuccess(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->OnSetDescriptionSuccess(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.onSetDescriptionSuccess"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo onSetDescriptionSuccess_methodinfo = {
  { (JSJitGetterOp)onSetDescriptionSuccess },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
onSetDescriptionError(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "PeerConnectionObserver.onSetDescriptionError");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "onSetDescriptionError", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  if (!args.requireAtLeast(cx, "PeerConnectionObserver.onSetDescriptionError", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  binding_detail::FastPCErrorData arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", true)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->OnSetDescriptionError(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->OnSetDescriptionError(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.onSetDescriptionError"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo onSetDescriptionError_methodinfo = {
  { (JSJitGetterOp)onSetDescriptionError },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
onAddIceCandidateSuccess(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "onAddIceCandidateSuccess", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->OnAddIceCandidateSuccess(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->OnAddIceCandidateSuccess(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.onAddIceCandidateSuccess"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo onAddIceCandidateSuccess_methodinfo = {
  { (JSJitGetterOp)onAddIceCandidateSuccess },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
onAddIceCandidateError(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "PeerConnectionObserver.onAddIceCandidateError");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "onAddIceCandidateError", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  if (!args.requireAtLeast(cx, "PeerConnectionObserver.onAddIceCandidateError", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  binding_detail::FastPCErrorData arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", true)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->OnAddIceCandidateError(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->OnAddIceCandidateError(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.onAddIceCandidateError"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo onAddIceCandidateError_methodinfo = {
  { (JSJitGetterOp)onAddIceCandidateError },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
onIceCandidate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "onIceCandidate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  if (!args.requireAtLeast(cx, "PeerConnectionObserver.onIceCandidate", 4)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  uint16_t arg0;
  if (!ValueToPrimitive<uint16_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg2;
  if (!ConvertJSValueToString(cx, args[2], eStringify, eStringify, arg2)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg3;
  if (!ConvertJSValueToString(cx, args[3], eStringify, eStringify, arg3)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->OnIceCandidate(arg0, NonNullHelper(Constify(arg1)), NonNullHelper(Constify(arg2)), NonNullHelper(Constify(arg3)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->OnIceCandidate(arg0, NonNullHelper(Constify(arg1)), NonNullHelper(Constify(arg2)), NonNullHelper(Constify(arg3)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.onIceCandidate"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo onIceCandidate_methodinfo = {
  { (JSJitGetterOp)onIceCandidate },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
notifyDataChannel(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "PeerConnectionObserver.notifyDataChannel");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "notifyDataChannel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  if (!args.requireAtLeast(cx, "PeerConnectionObserver.notifyDataChannel", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  NonNull<nsDOMDataChannel> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCDataChannel, nsDOMDataChannel>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "RTCDataChannel");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NotifyDataChannel(MOZ_KnownLive(NonNullHelper(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->NotifyDataChannel(MOZ_KnownLive(NonNullHelper(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.notifyDataChannel"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo notifyDataChannel_methodinfo = {
  { (JSJitGetterOp)notifyDataChannel },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
onStateChange(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "PeerConnectionObserver.onStateChange");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "onStateChange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  if (!args.requireAtLeast(cx, "PeerConnectionObserver.onStateChange", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  PCObserverStateType arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<true>(cx, args[0],
                                                                       binding_detail::EnumStrings<PCObserverStateType>::Values,
                                                                       "PCObserverStateType", "argument 1",
                                                                       &index)) {
      return false;
    }
    MOZ_ASSERT(index >= 0);
    arg0 = static_cast<PCObserverStateType>(index);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->OnStateChange(arg0, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->OnStateChange(arg0, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.onStateChange"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo onStateChange_methodinfo = {
  { (JSJitGetterOp)onStateChange },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
fireTrackEvent(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "PeerConnectionObserver.fireTrackEvent");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "fireTrackEvent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  if (!args.requireAtLeast(cx, "PeerConnectionObserver.fireTrackEvent", 2)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  NonNull<mozilla::dom::RTCRtpReceiver> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCRtpReceiver, mozilla::dom::RTCRtpReceiver>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "RTCRtpReceiver");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::AutoSequence<OwningNonNull<mozilla::DOMMediaStream>> arg1;
  if (args[1].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[1], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
      return false;
    }
    binding_detail::AutoSequence<OwningNonNull<mozilla::DOMMediaStream>> &arr = arg1;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      OwningNonNull<mozilla::DOMMediaStream>* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      OwningNonNull<mozilla::DOMMediaStream>& slot = *slotPtr;
      if (temp.isObject()) {
        static_assert(IsRefcounted<mozilla::DOMMediaStream>::value, "We can only store refcounted classes.");
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::MediaStream, mozilla::DOMMediaStream>(&temp, slot, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of argument 2", "MediaStream");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of argument 2");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->FireTrackEvent(MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->FireTrackEvent(MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.fireTrackEvent"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo fireTrackEvent_methodinfo = {
  { (JSJitGetterOp)fireTrackEvent },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
fireStreamEvent(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "PeerConnectionObserver.fireStreamEvent");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "fireStreamEvent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  if (!args.requireAtLeast(cx, "PeerConnectionObserver.fireStreamEvent", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  NonNull<mozilla::DOMMediaStream> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::MediaStream, mozilla::DOMMediaStream>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "MediaStream");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->FireStreamEvent(MOZ_KnownLive(NonNullHelper(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->FireStreamEvent(MOZ_KnownLive(NonNullHelper(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.fireStreamEvent"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo fireStreamEvent_methodinfo = {
  { (JSJitGetterOp)fireStreamEvent },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
fireNegotiationNeededEvent(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "fireNegotiationNeededEvent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->FireNegotiationNeededEvent(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->FireNegotiationNeededEvent(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.fireNegotiationNeededEvent"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo fireNegotiationNeededEvent_methodinfo = {
  { (JSJitGetterOp)fireNegotiationNeededEvent },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
onPacket(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "PeerConnectionObserver.onPacket");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "onPacket", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::PeerConnectionObserver*>(void_self);
  if (!args.requireAtLeast(cx, "PeerConnectionObserver.onPacket", 4)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  mozPacketDumpType arg1;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<true>(cx, args[1],
                                                                       binding_detail::EnumStrings<mozPacketDumpType>::Values,
                                                                       "mozPacketDumpType", "argument 2",
                                                                       &index)) {
      return false;
    }
    MOZ_ASSERT(index >= 0);
    arg1 = static_cast<mozPacketDumpType>(index);
  }
  bool arg2;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  RootedSpiderMonkeyInterface<ArrayBuffer> arg3(cx);
  if (args[3].isObject()) {
    if (!arg3.Init(&args[3].toObject())) {
      cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 4", "ArrayBuffer");
      return false;
    }
    if (JS::IsSharedArrayBufferObject(arg3.Obj())) {
      cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_SHARED>("Argument 4");
      return false;
    }
    if (JS::IsLargeArrayBufferMaybeShared(arg3.Obj())) {
      cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 4");
      return false;
    }
    if (JS::IsResizableArrayBufferMaybeShared(arg3.Obj())) {
      cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 4");
      return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 4");
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->OnPacket(arg0, arg1, arg2, Constify(arg3), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->OnPacket(arg0, arg1, arg2, Constify(arg3), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver.onPacket"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo onPacket_methodinfo = {
  { (JSJitGetterOp)onPacket },
  { prototypes::id::PeerConnectionObserver },
  { PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::PeerConnectionObserver* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::PeerConnectionObserver>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::PeerConnectionObserver>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sChromeStaticMethods_specs[] = {
  JS_FNSPEC("_create", PeerConnectionObserver::_Create, nullptr, 2, 0, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sChromeStaticMethods[] = {
  { nullptr, &sChromeStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("onCreateOfferSuccess", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&onCreateOfferSuccess_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("onCreateOfferError", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&onCreateOfferError_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("onCreateAnswerSuccess", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&onCreateAnswerSuccess_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("onCreateAnswerError", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&onCreateAnswerError_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("onSetDescriptionSuccess", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&onSetDescriptionSuccess_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("onSetDescriptionError", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&onSetDescriptionError_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("onAddIceCandidateSuccess", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&onAddIceCandidateSuccess_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("onAddIceCandidateError", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&onAddIceCandidateError_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("onIceCandidate", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&onIceCandidate_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("notifyDataChannel", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&notifyDataChannel_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("onStateChange", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&onStateChange_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("fireTrackEvent", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&fireTrackEvent_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("fireStreamEvent", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&fireStreamEvent_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("fireNegotiationNeededEvent", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&fireNegotiationNeededEvent_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("onPacket", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&onPacket_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(15 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[15];
static PropertyInfo sNativeProperties_propertyInfos[15];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  15,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(15 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[1];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[1];

static const NativePropertiesN<1> sChromeOnlyNativeProperties = {
  true,  0 /* sChromeStaticMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  1,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeStaticMethods, &sChromeOnlyNativeProperties_propertyInfos[0] }
  }
};
static_assert(1 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::PeerConnectionObserver,
  constructors::id::PeerConnectionObserver,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "PeerConnectionObserver constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PeerConnectionObserver", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "PeerConnectionObserver");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::PeerConnectionObserver,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "PeerConnectionObserver constructor", 1)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  NonNull<mozilla::dom::RTCPeerConnection> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCPeerConnection, mozilla::dom::RTCPeerConnection>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "RTCPeerConnection");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::PeerConnectionObserver>(mozilla::dom::PeerConnectionObserver::Constructor(global, cx, MOZ_KnownLive(NonNullHelper(arg0)), rv, desiredProto)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PeerConnectionObserver constructor"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth,
  prototypes::id::PeerConnectionObserver,
  true,
  1,
  "PeerConnectionObserver",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "PeerConnectionObserverPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::PeerConnectionObserver,
  PrototypeTraits<prototypes::id::PeerConnectionObserver>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return nsContentUtils::ThreadsafeIsSystemCaller(aCx);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<mozilla::dom::PeerConnectionObserver>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "PeerConnectionObserver",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::PeerConnectionObserver>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::PeerConnectionObserver, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::PeerConnectionObserver>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::PeerConnectionObserver>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::PeerConnectionObserver>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::PeerConnectionObserver>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::PeerConnectionObserver* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::PeerConnectionObserver>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::PeerConnectionObserver*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::PeerConnectionObserver> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::PeerConnectionObserver);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::PeerConnectionObserver);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 1, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              sChromeOnlyNativeProperties.Upcast(),
                              "PeerConnectionObserver",
                              ShouldExpose<PeerConnectionObserver_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::PeerConnectionObserver,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::PeerConnectionObserver,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace PeerConnectionObserver_Binding



void
PeerConnectionObserverJSImpl::OnCreateOfferSuccess(const nsAString& offer, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.onCreateOfferSuccess", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!xpc::NonVoidStringToJsval(cx, offer, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->onCreateOfferSuccess_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::OnCreateOfferError(const PCErrorData& error, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.onCreateOfferError", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!error.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->onCreateOfferError_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::OnCreateAnswerSuccess(const nsAString& answer, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.onCreateAnswerSuccess", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!xpc::NonVoidStringToJsval(cx, answer, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->onCreateAnswerSuccess_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::OnCreateAnswerError(const PCErrorData& error, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.onCreateAnswerError", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!error.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->onCreateAnswerError_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::OnSetDescriptionSuccess(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.onSetDescriptionSuccess", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->onSetDescriptionSuccess_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::OnSetDescriptionError(const PCErrorData& error, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.onSetDescriptionError", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!error.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->onSetDescriptionError_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::OnAddIceCandidateSuccess(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.onAddIceCandidateSuccess", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->onAddIceCandidateSuccess_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::OnAddIceCandidateError(const PCErrorData& error, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.onAddIceCandidateError", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!error.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->onAddIceCandidateError_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::OnIceCandidate(uint16_t level, const nsAString& mid, const nsAString& candidate, const nsAString& ufrag, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.onIceCandidate", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(4)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 4;

  do {
    if (!xpc::NonVoidStringToJsval(cx, ufrag, argv[3])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  do {
    if (!xpc::NonVoidStringToJsval(cx, candidate, argv[2])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  do {
    if (!xpc::NonVoidStringToJsval(cx, mid, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  do {
    argv[0].setInt32(int32_t(level));
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->onIceCandidate_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::NotifyDataChannel(nsDOMDataChannel& channel, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.notifyDataChannel", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!GetOrCreateDOMReflector(cx, channel, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->notifyDataChannel_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::OnStateChange(PCObserverStateType state, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.onStateChange", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!ToJSValue(cx, state, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->onStateChange_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::FireTrackEvent(RTCRtpReceiver& receiver, const Sequence<OwningNonNull<DOMMediaStream>>& streams, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.fireTrackEvent", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(2)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 2;

  do {

    uint32_t length = streams.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!GetOrCreateDOMReflector(cx, streams[sequenceIdx0], &tmp)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          aRv.Throw(NS_ERROR_UNEXPECTED);
          return;
        }
      }
    }
    argv[1].setObject(*returnArray);
    break;
  } while (false);

  do {
    if (!GetOrCreateDOMReflector(cx, receiver, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->fireTrackEvent_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::FireStreamEvent(DOMMediaStream& stream, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.fireStreamEvent", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!GetOrCreateDOMReflector(cx, stream, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->fireStreamEvent_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::FireNegotiationNeededEvent(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.fireNegotiationNeededEvent", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->fireNegotiationNeededEvent_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::OnPacket(uint32_t level, mozPacketDumpType type, bool sending, const ArrayBuffer& packet, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "PeerConnectionObserver.onPacket", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(4)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 4;

  do {
    argv[3].setObject(*packet.Obj());
    if (!MaybeWrapNonDOMObjectValue(cx, argv[3])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  do {
    argv[2].setBoolean(sending);
    break;
  } while (false);

  do {
    if (!ToJSValue(cx, type, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  do {
    argv[0].setNumber(level);
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->onPacket_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
PeerConnectionObserverJSImpl::__Init(RTCPeerConnection& domPC, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "__init", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!GetOrCreateDOMReflector(cx, domPC, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  PeerConnectionObserverAtoms* atomsCache = GetAtomCache<PeerConnectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->__init_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

bool
PeerConnectionObserverJSImpl::InitIds(JSContext* cx, PeerConnectionObserverAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->__init_id.init(cx, "__init") ||
      !atomsCache->onPacket_id.init(cx, "onPacket") ||
      !atomsCache->fireNegotiationNeededEvent_id.init(cx, "fireNegotiationNeededEvent") ||
      !atomsCache->fireStreamEvent_id.init(cx, "fireStreamEvent") ||
      !atomsCache->fireTrackEvent_id.init(cx, "fireTrackEvent") ||
      !atomsCache->onStateChange_id.init(cx, "onStateChange") ||
      !atomsCache->notifyDataChannel_id.init(cx, "notifyDataChannel") ||
      !atomsCache->onIceCandidate_id.init(cx, "onIceCandidate") ||
      !atomsCache->onAddIceCandidateError_id.init(cx, "onAddIceCandidateError") ||
      !atomsCache->onAddIceCandidateSuccess_id.init(cx, "onAddIceCandidateSuccess") ||
      !atomsCache->onSetDescriptionError_id.init(cx, "onSetDescriptionError") ||
      !atomsCache->onSetDescriptionSuccess_id.init(cx, "onSetDescriptionSuccess") ||
      !atomsCache->onCreateAnswerError_id.init(cx, "onCreateAnswerError") ||
      !atomsCache->onCreateAnswerSuccess_id.init(cx, "onCreateAnswerSuccess") ||
      !atomsCache->onCreateOfferError_id.init(cx, "onCreateOfferError") ||
      !atomsCache->onCreateOfferSuccess_id.init(cx, "onCreateOfferSuccess")) {
    return false;
  }
  return true;
}



NS_IMPL_CYCLE_COLLECTION_WRAPPERCACHE_CLASS(PeerConnectionObserver)
NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN(PeerConnectionObserver)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mImpl)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mParent)
  NS_IMPL_CYCLE_COLLECTION_UNLINK_PRESERVED_WRAPPER
  tmp->ClearWeakReferences();
NS_IMPL_CYCLE_COLLECTION_UNLINK_END
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN(PeerConnectionObserver)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mImpl)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mParent)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END
NS_IMPL_CYCLE_COLLECTING_ADDREF(PeerConnectionObserver)
NS_IMPL_CYCLE_COLLECTING_RELEASE(PeerConnectionObserver)
NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(PeerConnectionObserver)
  NS_WRAPPERCACHE_INTERFACE_MAP_ENTRY
  NS_INTERFACE_MAP_ENTRY(nsISupports)
  NS_INTERFACE_MAP_ENTRY(nsISupportsWeakReference)
NS_INTERFACE_MAP_END

PeerConnectionObserver::PeerConnectionObserver(JS::Handle<JSObject*> aJSImplObject, JS::Handle<JSObject*> aJSImplGlobal, nsIGlobalObject* aParent)
  : mImpl(new PeerConnectionObserverJSImpl(nullptr, aJSImplObject, aJSImplGlobal, /* aIncumbentGlobal = */ nullptr)),
    mParent(aParent)
{
}


PeerConnectionObserver::~PeerConnectionObserver()
{
}

nsISupports*
PeerConnectionObserver::GetParentObject() const
{
  return mParent;
}

JSObject*
PeerConnectionObserver::WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  JS::Rooted<JSObject*> obj(aCx, PeerConnectionObserver_Binding::Wrap(aCx, this, aGivenProto));
  if (!obj) {
    return nullptr;
  }

  // Now define it on our chrome object
  JSAutoRealm ar(aCx, mImpl->CallbackGlobalOrNull());
  if (!JS_WrapObject(aCx, &obj)) {
    return nullptr;
  }
  JS::Rooted<JSObject*> callback(aCx, mImpl->CallbackOrNull());
  if (!JS_DefineProperty(aCx, callback, "__DOM_IMPL__", obj, 0)) {
    return nullptr;
  }
  return obj;
}

already_AddRefed<PeerConnectionObserver>
PeerConnectionObserver::Constructor(const GlobalObject& global, JSContext* cx, RTCPeerConnection& domPC, ErrorResult& aRv, JS::Handle<JSObject*> aGivenProto)
{
  RefPtr<PeerConnectionObserver> impl =
    ConstructJSImplementation<PeerConnectionObserver>("@mozilla.org/dom/peerconnectionobserver;1", global, aRv);
  if (aRv.Failed()) {
    return nullptr;
  }
  // Wrap the object before calling __Init so that __DOM_IMPL__ is available.
  JS::Rooted<JSObject*> scopeObj(cx, global.Get());
  MOZ_ASSERT(js::IsObjectInContextCompartment(scopeObj, cx));
  JS::Rooted<JS::Value> wrappedVal(cx);
  if (!GetOrCreateDOMReflector(cx, impl, &wrappedVal, aGivenProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  // Initialize the object with the constructor arguments.
  impl->mImpl->__Init(domPC, aRv, js::GetNonCCWObjectRealm(scopeObj));
  if (aRv.Failed()) {
    return nullptr;
  }
  return impl.forget();
}

void
PeerConnectionObserver::OnCreateOfferSuccess(const nsAString& offer, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->OnCreateOfferSuccess(offer, aRv, aRealm);
}

void
PeerConnectionObserver::OnCreateOfferError(const PCErrorData& error, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->OnCreateOfferError(error, aRv, aRealm);
}

void
PeerConnectionObserver::OnCreateAnswerSuccess(const nsAString& answer, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->OnCreateAnswerSuccess(answer, aRv, aRealm);
}

void
PeerConnectionObserver::OnCreateAnswerError(const PCErrorData& error, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->OnCreateAnswerError(error, aRv, aRealm);
}

void
PeerConnectionObserver::OnSetDescriptionSuccess(ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->OnSetDescriptionSuccess(aRv, aRealm);
}

void
PeerConnectionObserver::OnSetDescriptionError(const PCErrorData& error, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->OnSetDescriptionError(error, aRv, aRealm);
}

void
PeerConnectionObserver::OnAddIceCandidateSuccess(ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->OnAddIceCandidateSuccess(aRv, aRealm);
}

void
PeerConnectionObserver::OnAddIceCandidateError(const PCErrorData& error, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->OnAddIceCandidateError(error, aRv, aRealm);
}

void
PeerConnectionObserver::OnIceCandidate(uint16_t level, const nsAString& mid, const nsAString& candidate, const nsAString& ufrag, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->OnIceCandidate(level, mid, candidate, ufrag, aRv, aRealm);
}

void
PeerConnectionObserver::NotifyDataChannel(nsDOMDataChannel& channel, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->NotifyDataChannel(channel, aRv, aRealm);
}

void
PeerConnectionObserver::OnStateChange(PCObserverStateType state, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->OnStateChange(state, aRv, aRealm);
}

void
PeerConnectionObserver::FireTrackEvent(RTCRtpReceiver& receiver, const Sequence<OwningNonNull<DOMMediaStream>>& streams, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->FireTrackEvent(receiver, streams, aRv, aRealm);
}

void
PeerConnectionObserver::FireStreamEvent(DOMMediaStream& stream, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->FireStreamEvent(stream, aRv, aRealm);
}

void
PeerConnectionObserver::FireNegotiationNeededEvent(ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->FireNegotiationNeededEvent(aRv, aRealm);
}

void
PeerConnectionObserver::OnPacket(uint32_t level, mozPacketDumpType type, bool sending, const ArrayBuffer& packet, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->OnPacket(level, type, sending, packet, aRv, aRealm);
}

bool
PeerConnectionObserver::_Create(JSContext* cx, unsigned argc, JS::Value* vp)
{
  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  if (!args.requireAtLeast(cx, "PeerConnectionObserver._create", 2)) {
    return false;
  }
  BindingCallContext callCx(cx, "PeerConnectionObserver._create");
  if (!args[0].isObject()) {
    return callCx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
  }
  if (!args[1].isObject()) {
    return callCx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
  }

  // GlobalObject will go through wrappers as needed for us, and
  // is simpler than the right UnwrapArg incantation.
  GlobalObject global(cx, &args[0].toObject());
  if (global.Failed()) {
    return false;
  }
  nsCOMPtr<nsIGlobalObject> globalHolder = do_QueryInterface(global.GetAsSupports());
  MOZ_ASSERT(globalHolder);
  JS::Rooted<JSObject*> arg(cx, &args[1].toObject());
  JS::Rooted<JSObject*> argGlobal(cx, JS::CurrentGlobalOrNull(cx));
  RefPtr<PeerConnectionObserver> impl = new PeerConnectionObserver(arg, argGlobal, globalHolder);
  MOZ_ASSERT(js::IsObjectInContextCompartment(arg, cx));
  return GetOrCreateDOMReflector(cx, impl, args.rval());
}


} // namespace mozilla::dom
