/* THIS FILE IS AUTOGENERATED FROM NetDashboard.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "NetDashboardBinding.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



ConnStatusDict::ConnStatusDict()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
ConnStatusDict::InitIds(JSContext* cx, ConnStatusDictAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->status_id.init(cx, "status")) {
    return false;
  }
  return true;
}

bool
ConnStatusDict::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mStatus.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
ConnStatusDict::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  ConnStatusDictAtoms* atomsCache = GetAtomCache<ConnStatusDictAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mStatus;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->status_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
ConnStatusDict::TraceDictionary(JSTracer* trc)
{
}

ConnStatusDict&
ConnStatusDict::operator=(const ConnStatusDict& aOther)
{
  DictionaryBase::operator=(aOther);
  mStatus = aOther.mStatus;
  return *this;
}



DNSLookupDict::DNSLookupDict()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
DNSLookupDict::InitIds(JSContext* cx, DNSLookupDictAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->error_id.init(cx, "error") ||
      !atomsCache->answer_id.init(cx, "answer") ||
      !atomsCache->address_id.init(cx, "address")) {
    return false;
  }
  return true;
}

bool
DNSLookupDict::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mAnswer = false;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mError.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
DNSLookupDict::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  DNSLookupDictAtoms* atomsCache = GetAtomCache<DNSLookupDictAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mAddress.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<nsString> const & currentValue = mAddress.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!xpc::NonVoidStringToJsval(cx, currentValue[sequenceIdx0], &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->address_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mAnswer;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->answer_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mError;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->error_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
DNSLookupDict::TraceDictionary(JSTracer* trc)
{
}

DNSLookupDict&
DNSLookupDict::operator=(const DNSLookupDict& aOther)
{
  DictionaryBase::operator=(aOther);
  mAddress.Reset();
  if (aOther.mAddress.WasPassed()) {
    mAddress.Construct(aOther.mAddress.Value());
  }
  mAnswer = aOther.mAnswer;
  mError = aOther.mError;
  return *this;
}



DnsAndSockInfoDict::DnsAndSockInfoDict()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
DnsAndSockInfoDict::InitIds(JSContext* cx, DnsAndSockInfoDictAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->speculative_id.init(cx, "speculative")) {
    return false;
  }
  return true;
}

bool
DnsAndSockInfoDict::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mSpeculative = false;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
DnsAndSockInfoDict::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  DnsAndSockInfoDictAtoms* atomsCache = GetAtomCache<DnsAndSockInfoDictAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mSpeculative;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->speculative_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
DnsAndSockInfoDict::TraceDictionary(JSTracer* trc)
{
}

DnsAndSockInfoDict&
DnsAndSockInfoDict::operator=(const DnsAndSockInfoDict& aOther)
{
  DictionaryBase::operator=(aOther);
  mSpeculative = aOther.mSpeculative;
  return *this;
}



DnsCacheEntry::DnsCacheEntry()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
DnsCacheEntry::InitIds(JSContext* cx, DnsCacheEntryAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->type_id.init(cx, "type") ||
      !atomsCache->trr_id.init(cx, "trr") ||
      !atomsCache->originAttributesSuffix_id.init(cx, "originAttributesSuffix") ||
      !atomsCache->hostname_id.init(cx, "hostname") ||
      !atomsCache->hostaddr_id.init(cx, "hostaddr") ||
      !atomsCache->flags_id.init(cx, "flags") ||
      !atomsCache->family_id.init(cx, "family") ||
      !atomsCache->expiration_id.init(cx, "expiration")) {
    return false;
  }
  return true;
}

bool
DnsCacheEntry::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mExpiration = 0.0;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mFamily.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mFlags.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mHostname.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mOriginAttributesSuffix.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mTrr = false;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mType = 0;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
DnsCacheEntry::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  DnsCacheEntryAtoms* atomsCache = GetAtomCache<DnsCacheEntryAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mExpiration;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->expiration_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mFamily;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->family_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mFlags;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->flags_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mHostaddr.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<nsString> const & currentValue = mHostaddr.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!xpc::NonVoidStringToJsval(cx, currentValue[sequenceIdx0], &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->hostaddr_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mHostname;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->hostname_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mOriginAttributesSuffix;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->originAttributesSuffix_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mTrr;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->trr_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint16_t const & currentValue = mType;
    temp.setInt32(int32_t(currentValue));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->type_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
DnsCacheEntry::TraceDictionary(JSTracer* trc)
{
}

DnsCacheEntry&
DnsCacheEntry::operator=(const DnsCacheEntry& aOther)
{
  DictionaryBase::operator=(aOther);
  mExpiration = aOther.mExpiration;
  mFamily = aOther.mFamily;
  mFlags = aOther.mFlags;
  mHostaddr.Reset();
  if (aOther.mHostaddr.WasPassed()) {
    mHostaddr.Construct(aOther.mHostaddr.Value());
  }
  mHostname = aOther.mHostname;
  mOriginAttributesSuffix = aOther.mOriginAttributesSuffix;
  mTrr = aOther.mTrr;
  mType = aOther.mType;
  return *this;
}



HttpConnInfo::HttpConnInfo()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
HttpConnInfo::InitIds(JSContext* cx, HttpConnInfoAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->ttl_id.init(cx, "ttl") ||
      !atomsCache->rtt_id.init(cx, "rtt") ||
      !atomsCache->protocolVersion_id.init(cx, "protocolVersion")) {
    return false;
  }
  return true;
}

bool
HttpConnInfo::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mProtocolVersion.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mRtt = 0U;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mTtl = 0U;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
HttpConnInfo::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  HttpConnInfoAtoms* atomsCache = GetAtomCache<HttpConnInfoAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mProtocolVersion;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->protocolVersion_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mRtt;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->rtt_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mTtl;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->ttl_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
HttpConnInfo::TraceDictionary(JSTracer* trc)
{
}

HttpConnInfo&
HttpConnInfo::operator=(const HttpConnInfo& aOther)
{
  DictionaryBase::operator=(aOther);
  mProtocolVersion = aOther.mProtocolVersion;
  mRtt = aOther.mRtt;
  mTtl = aOther.mTtl;
  return *this;
}



RcwnPerfStats::RcwnPerfStats()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RcwnPerfStats::InitIds(JSContext* cx, RcwnPerfStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->stddevLong_id.init(cx, "stddevLong") ||
      !atomsCache->avgShort_id.init(cx, "avgShort") ||
      !atomsCache->avgLong_id.init(cx, "avgLong")) {
    return false;
  }
  return true;
}

bool
RcwnPerfStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mAvgLong = 0U;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mAvgShort = 0U;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mStddevLong = 0U;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
RcwnPerfStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RcwnPerfStatsAtoms* atomsCache = GetAtomCache<RcwnPerfStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mAvgLong;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->avgLong_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mAvgShort;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->avgShort_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mStddevLong;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->stddevLong_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RcwnPerfStats::TraceDictionary(JSTracer* trc)
{
}

RcwnPerfStats&
RcwnPerfStats::operator=(const RcwnPerfStats& aOther)
{
  DictionaryBase::operator=(aOther);
  mAvgLong = aOther.mAvgLong;
  mAvgShort = aOther.mAvgShort;
  mStddevLong = aOther.mStddevLong;
  return *this;
}



SVCParam::SVCParam()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
SVCParam::InitIds(JSContext* cx, SVCParamAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->type_id.init(cx, "type")) {
    return false;
  }
  return true;
}

bool
SVCParam::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mType = 0;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SVCParam::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  SVCParamAtoms* atomsCache = GetAtomCache<SVCParamAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint16_t const & currentValue = mType;
    temp.setInt32(int32_t(currentValue));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->type_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
SVCParam::TraceDictionary(JSTracer* trc)
{
}

SVCParam&
SVCParam::operator=(const SVCParam& aOther)
{
  DictionaryBase::operator=(aOther);
  mType = aOther.mType;
  return *this;
}



SocketElement::SocketElement()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
SocketElement::InitIds(JSContext* cx, SocketElementAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->type_id.init(cx, "type") ||
      !atomsCache->sent_id.init(cx, "sent") ||
      !atomsCache->received_id.init(cx, "received") ||
      !atomsCache->port_id.init(cx, "port") ||
      !atomsCache->host_id.init(cx, "host") ||
      !atomsCache->active_id.init(cx, "active")) {
    return false;
  }
  return true;
}

bool
SocketElement::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mActive = false;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mHost.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mPort = 0U;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mReceived = 0.0;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mSent = 0.0;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mType.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SocketElement::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  SocketElementAtoms* atomsCache = GetAtomCache<SocketElementAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mActive;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->active_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mHost;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->host_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mPort;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->port_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mReceived;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->received_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mSent;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->sent_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mType;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->type_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
SocketElement::TraceDictionary(JSTracer* trc)
{
}

SocketElement&
SocketElement::operator=(const SocketElement& aOther)
{
  DictionaryBase::operator=(aOther);
  mActive = aOther.mActive;
  mHost = aOther.mHost;
  mPort = aOther.mPort;
  mReceived = aOther.mReceived;
  mSent = aOther.mSent;
  mType = aOther.mType;
  return *this;
}



WebSocketElement::WebSocketElement()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
WebSocketElement::InitIds(JSContext* cx, WebSocketElementAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->sentsize_id.init(cx, "sentsize") ||
      !atomsCache->receivedsize_id.init(cx, "receivedsize") ||
      !atomsCache->msgsent_id.init(cx, "msgsent") ||
      !atomsCache->msgreceived_id.init(cx, "msgreceived") ||
      !atomsCache->hostport_id.init(cx, "hostport") ||
      !atomsCache->encrypted_id.init(cx, "encrypted")) {
    return false;
  }
  return true;
}

bool
WebSocketElement::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mEncrypted = false;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mHostport.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mMsgreceived = 0U;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mMsgsent = 0U;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mReceivedsize = 0.0;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mSentsize = 0.0;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
WebSocketElement::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  WebSocketElementAtoms* atomsCache = GetAtomCache<WebSocketElementAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mEncrypted;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->encrypted_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mHostport;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->hostport_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mMsgreceived;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->msgreceived_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mMsgsent;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->msgsent_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mReceivedsize;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->receivedsize_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mSentsize;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->sentsize_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
WebSocketElement::TraceDictionary(JSTracer* trc)
{
}

WebSocketElement&
WebSocketElement::operator=(const WebSocketElement& aOther)
{
  DictionaryBase::operator=(aOther);
  mEncrypted = aOther.mEncrypted;
  mHostport = aOther.mHostport;
  mMsgreceived = aOther.mMsgreceived;
  mMsgsent = aOther.mMsgsent;
  mReceivedsize = aOther.mReceivedsize;
  mSentsize = aOther.mSentsize;
  return *this;
}



DNSCacheDict::DNSCacheDict()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
DNSCacheDict::InitIds(JSContext* cx, DNSCacheDictAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->entries_id.init(cx, "entries")) {
    return false;
  }
  return true;
}

bool
DNSCacheDict::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
DNSCacheDict::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  DNSCacheDictAtoms* atomsCache = GetAtomCache<DNSCacheDictAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mEntries.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<DnsCacheEntry> const & currentValue = mEntries.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->entries_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
DNSCacheDict::TraceDictionary(JSTracer* trc)
{
}

DNSCacheDict&
DNSCacheDict::operator=(const DNSCacheDict& aOther)
{
  DictionaryBase::operator=(aOther);
  mEntries.Reset();
  if (aOther.mEntries.WasPassed()) {
    mEntries.Construct(aOther.mEntries.Value());
  }
  return *this;
}



HttpConnectionElement::HttpConnectionElement()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
HttpConnectionElement::InitIds(JSContext* cx, HttpConnectionElementAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->ssl_id.init(cx, "ssl") ||
      !atomsCache->port_id.init(cx, "port") ||
      !atomsCache->idle_id.init(cx, "idle") ||
      !atomsCache->httpVersion_id.init(cx, "httpVersion") ||
      !atomsCache->host_id.init(cx, "host") ||
      !atomsCache->dnsAndSocks_id.init(cx, "dnsAndSocks") ||
      !atomsCache->active_id.init(cx, "active")) {
    return false;
  }
  return true;
}

bool
HttpConnectionElement::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mHost.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mHttpVersion.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mPort = 0U;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mSsl = false;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
HttpConnectionElement::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  HttpConnectionElementAtoms* atomsCache = GetAtomCache<HttpConnectionElementAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mActive.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<HttpConnInfo> const & currentValue = mActive.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->active_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mDnsAndSocks.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<DnsAndSockInfoDict> const & currentValue = mDnsAndSocks.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->dnsAndSocks_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mHost;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->host_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mHttpVersion;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->httpVersion_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mIdle.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<HttpConnInfo> const & currentValue = mIdle.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->idle_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mPort;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->port_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mSsl;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->ssl_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
HttpConnectionElement::TraceDictionary(JSTracer* trc)
{
}

HttpConnectionElement&
HttpConnectionElement::operator=(const HttpConnectionElement& aOther)
{
  DictionaryBase::operator=(aOther);
  mActive.Reset();
  if (aOther.mActive.WasPassed()) {
    mActive.Construct(aOther.mActive.Value());
  }
  mDnsAndSocks.Reset();
  if (aOther.mDnsAndSocks.WasPassed()) {
    mDnsAndSocks.Construct(aOther.mDnsAndSocks.Value());
  }
  mHost = aOther.mHost;
  mHttpVersion = aOther.mHttpVersion;
  mIdle.Reset();
  if (aOther.mIdle.WasPassed()) {
    mIdle.Construct(aOther.mIdle.Value());
  }
  mPort = aOther.mPort;
  mSsl = aOther.mSsl;
  return *this;
}



RcwnStatus::RcwnStatus()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RcwnStatus::InitIds(JSContext* cx, RcwnStatusAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->totalNetworkRequests_id.init(cx, "totalNetworkRequests") ||
      !atomsCache->rcwnNetWonCount_id.init(cx, "rcwnNetWonCount") ||
      !atomsCache->rcwnCacheWonCount_id.init(cx, "rcwnCacheWonCount") ||
      !atomsCache->perfStats_id.init(cx, "perfStats") ||
      !atomsCache->cacheSlowCount_id.init(cx, "cacheSlowCount") ||
      !atomsCache->cacheNotSlowCount_id.init(cx, "cacheNotSlowCount")) {
    return false;
  }
  return true;
}

bool
RcwnStatus::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mCacheNotSlowCount = 0U;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mCacheSlowCount = 0U;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mRcwnCacheWonCount = 0U;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mRcwnNetWonCount = 0U;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mTotalNetworkRequests = 0U;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
RcwnStatus::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RcwnStatusAtoms* atomsCache = GetAtomCache<RcwnStatusAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mCacheNotSlowCount;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->cacheNotSlowCount_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mCacheSlowCount;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->cacheSlowCount_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mPerfStats.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<RcwnPerfStats> const & currentValue = mPerfStats.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->perfStats_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mRcwnCacheWonCount;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->rcwnCacheWonCount_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mRcwnNetWonCount;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->rcwnNetWonCount_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mTotalNetworkRequests;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->totalNetworkRequests_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RcwnStatus::TraceDictionary(JSTracer* trc)
{
}

RcwnStatus&
RcwnStatus::operator=(const RcwnStatus& aOther)
{
  DictionaryBase::operator=(aOther);
  mCacheNotSlowCount = aOther.mCacheNotSlowCount;
  mCacheSlowCount = aOther.mCacheSlowCount;
  mPerfStats.Reset();
  if (aOther.mPerfStats.WasPassed()) {
    mPerfStats.Construct(aOther.mPerfStats.Value());
  }
  mRcwnCacheWonCount = aOther.mRcwnCacheWonCount;
  mRcwnNetWonCount = aOther.mRcwnNetWonCount;
  mTotalNetworkRequests = aOther.mTotalNetworkRequests;
  return *this;
}



SVCParamAlpn::SVCParamAlpn()
  : SVCParam(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
SVCParamAlpn::InitIds(JSContext* cx, SVCParamAlpnAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->alpn_id.init(cx, "alpn")) {
    return false;
  }
  return true;
}

bool
SVCParamAlpn::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!SVCParam::Init()) {
    return false;
  }

  {
    // scope for any temporaries our default value setting needs.
    mAlpn.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SVCParamAlpn::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  SVCParamAlpnAtoms* atomsCache = GetAtomCache<SVCParamAlpnAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!SVCParam::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mAlpn;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->alpn_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
SVCParamAlpn::TraceDictionary(JSTracer* trc)
{
  SVCParam::TraceDictionary(trc);
}

SVCParamAlpn&
SVCParamAlpn::operator=(const SVCParamAlpn& aOther)
{
  SVCParam::operator=(aOther);
  mAlpn = aOther.mAlpn;
  return *this;
}



SVCParamEchConfig::SVCParamEchConfig()
  : SVCParam(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
SVCParamEchConfig::InitIds(JSContext* cx, SVCParamEchConfigAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->echConfig_id.init(cx, "echConfig")) {
    return false;
  }
  return true;
}

bool
SVCParamEchConfig::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!SVCParam::Init()) {
    return false;
  }

  {
    // scope for any temporaries our default value setting needs.
    mEchConfig.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SVCParamEchConfig::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  SVCParamEchConfigAtoms* atomsCache = GetAtomCache<SVCParamEchConfigAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!SVCParam::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mEchConfig;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->echConfig_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
SVCParamEchConfig::TraceDictionary(JSTracer* trc)
{
  SVCParam::TraceDictionary(trc);
}

SVCParamEchConfig&
SVCParamEchConfig::operator=(const SVCParamEchConfig& aOther)
{
  SVCParam::operator=(aOther);
  mEchConfig = aOther.mEchConfig;
  return *this;
}



SVCParamIPv4Hint::SVCParamIPv4Hint()
  : SVCParam(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
SVCParamIPv4Hint::InitIds(JSContext* cx, SVCParamIPv4HintAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->address_id.init(cx, "address")) {
    return false;
  }
  return true;
}

bool
SVCParamIPv4Hint::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!SVCParam::Init()) {
    return false;
  }

  return true;
}

bool
SVCParamIPv4Hint::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  SVCParamIPv4HintAtoms* atomsCache = GetAtomCache<SVCParamIPv4HintAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!SVCParam::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mAddress.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<nsString> const & currentValue = mAddress.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!xpc::NonVoidStringToJsval(cx, currentValue[sequenceIdx0], &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->address_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
SVCParamIPv4Hint::TraceDictionary(JSTracer* trc)
{
  SVCParam::TraceDictionary(trc);
}

SVCParamIPv4Hint&
SVCParamIPv4Hint::operator=(const SVCParamIPv4Hint& aOther)
{
  SVCParam::operator=(aOther);
  mAddress.Reset();
  if (aOther.mAddress.WasPassed()) {
    mAddress.Construct(aOther.mAddress.Value());
  }
  return *this;
}



SVCParamIPv6Hint::SVCParamIPv6Hint()
  : SVCParam(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
SVCParamIPv6Hint::InitIds(JSContext* cx, SVCParamIPv6HintAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->address_id.init(cx, "address")) {
    return false;
  }
  return true;
}

bool
SVCParamIPv6Hint::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!SVCParam::Init()) {
    return false;
  }

  return true;
}

bool
SVCParamIPv6Hint::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  SVCParamIPv6HintAtoms* atomsCache = GetAtomCache<SVCParamIPv6HintAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!SVCParam::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mAddress.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<nsString> const & currentValue = mAddress.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!xpc::NonVoidStringToJsval(cx, currentValue[sequenceIdx0], &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->address_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
SVCParamIPv6Hint::TraceDictionary(JSTracer* trc)
{
  SVCParam::TraceDictionary(trc);
}

SVCParamIPv6Hint&
SVCParamIPv6Hint::operator=(const SVCParamIPv6Hint& aOther)
{
  SVCParam::operator=(aOther);
  mAddress.Reset();
  if (aOther.mAddress.WasPassed()) {
    mAddress.Construct(aOther.mAddress.Value());
  }
  return *this;
}



SVCParamNoDefaultAlpn::SVCParamNoDefaultAlpn()
  : SVCParam(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
SVCParamNoDefaultAlpn::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!SVCParam::Init()) {
    return false;
  }

  return true;
}

bool
SVCParamNoDefaultAlpn::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  // Per spec, we define the parent's members first
  if (!SVCParam::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());


  return true;
}

void
SVCParamNoDefaultAlpn::TraceDictionary(JSTracer* trc)
{
  SVCParam::TraceDictionary(trc);
}

SVCParamNoDefaultAlpn&
SVCParamNoDefaultAlpn::operator=(const SVCParamNoDefaultAlpn& aOther)
{
  SVCParam::operator=(aOther);
  return *this;
}



SVCParamODoHConfig::SVCParamODoHConfig()
  : SVCParam(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
SVCParamODoHConfig::InitIds(JSContext* cx, SVCParamODoHConfigAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->ODoHConfig_id.init(cx, "ODoHConfig")) {
    return false;
  }
  return true;
}

bool
SVCParamODoHConfig::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!SVCParam::Init()) {
    return false;
  }

  {
    // scope for any temporaries our default value setting needs.
    mODoHConfig.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SVCParamODoHConfig::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  SVCParamODoHConfigAtoms* atomsCache = GetAtomCache<SVCParamODoHConfigAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!SVCParam::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mODoHConfig;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->ODoHConfig_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
SVCParamODoHConfig::TraceDictionary(JSTracer* trc)
{
  SVCParam::TraceDictionary(trc);
}

SVCParamODoHConfig&
SVCParamODoHConfig::operator=(const SVCParamODoHConfig& aOther)
{
  SVCParam::operator=(aOther);
  mODoHConfig = aOther.mODoHConfig;
  return *this;
}



SVCParamPort::SVCParamPort()
  : SVCParam(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
SVCParamPort::InitIds(JSContext* cx, SVCParamPortAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->port_id.init(cx, "port")) {
    return false;
  }
  return true;
}

bool
SVCParamPort::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!SVCParam::Init()) {
    return false;
  }

  {
    // scope for any temporaries our default value setting needs.
    mPort = 0;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SVCParamPort::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  SVCParamPortAtoms* atomsCache = GetAtomCache<SVCParamPortAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!SVCParam::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint16_t const & currentValue = mPort;
    temp.setInt32(int32_t(currentValue));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->port_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
SVCParamPort::TraceDictionary(JSTracer* trc)
{
  SVCParam::TraceDictionary(trc);
}

SVCParamPort&
SVCParamPort::operator=(const SVCParamPort& aOther)
{
  SVCParam::operator=(aOther);
  mPort = aOther.mPort;
  return *this;
}



SocketsDict::SocketsDict()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
SocketsDict::InitIds(JSContext* cx, SocketsDictAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->sockets_id.init(cx, "sockets") ||
      !atomsCache->sent_id.init(cx, "sent") ||
      !atomsCache->received_id.init(cx, "received")) {
    return false;
  }
  return true;
}

bool
SocketsDict::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mReceived = 0.0;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mSent = 0.0;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SocketsDict::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  SocketsDictAtoms* atomsCache = GetAtomCache<SocketsDictAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mReceived;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->received_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mSent;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->sent_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mSockets.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<SocketElement> const & currentValue = mSockets.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->sockets_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
SocketsDict::TraceDictionary(JSTracer* trc)
{
}

SocketsDict&
SocketsDict::operator=(const SocketsDict& aOther)
{
  DictionaryBase::operator=(aOther);
  mReceived = aOther.mReceived;
  mSent = aOther.mSent;
  mSockets.Reset();
  if (aOther.mSockets.WasPassed()) {
    mSockets.Construct(aOther.mSockets.Value());
  }
  return *this;
}



WebSocketDict::WebSocketDict()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
WebSocketDict::InitIds(JSContext* cx, WebSocketDictAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->websockets_id.init(cx, "websockets")) {
    return false;
  }
  return true;
}

bool
WebSocketDict::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
WebSocketDict::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  WebSocketDictAtoms* atomsCache = GetAtomCache<WebSocketDictAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mWebsockets.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<WebSocketElement> const & currentValue = mWebsockets.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->websockets_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
WebSocketDict::TraceDictionary(JSTracer* trc)
{
}

WebSocketDict&
WebSocketDict::operator=(const WebSocketDict& aOther)
{
  DictionaryBase::operator=(aOther);
  mWebsockets.Reset();
  if (aOther.mWebsockets.WasPassed()) {
    mWebsockets.Construct(aOther.mWebsockets.Value());
  }
  return *this;
}



HTTPSRecord::HTTPSRecord()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
HTTPSRecord::InitIds(JSContext* cx, HTTPSRecordAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->targetName_id.init(cx, "targetName") ||
      !atomsCache->priority_id.init(cx, "priority") ||
      !atomsCache->port_id.init(cx, "port") ||
      !atomsCache->noDefaultAlpn_id.init(cx, "noDefaultAlpn") ||
      !atomsCache->ipv6Hint_id.init(cx, "ipv6Hint") ||
      !atomsCache->ipv4Hint_id.init(cx, "ipv4Hint") ||
      !atomsCache->echConfig_id.init(cx, "echConfig") ||
      !atomsCache->alpn_id.init(cx, "alpn") ||
      !atomsCache->ODoHConfig_id.init(cx, "ODoHConfig")) {
    return false;
  }
  return true;
}

bool
HTTPSRecord::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mPriority = 0;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mTargetName.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
HTTPSRecord::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  HTTPSRecordAtoms* atomsCache = GetAtomCache<HTTPSRecordAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mODoHConfig.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      SVCParamODoHConfig const & currentValue = mODoHConfig.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->ODoHConfig_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mAlpn.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      SVCParamAlpn const & currentValue = mAlpn.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->alpn_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mEchConfig.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      SVCParamEchConfig const & currentValue = mEchConfig.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->echConfig_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mIpv4Hint.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      SVCParamIPv4Hint const & currentValue = mIpv4Hint.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->ipv4Hint_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mIpv6Hint.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      SVCParamIPv6Hint const & currentValue = mIpv6Hint.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->ipv6Hint_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mNoDefaultAlpn.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      SVCParamNoDefaultAlpn const & currentValue = mNoDefaultAlpn.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->noDefaultAlpn_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPort.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      SVCParamPort const & currentValue = mPort.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->port_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint16_t const & currentValue = mPriority;
    temp.setInt32(int32_t(currentValue));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->priority_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mTargetName;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->targetName_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
HTTPSRecord::TraceDictionary(JSTracer* trc)
{
}

HTTPSRecord&
HTTPSRecord::operator=(const HTTPSRecord& aOther)
{
  DictionaryBase::operator=(aOther);
  mODoHConfig.Reset();
  if (aOther.mODoHConfig.WasPassed()) {
    mODoHConfig.Construct(aOther.mODoHConfig.Value());
  }
  mAlpn.Reset();
  if (aOther.mAlpn.WasPassed()) {
    mAlpn.Construct(aOther.mAlpn.Value());
  }
  mEchConfig.Reset();
  if (aOther.mEchConfig.WasPassed()) {
    mEchConfig.Construct(aOther.mEchConfig.Value());
  }
  mIpv4Hint.Reset();
  if (aOther.mIpv4Hint.WasPassed()) {
    mIpv4Hint.Construct(aOther.mIpv4Hint.Value());
  }
  mIpv6Hint.Reset();
  if (aOther.mIpv6Hint.WasPassed()) {
    mIpv6Hint.Construct(aOther.mIpv6Hint.Value());
  }
  mNoDefaultAlpn.Reset();
  if (aOther.mNoDefaultAlpn.WasPassed()) {
    mNoDefaultAlpn.Construct(aOther.mNoDefaultAlpn.Value());
  }
  mPort.Reset();
  if (aOther.mPort.WasPassed()) {
    mPort.Construct(aOther.mPort.Value());
  }
  mPriority = aOther.mPriority;
  mTargetName = aOther.mTargetName;
  return *this;
}



HttpConnDict::HttpConnDict()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
HttpConnDict::InitIds(JSContext* cx, HttpConnDictAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->connections_id.init(cx, "connections")) {
    return false;
  }
  return true;
}

bool
HttpConnDict::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
HttpConnDict::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  HttpConnDictAtoms* atomsCache = GetAtomCache<HttpConnDictAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mConnections.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<HttpConnectionElement> const & currentValue = mConnections.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->connections_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
HttpConnDict::TraceDictionary(JSTracer* trc)
{
}

HttpConnDict&
HttpConnDict::operator=(const HttpConnDict& aOther)
{
  DictionaryBase::operator=(aOther);
  mConnections.Reset();
  if (aOther.mConnections.WasPassed()) {
    mConnections.Construct(aOther.mConnections.Value());
  }
  return *this;
}



HTTPSRRLookupDict::HTTPSRRLookupDict()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
HTTPSRRLookupDict::InitIds(JSContext* cx, HTTPSRRLookupDictAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->records_id.init(cx, "records") ||
      !atomsCache->error_id.init(cx, "error") ||
      !atomsCache->answer_id.init(cx, "answer")) {
    return false;
  }
  return true;
}

bool
HTTPSRRLookupDict::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mAnswer = false;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mError.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
HTTPSRRLookupDict::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  HTTPSRRLookupDictAtoms* atomsCache = GetAtomCache<HTTPSRRLookupDictAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mAnswer;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->answer_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mError;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->error_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mRecords.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<HTTPSRecord> const & currentValue = mRecords.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->records_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
HTTPSRRLookupDict::TraceDictionary(JSTracer* trc)
{
}

HTTPSRRLookupDict&
HTTPSRRLookupDict::operator=(const HTTPSRRLookupDict& aOther)
{
  DictionaryBase::operator=(aOther);
  mAnswer = aOther.mAnswer;
  mError = aOther.mError;
  mRecords.Reset();
  if (aOther.mRecords.WasPassed()) {
    mRecords.Construct(aOther.mRecords.Value());
  }
  return *this;
}


} // namespace mozilla::dom
