/* THIS FILE IS AUTOGENERATED FROM MessageEvent.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "EventBinding.h"
#include "MainThreadUtils.h"
#include "MessageEventBinding.h"
#include "WrapperFactory.h"
#include "XrayWrapper.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/MessageEvent.h"
#include "mozilla/dom/MessagePort.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/ServiceWorker.h"
#include "mozilla/dom/WindowProxyHolder.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningWindowProxyOrMessagePortOrServiceWorker& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsWindowProxy()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsWindowProxy(), "mWindowProxy", aFlags);
  } else if (aUnion.IsMessagePort()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsMessagePort(), "mMessagePort", aFlags);
  } else if (aUnion.IsServiceWorker()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsServiceWorker(), "mServiceWorker", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningWindowProxyOrMessagePortOrServiceWorker& aUnion)
{
  aUnion.Uninit();
}


bool
WindowProxyOrMessagePortOrServiceWorker::TrySetToWindowProxy(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    mozilla::dom::WindowProxyHolder& memberSlot = RawSetAsWindowProxy();
    JS::Rooted<JSObject*> source(cx, &value.toObject());
    if (NS_FAILED(UnwrapWindowProxyArg(cx, source, memberSlot))) {
        DestroyWindowProxy();
        tryNext = true;
        return true;
    }
  }
  return true;
}

bool
WindowProxyOrMessagePortOrServiceWorker::TrySetToWindowProxy(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToWindowProxy(cx, value, tryNext, passedToJSImpl);
}







bool
WindowProxyOrMessagePortOrServiceWorker::TrySetToMessagePort(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::MessagePort>& memberSlot = RawSetAsMessagePort();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::MessagePort, mozilla::dom::MessagePort>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyMessagePort();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
WindowProxyOrMessagePortOrServiceWorker::TrySetToMessagePort(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToMessagePort(cx, value, tryNext, passedToJSImpl);
}







bool
WindowProxyOrMessagePortOrServiceWorker::TrySetToServiceWorker(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::ServiceWorker>& memberSlot = RawSetAsServiceWorker();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::ServiceWorker, mozilla::dom::ServiceWorker>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyServiceWorker();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
WindowProxyOrMessagePortOrServiceWorker::TrySetToServiceWorker(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToServiceWorker(cx, value, tryNext, passedToJSImpl);
}







bool
WindowProxyOrMessagePortOrServiceWorker::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToWindowProxy(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToMessagePort(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToServiceWorker(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "WindowProxy, MessagePort, ServiceWorker");
    return false;
  }
  return true;
}

bool
WindowProxyOrMessagePortOrServiceWorker::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
WindowProxyOrMessagePortOrServiceWorker::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eWindowProxy: {
      if (!WrapObject(cx, mValue.mWindowProxy.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eMessagePort: {
      if (!GetOrCreateDOMReflector(cx, mValue.mMessagePort.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eServiceWorker: {
      if (!GetOrCreateDOMReflector(cx, mValue.mServiceWorker.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningWindowProxyOrMessagePortOrServiceWorker::OwningWindowProxyOrMessagePortOrServiceWorker(OwningWindowProxyOrMessagePortOrServiceWorker&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eWindowProxy: {
      mType = eWindowProxy;
      mValue.mWindowProxy.SetValue(std::move(aOther.mValue.mWindowProxy.Value()));
      break;
    }
    case eMessagePort: {
      mType = eMessagePort;
      mValue.mMessagePort.SetValue(std::move(aOther.mValue.mMessagePort.Value()));
      break;
    }
    case eServiceWorker: {
      mType = eServiceWorker;
      mValue.mServiceWorker.SetValue(std::move(aOther.mValue.mServiceWorker.Value()));
      break;
    }
  }
}



bool
OwningWindowProxyOrMessagePortOrServiceWorker::TrySetToWindowProxy(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    mozilla::dom::WindowProxyHolder& memberSlot = RawSetAsWindowProxy();
    JS::Rooted<JSObject*> source(cx, &value.toObject());
    if (NS_FAILED(UnwrapWindowProxyArg(cx, source, memberSlot))) {
        DestroyWindowProxy();
        tryNext = true;
        return true;
    }
  }
  return true;
}

bool
OwningWindowProxyOrMessagePortOrServiceWorker::TrySetToWindowProxy(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToWindowProxy(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] mozilla::dom::WindowProxyHolder&
OwningWindowProxyOrMessagePortOrServiceWorker::RawSetAsWindowProxy()
{
  if (mType == eWindowProxy) {
    return mValue.mWindowProxy.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eWindowProxy;
  return mValue.mWindowProxy.SetValue();
}

[[nodiscard]] mozilla::dom::WindowProxyHolder&
OwningWindowProxyOrMessagePortOrServiceWorker::SetAsWindowProxy()
{
  if (mType == eWindowProxy) {
    return mValue.mWindowProxy.Value();
  }
  Uninit();
  mType = eWindowProxy;
  return mValue.mWindowProxy.SetValue();
}


void
OwningWindowProxyOrMessagePortOrServiceWorker::DestroyWindowProxy()
{
  MOZ_RELEASE_ASSERT(IsWindowProxy(), "Wrong type!");
  mValue.mWindowProxy.Destroy();
  mType = eUninitialized;
}



bool
OwningWindowProxyOrMessagePortOrServiceWorker::TrySetToMessagePort(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::MessagePort>& memberSlot = RawSetAsMessagePort();
    static_assert(IsRefcounted<mozilla::dom::MessagePort>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::MessagePort, mozilla::dom::MessagePort>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyMessagePort();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningWindowProxyOrMessagePortOrServiceWorker::TrySetToMessagePort(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToMessagePort(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::MessagePort>&
OwningWindowProxyOrMessagePortOrServiceWorker::RawSetAsMessagePort()
{
  if (mType == eMessagePort) {
    return mValue.mMessagePort.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eMessagePort;
  return mValue.mMessagePort.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::MessagePort>&
OwningWindowProxyOrMessagePortOrServiceWorker::SetAsMessagePort()
{
  if (mType == eMessagePort) {
    return mValue.mMessagePort.Value();
  }
  Uninit();
  mType = eMessagePort;
  return mValue.mMessagePort.SetValue();
}


void
OwningWindowProxyOrMessagePortOrServiceWorker::DestroyMessagePort()
{
  MOZ_RELEASE_ASSERT(IsMessagePort(), "Wrong type!");
  mValue.mMessagePort.Destroy();
  mType = eUninitialized;
}



bool
OwningWindowProxyOrMessagePortOrServiceWorker::TrySetToServiceWorker(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::ServiceWorker>& memberSlot = RawSetAsServiceWorker();
    static_assert(IsRefcounted<mozilla::dom::ServiceWorker>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::ServiceWorker, mozilla::dom::ServiceWorker>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyServiceWorker();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningWindowProxyOrMessagePortOrServiceWorker::TrySetToServiceWorker(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToServiceWorker(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::ServiceWorker>&
OwningWindowProxyOrMessagePortOrServiceWorker::RawSetAsServiceWorker()
{
  if (mType == eServiceWorker) {
    return mValue.mServiceWorker.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eServiceWorker;
  return mValue.mServiceWorker.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::ServiceWorker>&
OwningWindowProxyOrMessagePortOrServiceWorker::SetAsServiceWorker()
{
  if (mType == eServiceWorker) {
    return mValue.mServiceWorker.Value();
  }
  Uninit();
  mType = eServiceWorker;
  return mValue.mServiceWorker.SetValue();
}


void
OwningWindowProxyOrMessagePortOrServiceWorker::DestroyServiceWorker()
{
  MOZ_RELEASE_ASSERT(IsServiceWorker(), "Wrong type!");
  mValue.mServiceWorker.Destroy();
  mType = eUninitialized;
}



bool
OwningWindowProxyOrMessagePortOrServiceWorker::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToWindowProxy(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToMessagePort(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToServiceWorker(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "WindowProxy, MessagePort, ServiceWorker");
    return false;
  }
  return true;
}

bool
OwningWindowProxyOrMessagePortOrServiceWorker::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningWindowProxyOrMessagePortOrServiceWorker::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eWindowProxy: {
      DestroyWindowProxy();
      break;
    }
    case eMessagePort: {
      DestroyMessagePort();
      break;
    }
    case eServiceWorker: {
      DestroyServiceWorker();
      break;
    }
  }
}

bool
OwningWindowProxyOrMessagePortOrServiceWorker::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eWindowProxy: {
      if (!WrapObject(cx, mValue.mWindowProxy.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eMessagePort: {
      if (!GetOrCreateDOMReflector(cx, mValue.mMessagePort.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eServiceWorker: {
      if (!GetOrCreateDOMReflector(cx, mValue.mServiceWorker.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningWindowProxyOrMessagePortOrServiceWorker&
OwningWindowProxyOrMessagePortOrServiceWorker::operator=(OwningWindowProxyOrMessagePortOrServiceWorker&& aOther)
{
  this->~OwningWindowProxyOrMessagePortOrServiceWorker();
  new (this) OwningWindowProxyOrMessagePortOrServiceWorker (std::move(aOther));
  return *this;
}


OwningWindowProxyOrMessagePortOrServiceWorker&
OwningWindowProxyOrMessagePortOrServiceWorker::operator=(const OwningWindowProxyOrMessagePortOrServiceWorker& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eWindowProxy: {
      SetAsWindowProxy() = aOther.GetAsWindowProxy();
      break;
    }
    case eMessagePort: {
      SetAsMessagePort() = aOther.GetAsMessagePort();
      break;
    }
    case eServiceWorker: {
      SetAsServiceWorker() = aOther.GetAsServiceWorker();
      break;
    }
  }
  return *this;
}



MessageEventInit::MessageEventInit()
  : EventInit(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
MessageEventInit::InitIds(JSContext* cx, MessageEventInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->source_id.init(cx, "source") ||
      !atomsCache->ports_id.init(cx, "ports") ||
      !atomsCache->origin_id.init(cx, "origin") ||
      !atomsCache->lastEventId_id.init(cx, "lastEventId") ||
      !atomsCache->data_id.init(cx, "data")) {
    return false;
  }
  return true;
}

bool
MessageEventInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  MessageEventInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<MessageEventInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!EventInit::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->data_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunreachable-code"
#pragma clang diagnostic ignored "-Wunreachable-code-return"
#endif // __clang__
    if ((passedToJSImpl) && !CallerSubsumes(temp.ref())) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("'data' member of MessageEventInit");
      return false;
    }
#ifdef __clang__
#pragma clang diagnostic pop
#endif // __clang__
    mData = temp.ref();
  } else {
    mData = JS::NullValue();
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->lastEventId_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mLastEventId)) {
      return false;
    }
  } else {
    mLastEventId.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->origin_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mOrigin)) {
      return false;
    }
  } else {
    mOrigin.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->ports_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'ports' member of MessageEventInit", "sequence");
        return false;
      }
      Sequence<OwningNonNull<mozilla::dom::MessagePort>> &arr = mPorts;
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        OwningNonNull<mozilla::dom::MessagePort>* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        OwningNonNull<mozilla::dom::MessagePort>& slot = *slotPtr;
        if (temp.isObject()) {
          static_assert(IsRefcounted<mozilla::dom::MessagePort>::value, "We can only store refcounted classes.");
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::MessagePort, mozilla::dom::MessagePort>(&temp, slot, cx);
            if (NS_FAILED(rv)) {
              cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of 'ports' member of MessageEventInit", "MessagePort");
              return false;
            }
          }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of 'ports' member of MessageEventInit");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'ports' member of MessageEventInit", "sequence");
      return false;
    }
  } else {
    /* mPorts array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->source_id, temp.ptr())) {
      return false;
    }
  }
  if (!(!isNull && !temp->isUndefined()) || temp.ref().isNullOrUndefined()) {
    mSource.SetNull();
  } else {
    if (!mSource.SetValue().Init(cx, temp.ref(), "'source' member of MessageEventInit", passedToJSImpl)) {
      return false;
    }
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
MessageEventInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
MessageEventInit::TraceDictionary(JSTracer* trc)
{
  EventInit::TraceDictionary(trc);
  JS::TraceRoot(trc, &mData, "MessageEventInit.mData");
}




namespace MessageEvent_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<Event_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_data(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MessageEvent", "data", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MessageEvent*>(void_self);
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetData(cx, &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetData(cx, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "MessageEvent.data getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo data_getterinfo = {
  { get_data },
  { prototypes::id::MessageEvent },
  { PrototypeTraits<prototypes::id::MessageEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_origin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MessageEvent", "origin", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MessageEvent*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetOrigin(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetOrigin(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo origin_getterinfo = {
  { get_origin },
  { prototypes::id::MessageEvent },
  { PrototypeTraits<prototypes::id::MessageEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_lastEventId(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MessageEvent", "lastEventId", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MessageEvent*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetLastEventId(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetLastEventId(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo lastEventId_getterinfo = {
  { get_lastEventId },
  { prototypes::id::MessageEvent },
  { PrototypeTraits<prototypes::id::MessageEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_source(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MessageEvent", "source", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MessageEvent*>(void_self);
  Nullable<OwningWindowProxyOrMessagePortOrServiceWorker> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetSource(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetSource(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo source_getterinfo = {
  { get_source },
  { prototypes::id::MessageEvent },
  { PrototypeTraits<prototypes::id::MessageEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ports(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MessageEvent", "ports", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MessageEvent*>(void_self);
  // Have to either root across the getter call or reget after.
  bool isXray;
  JS::Rooted<JSObject*> slotStorage(cx, GetCachedSlotStorageObject(cx, obj, &isXray));
  if (!slotStorage) {
    return false;
  }
  const size_t slotIndex = isXray ? (DOM_EXPANDO_RESERVED_SLOTS + 0) : (DOM_INSTANCE_RESERVED_SLOTS + 0);
  MOZ_ASSERT(slotIndex < JSCLASS_RESERVED_SLOTS(JS::GetClass(slotStorage)));
  {
    // Scope for cachedVal
    JS::Value cachedVal = JS::GetReservedSlot(slotStorage, slotIndex);
    if (!cachedVal.isUndefined()) {
      args.rval().set(cachedVal);
      // The cached value is in the compartment of slotStorage,
      // so wrap into the caller compartment as needed.
      return MaybeWrapNonDOMObjectValue(cx, args.rval());
    }
  }

  nsTArray<StrongPtrForMember<mozilla::dom::MessagePort>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetPorts(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetPorts(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  {
    JS::Rooted<JSObject*> conversionScope(cx, isXray ? JS::CurrentGlobalOrNull(cx) : slotStorage);
    JSAutoRealm ar(cx, conversionScope);
    do { // block we break out of when done wrapping

      uint32_t length = result.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!GetOrCreateDOMReflector(cx, result[sequenceIdx0], &tmp)) {
              MOZ_ASSERT(JS_IsExceptionPending(cx));
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      args.rval().setObject(*returnArray);
      break;
    } while (false);
    JS::Rooted<JSObject*> rvalObj(cx, &args.rval().toObject());
    if (!JS_FreezeObject(cx, rvalObj)) {
      return false;
    }
  }
  { // And now store things in the realm of our slotStorage.
    JSAutoRealm ar(cx, slotStorage);
    // Make a copy so that we don't do unnecessary wrapping on args.rval().
    JS::Rooted<JS::Value> storedVal(cx, args.rval());
    if (!MaybeWrapNonDOMObjectValue(cx, &storedVal)) {
      return false;
    }
    JS::SetReservedSlot(slotStorage, slotIndex, storedVal);
    if (!isXray) {
      // In the Xray case we don't need to do this, because getting the
      // expando object already preserved our wrapper.
      PreserveWrapper(self);
    }
  }
  // And now make sure args.rval() is in the caller realm.
  return MaybeWrapNonDOMObjectValue(cx, args.rval());
}

static const JSJitInfo ports_getterinfo = {
  { get_ports },
  { prototypes::id::MessageEvent },
  { PrototypeTraits<prototypes::id::MessageEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  true, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  (DOM_INSTANCE_RESERVED_SLOTS + 0)   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) <= JSJitInfo::maxSlotIndex, "We won't fit");
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) < 2, "There is no slot for us");

MOZ_CAN_RUN_SCRIPT static bool
initMessageEvent(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "MessageEvent.initMessageEvent");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MessageEvent", "initMessageEvent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MessageEvent*>(void_self);
  if (!args.requireAtLeast(cx, "MessageEvent.initMessageEvent", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  bool arg1;
  if (args.hasDefined(1)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
      return false;
    }
  } else {
    arg1 = false;
  }
  bool arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = false;
  }
  JS::Rooted<JS::Value> arg3(cx);
  if (args.hasDefined(3)) {
    arg3 = args[3];
  } else {
    arg3 = JS::NullValue();
  }
  binding_detail::FakeString<char16_t> arg4;
  if (args.hasDefined(4)) {
    if (!ConvertJSValueToString(cx, args[4], eStringify, eStringify, arg4)) {
      return false;
    }
  } else {
    arg4.AssignLiteral(u"");
  }
  binding_detail::FakeString<char16_t> arg5;
  if (args.hasDefined(5)) {
    if (!ConvertJSValueToString(cx, args[5], eStringify, eStringify, arg5)) {
      return false;
    }
  } else {
    arg5.AssignLiteral(u"");
  }
  Nullable<WindowProxyOrMessagePortOrServiceWorker > arg6;
  if (!(args.hasDefined(6)) || args[6].isNullOrUndefined()) {
    arg6.SetNull();
  } else {
    if (!arg6.SetValue().Init(cx, args[6], "Argument 7", false)) {
      return false;
    }
  }
  binding_detail::AutoSequence<OwningNonNull<mozilla::dom::MessagePort>> arg7;
  if (args.hasDefined(7)) {
    if (args[7].isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(args[7], JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 8", "sequence");
        return false;
      }
      binding_detail::AutoSequence<OwningNonNull<mozilla::dom::MessagePort>> &arr = arg7;
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        OwningNonNull<mozilla::dom::MessagePort>* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        OwningNonNull<mozilla::dom::MessagePort>& slot = *slotPtr;
        if (temp.isObject()) {
          static_assert(IsRefcounted<mozilla::dom::MessagePort>::value, "We can only store refcounted classes.");
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::MessagePort, mozilla::dom::MessagePort>(&temp, slot, cx);
            if (NS_FAILED(rv)) {
              cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of argument 8", "MessagePort");
              return false;
            }
          }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of argument 8");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 8", "sequence");
      return false;
    }
  } else {
    /* arg7 array is already empty; nothing to do */
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->InitMessageEvent(cx, NonNullHelper(Constify(arg0)), arg1, arg2, arg3, NonNullHelper(Constify(arg4)), NonNullHelper(Constify(arg5)), Constify(arg6), Constify(arg7)))>, "Should be returning void here");
  MOZ_KnownLive(self)->InitMessageEvent(cx, NonNullHelper(Constify(arg0)), arg1, arg2, arg3, NonNullHelper(Constify(arg4)), NonNullHelper(Constify(arg5)), Constify(arg6), Constify(arg7));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo initMessageEvent_methodinfo = {
  { (JSJitGetterOp)initMessageEvent },
  { prototypes::id::MessageEvent },
  { PrototypeTraits<prototypes::id::MessageEvent>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isTrusted(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MessageEvent", "isTrusted", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MessageEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->IsTrusted());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isTrusted_getterinfo = {
  { get_isTrusted },
  { prototypes::id::MessageEvent },
  { PrototypeTraits<prototypes::id::MessageEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::MessageEvent* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::MessageEvent>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::MessageEvent>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("initMessageEvent", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&initMessageEvent_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("data", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &data_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("origin", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &origin_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("lastEventId", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &lastEventId_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("source", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &source_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("ports", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &ports_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(5 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sUnforgeableAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("isTrusted", JSPROP_ENUMERATE | JSPROP_PERMANENT, GenericGetter<NormalThisPolicy, ThrowExceptions>, &isTrusted_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sUnforgeableAttributes[] = {
  { nullptr, &sUnforgeableAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[7];
static PropertyInfo sNativeProperties_propertyInfos[7];

static const NativePropertiesN<3> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  true,  2 /* sUnforgeableAttributes */,
  false, 0,
  -1,
  7,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[1] },
    { sUnforgeableAttributes, &sNativeProperties_propertyInfos[6] }
  }
};
static_assert(7 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

// This may allocate too many slots, because we only really need
// slots for our non-interface-typed members that we cache.  But
// allocating slots only for those would make the slot index
// computations much more complicated, so let's do this the simple
// way for now.
DEFINE_XRAY_EXPANDO_CLASS_WITH_OPS(static, sXrayExpandoObjectClass, 1,
                                   &xpc::XrayExpandoObjectClassOps);

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::MessageEvent,
  constructors::id::MessageEvent,
  &sXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "MessageEvent constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MessageEvent", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "MessageEvent");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::MessageEvent,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "MessageEvent constructor", 1)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  RootedDictionary<binding_detail::FastMessageEventInit> arg1(cx);
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
    if (!JS_WrapValue(cx, JS::MutableHandle<JS::Value>::fromMarkedLocation(&arg1.mData))) {
      return false;
    }
  }
  auto result(StrongOrRawPtr<mozilla::dom::MessageEvent>(mozilla::dom::MessageEvent::Constructor(global, NonNullHelper(Constify(arg0)), Constify(arg1))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  Event_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::MessageEvent>::Depth,
  prototypes::id::MessageEvent,
  true,
  1,
  "MessageEvent",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "MessageEventPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE + 1 /* slot for the JSObject holding the unforgeable properties */),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::MessageEvent,
  PrototypeTraits<prototypes::id::MessageEvent>::Depth,
  &sNativePropertyHooks,
  Event_Binding::GetProtoObject
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<mozilla::dom::MessageEvent>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "MessageEvent",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(2) | JSCLASS_SKIP_NURSERY_FINALIZE,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::MessageEvent>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::Event, prototypes::id::MessageEvent, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::MessageEvent>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::MessageEvent>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::MessageEvent>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::MessageEvent>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(2 >= 2,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::MessageEvent* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::MessageEvent>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::MessageEvent*>);
  MOZ_ASSERT(static_cast<mozilla::dom::Event*>(aObject) ==
             reinterpret_cast<mozilla::dom::Event*>(aObject),
             "Multiple inheritance for mozilla::dom::Event is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::MessageEvent> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);

  // Important: do unforgeable property setup after we have handed
  // over ownership of the C++ object to obj as needed, so that if
  // we fail and it ends up GCed it won't have problems in the
  // finalizer trying to drop its ownership of the C++ object.
  JS::Rooted<JSObject*> unforgeableHolder(aCx,
    &JS::GetReservedSlot(canonicalProto, DOM_INTERFACE_PROTO_SLOTS_BASE).toObject());
  if (!JS_InitializePropertiesFromCompatibleNativeObject(aCx, aReflector, unforgeableHolder)) {
    aCache->ReleaseWrapper(aObject);
    aCache->ClearWrapper();
    return false;
  }
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
ClearCachedPortsValue(mozilla::dom::MessageEvent* aObject)
{
  JSObject* obj;
  obj = aObject->GetWrapper();
  if (!obj) {
    return;
  }
  JS::SetReservedSlot(obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), JS::UndefinedValue());
  ClearXrayExpandoSlots(RootingCx(), obj, (DOM_EXPANDO_RESERVED_SLOTS + 0));
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::MessageEvent);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::MessageEvent);

  JS::Handle<JSObject*> parentProto(Event_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(Event_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 1, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "MessageEvent",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);

  JS::AssertObjectIsNotGray(*protoCache);
  JS::Handle<JSObject*> proto = JS::Handle<JSObject*>::fromMarkedLocation(protoCache->unsafeAddress());
  if (!proto) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  JS::Rooted<JSObject*> unforgeableHolder(
      aCx, JS_NewObjectWithoutMetadata(aCx, sClass.ToJSClass(), proto));
  if (!unforgeableHolder) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (!DefineLegacyUnforgeableAttributes(aCx, unforgeableHolder, sUnforgeableAttributes)) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (*protoCache) {
    JS::SetReservedSlot(*protoCache, DOM_INTERFACE_PROTO_SLOTS_BASE,
                        JS::ObjectValue(*unforgeableHolder));
  }
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::MessageEvent,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::MessageEvent,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace MessageEvent_Binding



} // namespace mozilla::dom
