/* THIS FILE IS AUTOGENERATED FROM MediaCapabilities.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "MediaCapabilitiesBinding.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/MediaCapabilities.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<MediaDecodingType>::Values[2];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, MediaDecodingType aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<MediaDecodingType>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<MediaDecodingType>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<MediaDecodingType>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<MediaEncodingType>::Values[2];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, MediaEncodingType aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<MediaEncodingType>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<MediaEncodingType>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<MediaEncodingType>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<HdrMetadataType>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, HdrMetadataType aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<HdrMetadataType>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<HdrMetadataType>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<HdrMetadataType>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<ColorGamut>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ColorGamut aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<ColorGamut>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<ColorGamut>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<ColorGamut>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<TransferFunction>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, TransferFunction aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<TransferFunction>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<TransferFunction>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<TransferFunction>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}



AudioConfiguration::AudioConfiguration()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
AudioConfiguration::InitIds(JSContext* cx, AudioConfigurationAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->samplerate_id.init(cx, "samplerate") ||
      !atomsCache->contentType_id.init(cx, "contentType") ||
      !atomsCache->channels_id.init(cx, "channels") ||
      !atomsCache->bitrate_id.init(cx, "bitrate")) {
    return false;
  }
  return true;
}

bool
AudioConfiguration::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  AudioConfigurationAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<AudioConfigurationAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->bitrate_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mBitrate.Construct();
    if (!ValueToPrimitive<uint64_t, eDefault>(cx, temp.ref(), "'bitrate' member of AudioConfiguration", &(mBitrate.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->channels_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mChannels.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mChannels.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->contentType_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mContentType)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'contentType' member of AudioConfiguration");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->samplerate_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mSamplerate.Construct();
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'samplerate' member of AudioConfiguration", &(mSamplerate.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
AudioConfiguration::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
AudioConfiguration::TraceDictionary(JSTracer* trc)
{
}

AudioConfiguration&
AudioConfiguration::operator=(const AudioConfiguration& aOther)
{
  DictionaryBase::operator=(aOther);
  mBitrate.Reset();
  if (aOther.mBitrate.WasPassed()) {
    mBitrate.Construct(aOther.mBitrate.Value());
  }
  mChannels.Reset();
  if (aOther.mChannels.WasPassed()) {
    mChannels.Construct(aOther.mChannels.Value());
  }
  mContentType = aOther.mContentType;
  mSamplerate.Reset();
  if (aOther.mSamplerate.WasPassed()) {
    mSamplerate.Construct(aOther.mSamplerate.Value());
  }
  return *this;
}



KeySystemTrackConfiguration::KeySystemTrackConfiguration()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
KeySystemTrackConfiguration::InitIds(JSContext* cx, KeySystemTrackConfigurationAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->robustness_id.init(cx, "robustness") ||
      !atomsCache->encryptionScheme_id.init(cx, "encryptionScheme")) {
    return false;
  }
  return true;
}

bool
KeySystemTrackConfiguration::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  KeySystemTrackConfigurationAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<KeySystemTrackConfigurationAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->encryptionScheme_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eNull, eNull, mEncryptionScheme)) {
      return false;
    }
  } else {
    mEncryptionScheme.SetIsVoid(true);
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->robustness_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mRobustness)) {
      return false;
    }
  } else {
    mRobustness.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
KeySystemTrackConfiguration::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
KeySystemTrackConfiguration::TraceDictionary(JSTracer* trc)
{
}

KeySystemTrackConfiguration&
KeySystemTrackConfiguration::operator=(const KeySystemTrackConfiguration& aOther)
{
  DictionaryBase::operator=(aOther);
  mEncryptionScheme = aOther.mEncryptionScheme;
  mRobustness = aOther.mRobustness;
  return *this;
}



MediaCapabilitiesInfo::MediaCapabilitiesInfo()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
MediaCapabilitiesInfo::InitIds(JSContext* cx, MediaCapabilitiesInfoAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->supported_id.init(cx, "supported") ||
      !atomsCache->smooth_id.init(cx, "smooth") ||
      !atomsCache->powerEfficient_id.init(cx, "powerEfficient")) {
    return false;
  }
  return true;
}

bool
MediaCapabilitiesInfo::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
MediaCapabilitiesInfo::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  MediaCapabilitiesInfoAtoms* atomsCache = GetAtomCache<MediaCapabilitiesInfoAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mPowerEfficient;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->powerEfficient_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mSmooth;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->smooth_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mSupported;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->supported_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
MediaCapabilitiesInfo::TraceDictionary(JSTracer* trc)
{
}

MediaCapabilitiesInfo&
MediaCapabilitiesInfo::operator=(const MediaCapabilitiesInfo& aOther)
{
  DictionaryBase::operator=(aOther);
  mPowerEfficient = aOther.mPowerEfficient;
  mSmooth = aOther.mSmooth;
  mSupported = aOther.mSupported;
  return *this;
}



VideoConfiguration::VideoConfiguration()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
VideoConfiguration::InitIds(JSContext* cx, VideoConfigurationAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->width_id.init(cx, "width") ||
      !atomsCache->transferFunction_id.init(cx, "transferFunction") ||
      !atomsCache->scalabilityMode_id.init(cx, "scalabilityMode") ||
      !atomsCache->height_id.init(cx, "height") ||
      !atomsCache->hdrMetadataType_id.init(cx, "hdrMetadataType") ||
      !atomsCache->hasAlphaChannel_id.init(cx, "hasAlphaChannel") ||
      !atomsCache->framerate_id.init(cx, "framerate") ||
      !atomsCache->contentType_id.init(cx, "contentType") ||
      !atomsCache->colorGamut_id.init(cx, "colorGamut") ||
      !atomsCache->bitrate_id.init(cx, "bitrate")) {
    return false;
  }
  return true;
}

bool
VideoConfiguration::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  VideoConfigurationAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<VideoConfigurationAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->bitrate_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint64_t, eDefault>(cx, temp.ref(), "'bitrate' member of VideoConfiguration", &mBitrate)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'bitrate' member of VideoConfiguration");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->colorGamut_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mColorGamut.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<ColorGamut>::Values,
                                                                         "ColorGamut", "'colorGamut' member of VideoConfiguration",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mColorGamut.Value()) = static_cast<ColorGamut>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->contentType_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mContentType)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'contentType' member of VideoConfiguration");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->framerate_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'framerate' member of VideoConfiguration", &mFramerate)) {
      return false;
    } else if (!std::isfinite(mFramerate)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'framerate' member of VideoConfiguration");
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'framerate' member of VideoConfiguration");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->hasAlphaChannel_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mHasAlphaChannel.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'hasAlphaChannel' member of VideoConfiguration", &(mHasAlphaChannel.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->hdrMetadataType_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mHdrMetadataType.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<HdrMetadataType>::Values,
                                                                         "HdrMetadataType", "'hdrMetadataType' member of VideoConfiguration",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mHdrMetadataType.Value()) = static_cast<HdrMetadataType>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->height_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'height' member of VideoConfiguration", &mHeight)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'height' member of VideoConfiguration");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->scalabilityMode_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mScalabilityMode.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mScalabilityMode.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->transferFunction_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mTransferFunction.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<TransferFunction>::Values,
                                                                         "TransferFunction", "'transferFunction' member of VideoConfiguration",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mTransferFunction.Value()) = static_cast<TransferFunction>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->width_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'width' member of VideoConfiguration", &mWidth)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'width' member of VideoConfiguration");
  }
  return true;
}

bool
VideoConfiguration::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
VideoConfiguration::TraceDictionary(JSTracer* trc)
{
}

VideoConfiguration&
VideoConfiguration::operator=(const VideoConfiguration& aOther)
{
  DictionaryBase::operator=(aOther);
  mBitrate = aOther.mBitrate;
  mColorGamut.Reset();
  if (aOther.mColorGamut.WasPassed()) {
    mColorGamut.Construct(aOther.mColorGamut.Value());
  }
  mContentType = aOther.mContentType;
  mFramerate = aOther.mFramerate;
  mHasAlphaChannel.Reset();
  if (aOther.mHasAlphaChannel.WasPassed()) {
    mHasAlphaChannel.Construct(aOther.mHasAlphaChannel.Value());
  }
  mHdrMetadataType.Reset();
  if (aOther.mHdrMetadataType.WasPassed()) {
    mHdrMetadataType.Construct(aOther.mHdrMetadataType.Value());
  }
  mHeight = aOther.mHeight;
  mScalabilityMode.Reset();
  if (aOther.mScalabilityMode.WasPassed()) {
    mScalabilityMode.Construct(aOther.mScalabilityMode.Value());
  }
  mTransferFunction.Reset();
  if (aOther.mTransferFunction.WasPassed()) {
    mTransferFunction.Construct(aOther.mTransferFunction.Value());
  }
  mWidth = aOther.mWidth;
  return *this;
}



MediaCapabilitiesDecodingInfo::MediaCapabilitiesDecodingInfo()
  : MediaCapabilitiesInfo(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
MediaCapabilitiesDecodingInfo::InitIds(JSContext* cx, MediaCapabilitiesDecodingInfoAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->keySystemAccess_id.init(cx, "keySystemAccess")) {
    return false;
  }
  return true;
}

bool
MediaCapabilitiesDecodingInfo::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!MediaCapabilitiesInfo::Init()) {
    return false;
  }

  return true;
}

bool
MediaCapabilitiesDecodingInfo::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  MediaCapabilitiesDecodingInfoAtoms* atomsCache = GetAtomCache<MediaCapabilitiesDecodingInfoAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!MediaCapabilitiesInfo::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    RefPtr<mozilla::dom::MediaKeySystemAccess> const & currentValue = mKeySystemAccess;
    if (!currentValue) {
      temp.setNull();
      if (!JS_DefinePropertyById(cx, obj, atomsCache->keySystemAccess_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    }
    if (!GetOrCreateDOMReflector(cx, currentValue, &temp)) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->keySystemAccess_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
MediaCapabilitiesDecodingInfo::TraceDictionary(JSTracer* trc)
{
  MediaCapabilitiesInfo::TraceDictionary(trc);
}



MediaCapabilitiesDecodingInfo&
MediaCapabilitiesDecodingInfo::operator=(const MediaCapabilitiesDecodingInfo& aOther)
{
  MediaCapabilitiesInfo::operator=(aOther);
  mKeySystemAccess = aOther.mKeySystemAccess;
  return *this;
}



MediaCapabilitiesKeySystemConfiguration::MediaCapabilitiesKeySystemConfiguration()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
MediaCapabilitiesKeySystemConfiguration::InitIds(JSContext* cx, MediaCapabilitiesKeySystemConfigurationAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->video_id.init(cx, "video") ||
      !atomsCache->sessionTypes_id.init(cx, "sessionTypes") ||
      !atomsCache->persistentState_id.init(cx, "persistentState") ||
      !atomsCache->keySystem_id.init(cx, "keySystem") ||
      !atomsCache->initDataType_id.init(cx, "initDataType") ||
      !atomsCache->distinctiveIdentifier_id.init(cx, "distinctiveIdentifier") ||
      !atomsCache->audio_id.init(cx, "audio")) {
    return false;
  }
  return true;
}

bool
MediaCapabilitiesKeySystemConfiguration::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  MediaCapabilitiesKeySystemConfigurationAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<MediaCapabilitiesKeySystemConfigurationAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->audio_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mAudio.Construct();
    if (!(mAudio.Value()).Init(cx, temp.ref(), "'audio' member of MediaCapabilitiesKeySystemConfiguration", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->distinctiveIdentifier_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<MediaKeysRequirement>::Values,
                                                                         "MediaKeysRequirement", "'distinctiveIdentifier' member of MediaCapabilitiesKeySystemConfiguration",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mDistinctiveIdentifier = static_cast<MediaKeysRequirement>(index);
    }
  } else {
    mDistinctiveIdentifier = MediaKeysRequirement::Optional;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->initDataType_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mInitDataType)) {
      return false;
    }
  } else {
    mInitDataType.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->keySystem_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mKeySystem)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'keySystem' member of MediaCapabilitiesKeySystemConfiguration");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->persistentState_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<MediaKeysRequirement>::Values,
                                                                         "MediaKeysRequirement", "'persistentState' member of MediaCapabilitiesKeySystemConfiguration",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mPersistentState = static_cast<MediaKeysRequirement>(index);
    }
  } else {
    mPersistentState = MediaKeysRequirement::Optional;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->sessionTypes_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mSessionTypes.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'sessionTypes' member of MediaCapabilitiesKeySystemConfiguration", "sequence");
        return false;
      }
      Sequence<nsString> &arr = (mSessionTypes.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        nsString* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        nsString& slot = *slotPtr;
        if (!ConvertJSValueToString(cx, temp, eStringify, eStringify, slot)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'sessionTypes' member of MediaCapabilitiesKeySystemConfiguration", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->video_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mVideo.Construct();
    if (!(mVideo.Value()).Init(cx, temp.ref(), "'video' member of MediaCapabilitiesKeySystemConfiguration", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
MediaCapabilitiesKeySystemConfiguration::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
MediaCapabilitiesKeySystemConfiguration::TraceDictionary(JSTracer* trc)
{
}

MediaCapabilitiesKeySystemConfiguration&
MediaCapabilitiesKeySystemConfiguration::operator=(const MediaCapabilitiesKeySystemConfiguration& aOther)
{
  DictionaryBase::operator=(aOther);
  mAudio.Reset();
  if (aOther.mAudio.WasPassed()) {
    mAudio.Construct(aOther.mAudio.Value());
  }
  mDistinctiveIdentifier = aOther.mDistinctiveIdentifier;
  mInitDataType = aOther.mInitDataType;
  mKeySystem = aOther.mKeySystem;
  mPersistentState = aOther.mPersistentState;
  mSessionTypes.Reset();
  if (aOther.mSessionTypes.WasPassed()) {
    mSessionTypes.Construct(aOther.mSessionTypes.Value());
  }
  mVideo.Reset();
  if (aOther.mVideo.WasPassed()) {
    mVideo.Construct(aOther.mVideo.Value());
  }
  return *this;
}



MediaConfiguration::MediaConfiguration()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
MediaConfiguration::InitIds(JSContext* cx, MediaConfigurationAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->video_id.init(cx, "video") ||
      !atomsCache->audio_id.init(cx, "audio")) {
    return false;
  }
  return true;
}

bool
MediaConfiguration::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  MediaConfigurationAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<MediaConfigurationAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->audio_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mAudio.Construct();
    if (!(mAudio.Value()).Init(cx, temp.ref(), "'audio' member of MediaConfiguration", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->video_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mVideo.Construct();
    if (!(mVideo.Value()).Init(cx, temp.ref(), "'video' member of MediaConfiguration", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
MediaConfiguration::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
MediaConfiguration::TraceDictionary(JSTracer* trc)
{
}

MediaConfiguration&
MediaConfiguration::operator=(const MediaConfiguration& aOther)
{
  DictionaryBase::operator=(aOther);
  mAudio.Reset();
  if (aOther.mAudio.WasPassed()) {
    mAudio.Construct(aOther.mAudio.Value());
  }
  mVideo.Reset();
  if (aOther.mVideo.WasPassed()) {
    mVideo.Construct(aOther.mVideo.Value());
  }
  return *this;
}



MediaDecodingConfiguration::MediaDecodingConfiguration()
  : MediaConfiguration(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
MediaDecodingConfiguration::InitIds(JSContext* cx, MediaDecodingConfigurationAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->type_id.init(cx, "type") ||
      !atomsCache->keySystemConfiguration_id.init(cx, "keySystemConfiguration")) {
    return false;
  }
  return true;
}

bool
MediaDecodingConfiguration::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  MediaDecodingConfigurationAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<MediaDecodingConfigurationAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!MediaConfiguration::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->keySystemConfiguration_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mKeySystemConfiguration.Construct();
    if (!(mKeySystemConfiguration.Value()).Init(cx, temp.ref(), "'keySystemConfiguration' member of MediaDecodingConfiguration", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->type_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<MediaDecodingType>::Values,
                                                                         "MediaDecodingType", "'type' member of MediaDecodingConfiguration",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mType = static_cast<MediaDecodingType>(index);
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'type' member of MediaDecodingConfiguration");
  }
  return true;
}

bool
MediaDecodingConfiguration::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
MediaDecodingConfiguration::TraceDictionary(JSTracer* trc)
{
  MediaConfiguration::TraceDictionary(trc);
}

MediaDecodingConfiguration&
MediaDecodingConfiguration::operator=(const MediaDecodingConfiguration& aOther)
{
  MediaConfiguration::operator=(aOther);
  mKeySystemConfiguration.Reset();
  if (aOther.mKeySystemConfiguration.WasPassed()) {
    mKeySystemConfiguration.Construct(aOther.mKeySystemConfiguration.Value());
  }
  mType = aOther.mType;
  return *this;
}



MediaEncodingConfiguration::MediaEncodingConfiguration()
  : MediaConfiguration(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
MediaEncodingConfiguration::InitIds(JSContext* cx, MediaEncodingConfigurationAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->type_id.init(cx, "type")) {
    return false;
  }
  return true;
}

bool
MediaEncodingConfiguration::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  MediaEncodingConfigurationAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<MediaEncodingConfigurationAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!MediaConfiguration::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->type_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<MediaEncodingType>::Values,
                                                                         "MediaEncodingType", "'type' member of MediaEncodingConfiguration",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mType = static_cast<MediaEncodingType>(index);
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'type' member of MediaEncodingConfiguration");
  }
  return true;
}

bool
MediaEncodingConfiguration::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
MediaEncodingConfiguration::TraceDictionary(JSTracer* trc)
{
  MediaConfiguration::TraceDictionary(trc);
}

MediaEncodingConfiguration&
MediaEncodingConfiguration::operator=(const MediaEncodingConfiguration& aOther)
{
  MediaConfiguration::operator=(aOther);
  mType = aOther.mType;
  return *this;
}


namespace MediaCapabilities_Binding {

MOZ_CAN_RUN_SCRIPT static bool
decodingInfo(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "MediaCapabilities.decodingInfo");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MediaCapabilities", "decodingInfo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MediaCapabilities*>(void_self);
  if (!args.requireAtLeast(cx, "MediaCapabilities.decodingInfo", 1)) {
    return false;
  }
  binding_detail::FastMediaDecodingConfiguration arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->DecodingInfo(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "MediaCapabilities.decodingInfo"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
decodingInfo_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = decodingInfo(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo decodingInfo_methodinfo = {
  { (JSJitGetterOp)decodingInfo_promiseWrapper },
  { prototypes::id::MediaCapabilities },
  { PrototypeTraits<prototypes::id::MediaCapabilities>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
encodingInfo(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "MediaCapabilities.encodingInfo");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MediaCapabilities", "encodingInfo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MediaCapabilities*>(void_self);
  if (!args.requireAtLeast(cx, "MediaCapabilities.encodingInfo", 1)) {
    return false;
  }
  binding_detail::FastMediaEncodingConfiguration arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->EncodingInfo(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "MediaCapabilities.encodingInfo"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
encodingInfo_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = encodingInfo(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo encodingInfo_methodinfo = {
  { (JSJitGetterOp)encodingInfo_promiseWrapper },
  { prototypes::id::MediaCapabilities },
  { PrototypeTraits<prototypes::id::MediaCapabilities>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::MediaCapabilities* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::MediaCapabilities>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::MediaCapabilities>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("decodingInfo", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&decodingInfo_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("encodingInfo", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&encodingInfo_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[2];
static PropertyInfo sNativeProperties_propertyInfos[2];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  2,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(2 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::MediaCapabilities,
  constructors::id::MediaCapabilities,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::MediaCapabilities>::Depth,
  prototypes::id::MediaCapabilities,
  true,
  0,
  "MediaCapabilities",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "MediaCapabilitiesPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::MediaCapabilities,
  PrototypeTraits<prototypes::id::MediaCapabilities>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<mozilla::dom::MediaCapabilities>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "MediaCapabilities",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::MediaCapabilities>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::MediaCapabilities, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::MediaCapabilities>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::MediaCapabilities>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::MediaCapabilities>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::MediaCapabilities>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::MediaCapabilities* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::MediaCapabilities>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::MediaCapabilities*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::MediaCapabilities> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::MediaCapabilities);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::MediaCapabilities);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "MediaCapabilities",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::MediaCapabilities,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::MediaCapabilities,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace MediaCapabilities_Binding



} // namespace dom


} // namespace mozilla
