/* THIS FILE IS AUTOGENERATED FROM KeyframeEffect.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AnimationEffectBinding.h"
#include "AtomList.h"
#include "KeyframeEffectBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/Element.h"
#include "mozilla/dom/KeyframeEffect.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<IterationCompositeOperation>::Values[2];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, IterationCompositeOperation aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<IterationCompositeOperation>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<IterationCompositeOperation>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<IterationCompositeOperation>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}



AnimationPropertyValueDetails::AnimationPropertyValueDetails()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
AnimationPropertyValueDetails::InitIds(JSContext* cx, AnimationPropertyValueDetailsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->value_id.init(cx, "value") ||
      !atomsCache->offset_id.init(cx, "offset") ||
      !atomsCache->easing_id.init(cx, "easing") ||
      !atomsCache->composite_id.init(cx, "composite")) {
    return false;
  }
  return true;
}

bool
AnimationPropertyValueDetails::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
AnimationPropertyValueDetails::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  AnimationPropertyValueDetailsAtoms* atomsCache = GetAtomCache<AnimationPropertyValueDetailsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    CompositeOperation const & currentValue = mComposite;
    if (!ToJSValue(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->composite_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mEasing.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mEasing.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->easing_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mOffset;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->offset_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mValue.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mValue.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->value_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
AnimationPropertyValueDetails::TraceDictionary(JSTracer* trc)
{
}

AnimationPropertyValueDetails&
AnimationPropertyValueDetails::operator=(const AnimationPropertyValueDetails& aOther)
{
  DictionaryBase::operator=(aOther);
  mComposite = aOther.mComposite;
  mEasing.Reset();
  if (aOther.mEasing.WasPassed()) {
    mEasing.Construct(aOther.mEasing.Value());
  }
  mOffset = aOther.mOffset;
  mValue.Reset();
  if (aOther.mValue.WasPassed()) {
    mValue.Construct(aOther.mValue.Value());
  }
  return *this;
}



KeyframeEffectOptions::KeyframeEffectOptions()
  : EffectTiming(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
KeyframeEffectOptions::InitIds(JSContext* cx, KeyframeEffectOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->pseudoElement_id.init(cx, "pseudoElement") ||
      !atomsCache->iterationComposite_id.init(cx, "iterationComposite") ||
      !atomsCache->composite_id.init(cx, "composite")) {
    return false;
  }
  return true;
}

bool
KeyframeEffectOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  KeyframeEffectOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<KeyframeEffectOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!EffectTiming::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->composite_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<CompositeOperation>::Values,
                                                                         "CompositeOperation", "'composite' member of KeyframeEffectOptions",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mComposite = static_cast<CompositeOperation>(index);
    }
  } else {
    mComposite = CompositeOperation::Replace;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->iterationComposite_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<IterationCompositeOperation>::Values,
                                                                         "IterationCompositeOperation", "'iterationComposite' member of KeyframeEffectOptions",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mIterationComposite = static_cast<IterationCompositeOperation>(index);
    }
  } else {
    mIterationComposite = IterationCompositeOperation::Replace;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->pseudoElement_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eNull, eNull, mPseudoElement)) {
      return false;
    }
  } else {
    mPseudoElement.SetIsVoid(true);
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
KeyframeEffectOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
KeyframeEffectOptions::TraceDictionary(JSTracer* trc)
{
  EffectTiming::TraceDictionary(trc);
}

KeyframeEffectOptions&
KeyframeEffectOptions::operator=(const KeyframeEffectOptions& aOther)
{
  EffectTiming::operator=(aOther);
  mComposite = aOther.mComposite;
  mIterationComposite = aOther.mIterationComposite;
  mPseudoElement = aOther.mPseudoElement;
  return *this;
}



AnimationPropertyDetails::AnimationPropertyDetails()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
AnimationPropertyDetails::InitIds(JSContext* cx, AnimationPropertyDetailsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->warning_id.init(cx, "warning") ||
      !atomsCache->values_id.init(cx, "values") ||
      !atomsCache->runningOnCompositor_id.init(cx, "runningOnCompositor") ||
      !atomsCache->property_id.init(cx, "property")) {
    return false;
  }
  return true;
}

bool
AnimationPropertyDetails::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
AnimationPropertyDetails::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  AnimationPropertyDetailsAtoms* atomsCache = GetAtomCache<AnimationPropertyDetailsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mProperty;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->property_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mRunningOnCompositor;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->runningOnCompositor_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<AnimationPropertyValueDetails> const & currentValue = mValues;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->values_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mWarning.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mWarning.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->warning_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
AnimationPropertyDetails::TraceDictionary(JSTracer* trc)
{
}

AnimationPropertyDetails&
AnimationPropertyDetails::operator=(const AnimationPropertyDetails& aOther)
{
  DictionaryBase::operator=(aOther);
  mProperty = aOther.mProperty;
  mRunningOnCompositor = aOther.mRunningOnCompositor;
  mValues = aOther.mValues;
  mWarning.Reset();
  if (aOther.mWarning.WasPassed()) {
    mWarning.Construct(aOther.mWarning.Value());
  }
  return *this;
}


bool
UnrestrictedDoubleOrKeyframeEffectOptions::TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    double& memberSlot = RawSetAsUnrestrictedDouble();
    if (!ValueToPrimitive<double, eDefault>(cx, value, "Unrestricted double branch of (unrestricted double or KeyframeEffectOptions)", &memberSlot)) {
      return false;
    }
  }
  return true;
}







bool
UnrestrictedDoubleOrKeyframeEffectOptions::TrySetToKeyframeEffectOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FastKeyframeEffectOptions& memberSlot = RawSetAsKeyframeEffectOptions();
    if (!IsConvertibleToDictionary(value)) {
      DestroyKeyframeEffectOptions();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "KeyframeEffectOptions branch of (unrestricted double or KeyframeEffectOptions)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
UnrestrictedDoubleOrKeyframeEffectOptions::TrySetToKeyframeEffectOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToKeyframeEffectOptions(cx, value, tryNext, passedToJSImpl);
}







bool
UnrestrictedDoubleOrKeyframeEffectOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToKeyframeEffectOptions(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToUnrestrictedDouble(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "KeyframeEffectOptions");
    return false;
  }
  return true;
}

bool
UnrestrictedDoubleOrKeyframeEffectOptions::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}




OwningUnrestrictedDoubleOrKeyframeEffectOptions::OwningUnrestrictedDoubleOrKeyframeEffectOptions(OwningUnrestrictedDoubleOrKeyframeEffectOptions&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eUnrestrictedDouble: {
      mType = eUnrestrictedDouble;
      mValue.mUnrestrictedDouble.SetValue(std::move(aOther.mValue.mUnrestrictedDouble.Value()));
      break;
    }
    case eKeyframeEffectOptions: {
      mType = eKeyframeEffectOptions;
      mValue.mKeyframeEffectOptions.SetValue(std::move(aOther.mValue.mKeyframeEffectOptions.Value()));
      break;
    }
  }
}



bool
OwningUnrestrictedDoubleOrKeyframeEffectOptions::TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    double& memberSlot = RawSetAsUnrestrictedDouble();
    if (!ValueToPrimitive<double, eDefault>(cx, value, "Unrestricted double branch of (unrestricted double or KeyframeEffectOptions)", &memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] double&
OwningUnrestrictedDoubleOrKeyframeEffectOptions::RawSetAsUnrestrictedDouble()
{
  if (mType == eUnrestrictedDouble) {
    return mValue.mUnrestrictedDouble.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eUnrestrictedDouble;
  return mValue.mUnrestrictedDouble.SetValue();
}

[[nodiscard]] double&
OwningUnrestrictedDoubleOrKeyframeEffectOptions::SetAsUnrestrictedDouble()
{
  if (mType == eUnrestrictedDouble) {
    return mValue.mUnrestrictedDouble.Value();
  }
  Uninit();
  mType = eUnrestrictedDouble;
  return mValue.mUnrestrictedDouble.SetValue();
}


void
OwningUnrestrictedDoubleOrKeyframeEffectOptions::DestroyUnrestrictedDouble()
{
  MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
  mValue.mUnrestrictedDouble.Destroy();
  mType = eUninitialized;
}



bool
OwningUnrestrictedDoubleOrKeyframeEffectOptions::TrySetToKeyframeEffectOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    KeyframeEffectOptions& memberSlot = RawSetAsKeyframeEffectOptions();
    if (!IsConvertibleToDictionary(value)) {
      DestroyKeyframeEffectOptions();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "KeyframeEffectOptions branch of (unrestricted double or KeyframeEffectOptions)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
OwningUnrestrictedDoubleOrKeyframeEffectOptions::TrySetToKeyframeEffectOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToKeyframeEffectOptions(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] KeyframeEffectOptions&
OwningUnrestrictedDoubleOrKeyframeEffectOptions::RawSetAsKeyframeEffectOptions()
{
  if (mType == eKeyframeEffectOptions) {
    return mValue.mKeyframeEffectOptions.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eKeyframeEffectOptions;
  return mValue.mKeyframeEffectOptions.SetValue();
}

[[nodiscard]] KeyframeEffectOptions&
OwningUnrestrictedDoubleOrKeyframeEffectOptions::SetAsKeyframeEffectOptions()
{
  if (mType == eKeyframeEffectOptions) {
    return mValue.mKeyframeEffectOptions.Value();
  }
  Uninit();
  mType = eKeyframeEffectOptions;
  return mValue.mKeyframeEffectOptions.SetValue();
}


void
OwningUnrestrictedDoubleOrKeyframeEffectOptions::DestroyKeyframeEffectOptions()
{
  MOZ_RELEASE_ASSERT(IsKeyframeEffectOptions(), "Wrong type!");
  mValue.mKeyframeEffectOptions.Destroy();
  mType = eUninitialized;
}



bool
OwningUnrestrictedDoubleOrKeyframeEffectOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToKeyframeEffectOptions(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToUnrestrictedDouble(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "KeyframeEffectOptions");
    return false;
  }
  return true;
}

bool
OwningUnrestrictedDoubleOrKeyframeEffectOptions::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningUnrestrictedDoubleOrKeyframeEffectOptions::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eUnrestrictedDouble: {
      DestroyUnrestrictedDouble();
      break;
    }
    case eKeyframeEffectOptions: {
      DestroyKeyframeEffectOptions();
      break;
    }
  }
}

OwningUnrestrictedDoubleOrKeyframeEffectOptions&
OwningUnrestrictedDoubleOrKeyframeEffectOptions::operator=(OwningUnrestrictedDoubleOrKeyframeEffectOptions&& aOther)
{
  this->~OwningUnrestrictedDoubleOrKeyframeEffectOptions();
  new (this) OwningUnrestrictedDoubleOrKeyframeEffectOptions (std::move(aOther));
  return *this;
}


OwningUnrestrictedDoubleOrKeyframeEffectOptions&
OwningUnrestrictedDoubleOrKeyframeEffectOptions::operator=(const OwningUnrestrictedDoubleOrKeyframeEffectOptions& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eUnrestrictedDouble: {
      SetAsUnrestrictedDouble() = aOther.GetAsUnrestrictedDouble();
      break;
    }
    case eKeyframeEffectOptions: {
      SetAsKeyframeEffectOptions() = aOther.GetAsKeyframeEffectOptions();
      break;
    }
  }
  return *this;
}


namespace KeyframeEffect_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<AnimationEffect_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_target(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyframeEffect", "target", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyframeEffect*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->GetTarget()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_target(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "KeyframeEffect.target setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyframeEffect", "target", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyframeEffect*>(void_self);
  mozilla::dom::Element* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Value being assigned", "Element");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Value being assigned");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetTarget(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetTarget(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo target_getterinfo = {
  { get_target },
  { prototypes::id::KeyframeEffect },
  { PrototypeTraits<prototypes::id::KeyframeEffect>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo target_setterinfo = {
  { (JSJitGetterOp)set_target },
  { prototypes::id::KeyframeEffect },
  { PrototypeTraits<prototypes::id::KeyframeEffect>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_pseudoElement(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyframeEffect", "pseudoElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyframeEffect*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetPseudoElement(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetPseudoElement(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_pseudoElement(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyframeEffect", "pseudoElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyframeEffect*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eNull, eNull, arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetPseudoElement(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetPseudoElement(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "KeyframeEffect.pseudoElement setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo pseudoElement_getterinfo = {
  { get_pseudoElement },
  { prototypes::id::KeyframeEffect },
  { PrototypeTraits<prototypes::id::KeyframeEffect>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo pseudoElement_setterinfo = {
  { (JSJitGetterOp)set_pseudoElement },
  { prototypes::id::KeyframeEffect },
  { PrototypeTraits<prototypes::id::KeyframeEffect>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_iterationComposite(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyframeEffect", "iterationComposite", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyframeEffect*>(void_self);
  IterationCompositeOperation result(MOZ_KnownLive(self)->IterationComposite());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_iterationComposite(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "KeyframeEffect.iterationComposite setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyframeEffect", "iterationComposite", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyframeEffect*>(void_self);
  IterationCompositeOperation arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<IterationCompositeOperation>::Values,
                                                                       "IterationCompositeOperation", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<IterationCompositeOperation>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetIterationComposite(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetIterationComposite(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo iterationComposite_getterinfo = {
  { get_iterationComposite },
  { prototypes::id::KeyframeEffect },
  { PrototypeTraits<prototypes::id::KeyframeEffect>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo iterationComposite_setterinfo = {
  { (JSJitGetterOp)set_iterationComposite },
  { prototypes::id::KeyframeEffect },
  { PrototypeTraits<prototypes::id::KeyframeEffect>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_composite(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyframeEffect", "composite", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyframeEffect*>(void_self);
  CompositeOperation result(MOZ_KnownLive(self)->Composite());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_composite(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "KeyframeEffect.composite setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyframeEffect", "composite", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyframeEffect*>(void_self);
  CompositeOperation arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<CompositeOperation>::Values,
                                                                       "CompositeOperation", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<CompositeOperation>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetComposite(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetComposite(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo composite_getterinfo = {
  { get_composite },
  { prototypes::id::KeyframeEffect },
  { PrototypeTraits<prototypes::id::KeyframeEffect>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo composite_setterinfo = {
  { (JSJitGetterOp)set_composite },
  { prototypes::id::KeyframeEffect },
  { PrototypeTraits<prototypes::id::KeyframeEffect>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getKeyframes(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyframeEffect", "getKeyframes", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyframeEffect*>(void_self);
  FastErrorResult rv;
  nsTArray<JSObject*> result;
  SequenceRooter<JSObject* > resultRooter(cx, &result);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetKeyframes(cx, result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetKeyframes(cx, result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "KeyframeEffect.getKeyframes"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        JS::ExposeObjectToActiveJS(result[sequenceIdx0]);
        tmp.setObject(*result[sequenceIdx0]);
        if (!MaybeWrapObjectValue(cx, &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getKeyframes_methodinfo = {
  { (JSJitGetterOp)getKeyframes },
  { prototypes::id::KeyframeEffect },
  { PrototypeTraits<prototypes::id::KeyframeEffect>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setKeyframes(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "KeyframeEffect.setKeyframes");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyframeEffect", "setKeyframes", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyframeEffect*>(void_self);
  if (!args.requireAtLeast(cx, "KeyframeEffect.setKeyframes", 1)) {
    return false;
  }
  JS::Rooted<JSObject*> arg0(cx);
  if (args[0].isObject()) {
    arg0 = &args[0].toObject();
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetKeyframes(cx, arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetKeyframes(cx, arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "KeyframeEffect.setKeyframes"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setKeyframes_methodinfo = {
  { (JSJitGetterOp)setKeyframes },
  { prototypes::id::KeyframeEffect },
  { PrototypeTraits<prototypes::id::KeyframeEffect>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getProperties(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyframeEffect", "getProperties", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyframeEffect*>(void_self);
  FastErrorResult rv;
  nsTArray<AnimationPropertyDetails> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetProperties(result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetProperties(result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "KeyframeEffect.getProperties"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!result[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getProperties_methodinfo = {
  { (JSJitGetterOp)getProperties },
  { prototypes::id::KeyframeEffect },
  { PrototypeTraits<prototypes::id::KeyframeEffect>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::KeyframeEffect* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::KeyframeEffect>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::KeyframeEffect>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("getKeyframes", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getKeyframes_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setKeyframes", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setKeyframes_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sChromeMethods_specs[] = {
  JS_FNSPEC("getProperties", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getProperties_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sChromeMethods[] = {
  { nullptr, &sChromeMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("target", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &target_getterinfo, GenericSetter<NormalThisPolicy>, &target_setterinfo),
  JSPropertySpec::nativeAccessors("pseudoElement", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &pseudoElement_getterinfo, GenericSetter<NormalThisPolicy>, &pseudoElement_setterinfo),
  JSPropertySpec::nativeAccessors("iterationComposite", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &iterationComposite_getterinfo, GenericSetter<NormalThisPolicy>, &iterationComposite_setterinfo),
  JSPropertySpec::nativeAccessors("composite", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &composite_getterinfo, GenericSetter<NormalThisPolicy>, &composite_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[6];
static PropertyInfo sNativeProperties_propertyInfos[6];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  6,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[2] }
  }
};
static_assert(6 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[1];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[1];

static const NativePropertiesN<1> sChromeOnlyNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sChromeMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  1,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeMethods, &sChromeOnlyNativeProperties_propertyInfos[0] }
  }
};
static_assert(1 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::KeyframeEffect,
  constructors::id::KeyframeEffect,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "KeyframeEffect constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyframeEffect", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "KeyframeEffect");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::KeyframeEffect,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  unsigned argcount = std::min(args.length(), 3u);
  switch (argcount) {
    case 1: {
      GlobalObject global(cx, obj);
      if (global.Failed()) {
        return false;
      }

      NonNull<mozilla::dom::KeyframeEffect> arg0;
      if (args[0].isObject()) {
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::KeyframeEffect, mozilla::dom::KeyframeEffect>(args[0], arg0, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "KeyframeEffect");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<mozilla::dom::KeyframeEffect>(mozilla::dom::KeyframeEffect::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "KeyframeEffect constructor"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      static_assert(!std::is_pointer_v<decltype(result)>,
                    "NewObject implies that we need to keep the object alive with a strong reference.");
      if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
      break;
    }
    case 2: {
      [[fallthrough]];
    }
    case 3: {
      GlobalObject global(cx, obj);
      if (global.Failed()) {
        return false;
      }

      mozilla::dom::Element* arg0;
      if (args[0].isObject()) {
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
            return false;
          }
        }
      } else if (args[0].isNullOrUndefined()) {
        arg0 = nullptr;
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      JS::Rooted<JSObject*> arg1(cx);
      if (args[1].isObject()) {
        arg1 = &args[1].toObject();
      } else if (args[1].isNullOrUndefined()) {
        arg1 = nullptr;
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
        return false;
      }
      UnrestrictedDoubleOrKeyframeEffectOptions arg2;
      if (!(args.hasDefined(2))) {
        if (!arg2.RawSetAsKeyframeEffectOptions().Init(cx, JS::NullHandleValue, "Member of (unrestricted double or KeyframeEffectOptions)")) {
          return false;
        }
      } else {
        if (!arg2.Init(cx, args[2], "Argument 3", false)) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<mozilla::dom::KeyframeEffect>(mozilla::dom::KeyframeEffect::Constructor(global, MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "KeyframeEffect constructor"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      static_assert(!std::is_pointer_v<decltype(result)>,
                    "NewObject implies that we need to keep the object alive with a strong reference.");
      if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  AnimationEffect_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::KeyframeEffect>::Depth,
  prototypes::id::KeyframeEffect,
  true,
  1,
  "KeyframeEffect",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "KeyframeEffectPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::KeyframeEffect,
  PrototypeTraits<prototypes::id::KeyframeEffect>::Depth,
  &sNativePropertyHooks,
  AnimationEffect_Binding::GetProtoObject
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<mozilla::dom::KeyframeEffect>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "KeyframeEffect",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::KeyframeEffect>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::AnimationEffect, prototypes::id::KeyframeEffect, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::KeyframeEffect>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::KeyframeEffect>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::KeyframeEffect>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::KeyframeEffect>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::KeyframeEffect* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::KeyframeEffect>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::KeyframeEffect*>);
  MOZ_ASSERT(static_cast<mozilla::dom::AnimationEffect*>(aObject) ==
             reinterpret_cast<mozilla::dom::AnimationEffect*>(aObject),
             "Multiple inheritance for mozilla::dom::AnimationEffect is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::KeyframeEffect> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::KeyframeEffect);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::KeyframeEffect);

  JS::Handle<JSObject*> parentProto(AnimationEffect_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(AnimationEffect_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 1, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              sChromeOnlyNativeProperties.Upcast(),
                              "KeyframeEffect",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::KeyframeEffect,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::KeyframeEffect,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace KeyframeEffect_Binding



} // namespace dom


} // namespace mozilla
