/* THIS FILE IS AUTOGENERATED FROM KeyboardEvent.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "KeyboardEvent.h"
#include "KeyboardEventBinding.h"
#include "MainThreadUtils.h"
#include "UIEventBinding.h"
#include "WrapperFactory.h"
#include "XrayWrapper.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/KeyboardEvent.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "nsGlobalWindowInner.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



KeyboardEventInit::KeyboardEventInit()
  : EventModifierInit(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
KeyboardEventInit::InitIds(JSContext* cx, KeyboardEventInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->which_id.init(cx, "which") ||
      !atomsCache->repeat_id.init(cx, "repeat") ||
      !atomsCache->location_id.init(cx, "location") ||
      !atomsCache->keyCode_id.init(cx, "keyCode") ||
      !atomsCache->key_id.init(cx, "key") ||
      !atomsCache->isComposing_id.init(cx, "isComposing") ||
      !atomsCache->code_id.init(cx, "code") ||
      !atomsCache->charCode_id.init(cx, "charCode")) {
    return false;
  }
  return true;
}

bool
KeyboardEventInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  KeyboardEventInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<KeyboardEventInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!EventModifierInit::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->charCode_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'charCode' member of KeyboardEventInit", &mCharCode)) {
      return false;
    }
  } else {
    mCharCode = 0U;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->code_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mCode)) {
      return false;
    }
  } else {
    mCode.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->isComposing_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'isComposing' member of KeyboardEventInit", &mIsComposing)) {
      return false;
    }
  } else {
    mIsComposing = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->key_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mKey)) {
      return false;
    }
  } else {
    mKey.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->keyCode_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'keyCode' member of KeyboardEventInit", &mKeyCode)) {
      return false;
    }
  } else {
    mKeyCode = 0U;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->location_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'location' member of KeyboardEventInit", &mLocation)) {
      return false;
    }
  } else {
    mLocation = 0U;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->repeat_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'repeat' member of KeyboardEventInit", &mRepeat)) {
      return false;
    }
  } else {
    mRepeat = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->which_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'which' member of KeyboardEventInit", &mWhich)) {
      return false;
    }
  } else {
    mWhich = 0U;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
KeyboardEventInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
KeyboardEventInit::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  KeyboardEventInitAtoms* atomsCache = GetAtomCache<KeyboardEventInitAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!EventModifierInit::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mCharCode;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->charCode_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mCode;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->code_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mIsComposing;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->isComposing_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mKey;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->key_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mKeyCode;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->keyCode_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mLocation;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->location_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mRepeat;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->repeat_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mWhich;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->which_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
KeyboardEventInit::TraceDictionary(JSTracer* trc)
{
  EventModifierInit::TraceDictionary(trc);
}



KeyboardEventInit&
KeyboardEventInit::operator=(const KeyboardEventInit& aOther)
{
  EventModifierInit::operator=(aOther);
  mCharCode = aOther.mCharCode;
  mCode = aOther.mCode;
  mIsComposing = aOther.mIsComposing;
  mKey = aOther.mKey;
  mKeyCode = aOther.mKeyCode;
  mLocation = aOther.mLocation;
  mRepeat = aOther.mRepeat;
  mWhich = aOther.mWhich;
  return *this;
}


namespace KeyboardEvent_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<UIEvent_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_charCode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "charCode", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->CharCode(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo charCode_getterinfo = {
  { get_charCode },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_keyCode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "keyCode", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->KeyCode(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo keyCode_getterinfo = {
  { get_keyCode },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_altKey(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "altKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->AltKey(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo altKey_getterinfo = {
  { get_altKey },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ctrlKey(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "ctrlKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->CtrlKey(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo ctrlKey_getterinfo = {
  { get_ctrlKey },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_shiftKey(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "shiftKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->ShiftKey(nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo shiftKey_getterinfo = {
  { get_shiftKey },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_metaKey(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "metaKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->MetaKey());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo metaKey_getterinfo = {
  { get_metaKey },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getModifierState(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "getModifierState", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  if (!args.requireAtLeast(cx, "KeyboardEvent.getModifierState", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  bool result(MOZ_KnownLive(self)->GetModifierState(NonNullHelper(Constify(arg0)), nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo getModifierState_methodinfo = {
  { (JSJitGetterOp)getModifierState },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_location(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "location", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->Location());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo location_getterinfo = {
  { get_location },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_repeat(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "repeat", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->Repeat());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo repeat_getterinfo = {
  { get_repeat },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isComposing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "isComposing", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->IsComposing());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isComposing_getterinfo = {
  { get_isComposing },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_key(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "key", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetKey(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetKey(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo key_getterinfo = {
  { get_key },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_code(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "code", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetCode(result, nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetCode(result, nsContentUtils::IsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo code_getterinfo = {
  { get_code },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
initKeyboardEvent(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "KeyboardEvent.initKeyboardEvent");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "initKeyboardEvent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  if (!args.requireAtLeast(cx, "KeyboardEvent.initKeyboardEvent", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  bool arg1;
  if (args.hasDefined(1)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
      return false;
    }
  } else {
    arg1 = false;
  }
  bool arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = false;
  }
  nsGlobalWindowInner* arg3;
  if (args.hasDefined(3)) {
    if (args[3].isObject()) {
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::Window, nsGlobalWindowInner>(args[3], arg3, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 4", "Window");
          return false;
        }
      }
    } else if (args[3].isNullOrUndefined()) {
      arg3 = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 4");
      return false;
    }
  } else {
    arg3 = nullptr;
  }
  binding_detail::FakeString<char16_t> arg4;
  if (args.hasDefined(4)) {
    if (!ConvertJSValueToString(cx, args[4], eStringify, eStringify, arg4)) {
      return false;
    }
  } else {
    arg4.AssignLiteral(u"");
  }
  uint32_t arg5;
  if (args.hasDefined(5)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
      return false;
    }
  } else {
    arg5 = 0U;
  }
  bool arg6;
  if (args.hasDefined(6)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[6], "Argument 7", &arg6)) {
      return false;
    }
  } else {
    arg6 = false;
  }
  bool arg7;
  if (args.hasDefined(7)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[7], "Argument 8", &arg7)) {
      return false;
    }
  } else {
    arg7 = false;
  }
  bool arg8;
  if (args.hasDefined(8)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[8], "Argument 9", &arg8)) {
      return false;
    }
  } else {
    arg8 = false;
  }
  bool arg9;
  if (args.hasDefined(9)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[9], "Argument 10", &arg9)) {
      return false;
    }
  } else {
    arg9 = false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->InitKeyboardEventJS(NonNullHelper(Constify(arg0)), arg1, arg2, MOZ_KnownLive(Constify(arg3)), NonNullHelper(Constify(arg4)), arg5, arg6, arg7, arg8, arg9))>, "Should be returning void here");
  MOZ_KnownLive(self)->InitKeyboardEventJS(NonNullHelper(Constify(arg0)), arg1, arg2, MOZ_KnownLive(Constify(arg3)), NonNullHelper(Constify(arg4)), arg5, arg6, arg7, arg8, arg9);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo initKeyboardEvent_methodinfo = {
  { (JSJitGetterOp)initKeyboardEvent },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_initDict(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "initDict", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  // Have to either root across the getter call or reget after.
  bool isXray;
  JS::Rooted<JSObject*> slotStorage(cx, GetCachedSlotStorageObject(cx, obj, &isXray));
  if (!slotStorage) {
    return false;
  }
  const size_t slotIndex = isXray ? (DOM_EXPANDO_RESERVED_SLOTS + 0) : (DOM_INSTANCE_RESERVED_SLOTS + 0);
  MOZ_ASSERT(slotIndex < JSCLASS_RESERVED_SLOTS(JS::GetClass(slotStorage)));
  {
    // Scope for cachedVal
    JS::Value cachedVal = JS::GetReservedSlot(slotStorage, slotIndex);
    if (!cachedVal.isUndefined()) {
      args.rval().set(cachedVal);
      // The cached value is in the compartment of slotStorage,
      // so wrap into the caller compartment as needed.
      return MaybeWrapNonDOMObjectValue(cx, args.rval());
    }
  }

  KeyboardEventInit result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetInitDict(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetInitDict(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  {
    JS::Rooted<JSObject*> conversionScope(cx, isXray ? JS::CurrentGlobalOrNull(cx) : slotStorage);
    JSAutoRealm ar(cx, conversionScope);
    do { // block we break out of when done wrapping
      if (!result.ToObjectInternal(cx, args.rval())) {
        return false;
      }
      break;
    } while (false);
  }
  { // And now store things in the realm of our slotStorage.
    JSAutoRealm ar(cx, slotStorage);
    // Make a copy so that we don't do unnecessary wrapping on args.rval().
    JS::Rooted<JS::Value> storedVal(cx, args.rval());
    if (!MaybeWrapNonDOMObjectValue(cx, &storedVal)) {
      return false;
    }
    JS::SetReservedSlot(slotStorage, slotIndex, storedVal);
    if (!isXray) {
      // In the Xray case we don't need to do this, because getting the
      // expando object already preserved our wrapper.
      PreserveWrapper(self);
    }
  }
  // And now make sure args.rval() is in the caller realm.
  return MaybeWrapNonDOMObjectValue(cx, args.rval());
}

static const JSJitInfo initDict_getterinfo = {
  { get_initDict },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  true, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  (DOM_INSTANCE_RESERVED_SLOTS + 0)   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) <= JSJitInfo::maxSlotIndex, "We won't fit");
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) < 2, "There is no slot for us");

MOZ_CAN_RUN_SCRIPT static bool
initKeyEvent(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "KeyboardEvent.initKeyEvent");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "initKeyEvent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  if (!args.requireAtLeast(cx, "KeyboardEvent.initKeyEvent", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  bool arg1;
  if (args.hasDefined(1)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
      return false;
    }
  } else {
    arg1 = false;
  }
  bool arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = false;
  }
  nsGlobalWindowInner* arg3;
  if (args.hasDefined(3)) {
    if (args[3].isObject()) {
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::Window, nsGlobalWindowInner>(args[3], arg3, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 4", "Window");
          return false;
        }
      }
    } else if (args[3].isNullOrUndefined()) {
      arg3 = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 4");
      return false;
    }
  } else {
    arg3 = nullptr;
  }
  bool arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = false;
  }
  bool arg5;
  if (args.hasDefined(5)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[5], "Argument 6", &arg5)) {
      return false;
    }
  } else {
    arg5 = false;
  }
  bool arg6;
  if (args.hasDefined(6)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[6], "Argument 7", &arg6)) {
      return false;
    }
  } else {
    arg6 = false;
  }
  bool arg7;
  if (args.hasDefined(7)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[7], "Argument 8", &arg7)) {
      return false;
    }
  } else {
    arg7 = false;
  }
  uint32_t arg8;
  if (args.hasDefined(8)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
      return false;
    }
  } else {
    arg8 = 0U;
  }
  uint32_t arg9;
  if (args.hasDefined(9)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
      return false;
    }
  } else {
    arg9 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->InitKeyEventJS(NonNullHelper(Constify(arg0)), arg1, arg2, MOZ_KnownLive(Constify(arg3)), arg4, arg5, arg6, arg7, arg8, arg9))>, "Should be returning void here");
  MOZ_KnownLive(self)->InitKeyEventJS(NonNullHelper(Constify(arg0)), arg1, arg2, MOZ_KnownLive(Constify(arg3)), arg4, arg5, arg6, arg7, arg8, arg9);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo initKeyEvent_methodinfo = {
  { (JSJitGetterOp)initKeyEvent },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isTrusted(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "isTrusted", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::KeyboardEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->IsTrusted());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isTrusted_getterinfo = {
  { get_isTrusted },
  { prototypes::id::KeyboardEvent },
  { PrototypeTraits<prototypes::id::KeyboardEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::KeyboardEvent* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::KeyboardEvent>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::KeyboardEvent>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("getModifierState", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getModifierState_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("initKeyboardEvent", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&initKeyboardEvent_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("initKeyEvent", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&initKeyEvent_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};

static const PrefableDisablers sMethods_disablers3 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &KeyboardEvent::IsInitKeyEventAvailable
};

static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { &sMethods_disablers3, &sMethods_specs[3] },
  { nullptr, nullptr }
};

static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("charCode", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &charCode_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("keyCode", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &keyCode_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("altKey", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &altKey_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("ctrlKey", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &ctrlKey_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("shiftKey", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &shiftKey_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("metaKey", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &metaKey_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("location", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &location_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("repeat", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &repeat_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("isComposing", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &isComposing_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("key", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &key_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("code", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &code_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(11 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sChromeAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("initDict", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &initDict_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sChromeAttributes[] = {
  { nullptr, &sChromeAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sUnforgeableAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("isTrusted", JSPROP_ENUMERATE | JSPROP_PERMANENT, GenericGetter<NormalThisPolicy, ThrowExceptions>, &isTrusted_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sUnforgeableAttributes[] = {
  { nullptr, &sUnforgeableAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const ConstantSpec sConstants_specs[] = {
  { "DOM_KEY_LOCATION_STANDARD", JS::NumberValue(0U) },
  { "DOM_KEY_LOCATION_LEFT", JS::NumberValue(1U) },
  { "DOM_KEY_LOCATION_RIGHT", JS::NumberValue(2U) },
  { "DOM_KEY_LOCATION_NUMPAD", JS::NumberValue(3U) },
  { "DOM_VK_CANCEL", JS::NumberValue(3U) },
  { "DOM_VK_HELP", JS::NumberValue(6U) },
  { "DOM_VK_BACK_SPACE", JS::NumberValue(8U) },
  { "DOM_VK_TAB", JS::NumberValue(9U) },
  { "DOM_VK_CLEAR", JS::NumberValue(12U) },
  { "DOM_VK_RETURN", JS::NumberValue(13U) },
  { "DOM_VK_SHIFT", JS::NumberValue(16U) },
  { "DOM_VK_CONTROL", JS::NumberValue(17U) },
  { "DOM_VK_ALT", JS::NumberValue(18U) },
  { "DOM_VK_PAUSE", JS::NumberValue(19U) },
  { "DOM_VK_CAPS_LOCK", JS::NumberValue(20U) },
  { "DOM_VK_KANA", JS::NumberValue(21U) },
  { "DOM_VK_HANGUL", JS::NumberValue(21U) },
  { "DOM_VK_EISU", JS::NumberValue(22U) },
  { "DOM_VK_JUNJA", JS::NumberValue(23U) },
  { "DOM_VK_FINAL", JS::NumberValue(24U) },
  { "DOM_VK_HANJA", JS::NumberValue(25U) },
  { "DOM_VK_KANJI", JS::NumberValue(25U) },
  { "DOM_VK_ESCAPE", JS::NumberValue(27U) },
  { "DOM_VK_CONVERT", JS::NumberValue(28U) },
  { "DOM_VK_NONCONVERT", JS::NumberValue(29U) },
  { "DOM_VK_ACCEPT", JS::NumberValue(30U) },
  { "DOM_VK_MODECHANGE", JS::NumberValue(31U) },
  { "DOM_VK_SPACE", JS::NumberValue(32U) },
  { "DOM_VK_PAGE_UP", JS::NumberValue(33U) },
  { "DOM_VK_PAGE_DOWN", JS::NumberValue(34U) },
  { "DOM_VK_END", JS::NumberValue(35U) },
  { "DOM_VK_HOME", JS::NumberValue(36U) },
  { "DOM_VK_LEFT", JS::NumberValue(37U) },
  { "DOM_VK_UP", JS::NumberValue(38U) },
  { "DOM_VK_RIGHT", JS::NumberValue(39U) },
  { "DOM_VK_DOWN", JS::NumberValue(40U) },
  { "DOM_VK_SELECT", JS::NumberValue(41U) },
  { "DOM_VK_PRINT", JS::NumberValue(42U) },
  { "DOM_VK_EXECUTE", JS::NumberValue(43U) },
  { "DOM_VK_PRINTSCREEN", JS::NumberValue(44U) },
  { "DOM_VK_INSERT", JS::NumberValue(45U) },
  { "DOM_VK_DELETE", JS::NumberValue(46U) },
  { "DOM_VK_0", JS::NumberValue(48U) },
  { "DOM_VK_1", JS::NumberValue(49U) },
  { "DOM_VK_2", JS::NumberValue(50U) },
  { "DOM_VK_3", JS::NumberValue(51U) },
  { "DOM_VK_4", JS::NumberValue(52U) },
  { "DOM_VK_5", JS::NumberValue(53U) },
  { "DOM_VK_6", JS::NumberValue(54U) },
  { "DOM_VK_7", JS::NumberValue(55U) },
  { "DOM_VK_8", JS::NumberValue(56U) },
  { "DOM_VK_9", JS::NumberValue(57U) },
  { "DOM_VK_COLON", JS::NumberValue(58U) },
  { "DOM_VK_SEMICOLON", JS::NumberValue(59U) },
  { "DOM_VK_LESS_THAN", JS::NumberValue(60U) },
  { "DOM_VK_EQUALS", JS::NumberValue(61U) },
  { "DOM_VK_GREATER_THAN", JS::NumberValue(62U) },
  { "DOM_VK_QUESTION_MARK", JS::NumberValue(63U) },
  { "DOM_VK_AT", JS::NumberValue(64U) },
  { "DOM_VK_A", JS::NumberValue(65U) },
  { "DOM_VK_B", JS::NumberValue(66U) },
  { "DOM_VK_C", JS::NumberValue(67U) },
  { "DOM_VK_D", JS::NumberValue(68U) },
  { "DOM_VK_E", JS::NumberValue(69U) },
  { "DOM_VK_F", JS::NumberValue(70U) },
  { "DOM_VK_G", JS::NumberValue(71U) },
  { "DOM_VK_H", JS::NumberValue(72U) },
  { "DOM_VK_I", JS::NumberValue(73U) },
  { "DOM_VK_J", JS::NumberValue(74U) },
  { "DOM_VK_K", JS::NumberValue(75U) },
  { "DOM_VK_L", JS::NumberValue(76U) },
  { "DOM_VK_M", JS::NumberValue(77U) },
  { "DOM_VK_N", JS::NumberValue(78U) },
  { "DOM_VK_O", JS::NumberValue(79U) },
  { "DOM_VK_P", JS::NumberValue(80U) },
  { "DOM_VK_Q", JS::NumberValue(81U) },
  { "DOM_VK_R", JS::NumberValue(82U) },
  { "DOM_VK_S", JS::NumberValue(83U) },
  { "DOM_VK_T", JS::NumberValue(84U) },
  { "DOM_VK_U", JS::NumberValue(85U) },
  { "DOM_VK_V", JS::NumberValue(86U) },
  { "DOM_VK_W", JS::NumberValue(87U) },
  { "DOM_VK_X", JS::NumberValue(88U) },
  { "DOM_VK_Y", JS::NumberValue(89U) },
  { "DOM_VK_Z", JS::NumberValue(90U) },
  { "DOM_VK_WIN", JS::NumberValue(91U) },
  { "DOM_VK_CONTEXT_MENU", JS::NumberValue(93U) },
  { "DOM_VK_SLEEP", JS::NumberValue(95U) },
  { "DOM_VK_NUMPAD0", JS::NumberValue(96U) },
  { "DOM_VK_NUMPAD1", JS::NumberValue(97U) },
  { "DOM_VK_NUMPAD2", JS::NumberValue(98U) },
  { "DOM_VK_NUMPAD3", JS::NumberValue(99U) },
  { "DOM_VK_NUMPAD4", JS::NumberValue(100U) },
  { "DOM_VK_NUMPAD5", JS::NumberValue(101U) },
  { "DOM_VK_NUMPAD6", JS::NumberValue(102U) },
  { "DOM_VK_NUMPAD7", JS::NumberValue(103U) },
  { "DOM_VK_NUMPAD8", JS::NumberValue(104U) },
  { "DOM_VK_NUMPAD9", JS::NumberValue(105U) },
  { "DOM_VK_MULTIPLY", JS::NumberValue(106U) },
  { "DOM_VK_ADD", JS::NumberValue(107U) },
  { "DOM_VK_SEPARATOR", JS::NumberValue(108U) },
  { "DOM_VK_SUBTRACT", JS::NumberValue(109U) },
  { "DOM_VK_DECIMAL", JS::NumberValue(110U) },
  { "DOM_VK_DIVIDE", JS::NumberValue(111U) },
  { "DOM_VK_F1", JS::NumberValue(112U) },
  { "DOM_VK_F2", JS::NumberValue(113U) },
  { "DOM_VK_F3", JS::NumberValue(114U) },
  { "DOM_VK_F4", JS::NumberValue(115U) },
  { "DOM_VK_F5", JS::NumberValue(116U) },
  { "DOM_VK_F6", JS::NumberValue(117U) },
  { "DOM_VK_F7", JS::NumberValue(118U) },
  { "DOM_VK_F8", JS::NumberValue(119U) },
  { "DOM_VK_F9", JS::NumberValue(120U) },
  { "DOM_VK_F10", JS::NumberValue(121U) },
  { "DOM_VK_F11", JS::NumberValue(122U) },
  { "DOM_VK_F12", JS::NumberValue(123U) },
  { "DOM_VK_F13", JS::NumberValue(124U) },
  { "DOM_VK_F14", JS::NumberValue(125U) },
  { "DOM_VK_F15", JS::NumberValue(126U) },
  { "DOM_VK_F16", JS::NumberValue(127U) },
  { "DOM_VK_F17", JS::NumberValue(128U) },
  { "DOM_VK_F18", JS::NumberValue(129U) },
  { "DOM_VK_F19", JS::NumberValue(130U) },
  { "DOM_VK_F20", JS::NumberValue(131U) },
  { "DOM_VK_F21", JS::NumberValue(132U) },
  { "DOM_VK_F22", JS::NumberValue(133U) },
  { "DOM_VK_F23", JS::NumberValue(134U) },
  { "DOM_VK_F24", JS::NumberValue(135U) },
  { "DOM_VK_NUM_LOCK", JS::NumberValue(144U) },
  { "DOM_VK_SCROLL_LOCK", JS::NumberValue(145U) },
  { "DOM_VK_WIN_OEM_FJ_JISHO", JS::NumberValue(146U) },
  { "DOM_VK_WIN_OEM_FJ_MASSHOU", JS::NumberValue(147U) },
  { "DOM_VK_WIN_OEM_FJ_TOUROKU", JS::NumberValue(148U) },
  { "DOM_VK_WIN_OEM_FJ_LOYA", JS::NumberValue(149U) },
  { "DOM_VK_WIN_OEM_FJ_ROYA", JS::NumberValue(150U) },
  { "DOM_VK_CIRCUMFLEX", JS::NumberValue(160U) },
  { "DOM_VK_EXCLAMATION", JS::NumberValue(161U) },
  { "DOM_VK_DOUBLE_QUOTE", JS::NumberValue(162U) },
  { "DOM_VK_HASH", JS::NumberValue(163U) },
  { "DOM_VK_DOLLAR", JS::NumberValue(164U) },
  { "DOM_VK_PERCENT", JS::NumberValue(165U) },
  { "DOM_VK_AMPERSAND", JS::NumberValue(166U) },
  { "DOM_VK_UNDERSCORE", JS::NumberValue(167U) },
  { "DOM_VK_OPEN_PAREN", JS::NumberValue(168U) },
  { "DOM_VK_CLOSE_PAREN", JS::NumberValue(169U) },
  { "DOM_VK_ASTERISK", JS::NumberValue(170U) },
  { "DOM_VK_PLUS", JS::NumberValue(171U) },
  { "DOM_VK_PIPE", JS::NumberValue(172U) },
  { "DOM_VK_HYPHEN_MINUS", JS::NumberValue(173U) },
  { "DOM_VK_OPEN_CURLY_BRACKET", JS::NumberValue(174U) },
  { "DOM_VK_CLOSE_CURLY_BRACKET", JS::NumberValue(175U) },
  { "DOM_VK_TILDE", JS::NumberValue(176U) },
  { "DOM_VK_VOLUME_MUTE", JS::NumberValue(181U) },
  { "DOM_VK_VOLUME_DOWN", JS::NumberValue(182U) },
  { "DOM_VK_VOLUME_UP", JS::NumberValue(183U) },
  { "DOM_VK_COMMA", JS::NumberValue(188U) },
  { "DOM_VK_PERIOD", JS::NumberValue(190U) },
  { "DOM_VK_SLASH", JS::NumberValue(191U) },
  { "DOM_VK_BACK_QUOTE", JS::NumberValue(192U) },
  { "DOM_VK_OPEN_BRACKET", JS::NumberValue(219U) },
  { "DOM_VK_BACK_SLASH", JS::NumberValue(220U) },
  { "DOM_VK_CLOSE_BRACKET", JS::NumberValue(221U) },
  { "DOM_VK_QUOTE", JS::NumberValue(222U) },
  { "DOM_VK_META", JS::NumberValue(224U) },
  { "DOM_VK_ALTGR", JS::NumberValue(225U) },
  { "DOM_VK_WIN_ICO_HELP", JS::NumberValue(227U) },
  { "DOM_VK_WIN_ICO_00", JS::NumberValue(228U) },
  { "DOM_VK_PROCESSKEY", JS::NumberValue(229U) },
  { "DOM_VK_WIN_ICO_CLEAR", JS::NumberValue(230U) },
  { "DOM_VK_WIN_OEM_RESET", JS::NumberValue(233U) },
  { "DOM_VK_WIN_OEM_JUMP", JS::NumberValue(234U) },
  { "DOM_VK_WIN_OEM_PA1", JS::NumberValue(235U) },
  { "DOM_VK_WIN_OEM_PA2", JS::NumberValue(236U) },
  { "DOM_VK_WIN_OEM_PA3", JS::NumberValue(237U) },
  { "DOM_VK_WIN_OEM_WSCTRL", JS::NumberValue(238U) },
  { "DOM_VK_WIN_OEM_CUSEL", JS::NumberValue(239U) },
  { "DOM_VK_WIN_OEM_ATTN", JS::NumberValue(240U) },
  { "DOM_VK_WIN_OEM_FINISH", JS::NumberValue(241U) },
  { "DOM_VK_WIN_OEM_COPY", JS::NumberValue(242U) },
  { "DOM_VK_WIN_OEM_AUTO", JS::NumberValue(243U) },
  { "DOM_VK_WIN_OEM_ENLW", JS::NumberValue(244U) },
  { "DOM_VK_WIN_OEM_BACKTAB", JS::NumberValue(245U) },
  { "DOM_VK_ATTN", JS::NumberValue(246U) },
  { "DOM_VK_CRSEL", JS::NumberValue(247U) },
  { "DOM_VK_EXSEL", JS::NumberValue(248U) },
  { "DOM_VK_EREOF", JS::NumberValue(249U) },
  { "DOM_VK_PLAY", JS::NumberValue(250U) },
  { "DOM_VK_ZOOM", JS::NumberValue(251U) },
  { "DOM_VK_PA1", JS::NumberValue(253U) },
  { "DOM_VK_WIN_OEM_CLEAR", JS::NumberValue(254U) },
  { 0, JS::UndefinedValue() }
};


static const Prefable<const ConstantSpec> sConstants[] = {
  { nullptr, &sConstants_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(190 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[205];
static PropertyInfo sNativeProperties_propertyInfos[205];

static const NativePropertiesN<4> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  true,  2 /* sUnforgeableAttributes */,
  true,  3 /* sConstants */,
  -1,
  205,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[3] },
    { sUnforgeableAttributes, &sNativeProperties_propertyInfos[14] },
    { sConstants, &sNativeProperties_propertyInfos[15] }
  }
};
static_assert(205 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[1];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[1];

static const NativePropertiesN<1> sChromeOnlyNativeProperties = {
  false, 0,
  false, 0,
  false, 0,
  true,  0 /* sChromeAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  1,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeAttributes, &sChromeOnlyNativeProperties_propertyInfos[0] }
  }
};
static_assert(1 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

// This may allocate too many slots, because we only really need
// slots for our non-interface-typed members that we cache.  But
// allocating slots only for those would make the slot index
// computations much more complicated, so let's do this the simple
// way for now.
DEFINE_XRAY_EXPANDO_CLASS_WITH_OPS(static, sXrayExpandoObjectClass, 1,
                                   &xpc::XrayExpandoObjectClassOps);

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::KeyboardEvent,
  constructors::id::KeyboardEvent,
  &sXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "KeyboardEvent constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "KeyboardEvent", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "KeyboardEvent");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::KeyboardEvent,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "KeyboardEvent constructor", 1)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  binding_detail::FastKeyboardEventInit arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  auto result(StrongOrRawPtr<mozilla::dom::KeyboardEvent>(mozilla::dom::KeyboardEvent::ConstructorJS(global, NonNullHelper(Constify(arg0)), Constify(arg1))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  UIEvent_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::KeyboardEvent>::Depth,
  prototypes::id::KeyboardEvent,
  true,
  1,
  "KeyboardEvent",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "KeyboardEventPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE + 1 /* slot for the JSObject holding the unforgeable properties */),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::KeyboardEvent,
  PrototypeTraits<prototypes::id::KeyboardEvent>::Depth,
  &sNativePropertyHooks,
  UIEvent_Binding::GetProtoObject
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<mozilla::dom::KeyboardEvent>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "KeyboardEvent",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(2) | JSCLASS_SKIP_NURSERY_FINALIZE,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::KeyboardEvent>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::Event, prototypes::id::UIEvent, prototypes::id::KeyboardEvent, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::KeyboardEvent>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::KeyboardEvent>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::KeyboardEvent>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::KeyboardEvent>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(2 >= 2,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::KeyboardEvent* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::KeyboardEvent>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::KeyboardEvent*>);
  MOZ_ASSERT(static_cast<mozilla::dom::UIEvent*>(aObject) ==
             reinterpret_cast<mozilla::dom::UIEvent*>(aObject),
             "Multiple inheritance for mozilla::dom::UIEvent is broken.");
  MOZ_ASSERT(static_cast<mozilla::dom::Event*>(aObject) ==
             reinterpret_cast<mozilla::dom::Event*>(aObject),
             "Multiple inheritance for mozilla::dom::Event is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::KeyboardEvent> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);

  // Important: do unforgeable property setup after we have handed
  // over ownership of the C++ object to obj as needed, so that if
  // we fail and it ends up GCed it won't have problems in the
  // finalizer trying to drop its ownership of the C++ object.
  JS::Rooted<JSObject*> unforgeableHolder(aCx,
    &JS::GetReservedSlot(canonicalProto, DOM_INTERFACE_PROTO_SLOTS_BASE).toObject());
  if (!JS_InitializePropertiesFromCompatibleNativeObject(aCx, aReflector, unforgeableHolder)) {
    aCache->ReleaseWrapper(aObject);
    aCache->ClearWrapper();
    return false;
  }
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::KeyboardEvent);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::KeyboardEvent);

  JS::Handle<JSObject*> parentProto(UIEvent_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(UIEvent_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 1, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              sChromeOnlyNativeProperties.Upcast(),
                              "KeyboardEvent",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);

  JS::AssertObjectIsNotGray(*protoCache);
  JS::Handle<JSObject*> proto = JS::Handle<JSObject*>::fromMarkedLocation(protoCache->unsafeAddress());
  if (!proto) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  JS::Rooted<JSObject*> unforgeableHolder(
      aCx, JS_NewObjectWithoutMetadata(aCx, sClass.ToJSClass(), proto));
  if (!unforgeableHolder) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (!DefineLegacyUnforgeableAttributes(aCx, unforgeableHolder, sUnforgeableAttributes)) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (*protoCache) {
    JS::SetReservedSlot(*protoCache, DOM_INTERFACE_PROTO_SLOTS_BASE,
                        JS::ObjectValue(*unforgeableHolder));
  }
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::KeyboardEvent,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::KeyboardEvent,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace KeyboardEvent_Binding



} // namespace mozilla::dom
