/* THIS FILE IS AUTOGENERATED FROM HTMLScriptElement.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "ElementBinding.h"
#include "HTMLElementBinding.h"
#include "HTMLScriptElementBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "XrayWrapper.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/BasePrincipal.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CustomElementRegistry.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DocGroup.h"
#include "mozilla/dom/HTMLScriptElement.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/TrustedScript.h"
#include "mozilla/dom/TrustedScriptURL.h"
#include "mozilla/dom/UnionTypes.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "nsDOMTokenList.h"
#include "nsJSPrincipals.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningTrustedScriptOrNullIsEmptyString& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsTrustedScript()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsTrustedScript(), "mTrustedScript", aFlags);
  }
}


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningTrustedScriptOrString& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsTrustedScript()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsTrustedScript(), "mTrustedScript", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningTrustedScriptOrNullIsEmptyString& aUnion)
{
  aUnion.Uninit();
}


void
ImplCycleCollectionUnlink(OwningTrustedScriptOrString& aUnion)
{
  aUnion.Uninit();
}


bool
TrustedScriptOrNullIsEmptyString::TrySetToTrustedScript(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::TrustedScript>& memberSlot = RawSetAsTrustedScript();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TrustedScript, mozilla::dom::TrustedScript>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyTrustedScript();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
TrustedScriptOrNullIsEmptyString::TrySetToTrustedScript(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToTrustedScript(cx, value, tryNext, passedToJSImpl);
}







bool
TrustedScriptOrNullIsEmptyString::TrySetToNullIsEmptyString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char16_t>& memberSlot = RawSetAsNullIsEmptyString();
    if (!ConvertJSValueToString(cx, value, eEmpty, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}








bool
TrustedScriptOrNullIsEmptyString::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToTrustedScript(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToNullIsEmptyString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "TrustedScript");
    return false;
  }
  return true;
}

bool
TrustedScriptOrNullIsEmptyString::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
TrustedScriptOrNullIsEmptyString::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eTrustedScript: {
      if (!WrapNewBindingNonWrapperCachedObject(cx, scopeObj, mValue.mTrustedScript.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eNullIsEmptyString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mNullIsEmptyString.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningTrustedScriptOrNullIsEmptyString::OwningTrustedScriptOrNullIsEmptyString(OwningTrustedScriptOrNullIsEmptyString&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eTrustedScript: {
      mType = eTrustedScript;
      mValue.mTrustedScript.SetValue(std::move(aOther.mValue.mTrustedScript.Value()));
      break;
    }
    case eNullIsEmptyString: {
      mType = eNullIsEmptyString;
      mValue.mNullIsEmptyString.SetValue(std::move(aOther.mValue.mNullIsEmptyString.Value()));
      break;
    }
  }
}



bool
OwningTrustedScriptOrNullIsEmptyString::TrySetToTrustedScript(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::TrustedScript>& memberSlot = RawSetAsTrustedScript();
    static_assert(IsRefcounted<mozilla::dom::TrustedScript>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TrustedScript, mozilla::dom::TrustedScript>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyTrustedScript();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningTrustedScriptOrNullIsEmptyString::TrySetToTrustedScript(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToTrustedScript(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::TrustedScript>&
OwningTrustedScriptOrNullIsEmptyString::RawSetAsTrustedScript()
{
  if (mType == eTrustedScript) {
    return mValue.mTrustedScript.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eTrustedScript;
  return mValue.mTrustedScript.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::TrustedScript>&
OwningTrustedScriptOrNullIsEmptyString::SetAsTrustedScript()
{
  if (mType == eTrustedScript) {
    return mValue.mTrustedScript.Value();
  }
  Uninit();
  mType = eTrustedScript;
  return mValue.mTrustedScript.SetValue();
}


void
OwningTrustedScriptOrNullIsEmptyString::DestroyTrustedScript()
{
  MOZ_RELEASE_ASSERT(IsTrustedScript(), "Wrong type!");
  mValue.mTrustedScript.Destroy();
  mType = eUninitialized;
}



bool
OwningTrustedScriptOrNullIsEmptyString::TrySetToNullIsEmptyString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsString& memberSlot = RawSetAsNullIsEmptyString();
    if (!ConvertJSValueToString(cx, value, eEmpty, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsString&
OwningTrustedScriptOrNullIsEmptyString::RawSetAsNullIsEmptyString()
{
  if (mType == eNullIsEmptyString) {
    return mValue.mNullIsEmptyString.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eNullIsEmptyString;
  return mValue.mNullIsEmptyString.SetValue();
}

[[nodiscard]] nsString&
OwningTrustedScriptOrNullIsEmptyString::SetAsNullIsEmptyString()
{
  if (mType == eNullIsEmptyString) {
    return mValue.mNullIsEmptyString.Value();
  }
  Uninit();
  mType = eNullIsEmptyString;
  return mValue.mNullIsEmptyString.SetValue();
}



void
OwningTrustedScriptOrNullIsEmptyString::DestroyNullIsEmptyString()
{
  MOZ_RELEASE_ASSERT(IsNullIsEmptyString(), "Wrong type!");
  mValue.mNullIsEmptyString.Destroy();
  mType = eUninitialized;
}



bool
OwningTrustedScriptOrNullIsEmptyString::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToTrustedScript(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToNullIsEmptyString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "TrustedScript");
    return false;
  }
  return true;
}

bool
OwningTrustedScriptOrNullIsEmptyString::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningTrustedScriptOrNullIsEmptyString::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eTrustedScript: {
      DestroyTrustedScript();
      break;
    }
    case eNullIsEmptyString: {
      DestroyNullIsEmptyString();
      break;
    }
  }
}

bool
OwningTrustedScriptOrNullIsEmptyString::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eTrustedScript: {
      if (!WrapNewBindingNonWrapperCachedObject(cx, scopeObj, mValue.mTrustedScript.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eNullIsEmptyString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mNullIsEmptyString.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningTrustedScriptOrNullIsEmptyString&
OwningTrustedScriptOrNullIsEmptyString::operator=(OwningTrustedScriptOrNullIsEmptyString&& aOther)
{
  this->~OwningTrustedScriptOrNullIsEmptyString();
  new (this) OwningTrustedScriptOrNullIsEmptyString (std::move(aOther));
  return *this;
}


OwningTrustedScriptOrNullIsEmptyString&
OwningTrustedScriptOrNullIsEmptyString::operator=(const OwningTrustedScriptOrNullIsEmptyString& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eTrustedScript: {
      SetAsTrustedScript() = aOther.GetAsTrustedScript();
      break;
    }
    case eNullIsEmptyString: {
      SetAsNullIsEmptyString() = aOther.GetAsNullIsEmptyString();
      break;
    }
  }
  return *this;
}


bool
TrustedScriptOrString::TrySetToTrustedScript(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::TrustedScript>& memberSlot = RawSetAsTrustedScript();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TrustedScript, mozilla::dom::TrustedScript>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyTrustedScript();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
TrustedScriptOrString::TrySetToTrustedScript(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToTrustedScript(cx, value, tryNext, passedToJSImpl);
}







bool
TrustedScriptOrString::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char16_t>& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}








bool
TrustedScriptOrString::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToTrustedScript(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "TrustedScript");
    return false;
  }
  return true;
}

bool
TrustedScriptOrString::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
TrustedScriptOrString::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eTrustedScript: {
      if (!WrapNewBindingNonWrapperCachedObject(cx, scopeObj, mValue.mTrustedScript.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningTrustedScriptOrString::OwningTrustedScriptOrString(OwningTrustedScriptOrString&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eTrustedScript: {
      mType = eTrustedScript;
      mValue.mTrustedScript.SetValue(std::move(aOther.mValue.mTrustedScript.Value()));
      break;
    }
    case eString: {
      mType = eString;
      mValue.mString.SetValue(std::move(aOther.mValue.mString.Value()));
      break;
    }
  }
}



bool
OwningTrustedScriptOrString::TrySetToTrustedScript(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::TrustedScript>& memberSlot = RawSetAsTrustedScript();
    static_assert(IsRefcounted<mozilla::dom::TrustedScript>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TrustedScript, mozilla::dom::TrustedScript>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyTrustedScript();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningTrustedScriptOrString::TrySetToTrustedScript(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToTrustedScript(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::TrustedScript>&
OwningTrustedScriptOrString::RawSetAsTrustedScript()
{
  if (mType == eTrustedScript) {
    return mValue.mTrustedScript.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eTrustedScript;
  return mValue.mTrustedScript.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::TrustedScript>&
OwningTrustedScriptOrString::SetAsTrustedScript()
{
  if (mType == eTrustedScript) {
    return mValue.mTrustedScript.Value();
  }
  Uninit();
  mType = eTrustedScript;
  return mValue.mTrustedScript.SetValue();
}


void
OwningTrustedScriptOrString::DestroyTrustedScript()
{
  MOZ_RELEASE_ASSERT(IsTrustedScript(), "Wrong type!");
  mValue.mTrustedScript.Destroy();
  mType = eUninitialized;
}



bool
OwningTrustedScriptOrString::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsString& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsString&
OwningTrustedScriptOrString::RawSetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eString;
  return mValue.mString.SetValue();
}

[[nodiscard]] nsString&
OwningTrustedScriptOrString::SetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  Uninit();
  mType = eString;
  return mValue.mString.SetValue();
}



void
OwningTrustedScriptOrString::DestroyString()
{
  MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
  mValue.mString.Destroy();
  mType = eUninitialized;
}



bool
OwningTrustedScriptOrString::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToTrustedScript(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "TrustedScript");
    return false;
  }
  return true;
}

bool
OwningTrustedScriptOrString::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningTrustedScriptOrString::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eTrustedScript: {
      DestroyTrustedScript();
      break;
    }
    case eString: {
      DestroyString();
      break;
    }
  }
}

bool
OwningTrustedScriptOrString::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eTrustedScript: {
      if (!WrapNewBindingNonWrapperCachedObject(cx, scopeObj, mValue.mTrustedScript.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningTrustedScriptOrString&
OwningTrustedScriptOrString::operator=(OwningTrustedScriptOrString&& aOther)
{
  this->~OwningTrustedScriptOrString();
  new (this) OwningTrustedScriptOrString (std::move(aOther));
  return *this;
}


OwningTrustedScriptOrString&
OwningTrustedScriptOrString::operator=(const OwningTrustedScriptOrString& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eTrustedScript: {
      SetAsTrustedScript() = aOther.GetAsTrustedScript();
      break;
    }
    case eString: {
      SetAsString() = aOther.GetAsString();
      break;
    }
  }
  return *this;
}


namespace HTMLScriptElement_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<HTMLElement_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_src(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "src", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  OwningTrustedScriptURLOrString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetSrc(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetSrc(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_src(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "HTMLScriptElement.src setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "src", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  TrustedScriptURLOrString arg0;
  if (!arg0.Init(cx, args[0], "Value being assigned", false)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  nsIPrincipal* subjectPrincipal;
  {
    JS::Realm* realm = js::GetContextRealm(cx);
    MOZ_ASSERT(realm);
    JSPrincipals* principals = JS::GetRealmPrincipals(realm);
    nsIPrincipal* principal = nsJSPrincipals::get(principals);
    if (principal->IsSystemPrincipal()) {
    principal = nullptr;
  }

    subjectPrincipal = principal;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetSrc(Constify(arg0), MOZ_KnownLive(subjectPrincipal), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetSrc(Constify(arg0), MOZ_KnownLive(subjectPrincipal), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.src setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo src_getterinfo = {
  { get_src },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo src_setterinfo = {
  { (JSJitGetterOp)set_src },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_type(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "type", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetType(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetType(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_type(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "type", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetType(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetType(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.type setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo type_getterinfo = {
  { get_type },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo type_setterinfo = {
  { (JSJitGetterOp)set_type },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_noModule(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "noModule", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  bool result(MOZ_KnownLive(self)->NoModule());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_noModule(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "noModule", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  bool arg0;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetNoModule(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetNoModule(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.noModule setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo noModule_getterinfo = {
  { get_noModule },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo noModule_setterinfo = {
  { (JSJitGetterOp)set_noModule },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_charset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "charset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetCharset(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetCharset(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_charset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "charset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetCharset(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetCharset(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.charset setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo charset_getterinfo = {
  { get_charset },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo charset_setterinfo = {
  { (JSJitGetterOp)set_charset },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_async(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "async", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  bool result(MOZ_KnownLive(self)->Async());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_async(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "async", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  bool arg0;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetAsync(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetAsync(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.async setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo async_getterinfo = {
  { get_async },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo async_setterinfo = {
  { (JSJitGetterOp)set_async },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_defer(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "defer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  bool result(MOZ_KnownLive(self)->Defer());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_defer(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "defer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  bool arg0;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetDefer(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetDefer(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.defer setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo defer_getterinfo = {
  { get_defer },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo defer_setterinfo = {
  { (JSJitGetterOp)set_defer },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_crossOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "crossOrigin", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetCrossOrigin(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetCrossOrigin(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_crossOrigin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "crossOrigin", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eNull, eNull, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetCrossOrigin(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetCrossOrigin(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.crossOrigin setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo crossOrigin_getterinfo = {
  { get_crossOrigin },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo crossOrigin_setterinfo = {
  { (JSJitGetterOp)set_crossOrigin },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_referrerPolicy(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "referrerPolicy", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetReferrerPolicy(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetReferrerPolicy(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_referrerPolicy(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "referrerPolicy", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetReferrerPolicy(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetReferrerPolicy(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.referrerPolicy setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo referrerPolicy_getterinfo = {
  { get_referrerPolicy },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo referrerPolicy_setterinfo = {
  { (JSJitGetterOp)set_referrerPolicy },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_text(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "text", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  FastErrorResult rv;
  OwningTrustedScriptOrString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetText(result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetText(result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.text getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_text(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "HTMLScriptElement.text setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "text", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  TrustedScriptOrString arg0;
  if (!arg0.Init(cx, args[0], "Value being assigned", false)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetText(Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetText(Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.text setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo text_getterinfo = {
  { get_text },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo text_setterinfo = {
  { (JSJitGetterOp)set_text },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_blocking(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "blocking", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  auto result(StrongOrRawPtr<nsDOMTokenList>(MOZ_KnownLive(self)->Blocking()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_blocking(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "HTMLScriptElement.blocking setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "blocking", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::Rooted<JS::Value> v(cx);
  if (!JS_GetProperty(cx, obj, "blocking", &v)) {
    return false;
  }

  if (!v.isObject()) {
    return cx.ThrowErrorMessage<MSG_NOT_OBJECT>("HTMLScriptElement.blocking");
  }

  JS::Rooted<JSObject*> targetObj(cx, &v.toObject());
  return JS_SetProperty(cx, targetObj, "value", args[0]);
}

static const JSJitInfo blocking_getterinfo = {
  { get_blocking },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo blocking_setterinfo = {
  { (JSJitGetterOp)set_blocking },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fetchPriority(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "fetchPriority", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetFetchPriority(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetFetchPriority(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_fetchPriority(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "fetchPriority", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetFetchPriority(NonNullHelper(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetFetchPriority(NonNullHelper(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo fetchPriority_getterinfo = {
  { get_fetchPriority },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fetchPriority_setterinfo = {
  { (JSJitGetterOp)set_fetchPriority },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
supports(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "supports", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "HTMLScriptElement.supports", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  bool result(mozilla::dom::HTMLScriptElement::Supports(global, NonNullHelper(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
get_event(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "event", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetEvent(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetEvent(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_event(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "event", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetEvent(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetEvent(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.event setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo event_getterinfo = {
  { get_event },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo event_setterinfo = {
  { (JSJitGetterOp)set_event },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_htmlFor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "htmlFor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetHtmlFor(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetHtmlFor(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_htmlFor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "htmlFor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetHtmlFor(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetHtmlFor(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.htmlFor setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo htmlFor_getterinfo = {
  { get_htmlFor },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo htmlFor_setterinfo = {
  { (JSJitGetterOp)set_htmlFor },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_integrity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "integrity", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetIntegrity(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetIntegrity(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_integrity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "integrity", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetIntegrity(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetIntegrity(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.integrity setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo integrity_getterinfo = {
  { get_integrity },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo integrity_setterinfo = {
  { (JSJitGetterOp)set_integrity },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_innerText(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "innerText", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  FastErrorResult rv;
  OwningTrustedScriptOrNullIsEmptyString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetInnerText(result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetInnerText(result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.innerText getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_innerText(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "HTMLScriptElement.innerText setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "innerText", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  TrustedScriptOrNullIsEmptyString arg0;
  if (!arg0.Init(cx, args[0], "Value being assigned", false)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetInnerText(Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetInnerText(Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.innerText setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo innerText_getterinfo = {
  { get_innerText },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo innerText_setterinfo = {
  { (JSJitGetterOp)set_innerText },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textContent(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "textContent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  FastErrorResult rv;
  Nullable<OwningTrustedScriptOrString> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetTrustedScriptOrStringTextContent(result, OOMReporter::From(rv)))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetTrustedScriptOrStringTextContent(result, OOMReporter::From(rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.textContent getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_textContent(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "HTMLScriptElement.textContent setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "textContent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLScriptElement*>(void_self);
  Nullable<TrustedScriptOrString > arg0;
  if (args[0].isNullOrUndefined()) {
    arg0.SetNull();
  } else {
    if (!arg0.SetValue().Init(cx, args[0], "Value being assigned", false)) {
      return false;
    }
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  nsIPrincipal* subjectPrincipal;
  {
    JS::Realm* realm = js::GetContextRealm(cx);
    MOZ_ASSERT(realm);
    JSPrincipals* principals = JS::GetRealmPrincipals(realm);
    nsIPrincipal* principal = nsJSPrincipals::get(principals);
    if (principal->IsSystemPrincipal()) {
    principal = nullptr;
  }

    subjectPrincipal = principal;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetTrustedScriptOrStringTextContent(Constify(arg0), MOZ_KnownLive(subjectPrincipal), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetTrustedScriptOrStringTextContent(Constify(arg0), MOZ_KnownLive(subjectPrincipal), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLScriptElement.textContent setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo textContent_getterinfo = {
  { get_textContent },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textContent_setterinfo = {
  { (JSJitGetterOp)set_textContent },
  { prototypes::id::HTMLScriptElement },
  { PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::HTMLScriptElement* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::HTMLScriptElement>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    Element_Binding::ReflectedHTMLAttributeSlots::Finalize(obj);
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::HTMLScriptElement>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sStaticMethods_specs[] = {
  JS_FNSPEC("supports", supports, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sStaticMethods[] = {
  { nullptr, &sStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("src", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &src_getterinfo, GenericSetter<NormalThisPolicy>, &src_setterinfo),
  JSPropertySpec::nativeAccessors("type", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &type_getterinfo, GenericSetter<NormalThisPolicy>, &type_setterinfo),
  JSPropertySpec::nativeAccessors("noModule", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &noModule_getterinfo, GenericSetter<NormalThisPolicy>, &noModule_setterinfo),
  JSPropertySpec::nativeAccessors("charset", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &charset_getterinfo, GenericSetter<NormalThisPolicy>, &charset_setterinfo),
  JSPropertySpec::nativeAccessors("async", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &async_getterinfo, GenericSetter<NormalThisPolicy>, &async_setterinfo),
  JSPropertySpec::nativeAccessors("defer", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &defer_getterinfo, GenericSetter<NormalThisPolicy>, &defer_setterinfo),
  JSPropertySpec::nativeAccessors("crossOrigin", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &crossOrigin_getterinfo, GenericSetter<NormalThisPolicy>, &crossOrigin_setterinfo),
  JSPropertySpec::nativeAccessors("referrerPolicy", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &referrerPolicy_getterinfo, GenericSetter<NormalThisPolicy>, &referrerPolicy_setterinfo),
  JSPropertySpec::nativeAccessors("text", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &text_getterinfo, GenericSetter<NormalThisPolicy>, &text_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("blocking", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &blocking_getterinfo, GenericSetter<NormalThisPolicy>, &blocking_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("fetchPriority", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &fetchPriority_getterinfo, GenericSetter<NormalThisPolicy>, &fetchPriority_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("event", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &event_getterinfo, GenericSetter<NormalThisPolicy>, &event_setterinfo),
  JSPropertySpec::nativeAccessors("htmlFor", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &htmlFor_getterinfo, GenericSetter<NormalThisPolicy>, &htmlFor_setterinfo),
  JSPropertySpec::nativeAccessors("integrity", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &integrity_getterinfo, GenericSetter<NormalThisPolicy>, &integrity_setterinfo),
  JSPropertySpec::nativeAccessors("innerText", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &innerText_getterinfo, GenericSetter<NormalThisPolicy>, &innerText_setterinfo),
  JSPropertySpec::nativeAccessors("textContent", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &textContent_getterinfo, GenericSetter<NormalThisPolicy>, &textContent_setterinfo),
  JS_PS_END
};

static const PrefableDisablers sAttributes_disablers10 = {
  WebIDLPrefIndex::dom_element_blocking_enabled, 0, false, OriginTrial(0), nullptr
};

static const PrefableDisablers sAttributes_disablers12 = {
  WebIDLPrefIndex::network_fetchpriority_enabled, 0, false, OriginTrial(0), nullptr
};

static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { &sAttributes_disablers10, &sAttributes_specs[10] },
  { &sAttributes_disablers12, &sAttributes_specs[12] },
  { nullptr, &sAttributes_specs[14] },
  { nullptr, nullptr }
};

static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(9 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[17];
static PropertyInfo sNativeProperties_propertyInfos[17];

static const NativePropertiesN<2> sNativeProperties = {
  true,  0 /* sStaticMethods */,
  false, 0,
  false, 0,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  17,
  sNativeProperties_sortedPropertyIndices,
  {
    { sStaticMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[1] }
  }
};
static_assert(17 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

// This may allocate too many slots, because we only really need
// slots for our non-interface-typed members that we cache.  But
// allocating slots only for those would make the slot index
// computations much more complicated, so let's do this the simple
// way for now.
DEFINE_XRAY_EXPANDO_CLASS_WITH_OPS(static, sXrayExpandoObjectClass, 1,
                                   &Element_Binding::ReflectedHTMLAttributeSlots::sXrayExpandoObjectClassOps);

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::HTMLScriptElement,
  constructors::id::HTMLScriptElement,
  &sXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLScriptElement", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return HTMLConstructor(cx, argc, vp,
                         constructors::id::HTMLScriptElement,
                         prototypes::id::HTMLScriptElement,
                         CreateInterfaceObjects);
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  HTMLElement_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth,
  prototypes::id::HTMLScriptElement,
  true,
  0,
  "HTMLScriptElement",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "HTMLScriptElementPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::HTMLScriptElement,
  PrototypeTraits<prototypes::id::HTMLScriptElement>::Depth,
  &sNativePropertyHooks,
  HTMLElement_Binding::GetProtoObject
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<mozilla::dom::HTMLScriptElement>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  Element_Binding::ReflectedHTMLAttributeSlots::Trace, /* trace */
};

static const DOMJSClass sClass = {
  { "HTMLScriptElement",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(2),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::HTMLScriptElement>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::EventTarget, prototypes::id::Node, prototypes::id::Element, prototypes::id::HTMLElement, prototypes::id::HTMLScriptElement, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::HTMLScriptElement>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::HTMLScriptElement>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::HTMLScriptElement>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::HTMLScriptElement>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(2 >= 2,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::HTMLScriptElement* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::HTMLScriptElement>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::HTMLScriptElement*>);
  MOZ_ASSERT(static_cast<nsGenericHTMLElement*>(aObject) ==
             reinterpret_cast<nsGenericHTMLElement*>(aObject),
             "Multiple inheritance for nsGenericHTMLElement is broken.");
  MOZ_ASSERT(static_cast<mozilla::dom::Element*>(aObject) ==
             reinterpret_cast<mozilla::dom::Element*>(aObject),
             "Multiple inheritance for mozilla::dom::Element is broken.");
  MOZ_ASSERT(static_cast<nsINode*>(aObject) ==
             reinterpret_cast<nsINode*>(aObject),
             "Multiple inheritance for nsINode is broken.");
  MOZ_ASSERT(static_cast<mozilla::dom::EventTarget*>(aObject) ==
             reinterpret_cast<mozilla::dom::EventTarget*>(aObject),
             "Multiple inheritance for mozilla::dom::EventTarget is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::HTMLScriptElement> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::HTMLScriptElement);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::HTMLScriptElement);

  JS::Handle<JSObject*> parentProto(HTMLElement_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(HTMLElement_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "HTMLScriptElement",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::HTMLScriptElement,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLScriptElement,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace HTMLScriptElement_Binding



} // namespace mozilla::dom
