/* THIS FILE IS AUTOGENERATED FROM FrameLoader.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "FrameLoaderBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/BrowsingContext.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/Element.h"
#include "mozilla/dom/MessageSender.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "nsFrameLoader.h"
#include "nsIDocShell.h"
#include "nsILoadContext.h"
#include "nsIPrintSettings.h"
#include "nsIRemoteTab.h"
#include "nsIWebBrowserPersistDocument.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<PrintPreviewOrientation>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, PrintPreviewOrientation aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<PrintPreviewOrientation>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<PrintPreviewOrientation>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<PrintPreviewOrientation>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}



PrintPreviewSuccessInfo::PrintPreviewSuccessInfo()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
PrintPreviewSuccessInfo::InitIds(JSContext* cx, PrintPreviewSuccessInfoAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->totalPageCount_id.init(cx, "totalPageCount") ||
      !atomsCache->sheetCount_id.init(cx, "sheetCount") ||
      !atomsCache->pageWidth_id.init(cx, "pageWidth") ||
      !atomsCache->pageHeight_id.init(cx, "pageHeight") ||
      !atomsCache->orientation_id.init(cx, "orientation") ||
      !atomsCache->isEmpty_id.init(cx, "isEmpty") ||
      !atomsCache->hasSelfSelection_id.init(cx, "hasSelfSelection") ||
      !atomsCache->hasSelection_id.init(cx, "hasSelection")) {
    return false;
  }
  return true;
}

bool
PrintPreviewSuccessInfo::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mHasSelection = false;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mHasSelfSelection = false;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mIsEmpty = false;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mOrientation = PrintPreviewOrientation::Unspecified;
  }
  mIsAnyMemberPresent = true;

  mPageHeight.SetNull();
  mIsAnyMemberPresent = true;

  mPageWidth.SetNull();
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mSheetCount = 0U;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mTotalPageCount = 0U;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
PrintPreviewSuccessInfo::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  PrintPreviewSuccessInfoAtoms* atomsCache = GetAtomCache<PrintPreviewSuccessInfoAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mHasSelection;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->hasSelection_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mHasSelfSelection;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->hasSelfSelection_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mIsEmpty;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->isEmpty_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    PrintPreviewOrientation const & currentValue = mOrientation;
    if (!ToJSValue(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->orientation_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Nullable<float> const & currentValue = mPageHeight;
    if (currentValue.IsNull()) {
      temp.setNull();
      if (!JS_DefinePropertyById(cx, obj, atomsCache->pageHeight_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    }
    temp.set(JS_NumberValue(double(currentValue.Value())));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->pageHeight_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Nullable<float> const & currentValue = mPageWidth;
    if (currentValue.IsNull()) {
      temp.setNull();
      if (!JS_DefinePropertyById(cx, obj, atomsCache->pageWidth_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    }
    temp.set(JS_NumberValue(double(currentValue.Value())));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->pageWidth_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mSheetCount;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->sheetCount_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mTotalPageCount;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->totalPageCount_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
PrintPreviewSuccessInfo::TraceDictionary(JSTracer* trc)
{
}

PrintPreviewSuccessInfo&
PrintPreviewSuccessInfo::operator=(const PrintPreviewSuccessInfo& aOther)
{
  DictionaryBase::operator=(aOther);
  mHasSelection = aOther.mHasSelection;
  mHasSelfSelection = aOther.mHasSelfSelection;
  mIsEmpty = aOther.mIsEmpty;
  mOrientation = aOther.mOrientation;
  mPageHeight = aOther.mPageHeight;
  mPageWidth = aOther.mPageWidth;
  mSheetCount = aOther.mSheetCount;
  mTotalPageCount = aOther.mTotalPageCount;
  return *this;
}


namespace FrameLoader_Binding {

MOZ_CAN_RUN_SCRIPT static bool
get_docShell(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "docShell", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<nsIDocShell>(MOZ_KnownLive(self)->GetDocShell(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "FrameLoader.docShell getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result, &NS_GET_IID(nsIDocShell), args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo docShell_getterinfo = {
  { get_docShell },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_remoteTab(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "remoteTab", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  auto result(StrongOrRawPtr<nsIRemoteTab>(MOZ_KnownLive(self)->GetRemoteTab()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result, &NS_GET_IID(nsIRemoteTab), args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo remoteTab_getterinfo = {
  { get_remoteTab },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_loadContext(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "loadContext", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  auto result(StrongOrRawPtr<nsILoadContext>(MOZ_KnownLive(self)->GetLoadContext()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result, &NS_GET_IID(nsILoadContext), args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo loadContext_getterinfo = {
  { get_loadContext },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_browsingContext(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "browsingContext", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::BrowsingContext>(MOZ_KnownLive(self)->GetBrowsingContext()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo browsingContext_getterinfo = {
  { get_browsingContext },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_depthTooGreat(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "depthTooGreat", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  bool result(MOZ_KnownLive(self)->DepthTooGreat());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo depthTooGreat_getterinfo = {
  { get_depthTooGreat },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isRemoteFrame(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "isRemoteFrame", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  bool result(MOZ_KnownLive(self)->IsRemoteFrame());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isRemoteFrame_getterinfo = {
  { get_isRemoteFrame },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_messageManager(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "messageManager", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::MessageSender>(MOZ_KnownLive(self)->GetMessageManager()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo messageManager_getterinfo = {
  { get_messageManager },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
requestUpdatePosition(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "requestUpdatePosition", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->RequestUpdatePosition(rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->RequestUpdatePosition(rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "FrameLoader.requestUpdatePosition"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo requestUpdatePosition_methodinfo = {
  { (JSJitGetterOp)requestUpdatePosition },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
requestTabStateFlush(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "requestTabStateFlush", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->RequestTabStateFlush(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "FrameLoader.requestTabStateFlush"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
requestTabStateFlush_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = requestTabStateFlush(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo requestTabStateFlush_methodinfo = {
  { (JSJitGetterOp)requestTabStateFlush_promiseWrapper },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
requestEpochUpdate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "requestEpochUpdate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  if (!args.requireAtLeast(cx, "FrameLoader.requestEpochUpdate", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->RequestEpochUpdate(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->RequestEpochUpdate(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo requestEpochUpdate_methodinfo = {
  { (JSJitGetterOp)requestEpochUpdate },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
requestSHistoryUpdate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "requestSHistoryUpdate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->RequestSHistoryUpdate())>, "Should be returning void here");
  MOZ_KnownLive(self)->RequestSHistoryUpdate();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo requestSHistoryUpdate_methodinfo = {
  { (JSJitGetterOp)requestSHistoryUpdate },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
printPreview(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "FrameLoader.printPreview");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "printPreview", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  if (!args.requireAtLeast(cx, "FrameLoader.printPreview", 2)) {
    return false;
  }
  nsIPrintSettings* arg0;
  RefPtr<nsIPrintSettings> arg0_holder;
  if (args[0].isObject()) {
    JS::Rooted<JSObject*> source(cx, &args[0].toObject());
    if (NS_FAILED(UnwrapArg<nsIPrintSettings>(cx, source, getter_AddRefs(arg0_holder)))) {
      cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "nsIPrintSettings");
      return false;
    }
    MOZ_ASSERT(arg0_holder);
    arg0 = arg0_holder;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  mozilla::dom::BrowsingContext* arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::BrowsingContext, mozilla::dom::BrowsingContext>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "BrowsingContext");
        return false;
      }
    }
  } else if (args[1].isNullOrUndefined()) {
    arg1 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->PrintPreview(MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(Constify(arg1)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "FrameLoader.printPreview"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
printPreview_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = printPreview(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo printPreview_methodinfo = {
  { (JSJitGetterOp)printPreview_promiseWrapper },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
exitPrintPreview(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "exitPrintPreview", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ExitPrintPreview())>, "Should be returning void here");
  MOZ_KnownLive(self)->ExitPrintPreview();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo exitPrintPreview_methodinfo = {
  { (JSJitGetterOp)exitPrintPreview },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ownerElement(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "ownerElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->GetOwnerElement()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo ownerElement_getterinfo = {
  { get_ownerElement },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_childID(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "childID", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  uint64_t result(MOZ_KnownLive(self)->ChildID());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

static const JSJitInfo childID_getterinfo = {
  { get_childID },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_lazyWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "lazyWidth", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->LazyWidth());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo lazyWidth_getterinfo = {
  { get_lazyWidth },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_lazyHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "lazyHeight", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->LazyHeight());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo lazyHeight_getterinfo = {
  { get_lazyHeight },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isDead(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "isDead", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  bool result(MOZ_KnownLive(self)->IsDead());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isDead_getterinfo = {
  { get_isDead },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
startPersistence(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "FrameLoader.startPersistence");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FrameLoader", "startPersistence", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<nsFrameLoader*>(void_self);
  if (!args.requireAtLeast(cx, "FrameLoader.startPersistence", 2)) {
    return false;
  }
  mozilla::dom::BrowsingContext* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::BrowsingContext, mozilla::dom::BrowsingContext>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "BrowsingContext");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  nsIWebBrowserPersistDocumentReceiver* arg1;
  RefPtr<nsIWebBrowserPersistDocumentReceiver> arg1_holder;
  if (args[1].isObject()) {
    JS::Rooted<JSObject*> source(cx, &args[1].toObject());
    if (NS_FAILED(UnwrapArg<nsIWebBrowserPersistDocumentReceiver>(cx, source, getter_AddRefs(arg1_holder)))) {
      cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "nsIWebBrowserPersistDocumentReceiver");
      return false;
    }
    MOZ_ASSERT(arg1_holder);
    arg1 = arg1_holder;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->StartPersistence(MOZ_KnownLive(Constify(arg0)), MOZ_KnownLive(NonNullHelper(arg1)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->StartPersistence(MOZ_KnownLive(Constify(arg0)), MOZ_KnownLive(NonNullHelper(arg1)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "FrameLoader.startPersistence"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo startPersistence_methodinfo = {
  { (JSJitGetterOp)startPersistence },
  { prototypes::id::FrameLoader },
  { PrototypeTraits<prototypes::id::FrameLoader>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  nsFrameLoader* self = UnwrapPossiblyNotInitializedDOMObject<nsFrameLoader>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<nsFrameLoader>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("requestUpdatePosition", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&requestUpdatePosition_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("requestTabStateFlush", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&requestTabStateFlush_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("requestEpochUpdate", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&requestEpochUpdate_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("requestSHistoryUpdate", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&requestSHistoryUpdate_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("printPreview", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&printPreview_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("exitPrintPreview", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&exitPrintPreview_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("startPersistence", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&startPersistence_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(7 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("docShell", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &docShell_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("remoteTab", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &remoteTab_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("loadContext", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &loadContext_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("browsingContext", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &browsingContext_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("depthTooGreat", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &depthTooGreat_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("isRemoteFrame", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &isRemoteFrame_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("messageManager", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &messageManager_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("ownerElement", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &ownerElement_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("childID", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &childID_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("lazyWidth", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &lazyWidth_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("lazyHeight", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &lazyHeight_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("isDead", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &isDead_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(12 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[19];
static PropertyInfo sNativeProperties_propertyInfos[19];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  19,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[7] }
  }
};
static_assert(19 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::FrameLoader,
  constructors::id::FrameLoader,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::FrameLoader>::Depth,
  prototypes::id::FrameLoader,
  true,
  0,
  "FrameLoader",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "FrameLoaderPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::FrameLoader,
  PrototypeTraits<prototypes::id::FrameLoader>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return nsContentUtils::ThreadsafeIsSystemCaller(aCx);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<nsFrameLoader>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "FrameLoader",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<nsFrameLoader>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::FrameLoader, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, nsFrameLoader>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<nsFrameLoader>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<nsFrameLoader>::Get(),
  nullptr,
  NativeTypeHelpers<nsFrameLoader>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, nsFrameLoader* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, nsFrameLoader>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), nsFrameLoader*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<nsFrameLoader> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::FrameLoader);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::FrameLoader);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "FrameLoader",
                              ShouldExpose<FrameLoader_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::FrameLoader,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::FrameLoader,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace FrameLoader_Binding



} // namespace dom


} // namespace mozilla
