/* THIS FILE IS AUTOGENERATED FROM ExtensionTest.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "ExtensionTestBinding.h"
#include "FunctionBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/extensions/ExtensionEventManager.h"
#include "mozilla/extensions/ExtensionTest.h"
#include "nsThreadUtils.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace ExtensionTest_Binding {

MOZ_CAN_RUN_SCRIPT static bool
withHandlingUserInput(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ExtensionTest.withHandlingUserInput");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "withHandlingUserInput", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  if (!args.requireAtLeast(cx, "ExtensionTest.withHandlingUserInput", 1)) {
    return false;
  }
  RootedCallback<OwningNonNull<binding_detail::FastFunction>> arg0(cx);
  if (args[0].isObject()) {
    if (JS::IsCallable(&args[0].toObject())) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastFunction(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
      return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // Collecting all args js values into the single sequence argument
  // passed to the webextensions stub method.
  //
  // NOTE: The stub method will receive the original non-normalized js values,
  // but those arguments will still be normalized on the main thread by the
  // WebExtensions API request handler using the same JSONSchema defnition
  // used by the non-webIDL webextensions API bindings.
  AutoSequence<JS::Value> args_sequence;
  SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

  // maximum number of arguments expected by the WebExtensions API method
  // excluding the last optional chrome-compatible callback argument (which
  // is being passed to the stub method as a separate additional argument).
  uint32_t maxArgsSequenceLen = 1;

  uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
    args.length() : maxArgsSequenceLen;

  if (sequenceArgsLen > 0) {
    if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *args_sequence.AppendElement();
      slot = args[argIdx];
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNotImplementedNoReturn(cx, u"withHandlingUserInput"_ns, Constify(args_sequence), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodNotImplementedNoReturn(cx, u"withHandlingUserInput"_ns, Constify(args_sequence), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.withHandlingUserInput"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo withHandlingUserInput_methodinfo = {
  { (JSJitGetterOp)withHandlingUserInput },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
notifyFail(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "notifyFail", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  if (!args.requireAtLeast(cx, "ExtensionTest.notifyFail", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  // Collecting all args js values into the single sequence argument
  // passed to the webextensions stub method.
  //
  // NOTE: The stub method will receive the original non-normalized js values,
  // but those arguments will still be normalized on the main thread by the
  // WebExtensions API request handler using the same JSONSchema defnition
  // used by the non-webIDL webextensions API bindings.
  AutoSequence<JS::Value> args_sequence;
  SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

  // maximum number of arguments expected by the WebExtensions API method
  // excluding the last optional chrome-compatible callback argument (which
  // is being passed to the stub method as a separate additional argument).
  uint32_t maxArgsSequenceLen = 1;

  uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
    args.length() : maxArgsSequenceLen;

  if (sequenceArgsLen > 0) {
    if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *args_sequence.AppendElement();
      slot = args[argIdx];
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"notifyFail"_ns, Constify(args_sequence), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"notifyFail"_ns, Constify(args_sequence), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.notifyFail"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo notifyFail_methodinfo = {
  { (JSJitGetterOp)notifyFail },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
notifyPass(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ExtensionTest.notifyPass");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "notifyPass", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  unsigned argcount = std::min(args.length(), 1u);
  switch (argcount) {
    case 0: {
      // Collecting all args js values into the single sequence argument
      // passed to the webextensions stub method.
      //
      // NOTE: The stub method will receive the original non-normalized js values,
      // but those arguments will still be normalized on the main thread by the
      // WebExtensions API request handler using the same JSONSchema defnition
      // used by the non-webIDL webextensions API bindings.
      AutoSequence<JS::Value> args_sequence;
      SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

      // maximum number of arguments expected by the WebExtensions API method
      // excluding the last optional chrome-compatible callback argument (which
      // is being passed to the stub method as a separate additional argument).
      uint32_t maxArgsSequenceLen = 0;

      uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
        args.length() : maxArgsSequenceLen;

      if (sequenceArgsLen > 0) {
        if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
          // OK to do infallible append here, since we ensured capacity already.
          JS::Value& slot = *args_sequence.AppendElement();
          slot = args[argIdx];
        }
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"notifyPass"_ns, Constify(args_sequence), rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"notifyPass"_ns, Constify(args_sequence), rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.notifyPass"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 1: {
      binding_detail::FakeString<char16_t> arg0;
      if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
        return false;
      }
      // Collecting all args js values into the single sequence argument
      // passed to the webextensions stub method.
      //
      // NOTE: The stub method will receive the original non-normalized js values,
      // but those arguments will still be normalized on the main thread by the
      // WebExtensions API request handler using the same JSONSchema defnition
      // used by the non-webIDL webextensions API bindings.
      AutoSequence<JS::Value> args_sequence;
      SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

      // maximum number of arguments expected by the WebExtensions API method
      // excluding the last optional chrome-compatible callback argument (which
      // is being passed to the stub method as a separate additional argument).
      uint32_t maxArgsSequenceLen = 1;

      uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
        args.length() : maxArgsSequenceLen;

      if (sequenceArgsLen > 0) {
        if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
          // OK to do infallible append here, since we ensured capacity already.
          JS::Value& slot = *args_sequence.AppendElement();
          slot = args[argIdx];
        }
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"notifyPass"_ns, Constify(args_sequence), rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"notifyPass"_ns, Constify(args_sequence), rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.notifyPass"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo notifyPass_methodinfo = {
  { (JSJitGetterOp)notifyPass },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
log(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "log", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  if (!args.requireAtLeast(cx, "ExtensionTest.log", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  // Collecting all args js values into the single sequence argument
  // passed to the webextensions stub method.
  //
  // NOTE: The stub method will receive the original non-normalized js values,
  // but those arguments will still be normalized on the main thread by the
  // WebExtensions API request handler using the same JSONSchema defnition
  // used by the non-webIDL webextensions API bindings.
  AutoSequence<JS::Value> args_sequence;
  SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

  // maximum number of arguments expected by the WebExtensions API method
  // excluding the last optional chrome-compatible callback argument (which
  // is being passed to the stub method as a separate additional argument).
  uint32_t maxArgsSequenceLen = 1;

  uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
    args.length() : maxArgsSequenceLen;

  if (sequenceArgsLen > 0) {
    if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *args_sequence.AppendElement();
      slot = args[argIdx];
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"log"_ns, Constify(args_sequence), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"log"_ns, Constify(args_sequence), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.log"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo log_methodinfo = {
  { (JSJitGetterOp)log },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
sendMessage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "sendMessage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"sendMessage"_ns, Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"sendMessage"_ns, Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.sendMessage"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo sendMessage_methodinfo = {
  { (JSJitGetterOp)sendMessage },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
fail(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ExtensionTest.fail");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "fail", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  unsigned argcount = std::min(args.length(), 1u);
  switch (argcount) {
    case 0: {
      // Collecting all args js values into the single sequence argument
      // passed to the webextensions stub method.
      //
      // NOTE: The stub method will receive the original non-normalized js values,
      // but those arguments will still be normalized on the main thread by the
      // WebExtensions API request handler using the same JSONSchema defnition
      // used by the non-webIDL webextensions API bindings.
      AutoSequence<JS::Value> args_sequence;
      SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

      // maximum number of arguments expected by the WebExtensions API method
      // excluding the last optional chrome-compatible callback argument (which
      // is being passed to the stub method as a separate additional argument).
      uint32_t maxArgsSequenceLen = 0;

      uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
        args.length() : maxArgsSequenceLen;

      if (sequenceArgsLen > 0) {
        if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
          // OK to do infallible append here, since we ensured capacity already.
          JS::Value& slot = *args_sequence.AppendElement();
          slot = args[argIdx];
        }
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"fail"_ns, Constify(args_sequence), rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"fail"_ns, Constify(args_sequence), rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.fail"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 1: {
      JS::Rooted<JS::Value> arg0(cx);
      arg0 = args[0];
      // Collecting all args js values into the single sequence argument
      // passed to the webextensions stub method.
      //
      // NOTE: The stub method will receive the original non-normalized js values,
      // but those arguments will still be normalized on the main thread by the
      // WebExtensions API request handler using the same JSONSchema defnition
      // used by the non-webIDL webextensions API bindings.
      AutoSequence<JS::Value> args_sequence;
      SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

      // maximum number of arguments expected by the WebExtensions API method
      // excluding the last optional chrome-compatible callback argument (which
      // is being passed to the stub method as a separate additional argument).
      uint32_t maxArgsSequenceLen = 1;

      uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
        args.length() : maxArgsSequenceLen;

      if (sequenceArgsLen > 0) {
        if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
          // OK to do infallible append here, since we ensured capacity already.
          JS::Value& slot = *args_sequence.AppendElement();
          slot = args[argIdx];
        }
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"fail"_ns, Constify(args_sequence), rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"fail"_ns, Constify(args_sequence), rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.fail"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo fail_methodinfo = {
  { (JSJitGetterOp)fail },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
succeed(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ExtensionTest.succeed");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "succeed", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  unsigned argcount = std::min(args.length(), 1u);
  switch (argcount) {
    case 0: {
      // Collecting all args js values into the single sequence argument
      // passed to the webextensions stub method.
      //
      // NOTE: The stub method will receive the original non-normalized js values,
      // but those arguments will still be normalized on the main thread by the
      // WebExtensions API request handler using the same JSONSchema defnition
      // used by the non-webIDL webextensions API bindings.
      AutoSequence<JS::Value> args_sequence;
      SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

      // maximum number of arguments expected by the WebExtensions API method
      // excluding the last optional chrome-compatible callback argument (which
      // is being passed to the stub method as a separate additional argument).
      uint32_t maxArgsSequenceLen = 0;

      uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
        args.length() : maxArgsSequenceLen;

      if (sequenceArgsLen > 0) {
        if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
          // OK to do infallible append here, since we ensured capacity already.
          JS::Value& slot = *args_sequence.AppendElement();
          slot = args[argIdx];
        }
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"succeed"_ns, Constify(args_sequence), rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"succeed"_ns, Constify(args_sequence), rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.succeed"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 1: {
      JS::Rooted<JS::Value> arg0(cx);
      arg0 = args[0];
      // Collecting all args js values into the single sequence argument
      // passed to the webextensions stub method.
      //
      // NOTE: The stub method will receive the original non-normalized js values,
      // but those arguments will still be normalized on the main thread by the
      // WebExtensions API request handler using the same JSONSchema defnition
      // used by the non-webIDL webextensions API bindings.
      AutoSequence<JS::Value> args_sequence;
      SequenceRooter<JS::Value> args_sequence_holder(cx, &args_sequence);

      // maximum number of arguments expected by the WebExtensions API method
      // excluding the last optional chrome-compatible callback argument (which
      // is being passed to the stub method as a separate additional argument).
      uint32_t maxArgsSequenceLen = 1;

      uint32_t sequenceArgsLen = args.length() <= maxArgsSequenceLen ?
        args.length() : maxArgsSequenceLen;

      if (sequenceArgsLen > 0) {
        if (!args_sequence.SetCapacity(sequenceArgsLen, mozilla::fallible)) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        for (uint32_t argIdx = 0; argIdx < sequenceArgsLen; ++argIdx) {
          // OK to do infallible append here, since we ensured capacity already.
          JS::Value& slot = *args_sequence.AppendElement();
          slot = args[argIdx];
        }
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"succeed"_ns, Constify(args_sequence), rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"succeed"_ns, Constify(args_sequence), rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.succeed"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo succeed_methodinfo = {
  { (JSJitGetterOp)succeed },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
assertTrue(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "assertTrue", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"assertTrue"_ns, Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"assertTrue"_ns, Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.assertTrue"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo assertTrue_methodinfo = {
  { (JSJitGetterOp)assertTrue },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
assertFalse(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "assertFalse", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"assertFalse"_ns, Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"assertFalse"_ns, Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.assertFalse"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo assertFalse_methodinfo = {
  { (JSJitGetterOp)assertFalse },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
assertDeepEq(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "assertDeepEq", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"assertDeepEq"_ns, Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodNoReturn(cx, u"assertDeepEq"_ns, Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.assertDeepEq"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo assertDeepEq_methodinfo = {
  { (JSJitGetterOp)assertDeepEq },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
assertEq(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "assertEq", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  AutoSequence<JS::Value> arg0;
  SequenceRooter<JS::Value> arg0_holder(cx, &arg0);
  if (args.length() > 0) {
    if (!arg0.SetCapacity(args.length() - 0, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 0; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      JS::Value& slot = *arg0.AppendElement();
      slot = args[variadicArg];
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CallWebExtMethodAssertEq(cx, u"assertEq"_ns, Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->CallWebExtMethodAssertEq(cx, u"assertEq"_ns, Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.assertEq"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo assertEq_methodinfo = {
  { (JSJitGetterOp)assertEq },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
assertRejects(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ExtensionTest.assertRejects");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "assertRejects", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  unsigned argcount = std::min(args.length(), 4u);
  switch (argcount) {
    case 2: {
      OwningNonNull<Promise> arg0;
      { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
        // etc.

        JS::Rooted<JSObject*> globalObj(cx);
        globalObj = JS::CurrentGlobalOrNull(cx);
        JSAutoRealm ar(cx, globalObj);
        GlobalObject promiseGlobal(cx, globalObj);
        if (promiseGlobal.Failed()) {
          return false;
        }

        JS::Rooted<JS::Value> valueToResolve(cx, args[0]);
        if (!JS_WrapValue(cx, &valueToResolve)) {
          return false;
        }
        binding_detail::FastErrorResult promiseRv;
        nsCOMPtr<nsIGlobalObject> global =
          do_QueryInterface(promiseGlobal.GetAsSupports());
        if (!global) {
          promiseRv.Throw(NS_ERROR_UNEXPECTED);
          MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
          return false;
        }
        arg0 = Promise::Resolve(global, cx, valueToResolve,
                                        promiseRv);
        if (promiseRv.MaybeSetPendingException(cx)) {
          return false;
        }
      }
      JS::Rooted<JS::Value> arg1(cx);
      arg1 = args[1];
      Optional<OwningNonNull<Function>> arg2;
      if (args.hasDefined(2)) {
        arg2.Construct();
        if (args[2].isObject()) {
          if (JS::IsCallable(&args[2].toObject())) {
          { // scope for tempRoot and tempGlobalRoot if needed
            JS::Rooted<JSObject*> tempRoot(cx, &args[2].toObject());
            JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
            arg2.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
          }
          } else {
            cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 3");
            return false;
          }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
          return false;
        }
      }
      FastErrorResult rv;
      JS::Rooted<JS::Value> result(cx);
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->AssertRejects(cx, NonNullHelper(arg0), arg1, MOZ_KnownLive(NonNullHelper(Constify(arg2))), &result, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->AssertRejects(cx, NonNullHelper(arg0), arg1, MOZ_KnownLive(NonNullHelper(Constify(arg2))), &result, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.assertRejects"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      JS::ExposeValueToActiveJS(result);
      args.rval().set(result);
      if (!MaybeWrapValue(cx, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    case 3: {
      OwningNonNull<Promise> arg0;
      { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
        // etc.

        JS::Rooted<JSObject*> globalObj(cx);
        globalObj = JS::CurrentGlobalOrNull(cx);
        JSAutoRealm ar(cx, globalObj);
        GlobalObject promiseGlobal(cx, globalObj);
        if (promiseGlobal.Failed()) {
          return false;
        }

        JS::Rooted<JS::Value> valueToResolve(cx, args[0]);
        if (!JS_WrapValue(cx, &valueToResolve)) {
          return false;
        }
        binding_detail::FastErrorResult promiseRv;
        nsCOMPtr<nsIGlobalObject> global =
          do_QueryInterface(promiseGlobal.GetAsSupports());
        if (!global) {
          promiseRv.Throw(NS_ERROR_UNEXPECTED);
          MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
          return false;
        }
        arg0 = Promise::Resolve(global, cx, valueToResolve,
                                        promiseRv);
        if (promiseRv.MaybeSetPendingException(cx)) {
          return false;
        }
      }
      JS::Rooted<JS::Value> arg1(cx);
      arg1 = args[1];
      if (args[2].isUndefined()) {
        Optional<OwningNonNull<Function>> arg2;
        if (args.hasDefined(2)) {
          arg2.Construct();
          if (args[2].isObject()) {
            if (JS::IsCallable(&args[2].toObject())) {
            { // scope for tempRoot and tempGlobalRoot if needed
              JS::Rooted<JSObject*> tempRoot(cx, &args[2].toObject());
              JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
              arg2.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
            }
            } else {
              cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 3");
              return false;
            }
          } else {
            cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
            return false;
          }
        }
        FastErrorResult rv;
        JS::Rooted<JS::Value> result(cx);
        // NOTE: This assert does NOT call the function.
        static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->AssertRejects(cx, NonNullHelper(arg0), arg1, MOZ_KnownLive(NonNullHelper(Constify(arg2))), &result, rv))>, "Should be returning void here");
        MOZ_KnownLive(self)->AssertRejects(cx, NonNullHelper(arg0), arg1, MOZ_KnownLive(NonNullHelper(Constify(arg2))), &result, rv);
        if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.assertRejects"))) {
          return false;
        }
        MOZ_ASSERT(!JS_IsExceptionPending(cx));
        JS::ExposeValueToActiveJS(result);
        args.rval().set(result);
        if (!MaybeWrapValue(cx, args.rval())) {
          return false;
        }
        return true;
      }
      if (args[2].isObject()) {
        do {
          Optional<OwningNonNull<Function>> arg2;
          if (args.hasDefined(2)) {
            arg2.Construct();
            if (JS::IsCallable(&args[2].toObject())) {
            { // scope for tempRoot and tempGlobalRoot if needed
              JS::Rooted<JSObject*> tempRoot(cx, &args[2].toObject());
              JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
              arg2.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
            }
            } else {
              break;
            }
          }
          FastErrorResult rv;
          JS::Rooted<JS::Value> result(cx);
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->AssertRejects(cx, NonNullHelper(arg0), arg1, MOZ_KnownLive(NonNullHelper(Constify(arg2))), &result, rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->AssertRejects(cx, NonNullHelper(arg0), arg1, MOZ_KnownLive(NonNullHelper(Constify(arg2))), &result, rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.assertRejects"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          JS::ExposeValueToActiveJS(result);
          args.rval().set(result);
          if (!MaybeWrapValue(cx, args.rval())) {
            return false;
          }
          return true;
        } while (false);
      }
      binding_detail::FakeString<char16_t> arg2;
      if (!ConvertJSValueToString(cx, args[2], eStringify, eStringify, arg2)) {
        return false;
      }
      Optional<OwningNonNull<Function>> arg3;
      if (args.hasDefined(3)) {
        arg3.Construct();
        if (args[3].isObject()) {
          if (JS::IsCallable(&args[3].toObject())) {
          { // scope for tempRoot and tempGlobalRoot if needed
            JS::Rooted<JSObject*> tempRoot(cx, &args[3].toObject());
            JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
            arg3.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
          }
          } else {
            cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 4");
            return false;
          }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 4");
          return false;
        }
      }
      FastErrorResult rv;
      JS::Rooted<JS::Value> result(cx);
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->AssertRejects(cx, NonNullHelper(arg0), arg1, NonNullHelper(Constify(arg2)), MOZ_KnownLive(NonNullHelper(Constify(arg3))), &result, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->AssertRejects(cx, NonNullHelper(arg0), arg1, NonNullHelper(Constify(arg2)), MOZ_KnownLive(NonNullHelper(Constify(arg3))), &result, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.assertRejects"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      JS::ExposeValueToActiveJS(result);
      args.rval().set(result);
      if (!MaybeWrapValue(cx, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    case 4: {
      OwningNonNull<Promise> arg0;
      { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
        // etc.

        JS::Rooted<JSObject*> globalObj(cx);
        globalObj = JS::CurrentGlobalOrNull(cx);
        JSAutoRealm ar(cx, globalObj);
        GlobalObject promiseGlobal(cx, globalObj);
        if (promiseGlobal.Failed()) {
          return false;
        }

        JS::Rooted<JS::Value> valueToResolve(cx, args[0]);
        if (!JS_WrapValue(cx, &valueToResolve)) {
          return false;
        }
        binding_detail::FastErrorResult promiseRv;
        nsCOMPtr<nsIGlobalObject> global =
          do_QueryInterface(promiseGlobal.GetAsSupports());
        if (!global) {
          promiseRv.Throw(NS_ERROR_UNEXPECTED);
          MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
          return false;
        }
        arg0 = Promise::Resolve(global, cx, valueToResolve,
                                        promiseRv);
        if (promiseRv.MaybeSetPendingException(cx)) {
          return false;
        }
      }
      JS::Rooted<JS::Value> arg1(cx);
      arg1 = args[1];
      binding_detail::FakeString<char16_t> arg2;
      if (!ConvertJSValueToString(cx, args[2], eStringify, eStringify, arg2)) {
        return false;
      }
      Optional<OwningNonNull<Function>> arg3;
      if (args.hasDefined(3)) {
        arg3.Construct();
        if (args[3].isObject()) {
          if (JS::IsCallable(&args[3].toObject())) {
          { // scope for tempRoot and tempGlobalRoot if needed
            JS::Rooted<JSObject*> tempRoot(cx, &args[3].toObject());
            JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
            arg3.Value() = new Function(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
          }
          } else {
            cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 4");
            return false;
          }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 4");
          return false;
        }
      }
      FastErrorResult rv;
      JS::Rooted<JS::Value> result(cx);
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->AssertRejects(cx, NonNullHelper(arg0), arg1, NonNullHelper(Constify(arg2)), MOZ_KnownLive(NonNullHelper(Constify(arg3))), &result, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->AssertRejects(cx, NonNullHelper(arg0), arg1, NonNullHelper(Constify(arg2)), MOZ_KnownLive(NonNullHelper(Constify(arg3))), &result, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.assertRejects"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      JS::ExposeValueToActiveJS(result);
      args.rval().set(result);
      if (!MaybeWrapValue(cx, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo assertRejects_methodinfo = {
  { (JSJitGetterOp)assertRejects },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
assertThrows(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ExtensionTest.assertThrows");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "assertThrows", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  unsigned argcount = std::min(args.length(), 3u);
  switch (argcount) {
    case 2: {
      RootedCallback<OwningNonNull<binding_detail::FastFunction>> arg0(cx);
      if (args[0].isObject()) {
        if (JS::IsCallable(&args[0].toObject())) {
        { // scope for tempRoot and tempGlobalRoot if needed
          arg0 = new binding_detail::FastFunction(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
        }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      JS::Rooted<JS::Value> arg1(cx);
      arg1 = args[1];
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->AssertThrows(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->AssertThrows(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.assertThrows"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 3: {
      RootedCallback<OwningNonNull<binding_detail::FastFunction>> arg0(cx);
      if (args[0].isObject()) {
        if (JS::IsCallable(&args[0].toObject())) {
        { // scope for tempRoot and tempGlobalRoot if needed
          arg0 = new binding_detail::FastFunction(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
        }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      JS::Rooted<JS::Value> arg1(cx);
      arg1 = args[1];
      binding_detail::FakeString<char16_t> arg2;
      if (!ConvertJSValueToString(cx, args[2], eStringify, eStringify, arg2)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->AssertThrows(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, NonNullHelper(Constify(arg2)), rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->AssertThrows(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, NonNullHelper(Constify(arg2)), rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtensionTest.assertThrows"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo assertThrows_methodinfo = {
  { (JSJitGetterOp)assertThrows },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onMessage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "onMessage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::extensions::ExtensionTest*>(void_self);
  auto result(StrongOrRawPtr<mozilla::extensions::ExtensionEventManager>(MOZ_KnownLive(self)->OnMessage()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_onMessage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtensionTest", "onMessage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return JS_DefineProperty(cx, obj, "onMessage", args[0], JSPROP_ENUMERATE);
}

static const JSJitInfo onMessage_getterinfo = {
  { get_onMessage },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onMessage_setterinfo = {
  { (JSJitGetterOp)set_onMessage },
  { prototypes::id::ExtensionTest },
  { PrototypeTraits<prototypes::id::ExtensionTest>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::extensions::ExtensionTest* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::extensions::ExtensionTest>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::extensions::ExtensionTest>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("withHandlingUserInput", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&withHandlingUserInput_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("notifyFail", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&notifyFail_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("notifyPass", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&notifyPass_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("log", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&log_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("sendMessage", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&sendMessage_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("fail", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&fail_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("succeed", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&succeed_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("assertTrue", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&assertTrue_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("assertFalse", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&assertFalse_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("assertDeepEq", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&assertDeepEq_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("assertEq", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&assertEq_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("assertRejects", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&assertRejects_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("assertThrows", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&assertThrows_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("onMessage", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onMessage_getterinfo, GenericSetter<NormalThisPolicy>, &onMessage_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};


static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  0,
  nullptr,
  {
    { sMethods, nullptr },
    { sAttributes, nullptr }
  }
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "ExtensionTestPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::ExtensionTest,
  PrototypeTraits<prototypes::id::ExtensionTest>::Depth,
  &sEmptyNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<mozilla::extensions::ExtensionTest>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "ExtensionTest",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::extensions::ExtensionTest>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::ExtensionTest, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::extensions::ExtensionTest>,
  &sEmptyNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::extensions::ExtensionTest>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::extensions::ExtensionTest>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::extensions::ExtensionTest>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::extensions::ExtensionTest* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::extensions::ExtensionTest>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::extensions::ExtensionTest*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::extensions::ExtensionTest> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::ExtensionTest);
  JS::Heap<JSObject*>* interfaceCache = nullptr;

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              nullptr, nullptr, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "ExtensionTest",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::ExtensionTest,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

} // namespace ExtensionTest_Binding



} // namespace mozilla::dom
