/* THIS FILE IS AUTOGENERATED FROM ExtendableMessageEvent.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "ExtendableEventBinding.h"
#include "ExtendableMessageEventBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Client.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/MessagePort.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/ServiceWorker.h"
#include "mozilla/dom/ServiceWorkerEvents.h"
#include "nsThreadUtils.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningClientOrServiceWorkerOrMessagePort& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsClient()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsClient(), "mClient", aFlags);
  } else if (aUnion.IsServiceWorker()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsServiceWorker(), "mServiceWorker", aFlags);
  } else if (aUnion.IsMessagePort()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsMessagePort(), "mMessagePort", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningClientOrServiceWorkerOrMessagePort& aUnion)
{
  aUnion.Uninit();
}


bool
ClientOrServiceWorkerOrMessagePort::TrySetToClient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::Client>& memberSlot = RawSetAsClient();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Client, mozilla::dom::Client>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyClient();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
ClientOrServiceWorkerOrMessagePort::TrySetToClient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToClient(cx, value, tryNext, passedToJSImpl);
}







bool
ClientOrServiceWorkerOrMessagePort::TrySetToServiceWorker(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::ServiceWorker>& memberSlot = RawSetAsServiceWorker();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::ServiceWorker, mozilla::dom::ServiceWorker>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyServiceWorker();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
ClientOrServiceWorkerOrMessagePort::TrySetToServiceWorker(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToServiceWorker(cx, value, tryNext, passedToJSImpl);
}







bool
ClientOrServiceWorkerOrMessagePort::TrySetToMessagePort(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::MessagePort>& memberSlot = RawSetAsMessagePort();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::MessagePort, mozilla::dom::MessagePort>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyMessagePort();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
ClientOrServiceWorkerOrMessagePort::TrySetToMessagePort(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToMessagePort(cx, value, tryNext, passedToJSImpl);
}







bool
ClientOrServiceWorkerOrMessagePort::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToClient(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToServiceWorker(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToMessagePort(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "Client, ServiceWorker, MessagePort");
    return false;
  }
  return true;
}

bool
ClientOrServiceWorkerOrMessagePort::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
ClientOrServiceWorkerOrMessagePort::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eClient: {
      if (!GetOrCreateDOMReflector(cx, mValue.mClient.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eServiceWorker: {
      if (!GetOrCreateDOMReflector(cx, mValue.mServiceWorker.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eMessagePort: {
      if (!GetOrCreateDOMReflector(cx, mValue.mMessagePort.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningClientOrServiceWorkerOrMessagePort::OwningClientOrServiceWorkerOrMessagePort(OwningClientOrServiceWorkerOrMessagePort&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eClient: {
      mType = eClient;
      mValue.mClient.SetValue(std::move(aOther.mValue.mClient.Value()));
      break;
    }
    case eServiceWorker: {
      mType = eServiceWorker;
      mValue.mServiceWorker.SetValue(std::move(aOther.mValue.mServiceWorker.Value()));
      break;
    }
    case eMessagePort: {
      mType = eMessagePort;
      mValue.mMessagePort.SetValue(std::move(aOther.mValue.mMessagePort.Value()));
      break;
    }
  }
}



bool
OwningClientOrServiceWorkerOrMessagePort::TrySetToClient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::Client>& memberSlot = RawSetAsClient();
    static_assert(IsRefcounted<mozilla::dom::Client>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Client, mozilla::dom::Client>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyClient();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningClientOrServiceWorkerOrMessagePort::TrySetToClient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToClient(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::Client>&
OwningClientOrServiceWorkerOrMessagePort::RawSetAsClient()
{
  if (mType == eClient) {
    return mValue.mClient.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eClient;
  return mValue.mClient.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::Client>&
OwningClientOrServiceWorkerOrMessagePort::SetAsClient()
{
  if (mType == eClient) {
    return mValue.mClient.Value();
  }
  Uninit();
  mType = eClient;
  return mValue.mClient.SetValue();
}


void
OwningClientOrServiceWorkerOrMessagePort::DestroyClient()
{
  MOZ_RELEASE_ASSERT(IsClient(), "Wrong type!");
  mValue.mClient.Destroy();
  mType = eUninitialized;
}



bool
OwningClientOrServiceWorkerOrMessagePort::TrySetToServiceWorker(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::ServiceWorker>& memberSlot = RawSetAsServiceWorker();
    static_assert(IsRefcounted<mozilla::dom::ServiceWorker>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::ServiceWorker, mozilla::dom::ServiceWorker>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyServiceWorker();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningClientOrServiceWorkerOrMessagePort::TrySetToServiceWorker(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToServiceWorker(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::ServiceWorker>&
OwningClientOrServiceWorkerOrMessagePort::RawSetAsServiceWorker()
{
  if (mType == eServiceWorker) {
    return mValue.mServiceWorker.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eServiceWorker;
  return mValue.mServiceWorker.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::ServiceWorker>&
OwningClientOrServiceWorkerOrMessagePort::SetAsServiceWorker()
{
  if (mType == eServiceWorker) {
    return mValue.mServiceWorker.Value();
  }
  Uninit();
  mType = eServiceWorker;
  return mValue.mServiceWorker.SetValue();
}


void
OwningClientOrServiceWorkerOrMessagePort::DestroyServiceWorker()
{
  MOZ_RELEASE_ASSERT(IsServiceWorker(), "Wrong type!");
  mValue.mServiceWorker.Destroy();
  mType = eUninitialized;
}



bool
OwningClientOrServiceWorkerOrMessagePort::TrySetToMessagePort(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::MessagePort>& memberSlot = RawSetAsMessagePort();
    static_assert(IsRefcounted<mozilla::dom::MessagePort>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::MessagePort, mozilla::dom::MessagePort>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyMessagePort();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningClientOrServiceWorkerOrMessagePort::TrySetToMessagePort(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToMessagePort(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::MessagePort>&
OwningClientOrServiceWorkerOrMessagePort::RawSetAsMessagePort()
{
  if (mType == eMessagePort) {
    return mValue.mMessagePort.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eMessagePort;
  return mValue.mMessagePort.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::MessagePort>&
OwningClientOrServiceWorkerOrMessagePort::SetAsMessagePort()
{
  if (mType == eMessagePort) {
    return mValue.mMessagePort.Value();
  }
  Uninit();
  mType = eMessagePort;
  return mValue.mMessagePort.SetValue();
}


void
OwningClientOrServiceWorkerOrMessagePort::DestroyMessagePort()
{
  MOZ_RELEASE_ASSERT(IsMessagePort(), "Wrong type!");
  mValue.mMessagePort.Destroy();
  mType = eUninitialized;
}



bool
OwningClientOrServiceWorkerOrMessagePort::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToClient(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToServiceWorker(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToMessagePort(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "Client, ServiceWorker, MessagePort");
    return false;
  }
  return true;
}

bool
OwningClientOrServiceWorkerOrMessagePort::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningClientOrServiceWorkerOrMessagePort::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eClient: {
      DestroyClient();
      break;
    }
    case eServiceWorker: {
      DestroyServiceWorker();
      break;
    }
    case eMessagePort: {
      DestroyMessagePort();
      break;
    }
  }
}

bool
OwningClientOrServiceWorkerOrMessagePort::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eClient: {
      if (!GetOrCreateDOMReflector(cx, mValue.mClient.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eServiceWorker: {
      if (!GetOrCreateDOMReflector(cx, mValue.mServiceWorker.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eMessagePort: {
      if (!GetOrCreateDOMReflector(cx, mValue.mMessagePort.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningClientOrServiceWorkerOrMessagePort&
OwningClientOrServiceWorkerOrMessagePort::operator=(OwningClientOrServiceWorkerOrMessagePort&& aOther)
{
  this->~OwningClientOrServiceWorkerOrMessagePort();
  new (this) OwningClientOrServiceWorkerOrMessagePort (std::move(aOther));
  return *this;
}


OwningClientOrServiceWorkerOrMessagePort&
OwningClientOrServiceWorkerOrMessagePort::operator=(const OwningClientOrServiceWorkerOrMessagePort& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eClient: {
      SetAsClient() = aOther.GetAsClient();
      break;
    }
    case eServiceWorker: {
      SetAsServiceWorker() = aOther.GetAsServiceWorker();
      break;
    }
    case eMessagePort: {
      SetAsMessagePort() = aOther.GetAsMessagePort();
      break;
    }
  }
  return *this;
}



ExtendableMessageEventInit::ExtendableMessageEventInit()
  : ExtendableEventInit(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
ExtendableMessageEventInit::InitIds(JSContext* cx, ExtendableMessageEventInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->source_id.init(cx, "source") ||
      !atomsCache->ports_id.init(cx, "ports") ||
      !atomsCache->origin_id.init(cx, "origin") ||
      !atomsCache->lastEventId_id.init(cx, "lastEventId") ||
      !atomsCache->data_id.init(cx, "data")) {
    return false;
  }
  return true;
}

bool
ExtendableMessageEventInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  ExtendableMessageEventInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<ExtendableMessageEventInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!ExtendableEventInit::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->data_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunreachable-code"
#pragma clang diagnostic ignored "-Wunreachable-code-return"
#endif // __clang__
    if ((passedToJSImpl) && !CallerSubsumes(temp.ref())) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("'data' member of ExtendableMessageEventInit");
      return false;
    }
#ifdef __clang__
#pragma clang diagnostic pop
#endif // __clang__
    mData = temp.ref();
  } else {
    mData = JS::NullValue();
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->lastEventId_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mLastEventId)) {
      return false;
    }
  } else {
    mLastEventId.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->origin_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mOrigin)) {
      return false;
    }
  } else {
    mOrigin.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->ports_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'ports' member of ExtendableMessageEventInit", "sequence");
        return false;
      }
      Sequence<OwningNonNull<mozilla::dom::MessagePort>> &arr = mPorts;
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        OwningNonNull<mozilla::dom::MessagePort>* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        OwningNonNull<mozilla::dom::MessagePort>& slot = *slotPtr;
        if (temp.isObject()) {
          static_assert(IsRefcounted<mozilla::dom::MessagePort>::value, "We can only store refcounted classes.");
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::MessagePort, mozilla::dom::MessagePort>(&temp, slot, cx);
            if (NS_FAILED(rv)) {
              cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of 'ports' member of ExtendableMessageEventInit", "MessagePort");
              return false;
            }
          }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of 'ports' member of ExtendableMessageEventInit");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'ports' member of ExtendableMessageEventInit", "sequence");
      return false;
    }
  } else {
    /* mPorts array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->source_id, temp.ptr())) {
      return false;
    }
  }
  if (!(!isNull && !temp->isUndefined()) || temp.ref().isNullOrUndefined()) {
    mSource.SetNull();
  } else {
    if (!mSource.SetValue().Init(cx, temp.ref(), "'source' member of ExtendableMessageEventInit", passedToJSImpl)) {
      return false;
    }
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
ExtendableMessageEventInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
ExtendableMessageEventInit::TraceDictionary(JSTracer* trc)
{
  ExtendableEventInit::TraceDictionary(trc);
  JS::TraceRoot(trc, &mData, "ExtendableMessageEventInit.mData");
}




namespace ExtendableMessageEvent_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<ExtendableEvent_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_data(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtendableMessageEvent", "data", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ExtendableMessageEvent*>(void_self);
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetData(cx, &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetData(cx, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ExtendableMessageEvent.data getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo data_getterinfo = {
  { get_data },
  { prototypes::id::ExtendableMessageEvent },
  { PrototypeTraits<prototypes::id::ExtendableMessageEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_origin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtendableMessageEvent", "origin", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ExtendableMessageEvent*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetOrigin(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetOrigin(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo origin_getterinfo = {
  { get_origin },
  { prototypes::id::ExtendableMessageEvent },
  { PrototypeTraits<prototypes::id::ExtendableMessageEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_lastEventId(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtendableMessageEvent", "lastEventId", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ExtendableMessageEvent*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetLastEventId(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetLastEventId(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo lastEventId_getterinfo = {
  { get_lastEventId },
  { prototypes::id::ExtendableMessageEvent },
  { PrototypeTraits<prototypes::id::ExtendableMessageEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_source(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtendableMessageEvent", "source", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ExtendableMessageEvent*>(void_self);
  Nullable<OwningClientOrServiceWorkerOrMessagePort> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetSource(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetSource(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo source_getterinfo = {
  { get_source },
  { prototypes::id::ExtendableMessageEvent },
  { PrototypeTraits<prototypes::id::ExtendableMessageEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ports(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtendableMessageEvent", "ports", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ExtendableMessageEvent*>(void_self);
  // Have to either root across the getter call or reget after.
  JS::Rooted<JSObject*> slotStorage(cx, js::UncheckedUnwrap(obj, /* stopAtWindowProxy = */ false));
  MOZ_ASSERT(IsDOMObject(slotStorage));
  const size_t slotIndex = (DOM_INSTANCE_RESERVED_SLOTS + 0);
  MOZ_ASSERT(slotIndex < JSCLASS_RESERVED_SLOTS(JS::GetClass(slotStorage)));
  {
    // Scope for cachedVal
    JS::Value cachedVal = JS::GetReservedSlot(slotStorage, slotIndex);
    if (!cachedVal.isUndefined()) {
      args.rval().set(cachedVal);
      // The cached value is in the compartment of slotStorage,
      // so wrap into the caller compartment as needed.
      return MaybeWrapNonDOMObjectValue(cx, args.rval());
    }
  }

  nsTArray<StrongPtrForMember<mozilla::dom::MessagePort>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetPorts(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetPorts(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  {
    JS::Rooted<JSObject*> conversionScope(cx, slotStorage);
    JSAutoRealm ar(cx, conversionScope);
    do { // block we break out of when done wrapping

      uint32_t length = result.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!GetOrCreateDOMReflector(cx, result[sequenceIdx0], &tmp)) {
              MOZ_ASSERT(JS_IsExceptionPending(cx));
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      args.rval().setObject(*returnArray);
      break;
    } while (false);
    JS::Rooted<JSObject*> rvalObj(cx, &args.rval().toObject());
    if (!JS_FreezeObject(cx, rvalObj)) {
      return false;
    }
  }
  { // And now store things in the realm of our slotStorage.
    JSAutoRealm ar(cx, slotStorage);
    // Make a copy so that we don't do unnecessary wrapping on args.rval().
    JS::Rooted<JS::Value> storedVal(cx, args.rval());
    if (!MaybeWrapNonDOMObjectValue(cx, &storedVal)) {
      return false;
    }
    JS::SetReservedSlot(slotStorage, slotIndex, storedVal);
    PreserveWrapper(self);
  }
  // And now make sure args.rval() is in the caller realm.
  return MaybeWrapNonDOMObjectValue(cx, args.rval());
}

static const JSJitInfo ports_getterinfo = {
  { get_ports },
  { prototypes::id::ExtendableMessageEvent },
  { PrototypeTraits<prototypes::id::ExtendableMessageEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  true, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  (DOM_INSTANCE_RESERVED_SLOTS + 0)   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) <= JSJitInfo::maxSlotIndex, "We won't fit");
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) < 2, "There is no slot for us");

MOZ_CAN_RUN_SCRIPT static bool
get_isTrusted(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtendableMessageEvent", "isTrusted", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ExtendableMessageEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->IsTrusted());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isTrusted_getterinfo = {
  { get_isTrusted },
  { prototypes::id::ExtendableMessageEvent },
  { PrototypeTraits<prototypes::id::ExtendableMessageEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::ExtendableMessageEvent* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::ExtendableMessageEvent>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::ExtendableMessageEvent>(self);
  }
}

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("data", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &data_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("origin", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &origin_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("lastEventId", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &lastEventId_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("source", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &source_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("ports", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &ports_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

MOZ_GLOBINIT static const JSPropertySpec sUnforgeableAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("isTrusted", JSPROP_ENUMERATE | JSPROP_PERMANENT, GenericGetter<NormalThisPolicy, ThrowExceptions>, &isTrusted_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sUnforgeableAttributes[] = {
  { nullptr, &sUnforgeableAttributes_specs[0] },
  { nullptr, nullptr }
};


static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  false, 0,
  true,  0 /* sAttributes */,
  false, 0,
  true,  1 /* sUnforgeableAttributes */,
  false, 0,
  -1,
  0,
  nullptr,
  {
    { sAttributes, nullptr },
    { sUnforgeableAttributes, nullptr }
  }
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "ExtendableMessageEvent constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ExtendableMessageEvent", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "ExtendableMessageEvent");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::ExtendableMessageEvent,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "ExtendableMessageEvent constructor", 1)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  RootedDictionary<binding_detail::FastExtendableMessageEventInit> arg1(cx);
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
    if (!JS_WrapValue(cx, JS::MutableHandle<JS::Value>::fromMarkedLocation(&arg1.mData))) {
      return false;
    }
  }
  auto result(StrongOrRawPtr<mozilla::dom::ExtendableMessageEvent>(mozilla::dom::ExtendableMessageEvent::Constructor(global, NonNullHelper(Constify(arg0)), Constify(arg1))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sEmptyNativePropertyHooks },
  ExtendableEvent_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::ExtendableMessageEvent>::Depth,
  prototypes::id::ExtendableMessageEvent,
  true,
  1,
  "ExtendableMessageEvent",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "ExtendableMessageEventPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE + 1 /* slot for the JSObject holding the unforgeable properties */),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::ExtendableMessageEvent,
  PrototypeTraits<prototypes::id::ExtendableMessageEvent>::Depth,
  &sEmptyNativePropertyHooks,
  ExtendableEvent_Binding::GetProtoObject
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  MOZ_ASSERT(!NS_IsMainThread(), "Why did we even get called?");

  const char* name = JS::GetClass(aObj)->name;
  if (strcmp(name, "ServiceWorkerGlobalScope")) {
    return false;
  }

  return true;
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  NativeTypeHelpers<mozilla::dom::ExtendableMessageEvent>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "ExtendableMessageEvent",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(2) | JSCLASS_SKIP_NURSERY_FINALIZE,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::ExtendableMessageEvent>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::Event, prototypes::id::ExtendableEvent, prototypes::id::ExtendableMessageEvent, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::ExtendableMessageEvent>,
  &sEmptyNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::ExtendableMessageEvent>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::ExtendableMessageEvent>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::ExtendableMessageEvent>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(2 >= 2,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::ExtendableMessageEvent* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::ExtendableMessageEvent>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::ExtendableMessageEvent*>);
  MOZ_ASSERT(static_cast<mozilla::dom::ExtendableEvent*>(aObject) ==
             reinterpret_cast<mozilla::dom::ExtendableEvent*>(aObject),
             "Multiple inheritance for mozilla::dom::ExtendableEvent is broken.");
  MOZ_ASSERT(static_cast<mozilla::dom::Event*>(aObject) ==
             reinterpret_cast<mozilla::dom::Event*>(aObject),
             "Multiple inheritance for mozilla::dom::Event is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::ExtendableMessageEvent> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);

  // Important: do unforgeable property setup after we have handed
  // over ownership of the C++ object to obj as needed, so that if
  // we fail and it ends up GCed it won't have problems in the
  // finalizer trying to drop its ownership of the C++ object.
  JS::Rooted<JSObject*> unforgeableHolder(aCx,
    &JS::GetReservedSlot(canonicalProto, DOM_INTERFACE_PROTO_SLOTS_BASE).toObject());
  if (!JS_InitializePropertiesFromCompatibleNativeObject(aCx, aReflector, unforgeableHolder)) {
    aCache->ReleaseWrapper(aObject);
    aCache->ClearWrapper();
    return false;
  }
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::ExtendableMessageEvent);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::ExtendableMessageEvent);

  JS::Handle<JSObject*> parentProto(ExtendableEvent_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(ExtendableEvent_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 1, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "ExtendableMessageEvent",
                              ShouldExpose<ExtendableMessageEvent_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);

  JS::AssertObjectIsNotGray(*protoCache);
  JS::Handle<JSObject*> proto = JS::Handle<JSObject*>::fromMarkedLocation(protoCache->unsafeAddress());
  if (!proto) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  JS::Rooted<JSObject*> unforgeableHolder(
      aCx, JS_NewObjectWithoutMetadata(aCx, sClass.ToJSClass(), proto));
  if (!unforgeableHolder) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (!DefineLegacyUnforgeableAttributes(aCx, unforgeableHolder, sUnforgeableAttributes)) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (*protoCache) {
    JS::SetReservedSlot(*protoCache, DOM_INTERFACE_PROTO_SLOTS_BASE,
                        JS::ObjectValue(*unforgeableHolder));
  }
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::ExtendableMessageEvent,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::ExtendableMessageEvent,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace ExtendableMessageEvent_Binding



} // namespace mozilla::dom
