/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM DeviceLightEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "DeviceLightEvent.h"
#include "DeviceLightEventBinding.h"
#include "EventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/DeviceLightEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "nsGlobalWindowInner.h"

namespace mozilla::dom {


DeviceLightEvent::DeviceLightEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

DeviceLightEvent::~DeviceLightEvent()
{
}

DeviceLightEvent*
DeviceLightEvent::AsDeviceLightEvent()
{
  return this;
}

JSObject*
DeviceLightEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return DeviceLightEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<DeviceLightEvent>
DeviceLightEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const DeviceLightEventInit& aEventInitDict)
{
  RefPtr<DeviceLightEvent> e = new DeviceLightEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mValue = aEventInitDict.mValue;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<DeviceLightEvent>
DeviceLightEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const DeviceLightEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

double
DeviceLightEvent::Value() const
{
  return mValue;
}


} // namespace mozilla::dom
