/* THIS FILE IS AUTOGENERATED FROM DOMLocalization.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "DOMLocalizationBinding.h"
#include "L10nRegistryBinding.h"
#include "LocalizationBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMLocalization.h"
#include "mozilla/dom/Element.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "mozilla/intl/L10nRegistry.h"
#include "mozilla/intl/Localization.h"
#include "nsIContent.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace DOMLocalization_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<Localization_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
connectRoot(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "DOMLocalization.connectRoot");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DOMLocalization", "connectRoot", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMLocalization*>(void_self);
  if (!args.requireAtLeast(cx, "DOMLocalization.connectRoot", 1)) {
    return false;
  }
  NonNull<nsINode> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Node, nsINode>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Node");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ConnectRoot(MOZ_KnownLive(NonNullHelper(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->ConnectRoot(MOZ_KnownLive(NonNullHelper(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo connectRoot_methodinfo = {
  { (JSJitGetterOp)connectRoot },
  { prototypes::id::DOMLocalization },
  { PrototypeTraits<prototypes::id::DOMLocalization>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
disconnectRoot(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "DOMLocalization.disconnectRoot");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DOMLocalization", "disconnectRoot", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMLocalization*>(void_self);
  if (!args.requireAtLeast(cx, "DOMLocalization.disconnectRoot", 1)) {
    return false;
  }
  NonNull<nsINode> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Node, nsINode>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Node");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DisconnectRoot(MOZ_KnownLive(NonNullHelper(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->DisconnectRoot(MOZ_KnownLive(NonNullHelper(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo disconnectRoot_methodinfo = {
  { (JSJitGetterOp)disconnectRoot },
  { prototypes::id::DOMLocalization },
  { PrototypeTraits<prototypes::id::DOMLocalization>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
pauseObserving(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DOMLocalization", "pauseObserving", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMLocalization*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PauseObserving())>, "Should be returning void here");
  MOZ_KnownLive(self)->PauseObserving();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo pauseObserving_methodinfo = {
  { (JSJitGetterOp)pauseObserving },
  { prototypes::id::DOMLocalization },
  { PrototypeTraits<prototypes::id::DOMLocalization>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
resumeObserving(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DOMLocalization", "resumeObserving", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMLocalization*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ResumeObserving())>, "Should be returning void here");
  MOZ_KnownLive(self)->ResumeObserving();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo resumeObserving_methodinfo = {
  { (JSJitGetterOp)resumeObserving },
  { prototypes::id::DOMLocalization },
  { PrototypeTraits<prototypes::id::DOMLocalization>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setAttributes(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "DOMLocalization.setAttributes");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DOMLocalization", "setAttributes", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMLocalization*>(void_self);
  if (!args.requireAtLeast(cx, "DOMLocalization.setAttributes", 2)) {
    return false;
  }
  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  Optional<JS::Handle<JSObject*>> arg2;
  if (args.hasDefined(2)) {
    arg2.Construct(cx);
    if (args[2].isObject()) {
      arg2.Value() = &args[2].toObject();
    } else if (args[2].isNullOrUndefined()) {
      arg2.Value() = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetAttributes(cx, MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)), Constify(arg2), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetAttributes(cx, MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)), Constify(arg2), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "DOMLocalization.setAttributes"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setAttributes_methodinfo = {
  { (JSJitGetterOp)setAttributes },
  { prototypes::id::DOMLocalization },
  { PrototypeTraits<prototypes::id::DOMLocalization>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getAttributes(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "DOMLocalization.getAttributes");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DOMLocalization", "getAttributes", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMLocalization*>(void_self);
  if (!args.requireAtLeast(cx, "DOMLocalization.getAttributes", 1)) {
    return false;
  }
  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  L10nIdArgs result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetAttributes(MOZ_KnownLive(NonNullHelper(arg0)), result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetAttributes(MOZ_KnownLive(NonNullHelper(arg0)), result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "DOMLocalization.getAttributes"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getAttributes_methodinfo = {
  { (JSJitGetterOp)getAttributes },
  { prototypes::id::DOMLocalization },
  { PrototypeTraits<prototypes::id::DOMLocalization>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setArgs(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "DOMLocalization.setArgs");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DOMLocalization", "setArgs", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMLocalization*>(void_self);
  if (!args.requireAtLeast(cx, "DOMLocalization.setArgs", 1)) {
    return false;
  }
  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  Optional<JS::Handle<JSObject*>> arg1;
  if (args.hasDefined(1)) {
    arg1.Construct(cx);
    if (args[1].isObject()) {
      arg1.Value() = &args[1].toObject();
    } else if (args[1].isNullOrUndefined()) {
      arg1.Value() = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetArgs(cx, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetArgs(cx, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "DOMLocalization.setArgs"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setArgs_methodinfo = {
  { (JSJitGetterOp)setArgs },
  { prototypes::id::DOMLocalization },
  { PrototypeTraits<prototypes::id::DOMLocalization>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
translateFragment(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "DOMLocalization.translateFragment");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DOMLocalization", "translateFragment", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMLocalization*>(void_self);
  if (!args.requireAtLeast(cx, "DOMLocalization.translateFragment", 1)) {
    return false;
  }
  NonNull<nsINode> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Node, nsINode>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Node");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->TranslateFragment(MOZ_KnownLive(NonNullHelper(arg0)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "DOMLocalization.translateFragment"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
translateFragment_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = translateFragment(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo translateFragment_methodinfo = {
  { (JSJitGetterOp)translateFragment_promiseWrapper },
  { prototypes::id::DOMLocalization },
  { PrototypeTraits<prototypes::id::DOMLocalization>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
translateElements(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "DOMLocalization.translateElements");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DOMLocalization", "translateElements", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMLocalization*>(void_self);
  if (!args.requireAtLeast(cx, "DOMLocalization.translateElements", 1)) {
    return false;
  }
  binding_detail::AutoSequence<OwningNonNull<mozilla::dom::Element>> arg0;
  if (args[0].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[0], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 1", "sequence");
      return false;
    }
    binding_detail::AutoSequence<OwningNonNull<mozilla::dom::Element>> &arr = arg0;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      OwningNonNull<mozilla::dom::Element>* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      OwningNonNull<mozilla::dom::Element>& slot = *slotPtr;
      if (temp.isObject()) {
        static_assert(IsRefcounted<mozilla::dom::Element>::value, "We can only store refcounted classes.");
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(&temp, slot, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of argument 1", "Element");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of argument 1");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 1", "sequence");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->TranslateElements(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "DOMLocalization.translateElements"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
translateElements_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = translateElements(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo translateElements_methodinfo = {
  { (JSJitGetterOp)translateElements_promiseWrapper },
  { prototypes::id::DOMLocalization },
  { PrototypeTraits<prototypes::id::DOMLocalization>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
translateRoots(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DOMLocalization", "translateRoots", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMLocalization*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->TranslateRoots(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "DOMLocalization.translateRoots"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
translateRoots_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = translateRoots(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo translateRoots_methodinfo = {
  { (JSJitGetterOp)translateRoots_promiseWrapper },
  { prototypes::id::DOMLocalization },
  { PrototypeTraits<prototypes::id::DOMLocalization>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::DOMLocalization* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::DOMLocalization>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::DOMLocalization>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("connectRoot", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&connectRoot_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("disconnectRoot", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&disconnectRoot_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("pauseObserving", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&pauseObserving_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("resumeObserving", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&resumeObserving_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setAttributes", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setAttributes_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getAttributes", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getAttributes_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setArgs", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setArgs_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("translateFragment", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&translateFragment_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("translateElements", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&translateElements_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("translateRoots", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&translateRoots_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(10 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[10];
static PropertyInfo sNativeProperties_propertyInfos[10];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  10,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(10 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::DOMLocalization,
  constructors::id::DOMLocalization,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "DOMLocalization constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "DOMLocalization", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "DOMLocalization");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::DOMLocalization,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "DOMLocalization constructor", 1)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  binding_detail::AutoSequence<OwningUTF8StringOrResourceId> arg0;
  if (args[0].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[0], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 1", "sequence");
      return false;
    }
    binding_detail::AutoSequence<OwningUTF8StringOrResourceId> &arr = arg0;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      OwningUTF8StringOrResourceId* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      OwningUTF8StringOrResourceId& slot = *slotPtr;
      if (!slot.Init(cx, temp, "Element of argument 1", false)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 1", "sequence");
    return false;
  }
  bool arg1;
  if (args.hasDefined(1)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
      return false;
    }
  } else {
    arg1 = false;
  }
  Optional<NonNull<mozilla::intl::L10nRegistry>> arg2;
  if (args.hasDefined(2)) {
    arg2.Construct();
    if (args[2].isObject()) {
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::L10nRegistry, mozilla::intl::L10nRegistry>(args[2], arg2.Value(), cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 3", "L10nRegistry");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
      return false;
    }
  }
  Optional<Sequence<nsCString>> arg3;
  if (args.hasDefined(3)) {
    arg3.Construct();
    if (args[3].isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(args[3], JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 4", "sequence");
        return false;
      }
      Sequence<nsCString> &arr = arg3.Value();
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        nsCString* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        nsCString& slot = *slotPtr;
        if (!ConvertJSValueToString(cx, temp, eStringify, eStringify, slot)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 4", "sequence");
      return false;
    }
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMLocalization>(mozilla::dom::DOMLocalization::Constructor(global, Constify(arg0), arg1, MOZ_KnownLive(NonNullHelper(Constify(arg2))), Constify(arg3), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "DOMLocalization constructor"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  Localization_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::DOMLocalization>::Depth,
  prototypes::id::DOMLocalization,
  true,
  1,
  "DOMLocalization",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "DOMLocalizationPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::DOMLocalization,
  PrototypeTraits<prototypes::id::DOMLocalization>::Depth,
  &sNativePropertyHooks,
  Localization_Binding::GetProtoObject
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return mozilla::intl::Localization::IsAPIEnabled(aCx, aObj);
}

static const JSClassOps sClassOps = {
  NativeTypeHelpers<mozilla::dom::DOMLocalization>::AddProperty, /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "DOMLocalization",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::DOMLocalization>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::Localization, prototypes::id::DOMLocalization, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::DOMLocalization>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::DOMLocalization>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::DOMLocalization>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::DOMLocalization>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::DOMLocalization* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::DOMLocalization>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::DOMLocalization*>);
  MOZ_ASSERT(static_cast<mozilla::intl::Localization*>(aObject) ==
             reinterpret_cast<mozilla::intl::Localization*>(aObject),
             "Multiple inheritance for mozilla::intl::Localization is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::DOMLocalization> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::DOMLocalization);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::DOMLocalization);

  JS::Handle<JSObject*> parentProto(Localization_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(Localization_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 1, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "DOMLocalization",
                              ShouldExpose<DOMLocalization_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::DOMLocalization,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JSObject*
GetProtoObject(JSContext* aCx)
{
  return GetProtoObjectHandle(aCx);
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::DOMLocalization,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace DOMLocalization_Binding



} // namespace mozilla::dom
