/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/dns/nsITRRSkipReason.idl
 */

#ifndef __gen_nsITRRSkipReason_h__
#define __gen_nsITRRSkipReason_h__


#include "nsISupports.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsITRRSkipReason */
#define NS_ITRRSKIPREASON_IID_STR "e61b5d39-f6d6-4ed3-aead-1213b24c6f27"

#define NS_ITRRSKIPREASON_IID \
  {0xe61b5d39, 0xf6d6, 0x4ed3, \
    { 0xae, 0xad, 0x12, 0x13, 0xb2, 0x4c, 0x6f, 0x27 }}

class NS_NO_VTABLE nsITRRSkipReason : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ITRRSKIPREASON_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsITRRSkipReason;

  enum value : uint32_t {
    TRR_UNSET = 0,
    TRR_OK = 1,
    TRR_NO_GSERVICE = 2,
    TRR_PARENTAL_CONTROL = 3,
    TRR_OFF_EXPLICIT = 4,
    TRR_REQ_MODE_DISABLED = 5,
    TRR_MODE_NOT_ENABLED = 6,
    TRR_FAILED = 7,
    TRR_MODE_UNHANDLED_DEFAULT = 8,
    TRR_MODE_UNHANDLED_DISABLED = 9,
    TRR_DISABLED_FLAG = 10,
    TRR_TIMEOUT = 11,
    TRR_CHANNEL_DNS_FAIL = 12,
    TRR_BROWSER_IS_OFFLINE = 13,
    TRR_NOT_CONFIRMED = 14,
    TRR_DID_NOT_MAKE_QUERY = 15,
    TRR_UNKNOWN_CHANNEL_FAILURE = 16,
    TRR_HOST_BLOCKED_TEMPORARY = 17,
    TRR_SEND_FAILED = 18,
    TRR_NET_RESET = 19,
    TRR_NET_TIMEOUT = 20,
    TRR_NET_REFUSED = 21,
    TRR_NET_INTERRUPT = 22,
    TRR_NET_INADEQ_SEQURITY = 23,
    TRR_NO_ANSWERS = 24,
    TRR_DECODE_FAILED = 25,
    TRR_EXCLUDED = 26,
    TRR_SERVER_RESPONSE_ERR = 27,
    TRR_RCODE_FAIL = 28,
    TRR_NO_CONNECTIVITY = 29,
    TRR_NXDOMAIN = 30,
    TRR_REQ_CANCELLED = 31,
    ODOH_KEY_NOT_USABLE = 32,
    ODOH_UPDATE_KEY_FAILED = 33,
    ODOH_KEY_NOT_AVAILABLE = 34,
    ODOH_ENCRYPTION_FAILED = 35,
    ODOH_DECRYPTION_FAILED = 36,
    TRR_HEURISTIC_TRIPPED_GOOGLE_SAFESEARCH = 37,
    TRR_HEURISTIC_TRIPPED_YOUTUBE_SAFESEARCH = 38,
    TRR_HEURISTIC_TRIPPED_ZSCALER_CANARY = 39,
    TRR_HEURISTIC_TRIPPED_CANARY = 40,
    TRR_HEURISTIC_TRIPPED_MODIFIED_ROOTS = 41,
    TRR_HEURISTIC_TRIPPED_PARENTAL_CONTROLS = 42,
    TRR_HEURISTIC_TRIPPED_THIRD_PARTY_ROOTS = 43,
    TRR_HEURISTIC_TRIPPED_ENTERPRISE_POLICY = 44,
    TRR_HEURISTIC_TRIPPED_VPN = 45,
    TRR_HEURISTIC_TRIPPED_PROXY = 46,
    TRR_HEURISTIC_TRIPPED_NRPT = 47,
    TRR_BAD_URL = 48,
    TRR_SYSTEM_SLEEP_MODE = 49,
    eLAST_VALUE = 49,
  };

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsITRRSkipReason, NS_ITRRSKIPREASON_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSITRRSKIPREASON \

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSITRRSKIPREASON \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSITRRSKIPREASON(_to) \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSITRRSKIPREASON(_to) \

namespace mozilla {
namespace net {
using TRRSkippedReason = nsITRRSkipReason::value;
inline bool IsRelevantTRRSkipReason(TRRSkippedReason aReason) {
  // - TRR_REQ_MODE_DISABLED - these requests are intentionally skipping TRR.
  //     These include DNS queries used to bootstrap the TRR connection,
  //     captive portal checks, connectivity checks, etc.
  //     Since we don't want to use TRR for these connections, we don't need
  //     to include them with other relevant skip reasons.
  // - TRR_DISABLED_FLAG - This reason is used when retrying failed connections,
  //    sync DNS resolves on the main thread, or requests coming from
  //    webextensions that choose to skip TRR
  // - TRR_EXCLUDED - This reason is used when a certain domain is excluded
  //    from TRR because it is explicitly set by the user, or because it
  //    is part of the user's DNS suffix list, indicating a host that is likely
  //    to be on the local network.
  if (aReason == TRRSkippedReason::TRR_REQ_MODE_DISABLED ||
      aReason == TRRSkippedReason::TRR_DISABLED_FLAG ||
      aReason == TRRSkippedReason::TRR_EXCLUDED) {
    return false;
  }
  return true;
}
inline bool IsBlockedTRRRequest(TRRSkippedReason aReason) {
  // See TRR::MaybeBlockRequest. These are the reasons that could block sending
  // TRR requests.
  return (aReason == TRRSkippedReason::TRR_EXCLUDED ||
          aReason == TRRSkippedReason::TRR_MODE_NOT_ENABLED ||
          aReason == TRRSkippedReason::TRR_HOST_BLOCKED_TEMPORARY);
}
inline bool IsNonRecoverableTRRSkipReason(TRRSkippedReason aReason) {
  // These are non-recoverable reasons and we'll fallback to native without
  // retrying.
  return (aReason == TRRSkippedReason::TRR_NXDOMAIN ||
          aReason == TRRSkippedReason::TRR_NO_ANSWERS ||
          aReason == TRRSkippedReason::TRR_DISABLED_FLAG ||
          aReason == TRRSkippedReason::TRR_RCODE_FAIL);
}
inline bool IsFailedConfirmationOrNoConnectivity(TRRSkippedReason aReason) {
  // TRR is in non-confirmed state now, so we don't try to use TRR at all.
  return (aReason == TRRSkippedReason::TRR_NOT_CONFIRMED ||
          aReason == TRRSkippedReason::TRR_NO_CONNECTIVITY);
}
extern nsresult GetTRRSkipReasonName(TRRSkippedReason aReason, nsACString& aName);
} // net
} // mozilla

#endif /* __gen_nsITRRSkipReason_h__ */
