/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/docshell/base/nsIDocumentViewer.idl
 */

#ifndef __gen_nsIDocumentViewer_h__
#define __gen_nsIDocumentViewer_h__


#include "nsISupports.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDocShell; /* forward declaration */

class nsISHEntry; /* forward declaration */

class nsIPrintSettings; /* forward declaration */

namespace mozilla {
namespace dom {
class Document; /* webidl Document */
} // namespace dom
} // namespace mozilla

class nsINode; /* webidl Node */

#include "mozilla/Maybe.h"
#include "nsTArray.h"
#include "nsRect.h"
#include "Units.h"
class nsIWidget;
class nsPresContext;
class nsView;
class nsDOMNavigationTiming;
namespace mozilla {
class Encoding;
class PresShell;
namespace dom {
class WindowGlobalChild;
} // namespace dom
namespace layout {
class RemotePrintJobChild;
} // namespace layout
} // namespace mozilla

/* starting interface:    nsIDocumentViewer */
#define NS_IDOCUMENTVIEWER_IID_STR "48118355-e9a5-4452-ab18-59cc426fb817"

#define NS_IDOCUMENTVIEWER_IID \
  {0x48118355, 0xe9a5, 0x4452, \
    { 0xab, 0x18, 0x59, 0xcc, 0x42, 0x6f, 0xb8, 0x17 }}

class nsIDocumentViewer : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IDOCUMENTVIEWER_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIDocumentViewer;

  /* [noscript] void init (in nsIWidgetPtr aParentWidget, [const] in LayoutDeviceIntRectRef aBounds, in WindowGlobalChildPtr aWindowActor); */
  NS_IMETHOD Init(nsIWidget * aParentWidget, const mozilla::LayoutDeviceIntRect & aBounds, mozilla::dom::WindowGlobalChild * aWindowActor) = 0;

  /* attribute nsIDocShell container; */
  NS_IMETHOD GetContainer(nsIDocShell **aContainer) = 0;
  NS_IMETHOD SetContainer(nsIDocShell *aContainer) = 0;

  /* [noscript,nostdcall,notxpcom] void loadStart (in Document aDoc); */
  virtual void LoadStart(mozilla::dom::Document *aDoc) = 0;

  /* [can_run_script] void loadComplete (in nsresult aStatus); */
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD LoadComplete(nsresult aStatus) = 0;

  /* [nostdcall,notxpcom] readonly attribute boolean loadCompleted; */
  virtual bool GetLoadCompleted() = 0;

  /* [nostdcall,notxpcom] readonly attribute boolean isStopped; */
  virtual bool GetIsStopped() = 0;

  enum PermitUnloadAction : uint8_t {
    ePrompt = 0,
    eDontPromptAndDontUnload = 1,
    eDontPromptAndUnload = 2,
  };

  enum PermitUnloadResult : uint8_t {
    eAllowNavigation = 0,
    eRequestBlockNavigation = 1,
  };

     nsresult PermitUnload(bool* canUnload) {
      return PermitUnload(ePrompt, canUnload);
    }
    /* boolean permitUnload ([optional] in nsIDocumentViewer_PermitUnloadAction aAction); */
  NS_IMETHOD PermitUnload(nsIDocumentViewer::PermitUnloadAction aAction, bool *_retval) = 0;

  /* readonly attribute boolean inPermitUnload; */
  NS_IMETHOD GetInPermitUnload(bool *aInPermitUnload) = 0;

  /* [noscript,nostdcall,notxpcom] nsIDocumentViewer_PermitUnloadResult dispatchBeforeUnload (); */
  virtual nsIDocumentViewer::PermitUnloadResult DispatchBeforeUnload(void) = 0;

  /* readonly attribute boolean beforeUnloadFiring; */
  NS_IMETHOD GetBeforeUnloadFiring(bool *aBeforeUnloadFiring) = 0;

  /* [can_run_script] void pageHide (in boolean isUnload); */
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD PageHide(bool isUnload) = 0;

  /* void close (in nsISHEntry historyEntry); */
  NS_IMETHOD Close(nsISHEntry *historyEntry) = 0;

  /* void destroy (); */
  NS_IMETHOD Destroy(void) = 0;

  /* void stop (); */
  NS_IMETHOD Stop(void) = 0;

  /* readonly attribute Document DOMDocument; */
  NS_IMETHOD GetDOMDocument(mozilla::dom::Document **aDOMDocument) = 0;

  /* [noscript,nostdcall,notxpcom] Document getDocument (); */
  virtual mozilla::dom::Document * GetDocument(void) = 0;

  /* [noscript,nostdcall] void setDocument (in Document aDocument); */
  virtual nsresult SetDocument(mozilla::dom::Document *aDocument) = 0;

  /* [noscript] void getBounds (in LayoutDeviceIntRectRef aBounds); */
  NS_IMETHOD GetBounds(mozilla::LayoutDeviceIntRect & aBounds) = 0;

  /* [noscript] void setBounds ([const] in LayoutDeviceIntRectRef aBounds); */
  NS_IMETHOD SetBounds(const mozilla::LayoutDeviceIntRect & aBounds) = 0;

  enum {
    eDelayResize = 1U
  };

  /* [noscript] void setBoundsWithFlags ([const] in LayoutDeviceIntRectRef aBounds, in unsigned long aFlags); */
  NS_IMETHOD SetBoundsWithFlags(const mozilla::LayoutDeviceIntRect & aBounds, uint32_t aFlags) = 0;

  /* [nostdcall,notxpcom] attribute nsIDocumentViewer previousViewer; */
  virtual nsIDocumentViewer * GetPreviousViewer() = 0;
  virtual void SetPreviousViewer(nsIDocumentViewer *aPreviousViewer) = 0;

  /* void move (in long aX, in long aY); */
  NS_IMETHOD Move(int32_t aX, int32_t aY) = 0;

  /* void show (); */
  NS_IMETHOD Show(void) = 0;

  /* void hide (); */
  NS_IMETHOD Hide(void) = 0;

  /* attribute boolean sticky; */
  NS_IMETHOD GetSticky(bool *aSticky) = 0;
  NS_IMETHOD SetSticky(bool aSticky) = 0;

  /* void open (in nsISupports aState, in nsISHEntry aSHEntry); */
  NS_IMETHOD Open(nsISupports *aState, nsISHEntry *aSHEntry) = 0;

  /* void clearHistoryEntry (); */
  NS_IMETHOD ClearHistoryEntry(void) = 0;

  /* void setPageModeForTesting (in boolean aPageMode, in nsIPrintSettings aPrintSettings); */
  NS_IMETHOD SetPageModeForTesting(bool aPageMode, nsIPrintSettings *aPrintSettings) = 0;

  /* [can_run_script,noscript] void setPrintSettingsForSubdocument (in nsIPrintSettings aPrintSettings, in RemotePrintJobChildPtr aRemotePrintJob); */
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD SetPrintSettingsForSubdocument(nsIPrintSettings *aPrintSettings, mozilla::layout::RemotePrintJobChild * aRemotePrintJob) = 0;

  /* readonly attribute nsISHEntry historyEntry; */
  NS_IMETHOD GetHistoryEntry(nsISHEntry **aHistoryEntry) = 0;

  /* readonly attribute boolean isTabModalPromptAllowed; */
  NS_IMETHOD GetIsTabModalPromptAllowed(bool *aIsTabModalPromptAllowed) = 0;

  /* attribute boolean isHidden; */
  NS_IMETHOD GetIsHidden(bool *aIsHidden) = 0;
  NS_IMETHOD SetIsHidden(bool aIsHidden) = 0;

  /* [nostdcall,notxpcom] readonly attribute PresShellPtr presShell; */
  virtual mozilla::PresShell * GetPresShell() = 0;

  /* [nostdcall,notxpcom] readonly attribute nsPresContextPtr presContext; */
  virtual nsPresContext * GetPresContext() = 0;

  /* [noscript] void setDocumentInternal (in Document aDocument, in boolean aForceReuseInnerWindow); */
  NS_IMETHOD SetDocumentInternal(mozilla::dom::Document *aDocument, bool aForceReuseInnerWindow) = 0;

  /* [noscript,nostdcall,notxpcom] nsViewPtr findContainerView (); */
  virtual nsView * FindContainerView(void) = 0;

  /* [noscript,nostdcall,notxpcom] void setNavigationTiming (in nsDOMNavigationTimingPtr aTiming); */
  virtual void SetNavigationTiming(nsDOMNavigationTiming * aTiming) = 0;

  /* readonly attribute float deviceFullZoomForTest; */
  NS_IMETHOD GetDeviceFullZoomForTest(float *aDeviceFullZoomForTest) = 0;

  /* attribute boolean authorStyleDisabled; */
  NS_IMETHOD GetAuthorStyleDisabled(bool *aAuthorStyleDisabled) = 0;
  NS_IMETHOD SetAuthorStyleDisabled(bool aAuthorStyleDisabled) = 0;

  /* void getContentSize (in long maxWidth, in long maxHeight, in long prefWidth, out long width, out long height); */
  NS_IMETHOD GetContentSize(int32_t maxWidth, int32_t maxHeight, int32_t prefWidth, int32_t *width, int32_t *height) = 0;

   mozilla::Maybe<mozilla::CSSIntSize> GetContentSize(int32_t aMaxWidth = 0, int32_t aMaxHeight = 0, int32_t aPrefWidth = 0) {
    int32_t w = 0;
    int32_t h = 0;
    if (NS_SUCCEEDED(GetContentSize(aMaxWidth, aMaxHeight, aPrefWidth, &w, &h))) {
      return mozilla::Some(mozilla::CSSIntSize(w, h));
    }
    return mozilla::Nothing();
  }
  /* [noscript,notxpcom] Encoding getReloadEncodingAndSource (out int32_t aSource); */
  NS_IMETHOD_(const mozilla::Encoding *) GetReloadEncodingAndSource(int32_t *aSource) = 0;

  /* [noscript,notxpcom] void setReloadEncodingAndSource (in Encoding aEncoding, in int32_t aSource); */
  NS_IMETHOD_(void) SetReloadEncodingAndSource(const mozilla::Encoding * aEncoding, int32_t aSource) = 0;

  /* [noscript,notxpcom] void forgetReloadEncoding (); */
  NS_IMETHOD_(void) ForgetReloadEncoding(void) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIDocumentViewer, NS_IDOCUMENTVIEWER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIDOCUMENTVIEWER \
  NS_IMETHOD Init(nsIWidget * aParentWidget, const mozilla::LayoutDeviceIntRect & aBounds, mozilla::dom::WindowGlobalChild * aWindowActor) override; \
  NS_IMETHOD GetContainer(nsIDocShell **aContainer) override; \
  NS_IMETHOD SetContainer(nsIDocShell *aContainer) override; \
  virtual void LoadStart(mozilla::dom::Document *aDoc) override; \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD LoadComplete(nsresult aStatus) override; \
  virtual bool GetLoadCompleted() override; \
  virtual bool GetIsStopped() override; \
  NS_IMETHOD PermitUnload(nsIDocumentViewer::PermitUnloadAction aAction, bool *_retval) override; \
  NS_IMETHOD GetInPermitUnload(bool *aInPermitUnload) override; \
  virtual nsIDocumentViewer::PermitUnloadResult DispatchBeforeUnload(void) override; \
  NS_IMETHOD GetBeforeUnloadFiring(bool *aBeforeUnloadFiring) override; \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD PageHide(bool isUnload) override; \
  NS_IMETHOD Close(nsISHEntry *historyEntry) override; \
  NS_IMETHOD Destroy(void) override; \
  NS_IMETHOD Stop(void) override; \
  NS_IMETHOD GetDOMDocument(mozilla::dom::Document **aDOMDocument) override; \
  virtual mozilla::dom::Document * GetDocument(void) override; \
  virtual nsresult SetDocument(mozilla::dom::Document *aDocument) override; \
  NS_IMETHOD GetBounds(mozilla::LayoutDeviceIntRect & aBounds) override; \
  NS_IMETHOD SetBounds(const mozilla::LayoutDeviceIntRect & aBounds) override; \
  NS_IMETHOD SetBoundsWithFlags(const mozilla::LayoutDeviceIntRect & aBounds, uint32_t aFlags) override; \
  virtual nsIDocumentViewer * GetPreviousViewer() override; \
  virtual void SetPreviousViewer(nsIDocumentViewer *aPreviousViewer) override; \
  NS_IMETHOD Move(int32_t aX, int32_t aY) override; \
  NS_IMETHOD Show(void) override; \
  NS_IMETHOD Hide(void) override; \
  NS_IMETHOD GetSticky(bool *aSticky) override; \
  NS_IMETHOD SetSticky(bool aSticky) override; \
  NS_IMETHOD Open(nsISupports *aState, nsISHEntry *aSHEntry) override; \
  NS_IMETHOD ClearHistoryEntry(void) override; \
  NS_IMETHOD SetPageModeForTesting(bool aPageMode, nsIPrintSettings *aPrintSettings) override; \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD SetPrintSettingsForSubdocument(nsIPrintSettings *aPrintSettings, mozilla::layout::RemotePrintJobChild * aRemotePrintJob) override; \
  NS_IMETHOD GetHistoryEntry(nsISHEntry **aHistoryEntry) override; \
  NS_IMETHOD GetIsTabModalPromptAllowed(bool *aIsTabModalPromptAllowed) override; \
  NS_IMETHOD GetIsHidden(bool *aIsHidden) override; \
  NS_IMETHOD SetIsHidden(bool aIsHidden) override; \
  virtual mozilla::PresShell * GetPresShell() override; \
  virtual nsPresContext * GetPresContext() override; \
  NS_IMETHOD SetDocumentInternal(mozilla::dom::Document *aDocument, bool aForceReuseInnerWindow) override; \
  virtual nsView * FindContainerView(void) override; \
  virtual void SetNavigationTiming(nsDOMNavigationTiming * aTiming) override; \
  NS_IMETHOD GetDeviceFullZoomForTest(float *aDeviceFullZoomForTest) override; \
  NS_IMETHOD GetAuthorStyleDisabled(bool *aAuthorStyleDisabled) override; \
  NS_IMETHOD SetAuthorStyleDisabled(bool aAuthorStyleDisabled) override; \
  NS_IMETHOD GetContentSize(int32_t maxWidth, int32_t maxHeight, int32_t prefWidth, int32_t *width, int32_t *height) override; \
  NS_IMETHOD_(const mozilla::Encoding *) GetReloadEncodingAndSource(int32_t *aSource) override; \
  NS_IMETHOD_(void) SetReloadEncodingAndSource(const mozilla::Encoding * aEncoding, int32_t aSource) override; \
  NS_IMETHOD_(void) ForgetReloadEncoding(void) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIDOCUMENTVIEWER \
  nsresult Init(nsIWidget * aParentWidget, const mozilla::LayoutDeviceIntRect & aBounds, mozilla::dom::WindowGlobalChild * aWindowActor); \
  nsresult GetContainer(nsIDocShell **aContainer); \
  nsresult SetContainer(nsIDocShell *aContainer); \
  void LoadStart(mozilla::dom::Document *aDoc); \
  MOZ_CAN_RUN_SCRIPT nsresult LoadComplete(nsresult aStatus); \
  bool GetLoadCompleted(); \
  bool GetIsStopped(); \
  nsresult PermitUnload(nsIDocumentViewer::PermitUnloadAction aAction, bool *_retval); \
  nsresult GetInPermitUnload(bool *aInPermitUnload); \
  nsIDocumentViewer::PermitUnloadResult DispatchBeforeUnload(void); \
  nsresult GetBeforeUnloadFiring(bool *aBeforeUnloadFiring); \
  MOZ_CAN_RUN_SCRIPT nsresult PageHide(bool isUnload); \
  nsresult Close(nsISHEntry *historyEntry); \
  nsresult Destroy(void); \
  nsresult Stop(void); \
  nsresult GetDOMDocument(mozilla::dom::Document **aDOMDocument); \
  mozilla::dom::Document * GetDocument(void); \
  nsresult SetDocument(mozilla::dom::Document *aDocument); \
  nsresult GetBounds(mozilla::LayoutDeviceIntRect & aBounds); \
  nsresult SetBounds(const mozilla::LayoutDeviceIntRect & aBounds); \
  nsresult SetBoundsWithFlags(const mozilla::LayoutDeviceIntRect & aBounds, uint32_t aFlags); \
  nsIDocumentViewer * GetPreviousViewer(); \
  void SetPreviousViewer(nsIDocumentViewer *aPreviousViewer); \
  nsresult Move(int32_t aX, int32_t aY); \
  nsresult Show(void); \
  nsresult Hide(void); \
  nsresult GetSticky(bool *aSticky); \
  nsresult SetSticky(bool aSticky); \
  nsresult Open(nsISupports *aState, nsISHEntry *aSHEntry); \
  nsresult ClearHistoryEntry(void); \
  nsresult SetPageModeForTesting(bool aPageMode, nsIPrintSettings *aPrintSettings); \
  MOZ_CAN_RUN_SCRIPT nsresult SetPrintSettingsForSubdocument(nsIPrintSettings *aPrintSettings, mozilla::layout::RemotePrintJobChild * aRemotePrintJob); \
  nsresult GetHistoryEntry(nsISHEntry **aHistoryEntry); \
  nsresult GetIsTabModalPromptAllowed(bool *aIsTabModalPromptAllowed); \
  nsresult GetIsHidden(bool *aIsHidden); \
  nsresult SetIsHidden(bool aIsHidden); \
  mozilla::PresShell * GetPresShell(); \
  nsPresContext * GetPresContext(); \
  nsresult SetDocumentInternal(mozilla::dom::Document *aDocument, bool aForceReuseInnerWindow); \
  nsView * FindContainerView(void); \
  void SetNavigationTiming(nsDOMNavigationTiming * aTiming); \
  nsresult GetDeviceFullZoomForTest(float *aDeviceFullZoomForTest); \
  nsresult GetAuthorStyleDisabled(bool *aAuthorStyleDisabled); \
  nsresult SetAuthorStyleDisabled(bool aAuthorStyleDisabled); \
  nsresult GetContentSize(int32_t maxWidth, int32_t maxHeight, int32_t prefWidth, int32_t *width, int32_t *height); \
  nsresult_(const mozilla::Encoding *) GetReloadEncodingAndSource(int32_t *aSource); \
  nsresult_(void) SetReloadEncodingAndSource(const mozilla::Encoding * aEncoding, int32_t aSource); \
  nsresult_(void) ForgetReloadEncoding(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIDOCUMENTVIEWER(_to) \
  NS_IMETHOD Init(nsIWidget * aParentWidget, const mozilla::LayoutDeviceIntRect & aBounds, mozilla::dom::WindowGlobalChild * aWindowActor) override { return _to Init(aParentWidget, aBounds, aWindowActor); } \
  NS_IMETHOD GetContainer(nsIDocShell **aContainer) override { return _to GetContainer(aContainer); } \
  NS_IMETHOD SetContainer(nsIDocShell *aContainer) override { return _to SetContainer(aContainer); } \
  virtual void LoadStart(mozilla::dom::Document *aDoc) override { return _to LoadStart(aDoc); } \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD LoadComplete(nsresult aStatus) override { return _to LoadComplete(aStatus); } \
  virtual bool GetLoadCompleted() override { return _to GetLoadCompleted(); } \
  virtual bool GetIsStopped() override { return _to GetIsStopped(); } \
  NS_IMETHOD PermitUnload(nsIDocumentViewer::PermitUnloadAction aAction, bool *_retval) override { return _to PermitUnload(aAction, _retval); } \
  NS_IMETHOD GetInPermitUnload(bool *aInPermitUnload) override { return _to GetInPermitUnload(aInPermitUnload); } \
  virtual nsIDocumentViewer::PermitUnloadResult DispatchBeforeUnload(void) override { return _to DispatchBeforeUnload(); } \
  NS_IMETHOD GetBeforeUnloadFiring(bool *aBeforeUnloadFiring) override { return _to GetBeforeUnloadFiring(aBeforeUnloadFiring); } \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD PageHide(bool isUnload) override { return _to PageHide(isUnload); } \
  NS_IMETHOD Close(nsISHEntry *historyEntry) override { return _to Close(historyEntry); } \
  NS_IMETHOD Destroy(void) override { return _to Destroy(); } \
  NS_IMETHOD Stop(void) override { return _to Stop(); } \
  NS_IMETHOD GetDOMDocument(mozilla::dom::Document **aDOMDocument) override { return _to GetDOMDocument(aDOMDocument); } \
  virtual mozilla::dom::Document * GetDocument(void) override { return _to GetDocument(); } \
  virtual nsresult SetDocument(mozilla::dom::Document *aDocument) override { return _to SetDocument(aDocument); } \
  NS_IMETHOD GetBounds(mozilla::LayoutDeviceIntRect & aBounds) override { return _to GetBounds(aBounds); } \
  NS_IMETHOD SetBounds(const mozilla::LayoutDeviceIntRect & aBounds) override { return _to SetBounds(aBounds); } \
  NS_IMETHOD SetBoundsWithFlags(const mozilla::LayoutDeviceIntRect & aBounds, uint32_t aFlags) override { return _to SetBoundsWithFlags(aBounds, aFlags); } \
  virtual nsIDocumentViewer * GetPreviousViewer() override { return _to GetPreviousViewer(); } \
  virtual void SetPreviousViewer(nsIDocumentViewer *aPreviousViewer) override { return _to SetPreviousViewer(aPreviousViewer); } \
  NS_IMETHOD Move(int32_t aX, int32_t aY) override { return _to Move(aX, aY); } \
  NS_IMETHOD Show(void) override { return _to Show(); } \
  NS_IMETHOD Hide(void) override { return _to Hide(); } \
  NS_IMETHOD GetSticky(bool *aSticky) override { return _to GetSticky(aSticky); } \
  NS_IMETHOD SetSticky(bool aSticky) override { return _to SetSticky(aSticky); } \
  NS_IMETHOD Open(nsISupports *aState, nsISHEntry *aSHEntry) override { return _to Open(aState, aSHEntry); } \
  NS_IMETHOD ClearHistoryEntry(void) override { return _to ClearHistoryEntry(); } \
  NS_IMETHOD SetPageModeForTesting(bool aPageMode, nsIPrintSettings *aPrintSettings) override { return _to SetPageModeForTesting(aPageMode, aPrintSettings); } \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD SetPrintSettingsForSubdocument(nsIPrintSettings *aPrintSettings, mozilla::layout::RemotePrintJobChild * aRemotePrintJob) override { return _to SetPrintSettingsForSubdocument(aPrintSettings, aRemotePrintJob); } \
  NS_IMETHOD GetHistoryEntry(nsISHEntry **aHistoryEntry) override { return _to GetHistoryEntry(aHistoryEntry); } \
  NS_IMETHOD GetIsTabModalPromptAllowed(bool *aIsTabModalPromptAllowed) override { return _to GetIsTabModalPromptAllowed(aIsTabModalPromptAllowed); } \
  NS_IMETHOD GetIsHidden(bool *aIsHidden) override { return _to GetIsHidden(aIsHidden); } \
  NS_IMETHOD SetIsHidden(bool aIsHidden) override { return _to SetIsHidden(aIsHidden); } \
  virtual mozilla::PresShell * GetPresShell() override { return _to GetPresShell(); } \
  virtual nsPresContext * GetPresContext() override { return _to GetPresContext(); } \
  NS_IMETHOD SetDocumentInternal(mozilla::dom::Document *aDocument, bool aForceReuseInnerWindow) override { return _to SetDocumentInternal(aDocument, aForceReuseInnerWindow); } \
  virtual nsView * FindContainerView(void) override { return _to FindContainerView(); } \
  virtual void SetNavigationTiming(nsDOMNavigationTiming * aTiming) override { return _to SetNavigationTiming(aTiming); } \
  NS_IMETHOD GetDeviceFullZoomForTest(float *aDeviceFullZoomForTest) override { return _to GetDeviceFullZoomForTest(aDeviceFullZoomForTest); } \
  NS_IMETHOD GetAuthorStyleDisabled(bool *aAuthorStyleDisabled) override { return _to GetAuthorStyleDisabled(aAuthorStyleDisabled); } \
  NS_IMETHOD SetAuthorStyleDisabled(bool aAuthorStyleDisabled) override { return _to SetAuthorStyleDisabled(aAuthorStyleDisabled); } \
  NS_IMETHOD GetContentSize(int32_t maxWidth, int32_t maxHeight, int32_t prefWidth, int32_t *width, int32_t *height) override { return _to GetContentSize(maxWidth, maxHeight, prefWidth, width, height); } \
  NS_IMETHOD_(const mozilla::Encoding *) GetReloadEncodingAndSource(int32_t *aSource) override { return _to GetReloadEncodingAndSource(aSource); } \
  NS_IMETHOD_(void) SetReloadEncodingAndSource(const mozilla::Encoding * aEncoding, int32_t aSource) override { return _to SetReloadEncodingAndSource(aEncoding, aSource); } \
  NS_IMETHOD_(void) ForgetReloadEncoding(void) override { return _to ForgetReloadEncoding(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIDOCUMENTVIEWER(_to) \
  NS_IMETHOD Init(nsIWidget * aParentWidget, const mozilla::LayoutDeviceIntRect & aBounds, mozilla::dom::WindowGlobalChild * aWindowActor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Init(aParentWidget, aBounds, aWindowActor); } \
  NS_IMETHOD GetContainer(nsIDocShell **aContainer) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetContainer(aContainer); } \
  NS_IMETHOD SetContainer(nsIDocShell *aContainer) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetContainer(aContainer); } \
  virtual void LoadStart(mozilla::dom::Document *aDoc) override; \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD LoadComplete(nsresult aStatus) override { return !_to ? NS_ERROR_NULL_POINTER : _to->LoadComplete(aStatus); } \
  virtual bool GetLoadCompleted() override; \
  virtual bool GetIsStopped() override; \
  NS_IMETHOD PermitUnload(nsIDocumentViewer::PermitUnloadAction aAction, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->PermitUnload(aAction, _retval); } \
  NS_IMETHOD GetInPermitUnload(bool *aInPermitUnload) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInPermitUnload(aInPermitUnload); } \
  virtual nsIDocumentViewer::PermitUnloadResult DispatchBeforeUnload(void) override; \
  NS_IMETHOD GetBeforeUnloadFiring(bool *aBeforeUnloadFiring) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBeforeUnloadFiring(aBeforeUnloadFiring); } \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD PageHide(bool isUnload) override { return !_to ? NS_ERROR_NULL_POINTER : _to->PageHide(isUnload); } \
  NS_IMETHOD Close(nsISHEntry *historyEntry) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Close(historyEntry); } \
  NS_IMETHOD Destroy(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Destroy(); } \
  NS_IMETHOD Stop(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Stop(); } \
  NS_IMETHOD GetDOMDocument(mozilla::dom::Document **aDOMDocument) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDOMDocument(aDOMDocument); } \
  virtual mozilla::dom::Document * GetDocument(void) override; \
  virtual nsresult SetDocument(mozilla::dom::Document *aDocument) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDocument(aDocument); } \
  NS_IMETHOD GetBounds(mozilla::LayoutDeviceIntRect & aBounds) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBounds(aBounds); } \
  NS_IMETHOD SetBounds(const mozilla::LayoutDeviceIntRect & aBounds) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBounds(aBounds); } \
  NS_IMETHOD SetBoundsWithFlags(const mozilla::LayoutDeviceIntRect & aBounds, uint32_t aFlags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBoundsWithFlags(aBounds, aFlags); } \
  virtual nsIDocumentViewer * GetPreviousViewer() override; \
  virtual void SetPreviousViewer(nsIDocumentViewer *aPreviousViewer) override; \
  NS_IMETHOD Move(int32_t aX, int32_t aY) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Move(aX, aY); } \
  NS_IMETHOD Show(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Show(); } \
  NS_IMETHOD Hide(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Hide(); } \
  NS_IMETHOD GetSticky(bool *aSticky) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSticky(aSticky); } \
  NS_IMETHOD SetSticky(bool aSticky) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSticky(aSticky); } \
  NS_IMETHOD Open(nsISupports *aState, nsISHEntry *aSHEntry) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Open(aState, aSHEntry); } \
  NS_IMETHOD ClearHistoryEntry(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearHistoryEntry(); } \
  NS_IMETHOD SetPageModeForTesting(bool aPageMode, nsIPrintSettings *aPrintSettings) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPageModeForTesting(aPageMode, aPrintSettings); } \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD SetPrintSettingsForSubdocument(nsIPrintSettings *aPrintSettings, mozilla::layout::RemotePrintJobChild * aRemotePrintJob) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPrintSettingsForSubdocument(aPrintSettings, aRemotePrintJob); } \
  NS_IMETHOD GetHistoryEntry(nsISHEntry **aHistoryEntry) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHistoryEntry(aHistoryEntry); } \
  NS_IMETHOD GetIsTabModalPromptAllowed(bool *aIsTabModalPromptAllowed) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsTabModalPromptAllowed(aIsTabModalPromptAllowed); } \
  NS_IMETHOD GetIsHidden(bool *aIsHidden) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsHidden(aIsHidden); } \
  NS_IMETHOD SetIsHidden(bool aIsHidden) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIsHidden(aIsHidden); } \
  virtual mozilla::PresShell * GetPresShell() override; \
  virtual nsPresContext * GetPresContext() override; \
  NS_IMETHOD SetDocumentInternal(mozilla::dom::Document *aDocument, bool aForceReuseInnerWindow) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDocumentInternal(aDocument, aForceReuseInnerWindow); } \
  virtual nsView * FindContainerView(void) override; \
  virtual void SetNavigationTiming(nsDOMNavigationTiming * aTiming) override; \
  NS_IMETHOD GetDeviceFullZoomForTest(float *aDeviceFullZoomForTest) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDeviceFullZoomForTest(aDeviceFullZoomForTest); } \
  NS_IMETHOD GetAuthorStyleDisabled(bool *aAuthorStyleDisabled) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAuthorStyleDisabled(aAuthorStyleDisabled); } \
  NS_IMETHOD SetAuthorStyleDisabled(bool aAuthorStyleDisabled) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAuthorStyleDisabled(aAuthorStyleDisabled); } \
  NS_IMETHOD GetContentSize(int32_t maxWidth, int32_t maxHeight, int32_t prefWidth, int32_t *width, int32_t *height) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetContentSize(maxWidth, maxHeight, prefWidth, width, height); } \
  NS_IMETHOD_(const mozilla::Encoding *) GetReloadEncodingAndSource(int32_t *aSource) override; \
  NS_IMETHOD_(void) SetReloadEncodingAndSource(const mozilla::Encoding * aEncoding, int32_t aSource) override; \
  NS_IMETHOD_(void) ForgetReloadEncoding(void) override; 

namespace mozilla {
namespace dom {
using XPCOMPermitUnloadAction = nsIDocumentViewer::PermitUnloadAction;
using PermitUnloadResult = nsIDocumentViewer::PermitUnloadResult;
} // namespace dom
} // namespace mozilla

#endif /* __gen_nsIDocumentViewer_h__ */
