/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
#ifndef mozilla_glean_fog_ffi_generated_h
#define mozilla_glean_fog_ffi_generated_h


/* Generated with cbindgen:0.28.0 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. */

#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>
#include "nsTArray.h"
#include "nsString.h"

namespace mozilla::glean::impl {

struct FogDatetime {
  int32_t year;
  uint32_t month;
  uint32_t day;
  uint32_t hour;
  uint32_t minute;
  uint32_t second;
  uint32_t nano;
  int32_t offset_seconds;
};

/// FFI-compatible representation of recorded event data.
struct FfiRecordedEvent {
  uint64_t timestamp;
  nsCString category;
  nsCString name;
  /// Array of extra data, keys and values are interleaved.
  nsTArray<nsCString> extras;
};

extern "C" {

void fog_shutdown();

void fog_register_pings();

/// # Safety
/// Only safe if only called on a single thread (the same single thread you call
/// fog_give_ipc_buf on).
uintptr_t fog_serialize_ipc_buf();

/// # Safety
/// Only safe if called on a single thread (the same single thread you call
/// fog_serialize_ipc_buf on), and if buf points to an allocated buffer of at
/// least buf_len bytes.
uintptr_t fog_give_ipc_buf(uint8_t *buf, uintptr_t buf_len);

/// # Safety
/// Only safe if buf points to an allocated buffer of at least buf_len bytes.
/// No ownership is transfered to Rust by this method: caller owns the memory at
/// buf before and after this call.
void fog_use_ipc_buf(const uint8_t *buf, uintptr_t buf_len);

/// Sets the debug tag for pings assembled in the future.
/// Returns an error result if the provided value is not a valid tag.
nsresult fog_set_debug_view_tag(const nsACString *value);

/// Submits a ping by name.
nsresult fog_submit_ping(const nsACString *ping_name);

/// Turns ping logging on or off.
/// Returns an error if the logging failed to be configured.
nsresult fog_set_log_pings(bool value);

/// Flushes ping-lifetime data to the db when delay_ping_lifetime_io is true.
nsresult fog_persist_ping_lifetime_data();

/// Indicate that an experiment is running.
/// Glean will add an experiment annotation which is sent with pings.
/// This information is not persisted between runs.
///
/// See [`glean_core::Glean::set_experiment_active`].
void fog_set_experiment_active(const nsACString *experiment_id,
                               const nsACString *branch,
                               const nsTArray<nsCString> *extra_keys,
                               const nsTArray<nsCString> *extra_values);

/// Indicate that an experiment is no longer running.
///
/// See [`glean_core::Glean::set_experiment_inactive`].
void fog_set_experiment_inactive(const nsACString *experiment_id);

/// TEST ONLY FUNCTION
///
/// Returns true if the identified experiment is active.
bool fog_test_is_experiment_active(const nsACString *experiment_id);

/// TEST ONLY FUNCTION
///
/// Fills `branch`, `extra_keys`, and `extra_values` with the identified experiment's data.
/// Panics if the identified experiment isn't active.
void fog_test_get_experiment_data(const nsACString *experiment_id,
                                  nsACString *branch,
                                  nsTArray<nsCString> *extra_keys,
                                  nsTArray<nsCString> *extra_values);

/// Sets the remote feature configuration.
///
/// See [`glean_core::Glean::set_metrics_disabled_config`].
void fog_apply_server_knobs_config(const nsACString *config_json);

/// Performs Glean tasks when client state changes to inactive
///
/// See [`glean_core::Glean::handle_client_inactive`].
void fog_internal_glean_handle_client_inactive();

/// Apply a serverknobs config from the given path.
bool fog_apply_serverknobs(const nsAString *serverknobs_path);

/// Project FOG's entry point.
///
/// This assembles client information and the Glean configuration and then initializes the global
/// Glean instance.
nsresult fog_init(const nsACString *data_path_override,
                  const nsACString *app_id_override,
                  bool disable_internal_pings);

/// Project FOG's entry point on Android.
///
/// This assembles client information and the Glean configuration and then initializes the global
/// Glean instance.
/// It always enables upload and set no uploader.
/// This should only be called in test scenarios.
/// In normal use Glean should be initialized and controlled by the Glean Kotlin SDK.
nsresult fog_init(const nsACString *data_path_override,
                  const nsACString *app_id_override,
                  bool disable_internal_pings);

/// **TEST-ONLY METHOD**
/// Resets FOG and the underlying Glean SDK, clearing stores.
nsresult fog_test_reset(const nsACString *data_path_override, const nsACString *app_id_override);

extern bool FOG_TooLateToSend();

bool fog_boolean_test_has_value(uint32_t id, const nsACString *ping_name);

bool fog_boolean_test_get_value(uint32_t id, const nsACString *ping_name);

bool fog_boolean_test_get_error(uint32_t id, nsACString *error_str);

void fog_boolean_set(uint32_t id, bool value);

void fog_counter_add(uint32_t id, int32_t amount);

bool fog_counter_test_has_value(uint32_t id, const nsACString *ping_name);

int32_t fog_counter_test_get_value(uint32_t id, const nsACString *ping_name);

bool fog_counter_test_get_error(uint32_t id, nsACString *error_str);

bool fog_custom_distribution_test_has_value(uint32_t id, const nsACString *ping_name);

void fog_custom_distribution_test_get_value(uint32_t id,
                                            const nsACString *ping_name,
                                            uint64_t *sum,
                                            uint64_t *count,
                                            nsTArray<uint64_t> *buckets,
                                            nsTArray<uint64_t> *counts);

void fog_custom_distribution_accumulate_samples(uint32_t id, const nsTArray<uint64_t> *samples);

void fog_custom_distribution_accumulate_samples_signed(uint32_t id,
                                                       const nsTArray<int64_t> *samples);

void fog_custom_distribution_accumulate_single_sample(uint32_t id, uint64_t sample);

void fog_custom_distribution_accumulate_single_sample_signed(uint32_t id, int64_t sample);

bool fog_custom_distribution_test_get_error(uint32_t id, nsACString *error_str);

bool fog_datetime_test_has_value(uint32_t id, const nsACString *ping_name);

void fog_datetime_test_get_value(uint32_t id, const nsACString *ping_name, FogDatetime *value);

void fog_datetime_set(uint32_t id, const FogDatetime *dt);

bool fog_datetime_test_get_error(uint32_t id, nsACString *error_str);

void fog_denominator_add(uint32_t id, int32_t amount);

bool fog_denominator_test_has_value(uint32_t id, const nsACString *ping_name);

int32_t fog_denominator_test_get_value(uint32_t id, const nsACString *ping_name);

bool fog_denominator_test_get_error(uint32_t id, nsACString *error_str);

void fog_event_record(uint32_t id,
                      const nsTArray<nsCString> *extra_keys,
                      const nsTArray<nsCString> *extra_values);

bool fog_event_test_has_value(uint32_t id, const nsACString *ping_name);

bool fog_event_test_get_error(uint32_t id, nsACString *error_str);

void fog_event_test_get_value(uint32_t id,
                              const nsACString *ping_name,
                              nsTArray<FfiRecordedEvent> *out_events);

void fog_labeled_enum_to_str(uint32_t id, uint16_t label, nsACString *value);

uint32_t fog_labeled_boolean_get(uint32_t id, const nsACString *label);

uint32_t fog_labeled_boolean_enum_get(uint32_t id, uint16_t label);

uint32_t fog_labeled_counter_get(uint32_t id, const nsACString *label);

uint32_t fog_labeled_counter_enum_get(uint32_t id, uint16_t label);

uint32_t fog_labeled_custom_distribution_get(uint32_t id, const nsACString *label);

uint32_t fog_labeled_custom_distribution_enum_get(uint32_t id, uint16_t label);

uint32_t fog_labeled_memory_distribution_get(uint32_t id, const nsACString *label);

uint32_t fog_labeled_memory_distribution_enum_get(uint32_t id, uint16_t label);

uint32_t fog_labeled_string_get(uint32_t id, const nsACString *label);

uint32_t fog_labeled_string_enum_get(uint32_t id, uint16_t label);

uint32_t fog_labeled_timing_distribution_get(uint32_t id, const nsACString *label);

uint32_t fog_labeled_timing_distribution_enum_get(uint32_t id, uint16_t label);

uint32_t fog_labeled_quantity_get(uint32_t id, const nsACString *label);

uint32_t fog_labeled_quantity_enum_get(uint32_t id, uint16_t label);

bool fog_memory_distribution_test_has_value(uint32_t id, const nsACString *ping_name);

void fog_memory_distribution_test_get_value(uint32_t id,
                                            const nsACString *ping_name,
                                            uint64_t *sum,
                                            uint64_t *count,
                                            nsTArray<uint64_t> *buckets,
                                            nsTArray<uint64_t> *counts);

void fog_memory_distribution_accumulate(uint32_t id, uint64_t sample);

bool fog_memory_distribution_test_get_error(uint32_t id, nsACString *error_str);

void fog_numerator_add_to_numerator(uint32_t id, int32_t amount);

bool fog_numerator_test_has_value(uint32_t id, const nsACString *ping_name);

void fog_numerator_test_get_value(uint32_t id,
                                  const nsACString *ping_name,
                                  int32_t *num,
                                  int32_t *den);

bool fog_numerator_test_get_error(uint32_t id, nsACString *error_str);

void fog_object_set_string(uint32_t id, const nsACString *value);

bool fog_object_test_has_value(uint32_t id, const nsACString *ping_name);

void fog_object_test_get_value(uint32_t id, const nsACString *ping_name, nsACString *value);

bool fog_object_test_get_error(uint32_t id, nsACString *error_str);

void fog_submit_ping_by_id(uint32_t id, const nsACString *reason);

void fog_set_ping_enabled_by_id(uint32_t id, bool value);

void fog_quantity_set(uint32_t id, int64_t value);

bool fog_quantity_test_has_value(uint32_t id, const nsACString *ping_name);

int64_t fog_quantity_test_get_value(uint32_t id, const nsACString *ping_name);

bool fog_quantity_test_get_error(uint32_t id, nsACString *error_str);

void fog_rate_add_to_numerator(uint32_t id, int32_t amount);

void fog_rate_add_to_denominator(uint32_t id, int32_t amount);

bool fog_rate_test_has_value(uint32_t id, const nsACString *ping_name);

void fog_rate_test_get_value(uint32_t id, const nsACString *ping_name, int32_t *num, int32_t *den);

bool fog_rate_test_get_error(uint32_t id, nsACString *error_str);

bool fog_string_test_has_value(uint32_t id, const nsACString *ping_name);

void fog_string_test_get_value(uint32_t id, const nsACString *ping_name, nsACString *value);

void fog_string_set(uint32_t id, const nsACString *value);

bool fog_string_test_get_error(uint32_t id, nsACString *error_str);

bool fog_string_list_test_has_value(uint32_t id, const nsACString *ping_name);

void fog_string_list_test_get_value(uint32_t id,
                                    const nsACString *ping_name,
                                    nsTArray<nsCString> *value);

void fog_string_list_add(uint32_t id, const nsACString *value);

void fog_string_list_set(uint32_t id, const nsTArray<nsCString> *value);

bool fog_string_list_test_get_error(uint32_t id, nsACString *error_str);

bool fog_text_test_has_value(uint32_t id, const nsACString *ping_name);

void fog_text_test_get_value(uint32_t id, const nsACString *ping_name, nsACString *value);

void fog_text_set(uint32_t id, const nsACString *value);

bool fog_text_test_get_error(uint32_t id, nsACString *error_str);

void fog_timespan_start(uint32_t id);

void fog_timespan_stop(uint32_t id);

void fog_timespan_cancel(uint32_t id);

void fog_timespan_set_raw(uint32_t id, uint32_t duration);

bool fog_timespan_test_has_value(uint32_t id, const nsACString *ping_name);

uint64_t fog_timespan_test_get_value(uint32_t id, const nsACString *ping_name);

bool fog_timespan_test_get_error(uint32_t id, nsACString *error_str);

uint64_t fog_timing_distribution_start(uint32_t id);

void fog_timing_distribution_stop_and_accumulate(uint32_t id, uint64_t timing_id);

void fog_timing_distribution_accumulate_raw_nanos(uint32_t id, uint64_t sample);

void fog_timing_distribution_cancel(uint32_t id, uint64_t timing_id);

void fog_timing_distribution_accumulate_samples(uint32_t id, const nsTArray<int64_t> *samples);

void fog_timing_distribution_accumulate_single_sample(uint32_t id, int64_t sample);

bool fog_timing_distribution_test_has_value(uint32_t id, const nsACString *ping_name);

void fog_timing_distribution_test_get_value(uint32_t id,
                                            const nsACString *ping_name,
                                            uint64_t *sum,
                                            uint64_t *count,
                                            nsTArray<uint64_t> *buckets,
                                            nsTArray<uint64_t> *counts);

bool fog_timing_distribution_test_get_error(uint32_t id, nsACString *error_str);

bool fog_url_test_has_value(uint32_t id, const nsACString *ping_name);

void fog_url_test_get_value(uint32_t id, const nsACString *ping_name, nsACString *value);

void fog_url_set(uint32_t id, const nsACString *value);

bool fog_url_test_get_error(uint32_t id, nsACString *error_str);

bool fog_uuid_test_has_value(uint32_t id, const nsACString *ping_name);

void fog_uuid_test_get_value(uint32_t id, const nsACString *ping_name, nsACString *value);

void fog_uuid_set(uint32_t id, const nsACString *value);

void fog_uuid_generate_and_set(uint32_t id);

bool fog_uuid_test_get_error(uint32_t id, nsACString *error_str);

}  // extern "C"

}  // namespace mozilla::glean::impl

#endif // mozilla_glean_fog_ffi_generated_h
