// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanXpcomMetrics_h
#define mozilla_GleanXpcomMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace memory {
  /**
   * generated from memory.collection_time
   * Time spent gathering memory telemetry in milliseconds
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_COLLECTION_TIME.
   */
  constexpr impl::TimingDistributionMetric collection_time(4485);

  /**
   * generated from memory.distribution_among_content
   * Absolute difference of each content process' USS and the mean of USS's, normalized by the mean, in percentage. It will be recorded with the rest of the memory probes when gatherMemory is called, if at least 2 content processes are alive. Example: in case of 4 content processes with USS's: 1G, 500MB, 1G, 1.5G, the reported numbers will be: 0, 50, 0, 50. Which indicates that 2 processes used 50% more or 50% less memory than the avarage and 2 used exactly as much as the avarage.
   * This metric was generated to correspond to the Legacy Telemetry linear histogram MEMORY_DISTRIBUTION_AMONG_CONTENT.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> distribution_among_content(4486);

  /**
   * generated from memory.free_purged_pages
   * Time(ms) to purge dirty heap pages.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_FREE_PURGED_PAGES_MS.
   */
  constexpr impl::TimingDistributionMetric free_purged_pages(4487);

  /**
   * generated from memory.ghost_windows
   * Number of ghost windows
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram GHOST_WINDOWS.
   */
  constexpr impl::CustomDistributionMetric ghost_windows(4488);

  /**
   * generated from memory.heap_allocated
   * Heap memory allocated (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_HEAP_ALLOCATED.
   */
  constexpr impl::MemoryDistributionMetric heap_allocated(4489);

  /**
   * generated from memory.heap_overhead_fraction
   * Fraction of committed heap memory that is overhead (percentage).
   * This metric was generated to correspond to the Legacy Telemetry linear histogram MEMORY_HEAP_OVERHEAD_FRACTION.
   */
  constexpr impl::CustomDistributionMetric heap_overhead_fraction(4490);

  /**
   * generated from memory.images_content_used_uncompressed
   * Memory used for uncompressed, in-use content images (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_IMAGES_CONTENT_USED_UNCOMPRESSED.
   */
  constexpr impl::MemoryDistributionMetric images_content_used_uncompressed(4491);

  /**
   * generated from memory.js_compartments_system
   * Total JavaScript compartments used for add-ons and internals.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_JS_COMPARTMENTS_SYSTEM.
   */
  constexpr impl::CustomDistributionMetric js_compartments_system(4492);

  /**
   * generated from memory.js_compartments_user
   * Total JavaScript compartments used for web pages
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_JS_COMPARTMENTS_USER.
   */
  constexpr impl::CustomDistributionMetric js_compartments_user(4493);

  /**
   * generated from memory.js_gc_heap
   * Memory used by the garbage-collected JavaScript heap (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_JS_GC_HEAP.
   */
  constexpr impl::MemoryDistributionMetric js_gc_heap(4494);

  /**
   * generated from memory.js_realms_system
   * Total JavaScript realms used for add-ons and internals.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_JS_REALMS_SYSTEM.
   */
  constexpr impl::CustomDistributionMetric js_realms_system(4495);

  /**
   * generated from memory.js_realms_user
   * Total JavaScript realms used for web pages.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_JS_REALMS_USER.
   */
  constexpr impl::CustomDistributionMetric js_realms_user(4496);

  /**
   * generated from memory.low_memory_events_physical
   * Number of low-physical-memory events fired since last ping
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram LOW_MEMORY_EVENTS_PHYSICAL.
   */
  constexpr impl::CustomDistributionMetric low_memory_events_physical(4497);

  /**
   * generated from memory.page_faults_hard
   * Hard page faults (since last telemetry ping)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PAGE_FAULTS_HARD.
   */
  constexpr impl::CustomDistributionMetric page_faults_hard(4498);

  /**
   * generated from memory.resident_fast
   * Resident memory size (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_RESIDENT_FAST.
   */
  constexpr impl::MemoryDistributionMetric resident_fast(4499);

  /**
   * generated from memory.resident_peak
   * Peak resident memory size (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_RESIDENT_PEAK.
   */
  constexpr impl::MemoryDistributionMetric resident_peak(4500);

  /**
   * generated from memory.storage_sqlite
   * Memory used by SQLite (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_STORAGE_SQLITE.
   */
  constexpr impl::MemoryDistributionMetric storage_sqlite(4501);

  /**
   * generated from memory.total
   * Total Memory Across All Processes (KB) (inaccurate WRT shared memory. See MemoryTelemetry.cpp)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_TOTAL.
   */
  constexpr impl::MemoryDistributionMetric total(4502);

  /**
   * generated from memory.unique
   * Unique Set Size (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_UNIQUE.
   */
  constexpr impl::MemoryDistributionMetric unique(4503);

  /**
   * generated from memory.unique_content_startup
   * Unique Set Size of Content Process at Startup (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_UNIQUE_CONTENT_STARTUP.
   */
  constexpr impl::MemoryDistributionMetric unique_content_startup(4504);

  /**
   * generated from memory.vsize
   * Virtual memory size (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_VSIZE.
   */
  constexpr impl::MemoryDistributionMetric vsize(4505);

  /**
   * generated from memory.vsize_max_contiguous
   * Maximum-sized block of contiguous virtual memory (KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_VSIZE_MAX_CONTIGUOUS.
   */
  constexpr impl::MemoryDistributionMetric vsize_max_contiguous(4506);
}

namespace cycle_collector {
  /**
   * generated from cycle_collector.async_snow_white_freeing
   * Time spent on one asynchronous SnowWhite freeing (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_ASYNC_SNOW_WHITE_FREEING.
   */
  constexpr impl::TimingDistributionMetric async_snow_white_freeing(5700);

  /**
   * generated from cycle_collector.collected
   * Number of objects collected by the cycle collector
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_COLLECTED.
   */
  constexpr impl::CustomDistributionMetric collected(5701);

  /**
   * generated from cycle_collector.deferred_finalize_async
   * Pause time for asynchronous deferred finalization (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEFERRED_FINALIZE_ASYNC.
   */
  constexpr impl::TimingDistributionMetric deferred_finalize_async(5702);

  /**
   * generated from cycle_collector.finish_igc
   */
  enum class FinishIgcLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Cycle collection finished an incremental GC
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CYCLE_COLLECTOR_FINISH_IGC.
   */
  constexpr impl::Labeled<impl::CounterMetric, FinishIgcLabel> finish_igc(5703);

  /**
   * generated from cycle_collector.full
   * Full pause time for one cycle collection, including preparation (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_FULL.
   */
  constexpr impl::TimingDistributionMetric full(5704);

  /**
   * generated from cycle_collector.max_pause
   * Longest pause for an individual slice of one cycle collection, including preparation (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_MAX_PAUSE.
   */
  constexpr impl::TimingDistributionMetric max_pause(5705);

  /**
   * generated from cycle_collector.need_gc
   */
  enum class NeedGcLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Needed garbage collection before cycle collection.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CYCLE_COLLECTOR_NEED_GC.
   */
  constexpr impl::Labeled<impl::CounterMetric, NeedGcLabel> need_gc(5706);

  /**
   * generated from cycle_collector.slice_during_idle
   * Percent of cycle collector slice done during idle time
   * This metric was generated to correspond to the Legacy Telemetry linear histogram CYCLE_COLLECTOR_SLICE_DURING_IDLE.
   */
  constexpr impl::CustomDistributionMetric slice_during_idle(5707);

  /**
   * generated from cycle_collector.sync_skippable
   */
  enum class SyncSkippableLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Cycle collection synchronously ran forget skippable
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CYCLE_COLLECTOR_SYNC_SKIPPABLE.
   */
  constexpr impl::Labeled<impl::CounterMetric, SyncSkippableLabel> sync_skippable(5708);

  /**
   * generated from cycle_collector.time
   * Time spent on one cycle collection (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR.
   */
  constexpr impl::TimingDistributionMetric time(5709);

  /**
   * generated from cycle_collector.time_between
   * Time spent in between cycle collections (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_TIME_BETWEEN.
   */
  constexpr impl::TimingDistributionMetric time_between(5710);

  /**
   * generated from cycle_collector.visited_gced
   * Number of JS objects visited by the cycle collector
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_VISITED_GCED.
   */
  constexpr impl::CustomDistributionMetric visited_gced(5711);

  /**
   * generated from cycle_collector.visited_ref_counted
   * Number of ref counted objects visited by the cycle collector
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_VISITED_REF_COUNTED.
   */
  constexpr impl::CustomDistributionMetric visited_ref_counted(5712);

  /**
   * generated from cycle_collector.worker_collected
   * Number of objects collected by the cycle collector in a worker
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_WORKER_COLLECTED.
   */
  constexpr impl::CustomDistributionMetric worker_collected(5713);

  /**
   * generated from cycle_collector.worker_need_gc
   */
  enum class WorkerNeedGcLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Needed garbage collection before cycle collection in a worker.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CYCLE_COLLECTOR_WORKER_NEED_GC.
   */
  constexpr impl::Labeled<impl::CounterMetric, WorkerNeedGcLabel> worker_need_gc(5714);

  /**
   * generated from cycle_collector.worker_time
   * Time spent on one cycle collection in a worker (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_WORKER.
   */
  constexpr impl::TimingDistributionMetric worker_time(5715);

  /**
   * generated from cycle_collector.worker_visited_gced
   * Number of JS objects visited by the cycle collector in a worker
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_WORKER_VISITED_GCED.
   */
  constexpr impl::CustomDistributionMetric worker_visited_gced(5716);

  /**
   * generated from cycle_collector.worker_visited_ref_counted
   * Number of ref counted objects visited by the cycle collector in a worker
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CYCLE_COLLECTOR_WORKER_VISITED_REF_COUNTED.
   */
  constexpr impl::CustomDistributionMetric worker_visited_ref_counted(5717);
}

namespace memory_phc {
  /**
   * generated from memory_phc.slop
   * Over-allocation due to PHC's rounding (aka internal fragmentation).  Measured in bytes.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_PHC_SLOP.
   */
  constexpr impl::MemoryDistributionMetric slop(5718);

  /**
   * generated from memory_phc.slots_allocated
   * Number of PHC slots currently allocated
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_PHC_SLOTS_ALLOCATED.
   */
  constexpr impl::CustomDistributionMetric slots_allocated(5719);

  /**
   * generated from memory_phc.slots_freed
   * Number of PHC slots allocated-then-freed
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEMORY_PHC_SLOTS_FREED.
   */
  constexpr impl::CustomDistributionMetric slots_freed(5720);
}

namespace memory_watcher {
  /**
   * generated from memory_watcher.on_high_memory_stats
   */
  struct OnHighMemoryStatsExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This event is recorded when the memory situation is no longer low. The "stats" object consists of three numbers comma-delimited: 1) how many times a tab was unloaded 2) how many memory-pressure events were dispatched 3) how long we were in the low-memory situation in seconds This event was generated to correspond to the Legacy Telemetry event memory_watcher.on_high_memory#stats.
   */
  constexpr impl::EventMetric<OnHighMemoryStatsExtra> on_high_memory_stats(5721);
}

namespace timer_thread {
  /**
   * generated from timer_thread.timers_fired_per_wakeup
   * How many timers were processed in a single wake-up of the Timer Thread.
   */
  constexpr impl::CustomDistributionMetric timers_fired_per_wakeup(5722);
}

} // namespace mozilla::glean

#endif // mozilla_GleanXpcomMetrics_h
