// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanResistfingerprintingMetrics_h
#define mozilla_GleanResistfingerprintingMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace characteristics {
  /**
   * generated from characteristics.any_pointer_type
   * Union of pointers available. We apply union to determine if the user have both coarse and fine pointer.
   */
  constexpr impl::QuantityMetric any_pointer_type(5058);

  /**
   * generated from characteristics.audio_channels
   * Audio sampling rate
   */
  constexpr impl::QuantityMetric audio_channels(5059);

  /**
   * generated from characteristics.audio_fingerprint
   * Audio fingerprint of the user. A float number multiplied by 10e7.
   */
  constexpr impl::QuantityMetric audio_fingerprint(5060);

  /**
   * generated from characteristics.audio_frames
   * Audio frames
   */
  constexpr impl::QuantityMetric audio_frames(5061);

  /**
   * generated from characteristics.audio_rate
   * Audio sampling rate
   */
  constexpr impl::QuantityMetric audio_rate(5062);

  /**
   * generated from characteristics.avail_height
   * Available height property
   */
  constexpr impl::QuantityMetric avail_height(5063);

  /**
   * generated from characteristics.avail_width
   * Available width property
   */
  constexpr impl::QuantityMetric avail_width(5064);

  /**
   * generated from characteristics.build_date
   * Firefox build's build date in unix time
   */
  constexpr impl::QuantityMetric build_date(5065);

  /**
   * generated from characteristics.camera_count
   * Number of cameras available on the device.
   */
  constexpr impl::QuantityMetric camera_count(5066);

  /**
   * generated from characteristics.canvas_dpr
   * The device pixel ratio of the canvas rendering context
   */
  constexpr impl::StringMetric canvas_dpr(5067);

  /**
   * generated from characteristics.canvas_feature_status
   * Status of and failure id (if failed) of ACCELERATED_CANVAS2D feature
   */
  constexpr impl::StringMetric canvas_feature_status(5068);

  /**
   * generated from characteristics.canvasdata1
   * The sha1 hash of an image rendered on a canvas. The image is a simple organge box and used as a control image
   */
  constexpr impl::StringMetric canvasdata1(5069);

  /**
   * generated from characteristics.canvasdata10
   * The sha1 hash of an image rendered on a canvas. The image is a font shipped with Firefox rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata10(5070);

  /**
   * generated from characteristics.canvasdata10software
   * The sha1 hash of an image rendered on a canvas. The image is a font shipped with Firefox rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata10software(5071);

  /**
   * generated from characteristics.canvasdata11_webgl
   * The sha1 hash of an image rendered on a WebGL canvas (instead of Canvas2D). IT is a RGB gradient cube.
   */
  constexpr impl::StringMetric canvasdata11_webgl(5072);

  /**
   * generated from characteristics.canvasdata11_webglsoftware
   * The sha1 hash of an image rendered on a WebGL canvas (instead of Canvas2D). IT is a RGB gradient cube.
   */
  constexpr impl::StringMetric canvasdata11_webglsoftware(5073);

  /**
   * generated from characteristics.canvasdata12_fingerprintjs1
   * The sha1 hash of an image rendered on a canvas, it is a copy of fingerprintjs' text canvas
   */
  constexpr impl::StringMetric canvasdata12_fingerprintjs1(5074);

  /**
   * generated from characteristics.canvasdata12_fingerprintjs1software
   * The sha1 hash of an image rendered on a canvas, it is a copy of fingerprintjs' text canvas
   */
  constexpr impl::StringMetric canvasdata12_fingerprintjs1software(5075);

  /**
   * generated from characteristics.canvasdata13_fingerprintjs2
   * The sha1 hash of an image rendered on a canvas, it is a copy of fingerprintjs' geometry canvas
   */
  constexpr impl::StringMetric canvasdata13_fingerprintjs2(5076);

  /**
   * generated from characteristics.canvasdata13_fingerprintjs2software
   * The sha1 hash of an image rendered on a canvas, it is a copy of fingerprintjs' geometry canvas
   */
  constexpr impl::StringMetric canvasdata13_fingerprintjs2software(5077);

  /**
   * generated from characteristics.canvasdata1software
   * The sha1 hash of an image rendered on a canvas. The image is a simple organge box and used as a control image
   */
  constexpr impl::StringMetric canvasdata1software(5078);

  /**
   * generated from characteristics.canvasdata2
   * The sha1 hash of an image rendered on a canvas. The image is a bordered triage, and used to test point interpolation
   */
  constexpr impl::StringMetric canvasdata2(5079);

  /**
   * generated from characteristics.canvasdata2software
   * The sha1 hash of an image rendered on a canvas. The image is a bordered triage, and used to test point interpolation
   */
  constexpr impl::StringMetric canvasdata2software(5080);

  /**
   * generated from characteristics.canvasdata3
   * The sha1 hash of an image rendered on a canvas. The image is a stretched photographic image, used to test image operations.
   */
  constexpr impl::StringMetric canvasdata3(5081);

  /**
   * generated from characteristics.canvasdata3software
   * The sha1 hash of an image rendered on a canvas. The image is a stretched photographic image, used to test image operations.
   */
  constexpr impl::StringMetric canvasdata3software(5082);

  /**
   * generated from characteristics.canvasdata4
   * The sha1 hash of an image rendered on a canvas. The image is two rotated, semi-transparenct overlapping squares, used to test transparency and point interpolation.
   */
  constexpr impl::StringMetric canvasdata4(5083);

  /**
   * generated from characteristics.canvasdata4software
   * The sha1 hash of an image rendered on a canvas. The image is two rotated, semi-transparenct overlapping squares, used to test transparency and point interpolation.
   */
  constexpr impl::StringMetric canvasdata4software(5084);

  /**
   * generated from characteristics.canvasdata5
   * The sha1 hash of an image rendered on a canvas. The image is a local font rendered normally.
   */
  constexpr impl::StringMetric canvasdata5(5085);

  /**
   * generated from characteristics.canvasdata5software
   * The sha1 hash of an image rendered on a canvas. The image is a local font rendered normally.
   */
  constexpr impl::StringMetric canvasdata5software(5086);

  /**
   * generated from characteristics.canvasdata6
   * The sha1 hash of an image rendered on a canvas. The image is a local font rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata6(5087);

  /**
   * generated from characteristics.canvasdata6software
   * The sha1 hash of an image rendered on a canvas. The image is a local font rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata6software(5088);

  /**
   * generated from characteristics.canvasdata7
   * The sha1 hash of an image rendered on a canvas. The image is a system-ui font rendered normally.
   */
  constexpr impl::StringMetric canvasdata7(5089);

  /**
   * generated from characteristics.canvasdata7software
   * The sha1 hash of an image rendered on a canvas. The image is a system-ui font rendered normally.
   */
  constexpr impl::StringMetric canvasdata7software(5090);

  /**
   * generated from characteristics.canvasdata8
   * The sha1 hash of an image rendered on a canvas. The image is a system-ui font rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata8(5091);

  /**
   * generated from characteristics.canvasdata8software
   * The sha1 hash of an image rendered on a canvas. The image is a system-ui font rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata8software(5092);

  /**
   * generated from characteristics.canvasdata9
   * The sha1 hash of an image rendered on a canvas. The image is a font shipped with Firefox rendered normally.
   */
  constexpr impl::StringMetric canvasdata9(5093);

  /**
   * generated from characteristics.canvasdata9software
   * The sha1 hash of an image rendered on a canvas. The image is a font shipped with Firefox rendered normally.
   */
  constexpr impl::StringMetric canvasdata9software(5094);

  /**
   * generated from characteristics.changed_media_prefs
   * Changed media prefs and their values.
   */
  constexpr impl::StringMetric changed_media_prefs(5095);

  /**
   * generated from characteristics.channel
   * Firefox build channel
   */
  constexpr impl::StringMetric channel(5096);

  /**
   * generated from characteristics.client_identifier
   * A unique identifier for a user, not the same as the normal Telemetry client_id, but needed so we can deduplicate reports and only take the most recent one per user.
   */
  constexpr impl::UuidMetric client_identifier(5097);

  /**
   * generated from characteristics.color_accentcolor
   * The CSS system-color Accentcolor.
   */
  constexpr impl::QuantityMetric color_accentcolor(5098);

  /**
   * generated from characteristics.color_accentcolortext
   * The CSS system-color Accentcolortext.
   */
  constexpr impl::QuantityMetric color_accentcolortext(5099);

  /**
   * generated from characteristics.color_canvas
   * The CSS system-color Canvas.
   */
  constexpr impl::QuantityMetric color_canvas(5100);

  /**
   * generated from characteristics.color_canvastext
   * The CSS system-color Canvastext.
   */
  constexpr impl::QuantityMetric color_canvastext(5101);

  /**
   * generated from characteristics.color_highlight
   * The CSS system-color Highlight.
   */
  constexpr impl::QuantityMetric color_highlight(5102);

  /**
   * generated from characteristics.color_highlighttext
   * The CSS system-color Highlighttext.
   */
  constexpr impl::QuantityMetric color_highlighttext(5103);

  /**
   * generated from characteristics.color_scheme
   * The Color Scheme used for Content, from ContentPrefs() Preference Sheet.
   */
  constexpr impl::QuantityMetric color_scheme(5104);

  /**
   * generated from characteristics.color_selecteditem
   * The CSS system-color Selecteditem.
   */
  constexpr impl::QuantityMetric color_selecteditem(5105);

  /**
   * generated from characteristics.color_selecteditemtext
   * The CSS system-color Selecteditemtext.
   */
  constexpr impl::QuantityMetric color_selecteditemtext(5106);

  /**
   * generated from characteristics.cpu_arch
   * Arch of the user's device
   */
  constexpr impl::StringMetric cpu_arch(5107);

  /**
   * generated from characteristics.cpu_model
   * CPU model of the user's device
   */
  constexpr impl::StringMetric cpu_model(5108);

  /**
   * generated from characteristics.errors
   * Errors occured on C++ side of data collection
   */
  constexpr impl::TextMetric errors(5109);

  /**
   * generated from characteristics.font_default_default_group
   * The value of the font.default.<default language group> pref
   */
  constexpr impl::StringMetric font_default_default_group(5110);

  /**
   * generated from characteristics.font_default_modified
   * The number of other modified font.default prefs.
   */
  constexpr impl::QuantityMetric font_default_modified(5111);

  /**
   * generated from characteristics.font_default_western
   * The value of the font.default.x-western pref
   */
  constexpr impl::StringMetric font_default_western(5112);

  /**
   * generated from characteristics.font_minimum_size_default_group
   * The value of the font.minimum-size.<default language group> pref
   */
  constexpr impl::StringMetric font_minimum_size_default_group(5113);

  /**
   * generated from characteristics.font_minimum_size_modified
   * The number of other modified font.minimum-size prefs.
   */
  constexpr impl::QuantityMetric font_minimum_size_modified(5114);

  /**
   * generated from characteristics.font_minimum_size_western
   * The value of the font.minimum-size.x-western pref
   */
  constexpr impl::StringMetric font_minimum_size_western(5115);

  /**
   * generated from characteristics.font_name_list_cursive_modified
   * The number of modified font.name-list.cursive. prefs.
   */
  constexpr impl::QuantityMetric font_name_list_cursive_modified(5116);

  /**
   * generated from characteristics.font_name_list_emoji_modified
   * Whether the pref font.name-list.emoji was modified.
   */
  constexpr impl::BooleanMetric font_name_list_emoji_modified(5117);

  /**
   * generated from characteristics.font_name_list_monospace_modified
   * The number of modified font.name-list.monospace. prefs.
   */
  constexpr impl::QuantityMetric font_name_list_monospace_modified(5118);

  /**
   * generated from characteristics.font_name_list_sans_serif_modified
   * The number of modified font.name-list.sans-serif. prefs.
   */
  constexpr impl::QuantityMetric font_name_list_sans_serif_modified(5119);

  /**
   * generated from characteristics.font_name_list_serif_modified
   * The number of modified font.name-list.serif. prefs.
   */
  constexpr impl::QuantityMetric font_name_list_serif_modified(5120);

  /**
   * generated from characteristics.font_name_monospace_default_group
   * The value of the font.name.monospace.<default language group> pref
   */
  constexpr impl::StringMetric font_name_monospace_default_group(5121);

  /**
   * generated from characteristics.font_name_monospace_modified
   * The number of other modified font.name.monospace prefs.
   */
  constexpr impl::QuantityMetric font_name_monospace_modified(5122);

  /**
   * generated from characteristics.font_name_monospace_western
   * The value of the font.name.monospace.x-western pref
   */
  constexpr impl::StringMetric font_name_monospace_western(5123);

  /**
   * generated from characteristics.font_name_sans_serif_default_group
   * The value of the font.name.sans-serif.<default language group> pref
   */
  constexpr impl::StringMetric font_name_sans_serif_default_group(5124);

  /**
   * generated from characteristics.font_name_sans_serif_modified
   * The number of other modified font.name.sans-serif prefs.
   */
  constexpr impl::QuantityMetric font_name_sans_serif_modified(5125);

  /**
   * generated from characteristics.font_name_sans_serif_western
   * The value of the font.name.sans-serif.x-western pref
   */
  constexpr impl::StringMetric font_name_sans_serif_western(5126);

  /**
   * generated from characteristics.font_name_serif_default_group
   * The value of the font.name.serif.<default language group> pref
   */
  constexpr impl::StringMetric font_name_serif_default_group(5127);

  /**
   * generated from characteristics.font_name_serif_modified
   * The number of other modified font.name.serif prefs.
   */
  constexpr impl::QuantityMetric font_name_serif_modified(5128);

  /**
   * generated from characteristics.font_name_serif_western
   * The value of the font.name.serif.x-western pref
   */
  constexpr impl::StringMetric font_name_serif_western(5129);

  /**
   * generated from characteristics.font_size_monospace_default_group
   * The value of the font.size.monospace.<default language group> pref
   */
  constexpr impl::StringMetric font_size_monospace_default_group(5130);

  /**
   * generated from characteristics.font_size_monospace_modified
   * The number of other modified font.size.monospace prefs.
   */
  constexpr impl::QuantityMetric font_size_monospace_modified(5131);

  /**
   * generated from characteristics.font_size_monospace_western
   * The value of the font.size.monospace.x-western pref
   */
  constexpr impl::StringMetric font_size_monospace_western(5132);

  /**
   * generated from characteristics.font_size_variable_default_group
   * The value of the font.size.variable.<default language group> pref
   */
  constexpr impl::StringMetric font_size_variable_default_group(5133);

  /**
   * generated from characteristics.font_size_variable_modified
   * The number of other modified font.size.variable prefs.
   */
  constexpr impl::QuantityMetric font_size_variable_modified(5134);

  /**
   * generated from characteristics.font_size_variable_western
   * The value of the font.size.variable.x-western pref
   */
  constexpr impl::StringMetric font_size_variable_western(5135);

  /**
   * generated from characteristics.fonts_fpjs_allowlisted
   * SHA256 of allowlisted fonts queried by FPJS
   */
  constexpr impl::StringMetric fonts_fpjs_allowlisted(5136);

  /**
   * generated from characteristics.fonts_fpjs_nonallowlisted
   * SHA256 of non-allowlisted fonts queried by FPJS
   */
  constexpr impl::StringMetric fonts_fpjs_nonallowlisted(5137);

  /**
   * generated from characteristics.fonts_variant_a_allowlisted
   * SHA256 of allowlisted fonts queried of variant A
   */
  constexpr impl::StringMetric fonts_variant_a_allowlisted(5138);

  /**
   * generated from characteristics.fonts_variant_a_nonallowlisted
   * SHA256 of non-allowlisted fonts queried of variant A
   */
  constexpr impl::StringMetric fonts_variant_a_nonallowlisted(5139);

  /**
   * generated from characteristics.fonts_variant_b_allowlisted
   * SHA256 of allowlisted fonts queried of variant B
   */
  constexpr impl::StringMetric fonts_variant_b_allowlisted(5140);

  /**
   * generated from characteristics.fonts_variant_b_nonallowlisted
   * SHA256 of non-allowlisted fonts queried of variant B
   */
  constexpr impl::StringMetric fonts_variant_b_nonallowlisted(5141);

  /**
   * generated from characteristics.gamepads
   * The information of the gamepads inserted on the user device. Each string represents one gamepad. We use a JSON array to describe a gamepad, every value represents one property of the gamepad. Following are the details:
   *   index 0: The ID of the game pad
   *   index 1: Which hand for the gamepad.
   *   index 2: Number of buttons
   *   index 3: Number of axes
   *   index 4: Number of haptics
   *   index 5: Number of lights
   *   index 6: Number of touches
   */
  constexpr impl::StringListMetric gamepads(5142);

  /**
   * generated from characteristics.gl2_context_type
   * The type of the GL context (EGL, GLX, WGL, etc).
   */
  constexpr impl::StringMetric gl2_context_type(5143);

  /**
   * generated from characteristics.gl2_context_type_software
   * The type of the GL context (EGL, GLX, WGL, etc).
   */
  constexpr impl::StringMetric gl2_context_type_software(5144);

  /**
   * generated from characteristics.gl2_extensions
   * The list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl2_extensions(5145);

  /**
   * generated from characteristics.gl2_extensions_raw
   * The raw list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl2_extensions_raw(5146);

  /**
   * generated from characteristics.gl2_extensions_raw_software
   * The raw list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl2_extensions_raw_software(5147);

  /**
   * generated from characteristics.gl2_extensions_software
   * The list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl2_extensions_software(5148);

  /**
   * generated from characteristics.gl2_fragment_shader
   * Hash of the transformed source of the fragment shader.
   */
  constexpr impl::StringMetric gl2_fragment_shader(5149);

  /**
   * generated from characteristics.gl2_fragment_shader_software
   * Hash of the transformed source of the fragment shader.
   */
  constexpr impl::StringMetric gl2_fragment_shader_software(5150);

  /**
   * generated from characteristics.gl2_minimal_source
   * Transformed source of the minimal shader.
   */
  constexpr impl::TextMetric gl2_minimal_source(5151);

  /**
   * generated from characteristics.gl2_minimal_source_software
   * Transformed source of the minimal shader.
   */
  constexpr impl::TextMetric gl2_minimal_source_software(5152);

  /**
   * generated from characteristics.gl2_params
   * The list of GL parameters of GL2.
   */
  constexpr impl::TextMetric gl2_params(5153);

  /**
   * generated from characteristics.gl2_params_extensions
   * The list of GL parameters of the extensions.
   */
  constexpr impl::TextMetric gl2_params_extensions(5154);

  /**
   * generated from characteristics.gl2_params_extensions_software
   * The list of GL parameters of the extensions.
   */
  constexpr impl::TextMetric gl2_params_extensions_software(5155);

  /**
   * generated from characteristics.gl2_params_software
   * The list of GL parameters of GL2.
   */
  constexpr impl::TextMetric gl2_params_software(5156);

  /**
   * generated from characteristics.gl2_precision_fragment
   * Precisions of the fragment shader.
   */
  constexpr impl::TextMetric gl2_precision_fragment(5157);

  /**
   * generated from characteristics.gl2_precision_fragment_software
   * Precisions of the fragment shader.
   */
  constexpr impl::TextMetric gl2_precision_fragment_software(5158);

  /**
   * generated from characteristics.gl2_precision_vertex
   * Precisions of the vertex shader.
   */
  constexpr impl::TextMetric gl2_precision_vertex(5159);

  /**
   * generated from characteristics.gl2_precision_vertex_software
   * Precisions of the vertex shader.
   */
  constexpr impl::TextMetric gl2_precision_vertex_software(5160);

  /**
   * generated from characteristics.gl2_renderer
   * The OpenGL renderer string.
   */
  constexpr impl::StringMetric gl2_renderer(5161);

  /**
   * generated from characteristics.gl2_renderer_raw
   * The raw OpenGL renderer string.
   */
  constexpr impl::StringMetric gl2_renderer_raw(5162);

  /**
   * generated from characteristics.gl2_renderer_raw_software
   * The raw OpenGL renderer string.
   */
  constexpr impl::StringMetric gl2_renderer_raw_software(5163);

  /**
   * generated from characteristics.gl2_renderer_software
   * The OpenGL renderer string.
   */
  constexpr impl::StringMetric gl2_renderer_software(5164);

  /**
   * generated from characteristics.gl2_vendor
   * The OpenGL vendor string.
   */
  constexpr impl::StringMetric gl2_vendor(5165);

  /**
   * generated from characteristics.gl2_vendor_raw
   * The raw OpenGL vendor string.
   */
  constexpr impl::StringMetric gl2_vendor_raw(5166);

  /**
   * generated from characteristics.gl2_vendor_raw_software
   * The raw OpenGL vendor string.
   */
  constexpr impl::StringMetric gl2_vendor_raw_software(5167);

  /**
   * generated from characteristics.gl2_vendor_software
   * The OpenGL vendor string.
   */
  constexpr impl::StringMetric gl2_vendor_software(5168);

  /**
   * generated from characteristics.gl2_version_raw
   * The raw OpenGL version string.
   */
  constexpr impl::StringMetric gl2_version_raw(5169);

  /**
   * generated from characteristics.gl2_version_raw_software
   * The raw OpenGL version string.
   */
  constexpr impl::StringMetric gl2_version_raw_software(5170);

  /**
   * generated from characteristics.gl2_vertex_shader
   * Hash of the transformed source of the vertex shader.
   */
  constexpr impl::StringMetric gl2_vertex_shader(5171);

  /**
   * generated from characteristics.gl2_vertex_shader_software
   * Hash of the transformed source of the vertex shader.
   */
  constexpr impl::StringMetric gl2_vertex_shader_software(5172);

  /**
   * generated from characteristics.gl_context_type
   * The type of the GL context (EGL, GLX, WGL, etc).
   */
  constexpr impl::StringMetric gl_context_type(5173);

  /**
   * generated from characteristics.gl_context_type_software
   * The type of the GL context (EGL, GLX, WGL, etc).
   */
  constexpr impl::StringMetric gl_context_type_software(5174);

  /**
   * generated from characteristics.gl_extensions
   * The list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl_extensions(5175);

  /**
   * generated from characteristics.gl_extensions_raw
   * The raw list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl_extensions_raw(5176);

  /**
   * generated from characteristics.gl_extensions_raw_software
   * The raw list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl_extensions_raw_software(5177);

  /**
   * generated from characteristics.gl_extensions_software
   * The list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl_extensions_software(5178);

  /**
   * generated from characteristics.gl_fragment_shader
   * Hash of the transformed source of the fragment shader.
   */
  constexpr impl::StringMetric gl_fragment_shader(5179);

  /**
   * generated from characteristics.gl_fragment_shader_software
   * Hash of the transformed source of the fragment shader.
   */
  constexpr impl::StringMetric gl_fragment_shader_software(5180);

  /**
   * generated from characteristics.gl_minimal_source
   * Transformed source of the minimal shader.
   */
  constexpr impl::TextMetric gl_minimal_source(5181);

  /**
   * generated from characteristics.gl_minimal_source_software
   * Transformed source of the minimal shader.
   */
  constexpr impl::TextMetric gl_minimal_source_software(5182);

  /**
   * generated from characteristics.gl_params
   * The list of GL parameters of GL1.
   */
  constexpr impl::TextMetric gl_params(5183);

  /**
   * generated from characteristics.gl_params_extensions
   * The list of GL parameters of the extensions.
   */
  constexpr impl::TextMetric gl_params_extensions(5184);

  /**
   * generated from characteristics.gl_params_extensions_software
   * The list of GL parameters of the extensions.
   */
  constexpr impl::TextMetric gl_params_extensions_software(5185);

  /**
   * generated from characteristics.gl_params_software
   * The list of GL parameters of GL1.
   */
  constexpr impl::TextMetric gl_params_software(5186);

  /**
   * generated from characteristics.gl_precision_fragment
   * Precisions of the fragment shader.
   */
  constexpr impl::TextMetric gl_precision_fragment(5187);

  /**
   * generated from characteristics.gl_precision_fragment_software
   * Precisions of the fragment shader.
   */
  constexpr impl::TextMetric gl_precision_fragment_software(5188);

  /**
   * generated from characteristics.gl_precision_vertex
   * Precisions of the vertex shader.
   */
  constexpr impl::TextMetric gl_precision_vertex(5189);

  /**
   * generated from characteristics.gl_precision_vertex_software
   * Precisions of the vertex shader.
   */
  constexpr impl::TextMetric gl_precision_vertex_software(5190);

  /**
   * generated from characteristics.gl_renderer
   * The OpenGL renderer string.
   */
  constexpr impl::StringMetric gl_renderer(5191);

  /**
   * generated from characteristics.gl_renderer_raw
   * The raw OpenGL renderer string.
   */
  constexpr impl::StringMetric gl_renderer_raw(5192);

  /**
   * generated from characteristics.gl_renderer_raw_software
   * The raw OpenGL renderer string.
   */
  constexpr impl::StringMetric gl_renderer_raw_software(5193);

  /**
   * generated from characteristics.gl_renderer_software
   * The OpenGL renderer string.
   */
  constexpr impl::StringMetric gl_renderer_software(5194);

  /**
   * generated from characteristics.gl_vendor
   * The OpenGL vendor string.
   */
  constexpr impl::StringMetric gl_vendor(5195);

  /**
   * generated from characteristics.gl_vendor_raw
   * The raw OpenGL vendor string.
   */
  constexpr impl::StringMetric gl_vendor_raw(5196);

  /**
   * generated from characteristics.gl_vendor_raw_software
   * The raw OpenGL vendor string.
   */
  constexpr impl::StringMetric gl_vendor_raw_software(5197);

  /**
   * generated from characteristics.gl_vendor_software
   * The OpenGL vendor string.
   */
  constexpr impl::StringMetric gl_vendor_software(5198);

  /**
   * generated from characteristics.gl_version_raw
   * The raw OpenGL version string.
   */
  constexpr impl::StringMetric gl_version_raw(5199);

  /**
   * generated from characteristics.gl_version_raw_software
   * The raw OpenGL version string.
   */
  constexpr impl::StringMetric gl_version_raw_software(5200);

  /**
   * generated from characteristics.gl_vertex_shader
   * Hash of the transformed source of the vertex shader.
   */
  constexpr impl::StringMetric gl_vertex_shader(5201);

  /**
   * generated from characteristics.gl_vertex_shader_software
   * Hash of the transformed source of the vertex shader.
   */
  constexpr impl::StringMetric gl_vertex_shader_software(5202);

  /**
   * generated from characteristics.group_count
   * Number of device groups reported by the device.
   */
  constexpr impl::QuantityMetric group_count(5203);

  /**
   * generated from characteristics.group_count_wo_speakers
   * Number of device groups without speakers reported by the device.
   */
  constexpr impl::QuantityMetric group_count_wo_speakers(5204);

  /**
   * generated from characteristics.ice_order
   * Unique ICE foundations occurrence count
   */
  constexpr impl::QuantityMetric ice_order(5205);

  /**
   * generated from characteristics.ice_sd
   * ICE foundation discovery latency standard deviation sum multiplied by 1000
   */
  constexpr impl::QuantityMetric ice_sd(5206);

  /**
   * generated from characteristics.inner_height
   * Inner height of user's browser.
   */
  constexpr impl::QuantityMetric inner_height(5207);

  /**
   * generated from characteristics.inner_width
   * Inner width of user's browser.
   */
  constexpr impl::QuantityMetric inner_width(5208);

  /**
   * generated from characteristics.intl_locale
   * Locale information provided by Intl
   */
  constexpr impl::StringMetric intl_locale(5209);

  /**
   * generated from characteristics.inverted_colors
   * What LookAndFeel(InvertedColors) reports.
   */
  constexpr impl::BooleanMetric inverted_colors(5210);

  /**
   * generated from characteristics.js_errors
   * Errors occured on JavaScript side of data collection
   */
  constexpr impl::TextMetric js_errors(5211);

  /**
   * generated from characteristics.keyboard_layout
   * Name of the current keyboard layout.
   */
  constexpr impl::StringMetric keyboard_layout(5212);

  /**
   * generated from characteristics.languages
   * Languages the user set. Returns intl.accept_languages pref, if it is empty, returns the first matched OS's language or the default language.
   */
  constexpr impl::StringMetric languages(5213);

  /**
   * generated from characteristics.machine_model_name
   * Machine model name
   */
  constexpr impl::StringMetric machine_model_name(5214);

  /**
   * generated from characteristics.math_ops
   * Result of fingerprintable math operations
   */
  constexpr impl::TextMetric math_ops(5215);

  /**
   * generated from characteristics.math_ops_fdlibm
   * Windows only fdlibm math operation results
   */
  constexpr impl::TextMetric math_ops_fdlibm(5216);

  /**
   * generated from characteristics.mathml1
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml1(5217);

  /**
   * generated from characteristics.mathml10
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml10(5218);

  /**
   * generated from characteristics.mathml2
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml2(5219);

  /**
   * generated from characteristics.mathml3
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml3(5220);

  /**
   * generated from characteristics.mathml4
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml4(5221);

  /**
   * generated from characteristics.mathml5
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml5(5222);

  /**
   * generated from characteristics.mathml6
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml6(5223);

  /**
   * generated from characteristics.mathml7
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml7(5224);

  /**
   * generated from characteristics.mathml8
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml8(5225);

  /**
   * generated from characteristics.mathml9
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml9(5226);

  /**
   * generated from characteristics.max_touch_points
   * The number of touch points we will report to the web. On Android, this is based on Android's FEATURE_TOUCHSCREEN* constants - Mozilla caps this at 5 as Android stops distinguishing between numbers greater than 5.  On Windows this comes from the SM_MAXIMUMTOUCHES System Metric.
   */
  constexpr impl::QuantityMetric max_touch_points(5227);

  /**
   * generated from characteristics.media_capabilities_h264
   * Levels of support for H264 codec.
   */
  constexpr impl::TextMetric media_capabilities_h264(5228);

  /**
   * generated from characteristics.media_capabilities_not_efficient
   * Which, if any, media types are not power efficient.
   */
  constexpr impl::TextMetric media_capabilities_not_efficient(5229);

  /**
   * generated from characteristics.media_capabilities_not_smooth
   * Which, if any, media types are not smooth.
   */
  constexpr impl::TextMetric media_capabilities_not_smooth(5230);

  /**
   * generated from characteristics.media_capabilities_unsupported
   * Which, if any, media types are not supported.
   */
  constexpr impl::TextMetric media_capabilities_unsupported(5231);

  /**
   * generated from characteristics.microphone_count
   * Number of microphones available on the device.
   */
  constexpr impl::QuantityMetric microphone_count(5232);

  /**
   * generated from characteristics.missing_fonts
   * If a Font List is available for the user's platform, this string_list contains the fonts that are missing from the user's computer.
   */
  constexpr impl::TextMetric missing_fonts(5233);

  /**
   * generated from characteristics.monochrome
   * Whether the user's device is monochrome
   */
  constexpr impl::BooleanMetric monochrome(5234);

  /**
   * generated from characteristics.motion_decimals
   * devicemotion event's decimal places count
   */
  constexpr impl::QuantityMetric motion_decimals(5235);

  /**
   * generated from characteristics.motion_freq
   * devicemotion event's frequency
   */
  constexpr impl::QuantityMetric motion_freq(5236);

  /**
   * generated from characteristics.orientation_decimals
   * deviceorientation event's decimal places count
   */
  constexpr impl::QuantityMetric orientation_decimals(5237);

  /**
   * generated from characteristics.orientation_freq
   * deviceorientation event's frequency
   */
  constexpr impl::QuantityMetric orientation_freq(5238);

  /**
   * generated from characteristics.orientationabs_decimals
   * deviceorientationabsolute event's decimal places count
   */
  constexpr impl::QuantityMetric orientationabs_decimals(5239);

  /**
   * generated from characteristics.orientationabs_freq
   * deviceorientationabsolute event's frequency
   */
  constexpr impl::QuantityMetric orientationabs_freq(5240);

  /**
   * generated from characteristics.os_name
   * User's OS name
   */
  constexpr impl::StringMetric os_name(5241);

  /**
   * generated from characteristics.os_version
   * User's OS version
   */
  constexpr impl::StringMetric os_version(5242);

  /**
   * generated from characteristics.oscpu
   * User's OS CPU reported by the navigator
   */
  constexpr impl::StringMetric oscpu(5243);

  /**
   * generated from characteristics.outer_height
   * Outer height of user's browser.
   */
  constexpr impl::QuantityMetric outer_height(5244);

  /**
   * generated from characteristics.outer_width
   * Outer width of user's browser.
   */
  constexpr impl::QuantityMetric outer_width(5245);

  /**
   * generated from characteristics.pdf_viewer
   * PDF viewer support reported by the navigator
   */
  constexpr impl::BooleanMetric pdf_viewer(5246);

  /**
   * generated from characteristics.pixel_ratio
   * The value of window.devicePixelRatio
   */
  constexpr impl::StringMetric pixel_ratio(5247);

  /**
   * generated from characteristics.platform
   * Platform reported by the navigator
   */
  constexpr impl::StringMetric platform(5248);

  /**
   * generated from characteristics.pointer_height
   * Height of user's pointer
   */
  constexpr impl::QuantityMetric pointer_height(5249);

  /**
   * generated from characteristics.pointer_pressure
   * Pressure of user's pointer
   */
  constexpr impl::StringMetric pointer_pressure(5250);

  /**
   * generated from characteristics.pointer_tangentinal_pressure
   * Tangential Pressure of user's pointer
   */
  constexpr impl::StringMetric pointer_tangentinal_pressure(5251);

  /**
   * generated from characteristics.pointer_tiltx
   * TiltX of user's pointer
   */
  constexpr impl::QuantityMetric pointer_tiltx(5252);

  /**
   * generated from characteristics.pointer_tilty
   * TiltY of user's pointer
   */
  constexpr impl::QuantityMetric pointer_tilty(5253);

  /**
   * generated from characteristics.pointer_twist
   * Twist of user's pointer
   */
  constexpr impl::QuantityMetric pointer_twist(5254);

  /**
   * generated from characteristics.pointer_type
   * Pointer type of the user's primary pointer device.
   */
  constexpr impl::QuantityMetric pointer_type(5255);

  /**
   * generated from characteristics.pointer_width
   * Width of user's pointer
   */
  constexpr impl::QuantityMetric pointer_width(5256);

  /**
   * generated from characteristics.prefers_contrast
   * What Gecko_MediaFeatures_PrefersContrast reports for a ContentDocument
   */
  constexpr impl::QuantityMetric prefers_contrast(5257);

  /**
   * generated from characteristics.prefers_reduced_motion
   * What LookAndFeel(PrefersReducedMotion) reports.
   */
  constexpr impl::BooleanMetric prefers_reduced_motion(5258);

  /**
   * generated from characteristics.prefers_reduced_transparency
   * What LookAndFeel(PrefersReducedTransparency) reports.
   */
  constexpr impl::BooleanMetric prefers_reduced_transparency(5259);

  /**
   * generated from characteristics.prefs_block_popups
   * Block pop-up windows (The dom.disable_open_during_load pref)
   */
  constexpr impl::BooleanMetric prefs_block_popups(5260);

  /**
   * generated from characteristics.prefs_browser_display_use_document_fonts
   * Allow pages to choose their own fonts.
   */
  constexpr impl::BooleanMetric prefs_browser_display_use_document_fonts(5261);

  /**
   * generated from characteristics.prefs_general_autoscroll
   * Use autoscrolling
   */
  constexpr impl::BooleanMetric prefs_general_autoscroll(5262);

  /**
   * generated from characteristics.prefs_general_smoothscroll
   * Use smooth scrolling
   */
  constexpr impl::BooleanMetric prefs_general_smoothscroll(5263);

  /**
   * generated from characteristics.prefs_intl_accept_languages
   * Value of the intl.accept_languages pref.
   */
  constexpr impl::StringMetric prefs_intl_accept_languages(5264);

  /**
   * generated from characteristics.prefs_media_eme_enabled
   * Value of the media.eme.enabled pref.
   */
  constexpr impl::BooleanMetric prefs_media_eme_enabled(5265);

  /**
   * generated from characteristics.prefs_network_cookie_cookiebehavior
   * Value of the network.cookie.cookieBehavior pref.
   */
  constexpr impl::QuantityMetric prefs_network_cookie_cookiebehavior(5266);

  /**
   * generated from characteristics.prefs_overlay_scrollbars
   * Use overlay scrollbars (or otherwise "Always show scrollbars")
   */
  constexpr impl::BooleanMetric prefs_overlay_scrollbars(5267);

  /**
   * generated from characteristics.prefs_privacy_donottrackheader_enabled
   * Sending "do not track" HTTP header
   */
  constexpr impl::BooleanMetric prefs_privacy_donottrackheader_enabled(5268);

  /**
   * generated from characteristics.prefs_privacy_globalprivacycontrol_enabled
   * Sending "global privacy control" HTTP header
   */
  constexpr impl::BooleanMetric prefs_privacy_globalprivacycontrol_enabled(5269);

  /**
   * generated from characteristics.prefs_zoom_text_only
   * Text-only zoom enabled (vs. full-zoom)
   */
  constexpr impl::BooleanMetric prefs_zoom_text_only(5270);

  /**
   * generated from characteristics.processor_count
   * Number of processors.
   */
  constexpr impl::QuantityMetric processor_count(5271);

  /**
   * generated from characteristics.screen_height
   * Screen height from a window.
   */
  constexpr impl::QuantityMetric screen_height(5272);

  /**
   * generated from characteristics.screen_width
   * Screen width from a window.
   */
  constexpr impl::QuantityMetric screen_width(5273);

  /**
   * generated from characteristics.screens
   * JSON string of screen properties
   */
  constexpr impl::TextMetric screens(5274);

  /**
   * generated from characteristics.size_mode
   * Whether window is maximized, minimized, normal or fullscreen
   */
  constexpr impl::QuantityMetric size_mode(5275);

  /**
   * generated from characteristics.speaker_count
   * Number of speakers available on the device.
   */
  constexpr impl::QuantityMetric speaker_count(5276);

  /**
   * generated from characteristics.submission_schema
   * An incrementing constant that represents the current schema/source of the data present in a ping. By referring to this value in a ping, one can know for certain the provenance of other data present in the ping, and what data may or may not be present.
   */
  constexpr impl::QuantityMetric submission_schema(5277);

  /**
   * generated from characteristics.system_locale
   * The locale used by the host OS for localization.
   */
  constexpr impl::StringMetric system_locale(5278);

  /**
   * generated from characteristics.target_frame_rate
   * The target frame rate in frames-per-second.
   */
  constexpr impl::QuantityMetric target_frame_rate(5279);

  /**
   * generated from characteristics.text_anti_aliasing
   * Font anti aliasing level
   */
  constexpr impl::StringMetric text_anti_aliasing(5280);

  /**
   * generated from characteristics.timezone
   * The the current timezone of the system
   */
  constexpr impl::StringMetric timezone(5281);

  /**
   * generated from characteristics.touch_rotation_angle
   * Rotation angle of user's touch
   */
  constexpr impl::StringMetric touch_rotation_angle(5282);

  /**
   * generated from characteristics.use_document_colors
   * This is the derived PreferenceSheet::Prefs::mUseDocumentColors value.
   */
  constexpr impl::BooleanMetric use_document_colors(5283);

  /**
   * generated from characteristics.user_agent
   * User agent string
   */
  constexpr impl::TextMetric user_agent(5284);

  /**
   * generated from characteristics.using_accelerated_canvas
   * Whether the user's device is using accelerated canvas
   */
  constexpr impl::BooleanMetric using_accelerated_canvas(5285);

  /**
   * generated from characteristics.version
   * Firefox build version
   */
  constexpr impl::StringMetric version(5286);

  /**
   * generated from characteristics.voices_all_ssdeep
   * ssdeep hash of all speechSynthesis voices.
   */
  constexpr impl::StringMetric voices_all_ssdeep(5287);

  /**
   * generated from characteristics.voices_count
   * Number of speechSynthesis voices available to the user.
   */
  constexpr impl::QuantityMetric voices_count(5288);

  /**
   * generated from characteristics.voices_default
   * The default speechSynthesis voice.
   */
  constexpr impl::StringMetric voices_default(5289);

  /**
   * generated from characteristics.voices_local_count
   * Number of local speechSynthesis voices available to the user.
   */
  constexpr impl::QuantityMetric voices_local_count(5290);

  /**
   * generated from characteristics.voices_local_ssdeep
   * ssdeep hash of local speechSynthesis voices.
   */
  constexpr impl::StringMetric voices_local_ssdeep(5291);

  /**
   * generated from characteristics.voices_nonlocal_ssdeep
   * ssdeep hash of non-local speechSynthesis voices.
   */
  constexpr impl::StringMetric voices_nonlocal_ssdeep(5292);

  /**
   * generated from characteristics.voices_sample
   * Names of 5 sample speechSynthesis voices.
   */
  constexpr impl::TextMetric voices_sample(5293);

  /**
   * generated from characteristics.voices_sha1
   * SHA1 hash of all the voices.
   */
  constexpr impl::TextMetric voices_sha1(5294);

  /**
   * generated from characteristics.wgpu_maxbindgroups
   * WebGPU limit maxBindGroups
   */
  constexpr impl::QuantityMetric wgpu_maxbindgroups(5295);

  /**
   * generated from characteristics.wgpu_maxbindgroupsplusvertexbuffers
   * WebGPU limit maxBindGroupsPlusVertexBuffers
   */
  constexpr impl::QuantityMetric wgpu_maxbindgroupsplusvertexbuffers(5296);

  /**
   * generated from characteristics.wgpu_maxbindingsperbindgroup
   * WebGPU limit maxBindingsPerBindGroup
   */
  constexpr impl::QuantityMetric wgpu_maxbindingsperbindgroup(5297);

  /**
   * generated from characteristics.wgpu_maxbuffersize
   * WebGPU limit maxBufferSize
   */
  constexpr impl::QuantityMetric wgpu_maxbuffersize(5298);

  /**
   * generated from characteristics.wgpu_maxcolorattachmentbytespersample
   * WebGPU limit maxColorAttachmentBytesPerSample
   */
  constexpr impl::QuantityMetric wgpu_maxcolorattachmentbytespersample(5299);

  /**
   * generated from characteristics.wgpu_maxcolorattachments
   * WebGPU limit maxColorAttachments
   */
  constexpr impl::QuantityMetric wgpu_maxcolorattachments(5300);

  /**
   * generated from characteristics.wgpu_maxcomputeinvocationsperworkgroup
   * WebGPU limit maxComputeInvocationsPerWorkgroup
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeinvocationsperworkgroup(5301);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupsizex
   * WebGPU limit maxComputeWorkgroupSizeX
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupsizex(5302);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupsizey
   * WebGPU limit maxComputeWorkgroupSizeY
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupsizey(5303);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupsizez
   * WebGPU limit maxComputeWorkgroupSizeZ
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupsizez(5304);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupsperdimension
   * WebGPU limit maxComputeWorkgroupsPerDimension
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupsperdimension(5305);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupstoragesize
   * WebGPU limit maxComputeWorkgroupStorageSize
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupstoragesize(5306);

  /**
   * generated from characteristics.wgpu_maxdynamicstoragebuffersperpipelinelayout
   * WebGPU limit maxDynamicStorageBuffersPerPipelineLayout
   */
  constexpr impl::QuantityMetric wgpu_maxdynamicstoragebuffersperpipelinelayout(5307);

  /**
   * generated from characteristics.wgpu_maxdynamicuniformbuffersperpipelinelayout
   * WebGPU limit maxDynamicUniformBuffersPerPipelineLayout
   */
  constexpr impl::QuantityMetric wgpu_maxdynamicuniformbuffersperpipelinelayout(5308);

  /**
   * generated from characteristics.wgpu_maxinterstageshadervariables
   * WebGPU limit maxInterStageShaderVariables
   */
  constexpr impl::QuantityMetric wgpu_maxinterstageshadervariables(5309);

  /**
   * generated from characteristics.wgpu_maxsampledtexturespershaderstage
   * WebGPU limit maxSampledTexturesPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxsampledtexturespershaderstage(5310);

  /**
   * generated from characteristics.wgpu_maxsamplerspershaderstage
   * WebGPU limit maxSamplersPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxsamplerspershaderstage(5311);

  /**
   * generated from characteristics.wgpu_maxstoragebufferbindingsize
   * WebGPU limit maxStorageBufferBindingSize
   */
  constexpr impl::QuantityMetric wgpu_maxstoragebufferbindingsize(5312);

  /**
   * generated from characteristics.wgpu_maxstoragebufferspershaderstage
   * WebGPU limit maxStorageBuffersPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxstoragebufferspershaderstage(5313);

  /**
   * generated from characteristics.wgpu_maxstoragetexturespershaderstage
   * WebGPU limit maxStorageTexturesPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxstoragetexturespershaderstage(5314);

  /**
   * generated from characteristics.wgpu_maxtexturearraylayers
   * WebGPU limit maxTextureArrayLayers
   */
  constexpr impl::QuantityMetric wgpu_maxtexturearraylayers(5315);

  /**
   * generated from characteristics.wgpu_maxtexturedimension1d
   * WebGPU limit maxTextureDimension1D
   */
  constexpr impl::QuantityMetric wgpu_maxtexturedimension1d(5316);

  /**
   * generated from characteristics.wgpu_maxtexturedimension2d
   * WebGPU limit maxTextureDimension2D
   */
  constexpr impl::QuantityMetric wgpu_maxtexturedimension2d(5317);

  /**
   * generated from characteristics.wgpu_maxtexturedimension3d
   * WebGPU limit maxTextureDimension3D
   */
  constexpr impl::QuantityMetric wgpu_maxtexturedimension3d(5318);

  /**
   * generated from characteristics.wgpu_maxuniformbufferbindingsize
   * WebGPU limit maxUniformBufferBindingSize
   */
  constexpr impl::QuantityMetric wgpu_maxuniformbufferbindingsize(5319);

  /**
   * generated from characteristics.wgpu_maxuniformbufferspershaderstage
   * WebGPU limit maxUniformBuffersPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxuniformbufferspershaderstage(5320);

  /**
   * generated from characteristics.wgpu_maxvertexattributes
   * WebGPU limit maxVertexAttributes
   */
  constexpr impl::QuantityMetric wgpu_maxvertexattributes(5321);

  /**
   * generated from characteristics.wgpu_maxvertexbufferarraystride
   * WebGPU limit maxVertexBufferArrayStride
   */
  constexpr impl::QuantityMetric wgpu_maxvertexbufferarraystride(5322);

  /**
   * generated from characteristics.wgpu_maxvertexbuffers
   * WebGPU limit maxVertexBuffers
   */
  constexpr impl::QuantityMetric wgpu_maxvertexbuffers(5323);

  /**
   * generated from characteristics.wgpu_minstoragebufferoffsetalignment
   * WebGPU limit minStorageBufferOffsetAlignment
   */
  constexpr impl::QuantityMetric wgpu_minstoragebufferoffsetalignment(5324);

  /**
   * generated from characteristics.wgpu_minuniformbufferoffsetalignment
   * WebGPU limit minUniformBufferOffsetAlignment
   */
  constexpr impl::QuantityMetric wgpu_minuniformbufferoffsetalignment(5325);

  /**
   * generated from characteristics.wgpu_missing_features
   * Missing features of WebGPU as a bitset
   */
  constexpr impl::StringMetric wgpu_missing_features(5326);

  /**
   * generated from characteristics.zoom_count
   * Number of domains the users has a non-default zoom level.
   */
  constexpr impl::QuantityMetric zoom_count(5327);
}

namespace fingerprinting_protection {
  /**
   * generated from fingerprinting.protection.canvas_noise_calculate_time_2
   * Counts how long to generate canvas random noises.
   */
  constexpr impl::TimingDistributionMetric canvas_noise_calculate_time_2(5328);
}

} // namespace mozilla::glean

#endif // mozilla_GleanResistfingerprintingMetrics_h
