// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanNimbusMetrics_h
#define mozilla_GleanNimbusMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace nimbus_events {
  /**
   * generated from nimbus_events.enroll_failed
   */
  struct EnrollFailedExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> experiment;
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (experiment) {
        extraKeys.AppendElement()->AssignASCII("experiment");
        extraValues.EmplaceBack(experiment.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when an enrollment fails, including the reason for the failure.
   */
  constexpr impl::EventMetric<EnrollFailedExtra> enroll_failed(4720);

  /**
   * generated from nimbus_events.enrollment
   */
  struct EnrollmentExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> experiment;
    mozilla::Maybe<nsCString> experimentType;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (experiment) {
        extraKeys.AppendElement()->AssignASCII("experiment");
        extraValues.EmplaceBack(experiment.value());
      }
      if (experimentType) {
        extraKeys.AppendElement()->AssignASCII("experiment_type");
        extraValues.EmplaceBack(experimentType.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user has met the conditions and is first bucketed into an experiment (i.e. targeting matched and they were randomized into a bucket and branch of the experiment). Expected a maximum of once per experiment per user.
   */
  constexpr impl::EventMetric<EnrollmentExtra> enrollment(4721);

  /**
   * generated from nimbus_events.enrollment_status
   */
  struct EnrollmentStatusExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> conflictSlug;
    mozilla::Maybe<nsCString> errorString;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> slug;
    mozilla::Maybe<nsCString> status;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (conflictSlug) {
        extraKeys.AppendElement()->AssignASCII("conflict_slug");
        extraValues.EmplaceBack(conflictSlug.value());
      }
      if (errorString) {
        extraKeys.AppendElement()->AssignASCII("error_string");
        extraValues.EmplaceBack(errorString.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (slug) {
        extraKeys.AppendElement()->AssignASCII("slug");
        extraValues.EmplaceBack(slug.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded for each enrollment status each time the SDK completes application of pending experiments.
   */
  constexpr impl::EventMetric<EnrollmentStatusExtra> enrollment_status(4722);

  /**
   * generated from nimbus_events.exposure
   */
  struct ExposureExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> experiment;
    mozilla::Maybe<nsCString> featureId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (experiment) {
        extraKeys.AppendElement()->AssignASCII("experiment");
        extraValues.EmplaceBack(experiment.value());
      }
      if (featureId) {
        extraKeys.AppendElement()->AssignASCII("feature_id");
        extraValues.EmplaceBack(featureId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user actually observes an experimental treatment, or would have observed an experimental treatment if they had been in a branch that would have shown one.
   */
  constexpr impl::EventMetric<ExposureExtra> exposure(4723);

  /**
   * generated from nimbus_events.is_ready
   */
  /**
   * An event sent when Nimbus is ready — sent upon completion of each update of the recipes.
   */
  constexpr impl::EventMetric<NoExtraKeys> is_ready(4724);

  /**
   * generated from nimbus_events.migration
   */
  struct MigrationExtra {
    mozilla::Maybe<nsCString> enrollments;
    mozilla::Maybe<nsCString> errorReason;
    mozilla::Maybe<nsCString> migrationId;
    mozilla::Maybe<bool> success;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (enrollments) {
        extraKeys.AppendElement()->AssignASCII("enrollments");
        extraValues.EmplaceBack(enrollments.value());
      }
      if (errorReason) {
        extraKeys.AppendElement()->AssignASCII("error_reason");
        extraValues.EmplaceBack(errorReason.value());
      }
      if (migrationId) {
        extraKeys.AppendElement()->AssignASCII("migration_id");
        extraValues.EmplaceBack(migrationId.value());
      }
      if (success) {
        extraKeys.AppendElement()->AssignASCII("success");
        extraValues.AppendElement()->AssignASCII(success.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggered whenever a Nimbus migration is attempted, whether or not it succeeds.
   */
  constexpr impl::EventMetric<MigrationExtra> migration(4725);

  /**
   * generated from nimbus_events.unenroll_failed
   */
  struct UnenrollFailedExtra {
    mozilla::Maybe<nsCString> experiment;
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (experiment) {
        extraKeys.AppendElement()->AssignASCII("experiment");
        extraValues.EmplaceBack(experiment.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when an unenrollment fails, including the reason for the failure.
   */
  constexpr impl::EventMetric<UnenrollFailedExtra> unenroll_failed(4726);

  /**
   * generated from nimbus_events.unenrollment
   */
  struct UnenrollmentExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> changedPref;
    mozilla::Maybe<nsCString> conflictingSlug;
    mozilla::Maybe<nsCString> experiment;
    mozilla::Maybe<nsCString> prefName;
    mozilla::Maybe<nsCString> prefType;
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (changedPref) {
        extraKeys.AppendElement()->AssignASCII("changed_pref");
        extraValues.EmplaceBack(changedPref.value());
      }
      if (conflictingSlug) {
        extraKeys.AppendElement()->AssignASCII("conflicting_slug");
        extraValues.EmplaceBack(conflictingSlug.value());
      }
      if (experiment) {
        extraKeys.AppendElement()->AssignASCII("experiment");
        extraValues.EmplaceBack(experiment.value());
      }
      if (prefName) {
        extraKeys.AppendElement()->AssignASCII("pref_name");
        extraValues.EmplaceBack(prefName.value());
      }
      if (prefType) {
        extraKeys.AppendElement()->AssignASCII("pref_type");
        extraValues.EmplaceBack(prefType.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when either telemetry is disabled, or the experiment has run for its designed duration (i.e. it is no longer present in the Nimbus Remote Settings collection)
   */
  constexpr impl::EventMetric<UnenrollmentExtra> unenrollment(4727);

  /**
   * generated from nimbus_events.validation_failed
   */
  struct ValidationFailedExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> experiment;
    mozilla::Maybe<nsCString> feature;
    mozilla::Maybe<nsCString> featureIds;
    mozilla::Maybe<nsCString> l10nIds;
    mozilla::Maybe<nsCString> locale;
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (experiment) {
        extraKeys.AppendElement()->AssignASCII("experiment");
        extraValues.EmplaceBack(experiment.value());
      }
      if (feature) {
        extraKeys.AppendElement()->AssignASCII("feature");
        extraValues.EmplaceBack(feature.value());
      }
      if (featureIds) {
        extraKeys.AppendElement()->AssignASCII("feature_ids");
        extraValues.EmplaceBack(featureIds.value());
      }
      if (l10nIds) {
        extraKeys.AppendElement()->AssignASCII("l10n_ids");
        extraValues.EmplaceBack(l10nIds.value());
      }
      if (locale) {
        extraKeys.AppendElement()->AssignASCII("locale");
        extraValues.EmplaceBack(locale.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This records when validation of a recipe fails.
   */
  constexpr impl::EventMetric<ValidationFailedExtra> validation_failed(4728);
}

namespace nimbus_targeting_context {


  /**
   * generated from nimbus_targeting_context.addresses_saved
   * The number of addresses the user has saved.
   */
  constexpr impl::QuantityMetric addresses_saved(4731);

  /**
   * generated from nimbus_targeting_context.arch_bits
   * The architecture of the user's CPU (32-bit or 64-bit)
   */
  constexpr impl::QuantityMetric arch_bits(4732);



  /**
   * generated from nimbus_targeting_context.current_date
   * The current date, as an ISO-8601 string.
   */
  constexpr impl::StringMetric current_date(4735);


  /**
   * generated from nimbus_targeting_context.distribution_id
   * The installation's distribution ID.
   */
  constexpr impl::StringMetric distribution_id(4737);

  /**
   * generated from nimbus_targeting_context.does_app_need_pin
   * Does the app need pinning (i.e., is the app not pinned).
   */
  constexpr impl::BooleanMetric does_app_need_pin(4738);


  /**
   * generated from nimbus_targeting_context.firefox_version
   * The Firefox major version number.
   */
  constexpr impl::QuantityMetric firefox_version(4740);

  /**
   * generated from nimbus_targeting_context.has_active_enterprise_policies
   * Whether the profile has any active enterprise policies.
   */
  constexpr impl::BooleanMetric has_active_enterprise_policies(4741);


  /**
   * generated from nimbus_targeting_context.is_default_browser
   * Whether the current browser is the default browser.
   */
  constexpr impl::BooleanMetric is_default_browser(4743);


  /**
   * generated from nimbus_targeting_context.is_first_startup
   * Is this the first startup of the browser on this install? (NB: Must have been explicitly launched with the --first-startup commandline flag.)
   */
  constexpr impl::BooleanMetric is_first_startup(4745);

  /**
   * generated from nimbus_targeting_context.is_fx_a_enabled
   * Whether Firefox Accounts and Sync are enabled.
   */
  constexpr impl::BooleanMetric is_fx_a_enabled(4746);

  /**
   * generated from nimbus_targeting_context.is_fx_a_signed_in
   * Whether the user is logged in to Firefox Accounts.
   */
  constexpr impl::BooleanMetric is_fx_a_signed_in(4747);

  /**
   * generated from nimbus_targeting_context.is_msix
   * Is this copy of Firefox installed from an MSIX installer?
   */
  constexpr impl::BooleanMetric is_msix(4748);

  /**
   * generated from nimbus_targeting_context.locale
   * What is the active locale of the browser?
   */
  constexpr impl::StringMetric locale(4749);

  /**
   * generated from nimbus_targeting_context.memory_mb
   * The amount of system memory, in mebibytes (MiB).
   */
  constexpr impl::QuantityMetric memory_mb(4750);



  /**
   * generated from nimbus_targeting_context.profile_age_created
   * The UNIX timestamp of when the profile was created.
   */
  constexpr impl::QuantityMetric profile_age_created(4753);

  /**
   * generated from nimbus_targeting_context.region
   * What region is the browser located in?
   */
  constexpr impl::StringMetric region(4754);

  /**
   * generated from nimbus_targeting_context.total_bookmarks_count
   * The number of bookmarks.
   */
  constexpr impl::QuantityMetric total_bookmarks_count(4755);


  /**
   * generated from nimbus_targeting_context.user_prefers_reduced_motion
   * Whether the user prefers reduced motion.
   */
  constexpr impl::BooleanMetric user_prefers_reduced_motion(4757);

  /**
   * generated from nimbus_targeting_context.uses_firefox_sync
   * Whether the user uses Firefox Sync.
   */
  constexpr impl::BooleanMetric uses_firefox_sync(4758);

  /**
   * generated from nimbus_targeting_context.version
   * The full Firefox version string.
   */
  constexpr impl::StringMetric version(4759);
}

namespace nimbus_targeting_environment {
  /**
   * generated from nimbus_targeting_environment.attr_eval_errors
   */
  enum class AttrEvalErrorsLabel: uint16_t {
    eActiveexperiments = 0,
    eActiverollouts = 1,
    eAddressessaved = 2,
    eArchbits = 3,
    eAttributiondata = 4,
    eBrowsersettings = 5,
    eCurrentdate = 6,
    eDefaultpdfhandler = 7,
    eDistributionid = 8,
    eDoesappneedpin = 9,
    eEnrollmentsmap = 10,
    eFirefoxversion = 11,
    eHasactiveenterprisepolicies = 12,
    eHomepagesettings = 13,
    eIsdefaultbrowser = 14,
    eIsdefaulthandler = 15,
    eIsfirststartup = 16,
    eIsfxaenabled = 17,
    eIsfxasignedin = 18,
    eIsmsix = 19,
    eLocale = 20,
    eMemorymb = 21,
    eOs = 22,
    ePrimaryresolution = 23,
    eProfileagecreated = 24,
    eRegion = 25,
    eTotalbookmarkscount = 26,
    eUsermonthlyactivity = 27,
    eUserprefersreducedmotion = 28,
    eUsesfirefoxsync = 29,
    eVersion = 30,
    e__Other__,
  };
  /**
   * When a metric in `nimbus_targeting_context` cannot be recorded because an exception was thrown during evaluation of the targeting context attribute the name of the attribute is recorded in this metric.
   */
  constexpr impl::Labeled<impl::CounterMetric, AttrEvalErrorsLabel> attr_eval_errors(4760);

  /**
   * generated from nimbus_targeting_environment.pref_type_errors
   */
  enum class PrefTypeErrorsLabel: uint16_t {
    eBrowserNewtabpageActivityStreamAsrouterUserprefsCfrAddons = 0,
    eBrowserNewtabpageActivityStreamAsrouterUserprefsCfrFeatures = 1,
    eBrowserNewtabpageActivityStreamFeedsSectionHighlights = 2,
    eBrowserNewtabpageActivityStreamFeedsSectionTopstories = 3,
    eBrowserNewtabpageActivityStreamFeedsTopsites = 4,
    eBrowserNewtabpageActivityStreamShowsearch = 5,
    eBrowserNewtabpageActivityStreamShowsponsoredtopsites = 6,
    eBrowserNewtabpageEnabled = 7,
    eBrowserShoppingExperience2023Autoactivatecount = 8,
    eBrowserShoppingExperience2023Optedin = 9,
    eBrowserToolbarsBookmarksVisibility = 10,
    eBrowserUrlbarQuicksuggestDatacollectionEnabled = 11,
    eBrowserUrlbarShowsearchsuggestionsfirst = 12,
    eBrowserUrlbarSuggestQuicksuggestSponsored = 13,
    eMediaVideocontrolsPictureInPictureEnabled = 14,
    eMediaVideocontrolsPictureInPictureVideoToggleEnabled = 15,
    eMediaVideocontrolsPictureInPictureVideoToggleHasUsed = 16,
    eMessagingSystemActionTestday = 17,
    eNetworkTrrMode = 18,
    eNimbusQaPref1 = 19,
    eNimbusQaPref2 = 20,
    eSecuritySandboxContentLevel = 21,
    eTrailheadFirstrunDidseeaboutwelcome = 22,
    e__Other__,
  };
  /**
   * When a pref in `nimbus_targeting_environment.pref_values` cannot be recorded because the type in the metric does not match the type of the pref, it is recorded in this metric.
   */
  constexpr impl::Labeled<impl::CounterMetric, PrefTypeErrorsLabel> pref_type_errors(4761);


  /**
   * generated from nimbus_targeting_environment.targeting_context_value
   * The entirety of the Nimbus targeting context as a stringified JSON object.
   * This is disabled by default and only intended to be enabled via server knobs to debug recording failures in individual nimbus_targeting_context metric values.
   */
  constexpr impl::TextMetric targeting_context_value(4763);

}

namespace normandy {
  /**
   * generated from normandy.expose_nimbus_experiment
   */
  struct ExposeNimbusExperimentExtra {
    mozilla::Maybe<nsCString> branchslug;
    mozilla::Maybe<nsCString> featureid;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branchslug) {
        extraKeys.AppendElement()->AssignASCII("branchSlug");
        extraValues.EmplaceBack(branchslug.value());
      }
      if (featureid) {
        extraKeys.AppendElement()->AssignASCII("featureId");
        extraValues.EmplaceBack(featureid.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This records an event at the moment the user is exposed to an experiment treatment. The event is triggered either by the code checking that a certain experiment feature is enabled or when that feature value is used. This is different from enrollment or experiment activation because it registers when a user actually gets exposed to the experiment feature. This event was generated to correspond to the Legacy Telemetry event normandy.expose#nimbus_experiment.
   */
  constexpr impl::EventMetric<ExposeNimbusExperimentExtra> expose_nimbus_experiment(4765);
}

} // namespace mozilla::glean

#endif // mozilla_GleanNimbusMetrics_h
