// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanJsXpconnectMetrics_h
#define mozilla_GleanJsXpconnectMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace glam_experiment {
  /**
   * generated from glam_experiment.time
   * Duplicate of: `performance.clone.deserialize.time`
   * Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
   */
  constexpr impl::TimingDistributionMetric time(306);
}

namespace javascript_gc {
  /**
   * generated from javascript.gc.animation
   * Time spent running JS GC when animating.
   */
  constexpr impl::TimingDistributionMetric animation(3919);

  /**
   * generated from javascript.gc.budget
   * Requested GC slice budget.
   */
  constexpr impl::TimingDistributionMetric budget(3920);

  /**
   * generated from javascript.gc.budget_overrun
   * How long a GC slice ran over its budget.
   */
  constexpr impl::TimingDistributionMetric budget_overrun(3921);

  /**
   * generated from javascript.gc.budget_was_increased
   */
  enum class BudgetWasIncreasedLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether the budget was increased due to taking too long or approaching the incremental limit
   */
  constexpr impl::Labeled<impl::CounterMetric, BudgetWasIncreasedLabel> budget_was_increased(3922);

  /**
   * generated from javascript.gc.compact_time
   * The time spent in the compact phase. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric compact_time(3923);

  /**
   * generated from javascript.gc.effectiveness
   * GC effectiveness, the amount of memory freed divided by main-thread collection time (MB/s)
   */
  constexpr impl::CustomDistributionMetric effectiveness(3924);

  /**
   * generated from javascript.gc.is_zone_gc
   */
  enum class IsZoneGcLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Is it a zone GC?
   */
  constexpr impl::Labeled<impl::CounterMetric, IsZoneGcLabel> is_zone_gc(3925);

  /**
   * generated from javascript.gc.mark_gray
   * Time spent marking gray GC objects.
   */
  constexpr impl::TimingDistributionMetric mark_gray(3926);

  /**
   * generated from javascript.gc.mark_rate
   * The number of objects marked per ms during GC.
   */
  constexpr impl::CustomDistributionMetric mark_rate(3927);

  /**
   * generated from javascript.gc.mark_roots_time
   * The time spent marking GC roots. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric mark_roots_time(3928);

  /**
   * generated from javascript.gc.mark_time
   * The time spent in the mark phase. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric mark_time(3929);

  /**
   * generated from javascript.gc.mark_weak
   * Time spent marking GC objects held live through weakmaps.
   */
  constexpr impl::TimingDistributionMetric mark_weak(3930);

  /**
   * generated from javascript.gc.max_pause
   * Longest GC slice in a GC.
   */
  constexpr impl::TimingDistributionMetric max_pause(3931);

  /**
   * generated from javascript.gc.minor_reason
   */
  enum class MinorReasonLabel: uint16_t {
    eApi = 0,
    eEagerAllocTrigger = 1,
    eDestroyRuntime = 2,
    eRootsRemoved = 3,
    eLastDitch = 4,
    eTooMuchMalloc = 5,
    eAllocTrigger = 6,
    eDebugGc = 7,
    eCompartmentRevived = 8,
    eReset = 9,
    eOutOfNursery = 10,
    eEvictNursery = 11,
    eSharedMemoryLimit = 12,
    eEagerNurseryCollection = 13,
    eBgTaskFinished = 14,
    eAbortGc = 15,
    eFullWholeCellBuffer = 16,
    eFullGenericBuffer = 17,
    eFullValueBuffer = 18,
    eFullCellPtrObjBuffer = 19,
    eFullSlotBuffer = 20,
    eFullShapeBuffer = 21,
    eTooMuchWasmMemory = 22,
    eDisableGenerationalGc = 23,
    eFinishGc = 24,
    ePrepareForTracing = 25,
    eFullWasmAnyrefBuffer = 26,
    eFullCellPtrStrBuffer = 27,
    eTooMuchJitCode = 28,
    eFullCellPtrBigintBuffer = 29,
    eNurseryTrailers = 30,
    eNurseryMallocBuffers = 31,
    eDomWindowUtils = 32,
    eComponentUtils = 33,
    eMemPressure = 34,
    eCcFinished = 35,
    eCcForced = 36,
    eLoadEnd = 37,
    eUnused3 = 38,
    ePageHide = 39,
    eNsjscontextDestroy = 40,
    eWorkerShutdown = 41,
    eSetDocShell = 42,
    eDomUtils = 43,
    eDomIpc = 44,
    eDomWorker = 45,
    eInterSliceGc = 46,
    eUnused1 = 47,
    eFullGcTimer = 48,
    eShutdownCc = 49,
    eUnused2 = 50,
    eUserInactive = 51,
    eXpconnectShutdown = 52,
    eDocshell = 53,
    eHtmlParser = 54,
    eDomTestutils = 55,
    ePrepareForPageload = 56,
    e__Other__,
  };
  /**
   * Reason (enum value) for initiating a minor GC
   */
  constexpr impl::Labeled<impl::CounterMetric, MinorReasonLabel> minor_reason(3932);

  /**
   * generated from javascript.gc.minor_reason_long
   */
  enum class MinorReasonLongLabel: uint16_t {
    eApi = 0,
    eEagerAllocTrigger = 1,
    eDestroyRuntime = 2,
    eRootsRemoved = 3,
    eLastDitch = 4,
    eTooMuchMalloc = 5,
    eAllocTrigger = 6,
    eDebugGc = 7,
    eCompartmentRevived = 8,
    eReset = 9,
    eOutOfNursery = 10,
    eEvictNursery = 11,
    eSharedMemoryLimit = 12,
    eEagerNurseryCollection = 13,
    eBgTaskFinished = 14,
    eAbortGc = 15,
    eFullWholeCellBuffer = 16,
    eFullGenericBuffer = 17,
    eFullValueBuffer = 18,
    eFullCellPtrObjBuffer = 19,
    eFullSlotBuffer = 20,
    eFullShapeBuffer = 21,
    eTooMuchWasmMemory = 22,
    eDisableGenerationalGc = 23,
    eFinishGc = 24,
    ePrepareForTracing = 25,
    eFullWasmAnyrefBuffer = 26,
    eFullCellPtrStrBuffer = 27,
    eTooMuchJitCode = 28,
    eFullCellPtrBigintBuffer = 29,
    eNurseryTrailers = 30,
    eNurseryMallocBuffers = 31,
    eDomWindowUtils = 32,
    eComponentUtils = 33,
    eMemPressure = 34,
    eCcFinished = 35,
    eCcForced = 36,
    eLoadEnd = 37,
    eUnused3 = 38,
    ePageHide = 39,
    eNsjscontextDestroy = 40,
    eWorkerShutdown = 41,
    eSetDocShell = 42,
    eDomUtils = 43,
    eDomIpc = 44,
    eDomWorker = 45,
    eInterSliceGc = 46,
    eUnused1 = 47,
    eFullGcTimer = 48,
    eShutdownCc = 49,
    eUnused2 = 50,
    eUserInactive = 51,
    eXpconnectShutdown = 52,
    eDocshell = 53,
    eHtmlParser = 54,
    eDomTestutils = 55,
    ePrepareForPageload = 56,
    e__Other__,
  };
  /**
   * Reason (enum value) that caused a long (>1ms) minor GC
   */
  constexpr impl::Labeled<impl::CounterMetric, MinorReasonLongLabel> minor_reason_long(3933);

  /**
   * generated from javascript.gc.minor_time
   * The time taked by a minor (nursery) collection. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric minor_time(3934);

  /**
   * generated from javascript.gc.mmu_50
   * Minimum percentage of time spent outside GC over any 50ms window.
   */
  constexpr impl::CustomDistributionMetric mmu_50(3935);

  /**
   * generated from javascript.gc.non_incremental
   */
  enum class NonIncrementalLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Was the GC non-incremental?
   */
  constexpr impl::Labeled<impl::CounterMetric, NonIncrementalLabel> non_incremental(3936);

  /**
   * generated from javascript.gc.non_incremental_reason
   */
  enum class NonIncrementalReasonLabel: uint16_t {
    eNone = 0,
    eNonincrementalrequested = 1,
    eAbortrequested = 2,
    eUnused1 = 3,
    eIncrementaldisabled = 4,
    eModechange = 5,
    eMallocbytestrigger = 6,
    eGcbytestrigger = 7,
    eZonechange = 8,
    eCompartmentrevived = 9,
    eGrayrootbufferingfailed = 10,
    eJitcodebytestrigger = 11,
    e__Other__,
  };
  /**
   * Reason for performing a non-incremental GC (see js::GCAbortReason)
   */
  constexpr impl::Labeled<impl::CounterMetric, NonIncrementalReasonLabel> non_incremental_reason(3937);

  /**
   * generated from javascript.gc.nursery_bytes
   * Size of the GC nursery in bytes.
   */
  constexpr impl::MemoryDistributionMetric nursery_bytes(3938);

  /**
   * generated from javascript.gc.nursery_promotion_rate
   * The percentage of nursery objects that were promoted to the tenured heap.
   */
  constexpr impl::CustomDistributionMetric nursery_promotion_rate(3939);

  /**
   * generated from javascript.gc.parallel_mark_interruptions
   * Number of interruptions/donations per slice during parallel marking.
   */
  constexpr impl::CustomDistributionMetric parallel_mark_interruptions(3940);

  /**
   * generated from javascript.gc.parallel_mark_speedup
   * Ratio of total helper thread time spent marking to main thread time for parallel marking, scaled by 100.
   */
  constexpr impl::CustomDistributionMetric parallel_mark_speedup(3941);

  /**
   * generated from javascript.gc.parallel_mark_used
   */
  enum class ParallelMarkUsedLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether parallel marking was used for this collection
   */
  constexpr impl::Labeled<impl::CounterMetric, ParallelMarkUsedLabel> parallel_mark_used(3942);

  /**
   * generated from javascript.gc.parallel_mark_utilization
   * Ratio of helper thread time spent marking to total helper thread time for parallel marking.
   */
  constexpr impl::CustomDistributionMetric parallel_mark_utilization(3943);

  /**
   * generated from javascript.gc.prepare_time
   * The time spent in the preparation phase. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric prepare_time(3944);

  /**
   * generated from javascript.gc.pretenure_count
   * How many allocation sites were selected for pretenuring by a minor GC
   */
  constexpr impl::CustomDistributionMetric pretenure_count(3945);

  /**
   * generated from javascript.gc.reason
   */
  enum class ReasonLabel: uint16_t {
    eApi = 0,
    eEagerAllocTrigger = 1,
    eDestroyRuntime = 2,
    eRootsRemoved = 3,
    eLastDitch = 4,
    eTooMuchMalloc = 5,
    eAllocTrigger = 6,
    eDebugGc = 7,
    eCompartmentRevived = 8,
    eReset = 9,
    eOutOfNursery = 10,
    eEvictNursery = 11,
    eSharedMemoryLimit = 12,
    eEagerNurseryCollection = 13,
    eBgTaskFinished = 14,
    eAbortGc = 15,
    eFullWholeCellBuffer = 16,
    eFullGenericBuffer = 17,
    eFullValueBuffer = 18,
    eFullCellPtrObjBuffer = 19,
    eFullSlotBuffer = 20,
    eFullShapeBuffer = 21,
    eTooMuchWasmMemory = 22,
    eDisableGenerationalGc = 23,
    eFinishGc = 24,
    ePrepareForTracing = 25,
    eFullWasmAnyrefBuffer = 26,
    eFullCellPtrStrBuffer = 27,
    eTooMuchJitCode = 28,
    eFullCellPtrBigintBuffer = 29,
    eNurseryTrailers = 30,
    eNurseryMallocBuffers = 31,
    eDomWindowUtils = 32,
    eComponentUtils = 33,
    eMemPressure = 34,
    eCcFinished = 35,
    eCcForced = 36,
    eLoadEnd = 37,
    eUnused3 = 38,
    ePageHide = 39,
    eNsjscontextDestroy = 40,
    eWorkerShutdown = 41,
    eSetDocShell = 42,
    eDomUtils = 43,
    eDomIpc = 44,
    eDomWorker = 45,
    eInterSliceGc = 46,
    eUnused1 = 47,
    eFullGcTimer = 48,
    eShutdownCc = 49,
    eUnused2 = 50,
    eUserInactive = 51,
    eXpconnectShutdown = 52,
    eDocshell = 53,
    eHtmlParser = 54,
    eDomTestutils = 55,
    ePrepareForPageload = 56,
    e__Other__,
  };
  /**
   * Reason (enum value) for initiating a GC
   */
  constexpr impl::Labeled<impl::CounterMetric, ReasonLabel> reason(3946);

  /**
   * generated from javascript.gc.reset
   */
  enum class ResetLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Was an incremental GC canceled?
   */
  constexpr impl::Labeled<impl::CounterMetric, ResetLabel> reset(3947);

  /**
   * generated from javascript.gc.reset_reason
   */
  enum class ResetReasonLabel: uint16_t {
    eNone = 0,
    eNonincrementalrequested = 1,
    eAbortrequested = 2,
    eUnused1 = 3,
    eIncrementaldisabled = 4,
    eModechange = 5,
    eMallocbytestrigger = 6,
    eGcbytestrigger = 7,
    eZonechange = 8,
    eCompartmentrevived = 9,
    eGrayrootbufferingfailed = 10,
    eJitcodebytestrigger = 11,
    e__Other__,
  };
  /**
   * Reason for cancelling an ongoing GC (see js::GCAbortReason)
   */
  constexpr impl::Labeled<impl::CounterMetric, ResetReasonLabel> reset_reason(3948);

  /**
   * generated from javascript.gc.slice_count
   * The number of slices in an incremental GC for the main runtime.
   */
  constexpr impl::CustomDistributionMetric slice_count(3949);

  /**
   * generated from javascript.gc.slice_time
   * The time spent running a GC slice. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric slice_time(3950);

  /**
   * generated from javascript.gc.slice_was_long
   */
  enum class SliceWasLongLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether a GC slice took 1.5 times or 5ms more than its budget
   */
  constexpr impl::Labeled<impl::CounterMetric, SliceWasLongLabel> slice_was_long(3951);

  /**
   * generated from javascript.gc.slow_phase
   */
  enum class SlowPhaseLabel: uint16_t {
    eMutator = 0,
    eGcBegin = 1,
    eMarkCcws = 2,
    eMarkStack = 3,
    eMarkRuntimeData = 4,
    eMarkEmbedding = 5,
    eMarkRoots = 6,
    eEvictNurseryForMajorGc = 7,
    eWaitBackgroundThread = 8,
    eUnmark = 9,
    eUnmarkWeakmaps = 10,
    eMarkDiscardCode = 11,
    eRelazifyFunctions = 12,
    ePurge = 13,
    ePurgePropMapTables = 14,
    ePurgeSourceUrls = 15,
    eJoinParallelTasks = 16,
    ePrepare = 17,
    eMarkDelayed = 18,
    eMarkGrayWeak = 19,
    eMarkWeak = 20,
    eMarkIncomingGray = 21,
    eMarkGray = 22,
    eParallelMarkMark = 23,
    eParallelMarkWait = 24,
    eParallelMarkOther = 25,
    eParallelMark = 26,
    eMark = 27,
    eWeakZonesCallback = 28,
    eWeakCompartmentCallback = 29,
    eFinalizeStart = 30,
    eUpdateAtomsBitmap = 31,
    eSweepAtomsTable = 32,
    eSweepDiscardCode = 33,
    eSweepInnerViews = 34,
    eSweepCcWrapper = 35,
    eSweepBaseShape = 36,
    eSweepInitialShape = 37,
    eSweepRegexp = 38,
    eSweepCompression = 39,
    eSweepWeakmaps = 40,
    eSweepUniqueids = 41,
    eSweepWeakPointers = 42,
    eSweepFinalizationObservers = 43,
    eSweepJitData = 44,
    eSweepWeakCaches = 45,
    eSweepMisc = 46,
    eSweepCompartments = 47,
    eFinalizeObject = 48,
    eFinalizeNonObject = 49,
    eSweepPropMap = 50,
    eFinalizeEnd = 51,
    eDestroy = 52,
    eFindDeadCompartments = 53,
    eSweep = 54,
    eCompactMove = 55,
    eCompactUpdateCells = 56,
    eCompactUpdate = 57,
    eCompact = 58,
    eDecommit = 59,
    eGcEnd = 60,
    eMinorGc = 61,
    eEvictNursery = 62,
    eTraceHeap = 63,
    e__Other__,
  };
  /**
   * The longest phase in any slice that goes over 2x the budget. The phase values are defined in js/src/gc/GenerateStatsPhases.py.
   */
  constexpr impl::Labeled<impl::CounterMetric, SlowPhaseLabel> slow_phase(3952);

  /**
   * generated from javascript.gc.slow_task
   */
  enum class SlowTaskLabel: uint16_t {
    eMutator = 0,
    eGcBegin = 1,
    eMarkCcws = 2,
    eMarkStack = 3,
    eMarkRuntimeData = 4,
    eMarkEmbedding = 5,
    eMarkRoots = 6,
    eEvictNurseryForMajorGc = 7,
    eWaitBackgroundThread = 8,
    eUnmark = 9,
    eUnmarkWeakmaps = 10,
    eMarkDiscardCode = 11,
    eRelazifyFunctions = 12,
    ePurge = 13,
    ePurgePropMapTables = 14,
    ePurgeSourceUrls = 15,
    eJoinParallelTasks = 16,
    ePrepare = 17,
    eMarkDelayed = 18,
    eMarkGrayWeak = 19,
    eMarkWeak = 20,
    eMarkIncomingGray = 21,
    eMarkGray = 22,
    eParallelMarkMark = 23,
    eParallelMarkWait = 24,
    eParallelMarkOther = 25,
    eParallelMark = 26,
    eMark = 27,
    eWeakZonesCallback = 28,
    eWeakCompartmentCallback = 29,
    eFinalizeStart = 30,
    eUpdateAtomsBitmap = 31,
    eSweepAtomsTable = 32,
    eSweepDiscardCode = 33,
    eSweepInnerViews = 34,
    eSweepCcWrapper = 35,
    eSweepBaseShape = 36,
    eSweepInitialShape = 37,
    eSweepRegexp = 38,
    eSweepCompression = 39,
    eSweepWeakmaps = 40,
    eSweepUniqueids = 41,
    eSweepWeakPointers = 42,
    eSweepFinalizationObservers = 43,
    eSweepJitData = 44,
    eSweepWeakCaches = 45,
    eSweepMisc = 46,
    eSweepCompartments = 47,
    eFinalizeObject = 48,
    eFinalizeNonObject = 49,
    eSweepPropMap = 50,
    eFinalizeEnd = 51,
    eDestroy = 52,
    eFindDeadCompartments = 53,
    eSweep = 54,
    eCompactMove = 55,
    eCompactUpdateCells = 56,
    eCompactUpdate = 57,
    eCompact = 58,
    eDecommit = 59,
    eGcEnd = 60,
    eMinorGc = 61,
    eEvictNursery = 62,
    eTraceHeap = 63,
    e__Other__,
  };
  /**
   * The longest parallel task in any slice that goes over 2x the budget. The phase values are defined in js/src/gc/GenerateStatsPhases.py.
   */
  constexpr impl::Labeled<impl::CounterMetric, SlowTaskLabel> slow_task(3953);

  /**
   * generated from javascript.gc.sweep_time
   * The time spent in the sweep phase. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric sweep_time(3954);

  /**
   * generated from javascript.gc.task_start_delay
   * Delay between queuing a GC task and the task starting.
   */
  constexpr impl::TimingDistributionMetric task_start_delay(3955);

  /**
   * generated from javascript.gc.tenured_survival_rate
   * The percentage of tenured GC things that survived a collection.
   */
  constexpr impl::CustomDistributionMetric tenured_survival_rate(3956);

  /**
   * generated from javascript.gc.time_between
   * Time spent in between garbage collections for the main runtime.
   */
  constexpr impl::TimingDistributionMetric time_between(3957);

  /**
   * generated from javascript.gc.time_between_slices
   * Time spent in between garbage collections for the main runtime.
   */
  constexpr impl::TimingDistributionMetric time_between_slices(3958);

  /**
   * generated from javascript.gc.total_time
   * The total time taken by a major collection. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric total_time(3959);

  /**
   * generated from javascript.gc.zone_count
   * Total number of GC zones
   */
  constexpr impl::CustomDistributionMetric zone_count(3960);

  /**
   * generated from javascript.gc.zones_collected
   * Number of zones collected in a zone GC.
   */
  constexpr impl::CustomDistributionMetric zones_collected(3961);
}

namespace javascript_ion {
  /**
   * generated from javascript.ion.compile_time
   * Time in microseconds of an Ion compilation.
   */
  constexpr impl::TimingDistributionMetric compile_time(3962);
}

namespace performance_clone_deserialize {
  /**
   * generated from performance.clone.deserialize.items
   * Size of deserialized data, in items
   */
  constexpr impl::CustomDistributionMetric items(3963);

  /**
   * generated from performance.clone.deserialize.size
   * Size of deserialized data, in bytes
   */
  constexpr impl::MemoryDistributionMetric size(3964);

  /**
   * generated from performance.clone.deserialize.time
   * Time spent deserializing structured data
   */
  constexpr impl::TimingDistributionMetric time(3965);
}

namespace script_preloader {
  /**
   * generated from script.preloader.mainthread_recompile
   * How many times we ended up recompiling a script from the script preloader on the main thread. This metric was generated to correspond to the Legacy Telemetry scalar script.preloader.mainthread_recompile.
   */
  constexpr impl::CounterMetric mainthread_recompile(3966);
}

namespace slow_script_warning {
  /**
   * generated from slow_script_warning.shown_browser
   */
  struct ShownBrowserExtra {
    mozilla::Maybe<nsCString> hangDuration;
    mozilla::Maybe<nsCString> uriType;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hangDuration) {
        extraKeys.AppendElement()->AssignASCII("hang_duration");
        extraValues.EmplaceBack(hangDuration.value());
      }
      if (uriType) {
        extraKeys.AppendElement()->AssignASCII("uri_type");
        extraValues.EmplaceBack(uriType.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a slow script hang is resolved. This event was generated to correspond to the Legacy Telemetry event slow_script_warning.shown#browser.
   */
  constexpr impl::EventMetric<ShownBrowserExtra> shown_browser(3967);

  /**
   * generated from slow_script_warning.shown_content
   */
  struct ShownContentExtra {
    mozilla::Maybe<nsCString> endReason;
    mozilla::Maybe<nsCString> hangDuration;
    mozilla::Maybe<uint32_t> nTabDeselect;
    mozilla::Maybe<nsCString> uptime;
    mozilla::Maybe<nsCString> uriType;
    mozilla::Maybe<uint32_t> waitCount;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (endReason) {
        extraKeys.AppendElement()->AssignASCII("end_reason");
        extraValues.EmplaceBack(endReason.value());
      }
      if (hangDuration) {
        extraKeys.AppendElement()->AssignASCII("hang_duration");
        extraValues.EmplaceBack(hangDuration.value());
      }
      if (nTabDeselect) {
        extraKeys.AppendElement()->AssignASCII("n_tab_deselect");
        extraValues.EmplaceBack(nsPrintfCString("%d", nTabDeselect.value()));
      }
      if (uptime) {
        extraKeys.AppendElement()->AssignASCII("uptime");
        extraValues.EmplaceBack(uptime.value());
      }
      if (uriType) {
        extraKeys.AppendElement()->AssignASCII("uri_type");
        extraValues.EmplaceBack(uriType.value());
      }
      if (waitCount) {
        extraKeys.AppendElement()->AssignASCII("wait_count");
        extraValues.EmplaceBack(nsPrintfCString("%d", waitCount.value()));
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a slow script hang is resolved. This event was generated to correspond to the Legacy Telemetry event slow_script_warning.shown#content.
   */
  constexpr impl::EventMetric<ShownContentExtra> shown_content(3968);
}

} // namespace mozilla::glean

#endif // mozilla_GleanJsXpconnectMetrics_h
