// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomSecurityMetrics_h
#define mozilla_GleanDomSecurityMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace security {
  /**
   * generated from security.csp_violation_internal_page
   */
  struct CspViolationInternalPageExtra {
    mozilla::Maybe<nsCString> blockeduridetails;
    mozilla::Maybe<nsCString> blockeduritype;
    mozilla::Maybe<uint32_t> columnnumber;
    mozilla::Maybe<nsCString> directive;
    mozilla::Maybe<uint32_t> linenumber;
    mozilla::Maybe<nsCString> sample;
    mozilla::Maybe<nsCString> selfdetails;
    mozilla::Maybe<nsCString> selftype;
    mozilla::Maybe<nsCString> sourcedetails;
    mozilla::Maybe<nsCString> sourcetype;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (blockeduridetails) {
        extraKeys.AppendElement()->AssignASCII("blockeduridetails");
        extraValues.EmplaceBack(blockeduridetails.value());
      }
      if (blockeduritype) {
        extraKeys.AppendElement()->AssignASCII("blockeduritype");
        extraValues.EmplaceBack(blockeduritype.value());
      }
      if (columnnumber) {
        extraKeys.AppendElement()->AssignASCII("columnnumber");
        extraValues.EmplaceBack(nsPrintfCString("%d", columnnumber.value()));
      }
      if (directive) {
        extraKeys.AppendElement()->AssignASCII("directive");
        extraValues.EmplaceBack(directive.value());
      }
      if (linenumber) {
        extraKeys.AppendElement()->AssignASCII("linenumber");
        extraValues.EmplaceBack(nsPrintfCString("%d", linenumber.value()));
      }
      if (sample) {
        extraKeys.AppendElement()->AssignASCII("sample");
        extraValues.EmplaceBack(sample.value());
      }
      if (selfdetails) {
        extraKeys.AppendElement()->AssignASCII("selfdetails");
        extraValues.EmplaceBack(selfdetails.value());
      }
      if (selftype) {
        extraKeys.AppendElement()->AssignASCII("selftype");
        extraValues.EmplaceBack(selftype.value());
      }
      if (sourcedetails) {
        extraKeys.AppendElement()->AssignASCII("sourcedetails");
        extraValues.EmplaceBack(sourcedetails.value());
      }
      if (sourcetype) {
        extraKeys.AppendElement()->AssignASCII("sourcetype");
        extraValues.EmplaceBack(sourcetype.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Information about Content-Security-Policy violations that happen in internal pages like chrome://
   */
  constexpr impl::EventMetric<CspViolationInternalPageExtra> csp_violation_internal_page(424);

  /**
   * generated from security.eval_usage_parent_process
   */
  struct EvalUsageParentProcessExtra {
    mozilla::Maybe<nsCString> fileinfo;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fileinfo) {
        extraKeys.AppendElement()->AssignASCII("fileinfo");
        extraValues.EmplaceBack(fileinfo.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * eval() (or an eval()-like method) was called while running in the System Principal context or the Parent Process. Expected values are: chromeuri - chrome:// file   resourceuri - resource:// file datauri - a data URI   bloburi - a blob URI   abouturi - an about URI   singlestring - A single file or string with no slashes mozillaextension - An extension claiming to be from *mozilla.org (Deprecated)   otherextension - Another extension not from Mozilla (Deprecated)   mozillaextension_file - An extension claiming to be from *mozilla.org, loaded from a file://   otherextension_file - Another extension not from Mozilla, loaded from a file:// extension_uri - A URI with the moz-extension:// scheme suspectedUserChromeJS - A filepath ending in .uc.js sanitizedWindowsPath - A filepath, on Windows, sanitized by WinUtils::PreparePathForTelemetry                          which is a bare filename or a subpath of %ProgramFiles%, %SystemRoot%, or %TEMP%   sanitizedWindowsURL - A partial URL, on Windows, consisting of either file://../ followed by the value prepared as for sanitizedWindowsPath, or the bare scheme of                         the original url   other - Unknown other-on-worker - We cannot do a regex; it is not a chrome, resource, data, or blob uri, but                     could be any other.   regexfailure - Our Regex Matching code threw an error The fileinfo key may contain additional information about the file that caused the eval() depending on the above value. Resource, Chrome, About, and SingleString will contain the full value. (About URIs will remove any querystring values.) Extensions-from-file will contain the full value; however .xpi! will be shortened to !, shield.mozilla.org! to s! and mozilla.org! to m!.  Data, Blob, UserChromeJS, Other, and Regexfailure should have no value. This event was generated to correspond to the Legacy Telemetry event security.evalUsage#parentProcess.
   */
  constexpr impl::EventMetric<EvalUsageParentProcessExtra> eval_usage_parent_process(425);

  /**
   * generated from security.eval_usage_system_context
   */
  struct EvalUsageSystemContextExtra {
    mozilla::Maybe<nsCString> fileinfo;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fileinfo) {
        extraKeys.AppendElement()->AssignASCII("fileinfo");
        extraValues.EmplaceBack(fileinfo.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * eval() (or an eval()-like method) was called while running in the System Principal context or the Parent Process. Expected values are:
   *   - chromeuri - chrome:// file
   *   - resourceuri - resource:// file
   *   - datauri - a data URI
   *   - bloburi - a blob URI
   *   - abouturi - an about URI
   *   - singlestring - A single file or string with no slashes
   *   - mozillaextension - An extension claiming to be from *mozilla.org (Deprecated)
   *   - otherextension - Another extension not from Mozilla (Deprecated)
   *   - mozillaextension_file - An extension claiming to be from *mozilla.org, loaded from a file://
   *   - otherextension_file - Another extension not from Mozilla, loaded from a file://
   *   - extension_uri - A URI with the moz-extension:// scheme
   *   - suspectedUserChromeJS - A filepath ending in .uc.js
   *   - sanitizedWindowsPath - A filepath, on Windows, sanitized by WinUtils::PreparePathForTelemetry which is a bare filename or a subpath of %ProgramFiles%, %SystemRoot%, or %TEMP%
   *   - sanitizedWindowsURL - A partial URL, on Windows, consisting of either file://../ followed by the value prepared as for sanitizedWindowsPath, or the bare scheme of the original url
   *   - other - Unknown
   *   - other-on-worker - We cannot do a regex; it is not a chrome, resource, data, or blob uri, but could be any other.
   *   - regexfailure - Our Regex Matching code threw an error
   * 
   * The fileinfo key may contain additional information about the file that caused the eval() depending on the above value. Resource, Chrome, About, and SingleString will contain the full value. (About URIs will remove any querystring values.)
   * Extensions-from-file will contain the full value; however .xpi! will be shortened to !, shield.mozilla.org! to s! and mozilla.org! to m!.  Data, Blob, UserChromeJS, Other, and Regexfailure should have no value.
   * This event was generated to correspond to the Legacy Telemetry event security.evalUsage#systemContext.
   */
  constexpr impl::EventMetric<EvalUsageSystemContextExtra> eval_usage_system_context(426);

  /**
   * generated from security.javascript_load_parent_process
   */
  struct JavascriptLoadParentProcessExtra {
    mozilla::Maybe<nsCString> fileinfo;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fileinfo) {
        extraKeys.AppendElement()->AssignASCII("fileinfo");
        extraValues.EmplaceBack(fileinfo.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The javascript engine requested to load a filename that was not allowed. Expected values, and fileinfo key, are the same possible values as above in 'evalUsage' This event was generated to correspond to the Legacy Telemetry event security.javascriptLoad#parentProcess.
   */
  constexpr impl::EventMetric<JavascriptLoadParentProcessExtra> javascript_load_parent_process(427);

  /**
   * generated from security.unexpected_load
   */
  struct UnexpectedLoadExtra {
    mozilla::Maybe<nsCString> contenttype;
    mozilla::Maybe<nsCString> filedetails;
    mozilla::Maybe<nsCString> redirects;
    mozilla::Maybe<nsCString> remotetype;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (contenttype) {
        extraKeys.AppendElement()->AssignASCII("contenttype");
        extraValues.EmplaceBack(contenttype.value());
      }
      if (filedetails) {
        extraKeys.AppendElement()->AssignASCII("filedetails");
        extraValues.EmplaceBack(filedetails.value());
      }
      if (redirects) {
        extraKeys.AppendElement()->AssignASCII("redirects");
        extraValues.EmplaceBack(redirects.value());
      }
      if (remotetype) {
        extraKeys.AppendElement()->AssignASCII("remotetype");
        extraValues.EmplaceBack(remotetype.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Long term want to block all loads from the system principal that cause us to parse non-trivial data. We don't look to break existing functionality and will allow exceptions, for this we are collecting information about unexpected requests triggered by the system principal Our measurement *excludes* acceptable requests. Those are: - annotated using the 'AllowedDeprecatedSystemRequests' loadinfo flag - using a nsContentPolicyType of FETCH, XMLHTTPREQUEST, WEBSOCKET, SAVEAS_DOWNLOAD or IMAGE - with a requested URI object has the flag URI_IS_UI_RESOURCE - if the URL scheme is 'view-source' - if the URL scheme is 'file' and the Content-Type is STYLESHEET or OTHER - if the scheme is 'jar', 'about' or 'moz-extension' This event was generated to correspond to the Legacy Telemetry event security.unexpectedload#systemprincipal.
   */
  constexpr impl::EventMetric<UnexpectedLoadExtra> unexpected_load(428);
}

namespace httpsfirst {
  /**
   * generated from httpsfirst.downgrade_time
   * If a HTTPS-First (`dom.security.https_first` enabled) upgrade isn't successful, measures the timespan between the navigation start and the downgrade.
   */
  constexpr impl::TimingDistributionMetric downgrade_time(3781);

  /**
   * generated from httpsfirst.downgrade_time_schemeless
   * If a schemeless HTTPS-First (`dom.security.https_first` disabled, but load marked as schemeless) upgrade isn't successful, measures the timespan between the navigation start and the downgrade.
   */
  constexpr impl::TimingDistributionMetric downgrade_time_schemeless(3782);

  /**
   * generated from httpsfirst.downgraded
   * How many regular HTTPS-First (`dom.security.https_first` enabled) upgrades fail and get downgraded again.
   */
  constexpr impl::DenominatorMetric downgraded(3783);

  /**
   * generated from httpsfirst.downgraded_on_timer
   * How many HTTPS-First (`dom.security.https_first` enabled) upgrades get downgraded again because the HTTP request fired after 3s received a answer faster than the HTTPS request.
   */
  constexpr impl::NumeratorMetric downgraded_on_timer(3784);

  /**
   * generated from httpsfirst.downgraded_on_timer_schemeless
   * How many of schemeless HTTPS-First (`dom.security.https_first` disabled, but load marked as schemeless) upgrades get downgraded again because the HTTP request fired after 3s received a answer faster than the HTTPS request
   */
  constexpr impl::NumeratorMetric downgraded_on_timer_schemeless(3785);

  /**
   * generated from httpsfirst.downgraded_schemeless
   * How many schemeless HTTPS-First (`dom.security.https_first` disabled, but load marked as schemeless) upgrades fail and get downgraded again.
   */
  constexpr impl::DenominatorMetric downgraded_schemeless(3786);

  /**
   * generated from httpsfirst.upgraded
   * Counts how often a load is successfully upgraded to HTTPS because of HTTPS-First (`dom.security.https_first` enabled). This does not include loads that get downgraded again.
   */
  constexpr impl::CounterMetric upgraded(3787);

  /**
   * generated from httpsfirst.upgraded_schemeless
   * Counts how often a load is successfully upgraded to HTTPS because of schemeless HTTPS-First (`dom.security.https_first` disabled, but load marked as schemeless). This does not include loads that get downgraded again.
   */
  constexpr impl::CounterMetric upgraded_schemeless(3788);
}

namespace mixed_content {
  /**
   * generated from mixed_content.audio
   */
  enum class AudioLabel: uint16_t {
    eAudioupsuccess = 0,
    eAudioupfailure = 1,
    eAudionoupsuccess = 2,
    eAudionoupfailure = 3,
    e__Other__,
  };
  /**
   * How often audio loads fail in regular mode and in upgrading mode?
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram MIXED_CONTENT_AUDIO.
   */
  constexpr impl::Labeled<impl::CounterMetric, AudioLabel> audio(3789);

  /**
   * generated from mixed_content.hsts
   * How often would blocked mixed content be allowed if HSTS upgrades were allowed? 0=display/no-HSTS, 1=display/HSTS, 2=active/no-HSTS, 3=active/HSTS
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram MIXED_CONTENT_HSTS.
   */
  constexpr impl::CustomDistributionMetric hsts(3790);

  /**
   * generated from mixed_content.images
   */
  enum class ImagesLabel: uint16_t {
    eImgupsuccess = 0,
    eImgupfailure = 1,
    eImgnoupsuccess = 2,
    eImgnoupfailure = 3,
    e__Other__,
  };
  /**
   * How often image loads fail in regular mode and in upgrading mode?
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram MIXED_CONTENT_IMAGES.
   */
  constexpr impl::Labeled<impl::CounterMetric, ImagesLabel> images(3791);

  /**
   * generated from mixed_content.page_load
   * Accumulates type of content per page load (0=no mixed or non-secure page, 1=mixed passive, 2=mixed active, 3=mixed passive and mixed active)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram MIXED_CONTENT_PAGE_LOAD.
   */
  constexpr impl::CustomDistributionMetric page_load(3792);

  /**
   * generated from mixed_content.unblock_counter
   * A simple counter of daily mixed-content unblock operations and top documents loaded
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram MIXED_CONTENT_UNBLOCK_COUNTER.
   */
  constexpr impl::CustomDistributionMetric unblock_counter(3793);

  /**
   * generated from mixed_content.video
   */
  enum class VideoLabel: uint16_t {
    eVideoupsuccess = 0,
    eVideoupfailure = 1,
    eVideonoupsuccess = 2,
    eVideonoupfailure = 3,
    e__Other__,
  };
  /**
   * How often video loads fail in regular mode and in upgrading mode?
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram MIXED_CONTENT_VIDEO.
   */
  constexpr impl::Labeled<impl::CounterMetric, VideoLabel> video(3794);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomSecurityMetrics_h
