// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomQuotaMetrics_h
#define mozilla_GleanDomQuotaMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace dom_quota {
  /**
   * generated from dom.quota.info_load_time
   * Time (ms) for the QuotaManager to load quota information. Keyed by conditions during quota info loading, see RecordTimeDeltaHelper::Run in https://searchfox.org/mozilla-central/source/dom/quota/ActorsParent.cpp
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram QM_QUOTA_INFO_LOAD_TIME_V0.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> info_load_time(3777);

  /**
   * generated from dom.quota.shutdown_time
   * Time (ms) for the QuotaManager to shutdown. Keyed by conditions during shutdown, see RecordTimeDeltaHelper::Run in https://searchfox.org/mozilla-central/source/dom/quota/ActorsParent.cpp
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram QM_SHUTDOWN_TIME_V0.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> shutdown_time(3778);
}

namespace dom_quota_try {
  /**
   * generated from dom.quota.try.error_step
   */
  struct ErrorStepExtra {
    mozilla::Maybe<nsCString> context;
    mozilla::Maybe<nsCString> frameId;
    mozilla::Maybe<nsCString> processId;
    mozilla::Maybe<nsCString> result;
    mozilla::Maybe<uint32_t> seq;
    mozilla::Maybe<nsCString> severity;
    mozilla::Maybe<nsCString> sourceFile;
    mozilla::Maybe<uint32_t> sourceLine;
    mozilla::Maybe<nsCString> stackId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (context) {
        extraKeys.AppendElement()->AssignASCII("context");
        extraValues.EmplaceBack(context.value());
      }
      if (frameId) {
        extraKeys.AppendElement()->AssignASCII("frame_id");
        extraValues.EmplaceBack(frameId.value());
      }
      if (processId) {
        extraKeys.AppendElement()->AssignASCII("process_id");
        extraValues.EmplaceBack(processId.value());
      }
      if (result) {
        extraKeys.AppendElement()->AssignASCII("result");
        extraValues.EmplaceBack(result.value());
      }
      if (seq) {
        extraKeys.AppendElement()->AssignASCII("seq");
        extraValues.EmplaceBack(nsPrintfCString("%d", seq.value()));
      }
      if (severity) {
        extraKeys.AppendElement()->AssignASCII("severity");
        extraValues.EmplaceBack(severity.value());
      }
      if (sourceFile) {
        extraKeys.AppendElement()->AssignASCII("source_file");
        extraValues.EmplaceBack(sourceFile.value());
      }
      if (sourceLine) {
        extraKeys.AppendElement()->AssignASCII("source_line");
        extraValues.EmplaceBack(nsPrintfCString("%d", sourceLine.value()));
      }
      if (stackId) {
        extraKeys.AppendElement()->AssignASCII("stack_id");
        extraValues.EmplaceBack(stackId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * An event recorded on an error of the quota manager or its clients. Since errors are usually propagated up the call chain, all such propagation steps are recorded for an error. This is only active during specific contexts, in particular during storage initialization. No dynamic data is included in the event beyond the error code which will be added through Bug 1670555. This event was generated to correspond to the Legacy Telemetry event dom.quota.try.error#step.
   */
  constexpr impl::EventMetric<ErrorStepExtra> error_step(3779);
}

namespace quotamanager_initialize_repository {
  /**
   * generated from quotamanager.initialize.repository.number_of_iterations
   */
  enum class NumberOfIterationsLabel: uint16_t {
    ePersistent = 0,
    eTemporary = 1,
    eDefault = 2,
    ePrivate = 3,
    e__Other__,
  };
  /**
   * This metric logs the count of directory entries iterated within the QuotaManager::InitializeRepository function for each repository type. Each instance of this metric is labeled with one of three repository types: "persistent", "temporary" or "default" (there's also "private" repository but that should never be iterated by the function). The main purpose is to track and analyze iteration counts during the initialization process of each repository type, helping to identify performance trends or potential inefficiencies across these repositories. This can provide insight into the impacts of specific code changes, including potential optimizations or regressions.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, NumberOfIterationsLabel> number_of_iterations(3780);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomQuotaMetrics_h
