// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomNotificationMetrics_h
#define mozilla_GleanDomNotificationMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace web_notification {
  /**
   * generated from web_notification.icon_url_encoding
   */
  enum class IconUrlEncodingLabel: uint16_t {
    eUtf8 = 0,
    eDocumentCharset = 1,
    eEitherWay = 2,
    eNeitherWay = 3,
    e__Other__,
  };
  /**
   * The encoding of the notification icon URL
   */
  constexpr impl::Labeled<impl::CounterMetric, IconUrlEncodingLabel> icon_url_encoding(3766);

  /**
   * generated from web_notification.insecure_context_permission_request
   * Whether we saw a permission request from an insecure context.
   */
  constexpr impl::CounterMetric insecure_context_permission_request(3767);

  /**
   * generated from web_notification.permission_origin
   */
  enum class PermissionOriginLabel: uint16_t {
    eFirstParty = 0,
    eThirdParty = 1,
    eNestedFirstParty = 2,
    e__Other__,
  };
  /**
   * The category of the origin that retrieves Notification.permission.
   */
  constexpr impl::Labeled<impl::CounterMetric, PermissionOriginLabel> permission_origin(3768);

  /**
   * generated from web_notification.request_permission_origin
   */
  enum class RequestPermissionOriginLabel: uint16_t {
    eFirstParty = 0,
    eThirdParty = 1,
    eNestedFirstParty = 2,
    e__Other__,
  };
  /**
   * The category of the origin that calls Notification.requestPermission().
   */
  constexpr impl::Labeled<impl::CounterMetric, RequestPermissionOriginLabel> request_permission_origin(3769);

  /**
   * generated from web_notification.show_origin
   */
  enum class ShowOriginLabel: uint16_t {
    eFirstParty = 0,
    eThirdParty = 1,
    eNestedFirstParty = 2,
    e__Other__,
  };
  /**
   * The category of the origin that calls new Notification/showNotification().
   */
  constexpr impl::Labeled<impl::CounterMetric, ShowOriginLabel> show_origin(3770);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomNotificationMetrics_h
