// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomMetrics_h
#define mozilla_GleanDomMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace glam_experiment {
  /**
   * generated from glam_experiment.largest_contentful_paint
   * Duplicate of: `perf.largest_contentful_paint`
   * Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
   */
  constexpr impl::TimingDistributionMetric largest_contentful_paint(304);

  /**
   * generated from glam_experiment.protect_time
   * Duplicate of: `javascript_pageload.protect_time`
   * Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
   */
  constexpr impl::TimingDistributionMetric protect_time(305);
}

namespace security {
  /**
   * generated from security.fission_principals
   */
  struct FissionPrincipalsExtra {
    mozilla::Maybe<nsCString> principaltype;
    mozilla::Maybe<nsCString> scheme;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (principaltype) {
        extraKeys.AppendElement()->AssignASCII("principalType");
        extraValues.EmplaceBack(principaltype.value());
      }
      if (scheme) {
        extraKeys.AppendElement()->AssignASCII("scheme");
        extraValues.EmplaceBack(scheme.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * When running with Fission, we received an unexpected principal from the content process. Expected values for this telemetry event are the method names in ContentParent that received the unexpected principal. This event was generated to correspond to the Legacy Telemetry event security.fissionPrincipals#contentParent.
   */
  constexpr impl::EventMetric<FissionPrincipalsExtra> fission_principals(423);
}

namespace performance_page {
  /**
   * generated from performance.page.non_blank_paint
   * The time between navigationStart and the first non-blank paint of a foreground root content document, in milliseconds. This only records documents that were in an active docshell throughout the whole time between navigation start and non-blank paint. The non-blank paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric non_blank_paint(1202);
}

namespace dom_contentprocess {
  /**
   * generated from dom.contentprocess.build_id_mismatch
   * The number of times the about:restartrequired page appeared due to a buildID mismatch between the parent and the content processes. This metric was generated to correspond to the Legacy Telemetry scalar dom.contentprocess.buildID_mismatch.
   */
  constexpr impl::CounterMetric build_id_mismatch(3726);

  /**
   * generated from dom.contentprocess.build_id_mismatch_false_positive
   * The number of times a process crashed early but we could verify it was not because of buildID mismatch between the parent and the content processes. This metric was generated to correspond to the Legacy Telemetry scalar dom.contentprocess.buildID_mismatch_false_positive.
   */
  constexpr impl::CounterMetric build_id_mismatch_false_positive(3727);

  /**
   * generated from dom.contentprocess.launch_is_sync
   */
  enum class LaunchIsSyncLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether a content process was launched synchronously (unnecessarily delaying UI response).
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CONTENT_PROCESS_LAUNCH_IS_SYNC.
   */
  constexpr impl::Labeled<impl::CounterMetric, LaunchIsSyncLabel> launch_is_sync(3728);

  /**
   * generated from dom.contentprocess.launch_mainthread
   * Time spent on the main thread during asynchronous content process launch.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CONTENT_PROCESS_LAUNCH_MAINTHREAD_MS.
   */
  constexpr impl::TimingDistributionMetric launch_mainthread(3729);

  /**
   * generated from dom.contentprocess.launch_total
   * Total time elapsed during asynchronous content process launch, until the process is usable for loading content.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CONTENT_PROCESS_LAUNCH_TOTAL_MS.
   */
  constexpr impl::TimingDistributionMetric launch_total(3730);

  /**
   * generated from dom.contentprocess.os_priority_change_considered
   * The number of times we've had the opportunity to change content process priority due to a tab switch or a tab being opened. This metric was generated to correspond to the Legacy Telemetry scalar dom.contentprocess.os_priority_change_considered.
   */
  constexpr impl::CounterMetric os_priority_change_considered(3731);

  /**
   * generated from dom.contentprocess.os_priority_lowered
   * The number of times a content process has had its OS priority lowered due to only containing background tabs without audible media playing. This metric was generated to correspond to the Legacy Telemetry scalar dom.contentprocess.os_priority_lowered.
   */
  constexpr impl::CounterMetric os_priority_lowered(3732);

  /**
   * generated from dom.contentprocess.os_priority_raised
   * The number of times a content process has had its OS priority raised due to containing at least one foregrounded tab, or a tab with audible media has started playing in it. This metric was generated to correspond to the Legacy Telemetry scalar dom.contentprocess.os_priority_raised.
   */
  constexpr impl::CounterMetric os_priority_raised(3733);

  /**
   * generated from dom.contentprocess.sync_launch
   * Time elapsed during synchronous content process launch until the process is usable for loading content.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram CONTENT_PROCESS_SYNC_LAUNCH_MS.
   */
  constexpr impl::TimingDistributionMetric sync_launch(3734);
}

namespace dom_parentprocess {
  /**
   * generated from dom.parentprocess.private_window_used
   * Whether a private browsing window has been used in the session. This metric was generated to correspond to the Legacy Telemetry scalar dom.parentprocess.private_window_used.
   */
  constexpr impl::BooleanMetric private_window_used(3735);

  /**
   * generated from dom.parentprocess.process_launch_errors
   * Collect precise set of error code and calling site upon process creation failure path. This metric was generated to correspond to the Legacy Telemetry scalar dom.parentprocess.process_launch_errors.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> process_launch_errors(3736);
}

namespace dom_textfragment {
  /**
   * generated from dom.textfragment.create_directive
   * Time spent in FragmentDirective::CreateTextDirective()
   */
  constexpr impl::TimingDistributionMetric create_directive(3737);

  /**
   * generated from dom.textfragment.find_directives
   * Time spent in TextDirectiveFinder::FindTextDirectivesInDocument() per page load
   */
  constexpr impl::TimingDistributionMetric find_directives(3738);
}

namespace javascript_pageload {
  /**
   * generated from javascript.pageload.baseline_compile_time
   * Time spent during page load baseline compiling Javascript in ms. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric baseline_compile_time(3739);

  /**
   * generated from javascript.pageload.delazification_time
   * Time spent during page load delazifying Javascript in ms. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric delazification_time(3740);

  /**
   * generated from javascript.pageload.execution_time
   * Time spent during page load executing Javascript in ms. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric execution_time(3741);

  /**
   * generated from javascript.pageload.gc_time
   * Time spent during page load in the GC in ms. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric gc_time(3742);

  /**
   * generated from javascript.pageload.parse_time
   * Time spent during page load syntax parsing JS scripts on the main thread in ms. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric parse_time(3743);

  /**
   * generated from javascript.pageload.protect_time
   * Time spent during page load protecting JIT executable memory. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric protect_time(3744);

  /**
   * generated from javascript.pageload.xdr_encode_time
   * Time spent during page load XDR encoding Javascript in ms. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric xdr_encode_time(3745);
}

namespace mathml {
  /**
   * generated from mathml.doc_count
   * The number of documents that contained enabled MathML elements. This metric was generated to correspond to the Legacy Telemetry scalar mathml.doc_count.
   */
  constexpr impl::CounterMetric doc_count(3746);
}

namespace perf {
  /**
   * generated from perf.largest_contentful_paint
   * Time from navigation start to largest contentful paint.
   */
  constexpr impl::TimingDistributionMetric largest_contentful_paint(3747);

  /**
   * generated from perf.largest_contentful_paint_from_response_start
   * Time from response start to largest contentful paint.
   */
  constexpr impl::TimingDistributionMetric largest_contentful_paint_from_response_start(3748);

  /**
   * generated from perf.page_load
   */
  struct PageLoadExtra {
    mozilla::Maybe<uint32_t> dnsLookupTime;
    mozilla::Maybe<uint32_t> fcpTime;
    mozilla::Maybe<uint32_t> features;
    mozilla::Maybe<uint32_t> httpVer;
    mozilla::Maybe<uint32_t> jsExecTime;
    mozilla::Maybe<uint32_t> lcpTime;
    mozilla::Maybe<uint32_t> loadTime;
    mozilla::Maybe<nsCString> loadType;
    mozilla::Maybe<uint32_t> redirectCount;
    mozilla::Maybe<uint32_t> redirectTime;
    mozilla::Maybe<uint32_t> responseTime;
    mozilla::Maybe<bool> sameOriginNav;
    mozilla::Maybe<uint32_t> timeToRequestStart;
    mozilla::Maybe<uint32_t> tlsHandshakeTime;
    mozilla::Maybe<nsCString> trrDomain;
    mozilla::Maybe<bool> usingWebdriver;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (dnsLookupTime) {
        extraKeys.AppendElement()->AssignASCII("dns_lookup_time");
        extraValues.EmplaceBack(nsPrintfCString("%d", dnsLookupTime.value()));
      }
      if (fcpTime) {
        extraKeys.AppendElement()->AssignASCII("fcp_time");
        extraValues.EmplaceBack(nsPrintfCString("%d", fcpTime.value()));
      }
      if (features) {
        extraKeys.AppendElement()->AssignASCII("features");
        extraValues.EmplaceBack(nsPrintfCString("%d", features.value()));
      }
      if (httpVer) {
        extraKeys.AppendElement()->AssignASCII("http_ver");
        extraValues.EmplaceBack(nsPrintfCString("%d", httpVer.value()));
      }
      if (jsExecTime) {
        extraKeys.AppendElement()->AssignASCII("js_exec_time");
        extraValues.EmplaceBack(nsPrintfCString("%d", jsExecTime.value()));
      }
      if (lcpTime) {
        extraKeys.AppendElement()->AssignASCII("lcp_time");
        extraValues.EmplaceBack(nsPrintfCString("%d", lcpTime.value()));
      }
      if (loadTime) {
        extraKeys.AppendElement()->AssignASCII("load_time");
        extraValues.EmplaceBack(nsPrintfCString("%d", loadTime.value()));
      }
      if (loadType) {
        extraKeys.AppendElement()->AssignASCII("load_type");
        extraValues.EmplaceBack(loadType.value());
      }
      if (redirectCount) {
        extraKeys.AppendElement()->AssignASCII("redirect_count");
        extraValues.EmplaceBack(nsPrintfCString("%d", redirectCount.value()));
      }
      if (redirectTime) {
        extraKeys.AppendElement()->AssignASCII("redirect_time");
        extraValues.EmplaceBack(nsPrintfCString("%d", redirectTime.value()));
      }
      if (responseTime) {
        extraKeys.AppendElement()->AssignASCII("response_time");
        extraValues.EmplaceBack(nsPrintfCString("%d", responseTime.value()));
      }
      if (sameOriginNav) {
        extraKeys.AppendElement()->AssignASCII("same_origin_nav");
        extraValues.AppendElement()->AssignASCII(sameOriginNav.value() ? "true" : "false");
      }
      if (timeToRequestStart) {
        extraKeys.AppendElement()->AssignASCII("time_to_request_start");
        extraValues.EmplaceBack(nsPrintfCString("%d", timeToRequestStart.value()));
      }
      if (tlsHandshakeTime) {
        extraKeys.AppendElement()->AssignASCII("tls_handshake_time");
        extraValues.EmplaceBack(nsPrintfCString("%d", tlsHandshakeTime.value()));
      }
      if (trrDomain) {
        extraKeys.AppendElement()->AssignASCII("trr_domain");
        extraValues.EmplaceBack(trrDomain.value());
      }
      if (usingWebdriver) {
        extraKeys.AppendElement()->AssignASCII("using_webdriver");
        extraValues.AppendElement()->AssignASCII(usingWebdriver.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a top level content document has been loaded.
   */
  constexpr impl::EventMetric<PageLoadExtra> page_load(3749);
}

namespace performance_pageload {
  /**
   * generated from performance.pageload.fcp
   * The time between navigationStart and the first contentful paint of a foreground http or https root content document, in milliseconds. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric fcp(3750);

  /**
   * generated from performance.pageload.fcp_responsestart
   * The time between responseStart and the first contentful paint of a foreground http or https root content document, in milliseconds. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric fcp_responsestart(3751);

  /**
   * generated from performance.pageload.h3p_fcp_with_priority
   * The time between navigationStart and the first contentful paint of a foreground http or https root content document, in milliseconds. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. This is collected only on page load where the main document uses HTTP3. A "priority" header has been received.
   */
  constexpr impl::TimingDistributionMetric h3p_fcp_with_priority(3752);

  /**
   * generated from performance.pageload.http3_fcp_http3
   * The time between navigationStart and the first contentful paint of a foreground http or https root content document, in milliseconds. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. This is collected only on page load where the main document uses or suppports HTTP3.
   */
  constexpr impl::TimingDistributionMetric http3_fcp_http3(3753);

  /**
   * generated from performance.pageload.http3_fcp_supports_http3
   * The time between navigationStart and the first contentful paint of a foreground http or https root content document, in milliseconds. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. This is collected only on page load where the main document supports but is not using HTTP3.
   */
  constexpr impl::TimingDistributionMetric http3_fcp_supports_http3(3754);

  /**
   * generated from performance.pageload.http3_fcp_without_priority
   * The time between navigationStart and the first contentful paint of a foreground http or https root content document, in milliseconds. The contentful paint timestamp is taken during display list building and does not include rasterization or compositing of that paint. This is collected only on page load where the main document uses HTTP3. A "priority" header has not been received.
   */
  constexpr impl::TimingDistributionMetric http3_fcp_without_priority(3755);

  /**
   * generated from performance.pageload.load_time
   * Time in milliseconds from navigationStart to loadEventStart for the foreground http or https root content document. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric load_time(3756);

  /**
   * generated from performance.pageload.load_time_responsestart
   * Time in milliseconds from responseStart to loadEventStart for the foreground http or https root content document. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric load_time_responsestart(3757);
}

namespace performance_time {
  /**
   * generated from performance.time.dom_complete
   * Time from navigationStart to domComplete as per the W3C Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric dom_complete(3759);

  /**
   * generated from performance.time.dom_content_loaded_end
   * Time from navigationStart to domContentLoadedEventEnd as per the W3C Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric dom_content_loaded_end(3760);

  /**
   * generated from performance.time.dom_content_loaded_start
   * Time from navigationStart to domContentLoadedEventStart as per the W3C Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric dom_content_loaded_start(3761);

  /**
   * generated from performance.time.dom_interactive
   * Time from navigationStart to domInteractive as per the W3C Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric dom_interactive(3762);

  /**
   * generated from performance.time.load_event_end
   * Time from navigationStart to loadEventEnd as per the W3C Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric load_event_end(3763);

  /**
   * generated from performance.time.load_event_start
   * Time from navigationStart to loadEventStart as per the W3C Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric load_event_start(3764);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomMetrics_h
