// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomMediaWebrtcMetrics_h
#define mozilla_GleanDomMediaWebrtcMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace codec_stats {
  /**
   * generated from codec.stats.audio_preferred_codec
   * Counts the preferred audio codec being signaled to us to identify preferred audio codec.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> audio_preferred_codec(3660);

  /**
   * generated from codec.stats.other_fec_signaled
   * Count how many other fec options are being offered.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> other_fec_signaled(3661);

  /**
   * generated from codec.stats.ulpfec_negotiated
   */
  enum class UlpfecNegotiatedLabel: uint16_t {
    eNegotiated = 0,
    eNotNegotiated = 1,
    e__Other__,
  };
  /**
   * Counts the number of times that ulpfec is negotiated or not negotiated on the first negotiation for each video transceiver.
   */
  constexpr impl::Labeled<impl::CounterMetric, UlpfecNegotiatedLabel> ulpfec_negotiated(3662);

  /**
   * generated from codec.stats.video_preferred_codec
   * Counts the preferred video codec being signaled to us to identify preferred video codec.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> video_preferred_codec(3663);
}

namespace rtcrtpsender {
  /**
   * generated from rtcrtpsender.count
   * The number of RTCRtpSenders created.
   */
  constexpr impl::DenominatorMetric count(3664);

  /**
   * generated from rtcrtpsender.count_setparameters_compat
   * The number of RTCRtpSenders created that use the compatibility mode for setParameters.
   */
  constexpr impl::DenominatorMetric count_setparameters_compat(3665);

  /**
   * generated from rtcrtpsender.used_sendencodings
   * The proportion of RTCRtpSenders that were created by an addTransceivers call that was passed a sendEncodings.
   */
  constexpr impl::NumeratorMetric used_sendencodings(3666);
}

namespace rtcrtpsender_setparameters {
  /**
   * generated from rtcrtpsender.setparameters.fail_length_changed
   * The proportion of RTCRtpSenders that have thrown an error at least once about a setParameters call that attempted to change the number of encodings.
   */
  constexpr impl::NumeratorMetric fail_length_changed(3667);

  /**
   * generated from rtcrtpsender.setparameters.fail_no_encodings
   * The proportion of RTCRtpSenders configured with the setParameters compat mode that have thrown an error at least once about a setParameters call that had no encodings (we do not measure this against the general population of RTCRtpSenders, since without the compat mode this failure is never observed, because it fails the length change check).
   */
  constexpr impl::NumeratorMetric fail_no_encodings(3668);

  /**
   * generated from rtcrtpsender.setparameters.fail_no_getparameters
   * The proportion of RTCRtpSenders that have thrown an error at least once about a setParameters call because [[LastReturnedParameters]] was not set. (ie; there was not a recent enough call to getParameters)
   */
  constexpr impl::NumeratorMetric fail_no_getparameters(3669);

  /**
   * generated from rtcrtpsender.setparameters.fail_no_transactionid
   * The proportion of RTCRtpSenders that have thrown an error at least once about a setParameters call that did not set the transactionId field.
   */
  constexpr impl::NumeratorMetric fail_no_transactionid(3670);

  /**
   * generated from rtcrtpsender.setparameters.fail_other
   * The proportion of RTCRtpSenders that have thrown an error at least once about a setParameters call that had no encodings.
   */
  constexpr impl::NumeratorMetric fail_other(3671);

  /**
   * generated from rtcrtpsender.setparameters.fail_rid_changed
   * The proportion of RTCRtpSenders that have thrown an error at least once about a setParameters call that attempted to change the rid on an encoding (note that we only check this if the encoding count did not change, see fail_length_changed).
   */
  constexpr impl::NumeratorMetric fail_rid_changed(3672);

  /**
   * generated from rtcrtpsender.setparameters.fail_stale_transactionid
   * The proportion of RTCRtpSenders that have thrown an error at least once about a setParameters call that used a stale transaction id.
   */
  constexpr impl::NumeratorMetric fail_stale_transactionid(3673);

  /**
   * generated from rtcrtpsender.setparameters.warn_length_changed
   * The proportion of RTCRtpSenders configured with the setParameters compat mode that have warned at least once about a setParameters call that attempted to change the number of encodings.
   */
  constexpr impl::NumeratorMetric warn_length_changed(3674);

  /**
   * generated from rtcrtpsender.setparameters.warn_no_getparameters
   * The proportion of RTCRtpSenders configured with the setParameters compat mode that have warned at least once about a setParameters call because [[LastReturnedParameters]] was not set.  (ie; there was not a recent enough call to getParameters)
   */
  constexpr impl::NumeratorMetric warn_no_getparameters(3675);

  /**
   * generated from rtcrtpsender.setparameters.warn_no_transactionid
   * The proportion of RTCRtpSenders configured with the setParameters compat mode that have warned at least once about a setParameters call that did not set the transactionId field.
   */
  constexpr impl::NumeratorMetric warn_no_transactionid(3676);
}

namespace webrtc {
  /**
   * generated from webrtc.audio_quality_inbound_bandwidth_kbits
   * Locally measured data rate on inbound audio (kbit/s). Computed every second of a call.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_AUDIO_QUALITY_INBOUND_BANDWIDTH_KBITS.
   */
  constexpr impl::CustomDistributionMetric audio_quality_inbound_bandwidth_kbits(3677);

  /**
   * generated from webrtc.audio_quality_inbound_jitter
   * Locally measured jitter on inbound audio (ms). Sampled every second of a call.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_AUDIO_QUALITY_INBOUND_JITTER.
   */
  constexpr impl::TimingDistributionMetric audio_quality_inbound_jitter(3678);

  /**
   * generated from webrtc.audio_quality_inbound_packetloss_rate
   * Locally measured packet loss on inbound audio (permille). Sampled every second of a call.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_AUDIO_QUALITY_INBOUND_PACKETLOSS_RATE.
   */
  constexpr impl::CustomDistributionMetric audio_quality_inbound_packetloss_rate(3679);

  /**
   * generated from webrtc.audio_quality_outbound_jitter
   * RTCP-reported jitter by remote recipient of outbound audio (ms). Sampled every second of a call (for easy comparison).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_AUDIO_QUALITY_OUTBOUND_JITTER.
   */
  constexpr impl::TimingDistributionMetric audio_quality_outbound_jitter(3680);

  /**
   * generated from webrtc.audio_quality_outbound_packetloss_rate
   * RTCP-reported packet loss by remote recipient of outbound audio (permille). Sampled every second of a call (for easy comparison).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_AUDIO_QUALITY_OUTBOUND_PACKETLOSS_RATE.
   */
  constexpr impl::CustomDistributionMetric audio_quality_outbound_packetloss_rate(3681);

  /**
   * generated from webrtc.audio_quality_outbound_rtt
   * Roundtrip time of outbound audio (ms). Sampled every second of a call.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_AUDIO_QUALITY_OUTBOUND_RTT.
   */
  constexpr impl::TimingDistributionMetric audio_quality_outbound_rtt(3682);

  /**
   * generated from webrtc.av_call_duration
   * The length of time (in seconds) that a call with audio or video in it lasted.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_AV_CALL_DURATION.
   */
  constexpr impl::TimingDistributionMetric av_call_duration(3683);

  /**
   * generated from webrtc.call_count_3
   * The number of successfully connected calls made during a session (discounting re-negotiations).
   * This metric was generated to correspond to the Legacy Telemetry count histogram WEBRTC_CALL_COUNT_3.
   */
  constexpr impl::CounterMetric call_count_3(3684);

  /**
   * generated from webrtc.call_duration
   * The length of time (in seconds) that a call lasted.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_CALL_DURATION.
   */
  constexpr impl::TimingDistributionMetric call_duration(3685);

  /**
   * generated from webrtc.call_type
   * Type of call: (Bitmask) Audio = 1, Video = 2, DataChannels = 4
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram WEBRTC_CALL_TYPE.
   */
  constexpr impl::CustomDistributionMetric call_type(3686);

  /**
   * generated from webrtc.datachannel_negotiated
   */
  enum class DatachannelNegotiatedLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Was DataChannels negotiated
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram WEBRTC_DATACHANNEL_NEGOTIATED.
   */
  constexpr impl::Labeled<impl::CounterMetric, DatachannelNegotiatedLabel> datachannel_negotiated(3687);

  /**
   * generated from webrtc.get_user_media_type
   * Type for media in getUserMedia calls (0=Camera, 1=Screen, 2=Application, 3=Window, 4=Browser, 5=Microphone, 6=AudioCapture, 7=Other)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram WEBRTC_GET_USER_MEDIA_TYPE.
   */
  constexpr impl::CustomDistributionMetric get_user_media_type(3688);

  /**
   * generated from webrtc.gmp_init_success
   */
  enum class GmpInitSuccessLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Counts of GMP codec initialization success and failure
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram WEBRTC_GMP_INIT_SUCCESS.
   */
  constexpr impl::Labeled<impl::CounterMetric, GmpInitSuccessLabel> gmp_init_success(3689);

  /**
   * generated from webrtc.h264_enabled
   */
  enum class H264EnabledLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether any kind of H264 is enabled
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram WEBRTC_H264_ENABLED.
   */
  constexpr impl::Labeled<impl::CounterMetric, H264EnabledLabel> h264_enabled(3690);

  /**
   * generated from webrtc.hardware_h264_enabled
   */
  enum class HardwareH264EnabledLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether software H264 is enabled
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram WEBRTC_HARDWARE_H264_ENABLED.
   */
  constexpr impl::Labeled<impl::CounterMetric, HardwareH264EnabledLabel> hardware_h264_enabled(3691);

  /**
   * generated from webrtc.has_h264_hardware
   */
  enum class HasH264HardwareLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether the user has H264 hardware
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram WEBRTC_HAS_H264_HARDWARE.
   */
  constexpr impl::Labeled<impl::CounterMetric, HasH264HardwareLabel> has_h264_hardware(3692);

  /**
   * generated from webrtc.max_audio_receive_track
   * Number of Audio tracks received simultaneously
   * This metric was generated to correspond to the Legacy Telemetry linear histogram WEBRTC_MAX_AUDIO_RECEIVE_TRACK.
   */
  constexpr impl::CustomDistributionMetric max_audio_receive_track(3693);

  /**
   * generated from webrtc.max_audio_send_track
   * Number of Audio tracks sent simultaneously
   * This metric was generated to correspond to the Legacy Telemetry linear histogram WEBRTC_MAX_AUDIO_SEND_TRACK.
   */
  constexpr impl::CustomDistributionMetric max_audio_send_track(3694);

  /**
   * generated from webrtc.max_video_receive_track
   * Number of Video tracks received simultaneously
   * This metric was generated to correspond to the Legacy Telemetry linear histogram WEBRTC_MAX_VIDEO_RECEIVE_TRACK.
   */
  constexpr impl::CustomDistributionMetric max_video_receive_track(3695);

  /**
   * generated from webrtc.max_video_send_track
   * Number of Video tracks sent simultaneously
   * This metric was generated to correspond to the Legacy Telemetry linear histogram WEBRTC_MAX_VIDEO_SEND_TRACK.
   */
  constexpr impl::CustomDistributionMetric max_video_send_track(3696);

  /**
   * generated from webrtc.renegotiations
   * Number of Renegotiations during each call
   * This metric was generated to correspond to the Legacy Telemetry linear histogram WEBRTC_RENEGOTIATIONS.
   */
  constexpr impl::CustomDistributionMetric renegotiations(3697);

  /**
   * generated from webrtc.software_h264_enabled
   */
  enum class SoftwareH264EnabledLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether hardware H264 is enabled
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram WEBRTC_SOFTWARE_H264_ENABLED.
   */
  constexpr impl::Labeled<impl::CounterMetric, SoftwareH264EnabledLabel> software_h264_enabled(3698);

  /**
   * generated from webrtc.video_decoder_bitrate_avg_per_call_kbps
   * Video decoder's average bitrate (in kbits/s) over an entire call
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_DECODER_BITRATE_AVG_PER_CALL_KBPS.
   */
  constexpr impl::CustomDistributionMetric video_decoder_bitrate_avg_per_call_kbps(3699);

  /**
   * generated from webrtc.video_decoder_bitrate_std_dev_per_call_kbps
   * Standard deviation from video decoder's average bitrate (in kbits/s) over an entire call
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_DECODER_BITRATE_STD_DEV_PER_CALL_KBPS.
   */
  constexpr impl::CustomDistributionMetric video_decoder_bitrate_std_dev_per_call_kbps(3700);

  /**
   * generated from webrtc.video_decoder_discarded_packets_per_call_ppm
   * Video decoder's number of discarded packets (in packets/min) over an entire call
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_DECODER_DISCARDED_PACKETS_PER_CALL_PPM.
   */
  constexpr impl::CustomDistributionMetric video_decoder_discarded_packets_per_call_ppm(3701);

  /**
   * generated from webrtc.video_decoder_framerate_10x_std_dev_per_call
   * Standard deviation from video decoder's average framerate (in 1/10 fps) over an entire call
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_DECODER_FRAMERATE_10X_STD_DEV_PER_CALL.
   */
  constexpr impl::CustomDistributionMetric video_decoder_framerate_10x_std_dev_per_call(3702);

  /**
   * generated from webrtc.video_decoder_framerate_avg_per_call
   * Video decoder's average framerate (in fps) over an entire call
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_DECODER_FRAMERATE_AVG_PER_CALL.
   */
  constexpr impl::CustomDistributionMetric video_decoder_framerate_avg_per_call(3703);

  /**
   * generated from webrtc.video_encoder_bitrate_avg_per_call_kbps
   * Video encoder's average bitrate (in kbits/s) over an entire call
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_ENCODER_BITRATE_AVG_PER_CALL_KBPS.
   */
  constexpr impl::CustomDistributionMetric video_encoder_bitrate_avg_per_call_kbps(3704);

  /**
   * generated from webrtc.video_encoder_bitrate_std_dev_per_call_kbps
   * Standard deviation from video encoder's average bitrate (in kbits/s) over an entire call
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_ENCODER_BITRATE_STD_DEV_PER_CALL_KBPS.
   */
  constexpr impl::CustomDistributionMetric video_encoder_bitrate_std_dev_per_call_kbps(3705);

  /**
   * generated from webrtc.video_encoder_framerate_10x_std_dev_per_call
   * Standard deviation from video encoder's average framerate (in 1/10 fps) over an entire call
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_ENCODER_FRAMERATE_10X_STD_DEV_PER_CALL.
   */
  constexpr impl::CustomDistributionMetric video_encoder_framerate_10x_std_dev_per_call(3706);

  /**
   * generated from webrtc.video_encoder_framerate_avg_per_call
   * Video encoder's average framerate (in fps) over an entire call
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_ENCODER_FRAMERATE_AVG_PER_CALL.
   */
  constexpr impl::CustomDistributionMetric video_encoder_framerate_avg_per_call(3707);

  /**
   * generated from webrtc.video_quality_inbound_bandwidth_kbits
   * Locally measured data rate of inbound video (kbit/s). Computed every second of a call.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_QUALITY_INBOUND_BANDWIDTH_KBITS.
   */
  constexpr impl::CustomDistributionMetric video_quality_inbound_bandwidth_kbits(3708);

  /**
   * generated from webrtc.video_quality_inbound_jitter
   * Locally measured jitter on inbound video (ms). Sampled every second of a call.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_QUALITY_INBOUND_JITTER.
   */
  constexpr impl::TimingDistributionMetric video_quality_inbound_jitter(3709);

  /**
   * generated from webrtc.video_quality_inbound_packetloss_rate
   * Locally measured packet loss on inbound video (permille). Sampled every second of a call.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_QUALITY_INBOUND_PACKETLOSS_RATE.
   */
  constexpr impl::CustomDistributionMetric video_quality_inbound_packetloss_rate(3710);

  /**
   * generated from webrtc.video_quality_outbound_jitter
   * RTCP-reported jitter by remote recipient of outbound video (ms). Sampled every second of a call (for easy comparison).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_QUALITY_OUTBOUND_JITTER.
   */
  constexpr impl::TimingDistributionMetric video_quality_outbound_jitter(3711);

  /**
   * generated from webrtc.video_quality_outbound_packetloss_rate
   * RTCP-reported packet loss by remote recipient of outbound video (permille). Sampled every second of a call (for easy comparison).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_QUALITY_OUTBOUND_PACKETLOSS_RATE.
   */
  constexpr impl::CustomDistributionMetric video_quality_outbound_packetloss_rate(3712);

  /**
   * generated from webrtc.video_quality_outbound_rtt
   * Roundtrip time of outbound video (ms). Sampled every second of a call.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBRTC_VIDEO_QUALITY_OUTBOUND_RTT.
   */
  constexpr impl::TimingDistributionMetric video_quality_outbound_rtt(3713);
}

namespace webrtc_signaling {
  /**
   * generated from webrtc.signaling.audio_msection_negotiated
   */
  struct AudioMsectionNegotiatedExtra {
    mozilla::Maybe<nsCString> codecs;
    mozilla::Maybe<nsCString> direction;
    mozilla::Maybe<bool> hasRtcpMux;
    mozilla::Maybe<nsCString> pcId;
    mozilla::Maybe<uint32_t> pcNegotiationCount;
    mozilla::Maybe<nsCString> preferredRecvCodec;
    mozilla::Maybe<nsCString> preferredSendCodec;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (codecs) {
        extraKeys.AppendElement()->AssignASCII("codecs");
        extraValues.EmplaceBack(codecs.value());
      }
      if (direction) {
        extraKeys.AppendElement()->AssignASCII("direction");
        extraValues.EmplaceBack(direction.value());
      }
      if (hasRtcpMux) {
        extraKeys.AppendElement()->AssignASCII("has_rtcp_mux");
        extraValues.AppendElement()->AssignASCII(hasRtcpMux.value() ? "true" : "false");
      }
      if (pcId) {
        extraKeys.AppendElement()->AssignASCII("pc_id");
        extraValues.EmplaceBack(pcId.value());
      }
      if (pcNegotiationCount) {
        extraKeys.AppendElement()->AssignASCII("pc_negotiation_count");
        extraValues.EmplaceBack(nsPrintfCString("%d", pcNegotiationCount.value()));
      }
      if (preferredRecvCodec) {
        extraKeys.AppendElement()->AssignASCII("preferred_recv_codec");
        extraValues.EmplaceBack(preferredRecvCodec.value());
      }
      if (preferredSendCodec) {
        extraKeys.AppendElement()->AssignASCII("preferred_send_codec");
        extraValues.EmplaceBack(preferredSendCodec.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collects data relevant to an audio m-section as part of SDP Offer/Answer negotiation completing and the RTCPeerConnection's signaling state becoming stable.
   */
  constexpr impl::EventMetric<AudioMsectionNegotiatedExtra> audio_msection_negotiated(3714);

  /**
   * generated from webrtc.signaling.sdp_negotiated
   */
  struct SdpNegotiatedExtra {
    mozilla::Maybe<nsCString> bundlePolicy;
    mozilla::Maybe<nsCString> iceTransportPolicy;
    mozilla::Maybe<bool> isRemoteIceLite;
    mozilla::Maybe<uint32_t> negotiationCount;
    mozilla::Maybe<uint32_t> numMsectionsAudioRecvonly;
    mozilla::Maybe<uint32_t> numMsectionsAudioSendonly;
    mozilla::Maybe<uint32_t> numMsectionsAudioSendrecv;
    mozilla::Maybe<uint32_t> numMsectionsData;
    mozilla::Maybe<uint32_t> numMsectionsVideoRecvonly;
    mozilla::Maybe<uint32_t> numMsectionsVideoSendonly;
    mozilla::Maybe<uint32_t> numMsectionsVideoSendrecv;
    mozilla::Maybe<uint32_t> numTransports;
    mozilla::Maybe<nsCString> pcId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (bundlePolicy) {
        extraKeys.AppendElement()->AssignASCII("bundle_policy");
        extraValues.EmplaceBack(bundlePolicy.value());
      }
      if (iceTransportPolicy) {
        extraKeys.AppendElement()->AssignASCII("ice_transport_policy");
        extraValues.EmplaceBack(iceTransportPolicy.value());
      }
      if (isRemoteIceLite) {
        extraKeys.AppendElement()->AssignASCII("is_remote_ice_lite");
        extraValues.AppendElement()->AssignASCII(isRemoteIceLite.value() ? "true" : "false");
      }
      if (negotiationCount) {
        extraKeys.AppendElement()->AssignASCII("negotiation_count");
        extraValues.EmplaceBack(nsPrintfCString("%d", negotiationCount.value()));
      }
      if (numMsectionsAudioRecvonly) {
        extraKeys.AppendElement()->AssignASCII("num_msections_audio_recvonly");
        extraValues.EmplaceBack(nsPrintfCString("%d", numMsectionsAudioRecvonly.value()));
      }
      if (numMsectionsAudioSendonly) {
        extraKeys.AppendElement()->AssignASCII("num_msections_audio_sendonly");
        extraValues.EmplaceBack(nsPrintfCString("%d", numMsectionsAudioSendonly.value()));
      }
      if (numMsectionsAudioSendrecv) {
        extraKeys.AppendElement()->AssignASCII("num_msections_audio_sendrecv");
        extraValues.EmplaceBack(nsPrintfCString("%d", numMsectionsAudioSendrecv.value()));
      }
      if (numMsectionsData) {
        extraKeys.AppendElement()->AssignASCII("num_msections_data");
        extraValues.EmplaceBack(nsPrintfCString("%d", numMsectionsData.value()));
      }
      if (numMsectionsVideoRecvonly) {
        extraKeys.AppendElement()->AssignASCII("num_msections_video_recvonly");
        extraValues.EmplaceBack(nsPrintfCString("%d", numMsectionsVideoRecvonly.value()));
      }
      if (numMsectionsVideoSendonly) {
        extraKeys.AppendElement()->AssignASCII("num_msections_video_sendonly");
        extraValues.EmplaceBack(nsPrintfCString("%d", numMsectionsVideoSendonly.value()));
      }
      if (numMsectionsVideoSendrecv) {
        extraKeys.AppendElement()->AssignASCII("num_msections_video_sendrecv");
        extraValues.EmplaceBack(nsPrintfCString("%d", numMsectionsVideoSendrecv.value()));
      }
      if (numTransports) {
        extraKeys.AppendElement()->AssignASCII("num_transports");
        extraValues.EmplaceBack(nsPrintfCString("%d", numTransports.value()));
      }
      if (pcId) {
        extraKeys.AppendElement()->AssignASCII("pc_id");
        extraValues.EmplaceBack(pcId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collects data relevant to a SDP Offer/Answer negotiation completing and the RTCPeerConnection's signaling state becoming stable. The pc_id and negotiation_count uniquely identifies these events.
   */
  constexpr impl::EventMetric<SdpNegotiatedExtra> sdp_negotiated(3715);

  /**
   * generated from webrtc.signaling.video_msection_negotiated
   */
  struct VideoMsectionNegotiatedExtra {
    mozilla::Maybe<nsCString> codecs;
    mozilla::Maybe<nsCString> direction;
    mozilla::Maybe<bool> hasRtcpMux;
    mozilla::Maybe<uint32_t> numSendSimulcastLayers;
    mozilla::Maybe<nsCString> pcId;
    mozilla::Maybe<uint32_t> pcNegotiationCount;
    mozilla::Maybe<nsCString> preferredRecvCodec;
    mozilla::Maybe<nsCString> preferredSendCodec;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (codecs) {
        extraKeys.AppendElement()->AssignASCII("codecs");
        extraValues.EmplaceBack(codecs.value());
      }
      if (direction) {
        extraKeys.AppendElement()->AssignASCII("direction");
        extraValues.EmplaceBack(direction.value());
      }
      if (hasRtcpMux) {
        extraKeys.AppendElement()->AssignASCII("has_rtcp_mux");
        extraValues.AppendElement()->AssignASCII(hasRtcpMux.value() ? "true" : "false");
      }
      if (numSendSimulcastLayers) {
        extraKeys.AppendElement()->AssignASCII("num_send_simulcast_layers");
        extraValues.EmplaceBack(nsPrintfCString("%d", numSendSimulcastLayers.value()));
      }
      if (pcId) {
        extraKeys.AppendElement()->AssignASCII("pc_id");
        extraValues.EmplaceBack(pcId.value());
      }
      if (pcNegotiationCount) {
        extraKeys.AppendElement()->AssignASCII("pc_negotiation_count");
        extraValues.EmplaceBack(nsPrintfCString("%d", pcNegotiationCount.value()));
      }
      if (preferredRecvCodec) {
        extraKeys.AppendElement()->AssignASCII("preferred_recv_codec");
        extraValues.EmplaceBack(preferredRecvCodec.value());
      }
      if (preferredSendCodec) {
        extraKeys.AppendElement()->AssignASCII("preferred_send_codec");
        extraValues.EmplaceBack(preferredSendCodec.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Collects data relevant to a video m-section as part of SDP Offer/Answer negotiation completing and the RTCPeerConnection's signaling state becoming stable.
   */
  constexpr impl::EventMetric<VideoMsectionNegotiatedExtra> video_msection_negotiated(3716);
}

namespace webrtc_video {
  /**
   * generated from webrtc.video.recv_codec_used
   * The video codec used for receiving video on a WebRTC call. This metric was generated to correspond to the Legacy Telemetry scalar webrtc.video.recv_codec_used.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> recv_codec_used(3717);

  /**
   * generated from webrtc.video.send_codec_used
   * The video codec used for sending video on a WebRTC call. This metric was generated to correspond to the Legacy Telemetry scalar webrtc.video.send_codec_used.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> send_codec_used(3718);
}

namespace webrtcdtls {
  /**
   * generated from webrtcdtls.cipher
   * The CipherSuite used for each webrtc DTLS connection, as a string representation of the CipherSuite's ID in 4 hex digits (eg; TLS_DHE_RSA_WITH_AES_128_CBC_SHA would be "0x0033")
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> cipher(3719);

  /**
   * generated from webrtcdtls.client_handshake_result
   * The result of each webrtc client DTLS handshake as a string containing either the name of the error code (eg; SSL_ERROR_BAD_CERTIFICATE), SUCCESS for successful handshakes, ALPN_FAILURE when ALPN negotiation fails, or CERT_FAILURE when cert validation fails.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> client_handshake_result(3720);

  /**
   * generated from webrtcdtls.client_handshake_started_counter
   * The number of webrtc transports that have started a DTLS handshake as the client.
   */
  constexpr impl::CounterMetric client_handshake_started_counter(3721);

  /**
   * generated from webrtcdtls.protocol_version
   * The version of DTLS used for each webrtc connection. Can be 1.0, 1.2, or 1.3 (there is no 1.1 version of DTLS)
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> protocol_version(3722);

  /**
   * generated from webrtcdtls.server_handshake_result
   * The result of each webrtc server DTLS handshake, as the name of the error code (eg; SSL_ERROR_BAD_CERTIFICATE), the empty string for successful handshakes, ALPN_FAILURE when ALPN negotiation fails, or CERT_FAILURE when cert validation fails.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> server_handshake_result(3723);

  /**
   * generated from webrtcdtls.server_handshake_started_counter
   * The number of webrtc transports that have started a DTLS handshake as the server.
   */
  constexpr impl::CounterMetric server_handshake_started_counter(3724);

  /**
   * generated from webrtcdtls.srtp_cipher
   * The SRTPProtectionProfile (see RFC 5764) used for each webrtc SRTP connection, as a string representation of the SRTPProtectionProfile's ID in 4 hex digits (eg; SRTP_AES128_CM_HMAC_SHA1_80 would be "0x0001")
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> srtp_cipher(3725);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomMediaWebrtcMetrics_h
