// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomMediaPlatformsWmfMetrics_h
#define mozilla_GleanDomMediaPlatformsWmfMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace media {
  /**
   * generated from media.decoder_backend_used
   * Media decoder backend (0=WMF Software, 1=DXVA2D3D9, 2=DXVA2D3D11)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram MEDIA_DECODER_BACKEND_USED.
   */
  constexpr impl::CustomDistributionMetric decoder_backend_used(3648);
}

namespace mfcdm {
  /**
   * generated from mfcdm.eme_playback
   */
  struct EmePlaybackExtra {
    mozilla::Maybe<uint32_t> droppedFrames;
    mozilla::Maybe<nsCString> keySystem;
    mozilla::Maybe<uint32_t> playedTime;
    mozilla::Maybe<uint32_t> renderedFrames;
    mozilla::Maybe<nsCString> resolution;
    mozilla::Maybe<nsCString> videoCodec;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (droppedFrames) {
        extraKeys.AppendElement()->AssignASCII("dropped_frames");
        extraValues.EmplaceBack(nsPrintfCString("%d", droppedFrames.value()));
      }
      if (keySystem) {
        extraKeys.AppendElement()->AssignASCII("key_system");
        extraValues.EmplaceBack(keySystem.value());
      }
      if (playedTime) {
        extraKeys.AppendElement()->AssignASCII("played_time");
        extraValues.EmplaceBack(nsPrintfCString("%d", playedTime.value()));
      }
      if (renderedFrames) {
        extraKeys.AppendElement()->AssignASCII("rendered_frames");
        extraValues.EmplaceBack(nsPrintfCString("%d", renderedFrames.value()));
      }
      if (resolution) {
        extraKeys.AppendElement()->AssignASCII("resolution");
        extraValues.EmplaceBack(resolution.value());
      }
      if (videoCodec) {
        extraKeys.AppendElement()->AssignASCII("video_codec");
        extraValues.EmplaceBack(videoCodec.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record the information about the EME playback when using the media engine. The value of this event is the key system name.
   */
  constexpr impl::EventMetric<EmePlaybackExtra> eme_playback(3658);

  /**
   * generated from mfcdm.error
   */
  struct ErrorExtra {
    mozilla::Maybe<nsCString> audioCodec;
    mozilla::Maybe<nsCString> currentState;
    mozilla::Maybe<nsCString> errorName;
    mozilla::Maybe<nsCString> keySystem;
    mozilla::Maybe<uint32_t> platformError;
    mozilla::Maybe<nsCString> resolution;
    mozilla::Maybe<nsCString> videoCodec;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (audioCodec) {
        extraKeys.AppendElement()->AssignASCII("audio_codec");
        extraValues.EmplaceBack(audioCodec.value());
      }
      if (currentState) {
        extraKeys.AppendElement()->AssignASCII("current_state");
        extraValues.EmplaceBack(currentState.value());
      }
      if (errorName) {
        extraKeys.AppendElement()->AssignASCII("error_name");
        extraValues.EmplaceBack(errorName.value());
      }
      if (keySystem) {
        extraKeys.AppendElement()->AssignASCII("key_system");
        extraValues.EmplaceBack(keySystem.value());
      }
      if (platformError) {
        extraKeys.AppendElement()->AssignASCII("platform_error");
        extraValues.EmplaceBack(nsPrintfCString("%d", platformError.value()));
      }
      if (resolution) {
        extraKeys.AppendElement()->AssignASCII("resolution");
        extraValues.EmplaceBack(resolution.value());
      }
      if (videoCodec) {
        extraKeys.AppendElement()->AssignASCII("video_codec");
        extraValues.EmplaceBack(videoCodec.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record the error or crash happened while using the media engine playback. The value of this event is the name of error. This probe covers both EME and non-EME playback.
   */
  constexpr impl::EventMetric<ErrorExtra> error(3659);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomMediaPlatformsWmfMetrics_h
