/* THIS FILE IS AUTOGENERATED FROM VideoDecoder.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_VIDEODECODERBINDING_H_
#define DOM_VIDEODECODERBINDING_H_

#include "VideoColorSpaceBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionTypes.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {
namespace dom {

class DOMException;
class MaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer;
struct NativePropertyHooks;
class OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer;
class ProtoAndIfaceCache;
struct VideoColorSpaceInit;
class VideoDecoder;
struct VideoDecoderConfig;
struct VideoDecoderConfigAtoms;
struct VideoDecoderInitAtoms;
struct VideoDecoderSupportAtoms;
class VideoFrame;
class VideoFrameOutputCallback;
class WebCodecsErrorCallback;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class HardwareAcceleration : uint8_t {
  No_preference,
  Prefer_hardware,
  Prefer_software,
};

namespace binding_detail {
template <> struct EnumStrings<HardwareAcceleration> {
  static constexpr nsLiteralCString Values[3] {
    "no-preference"_ns,
    "prefer-hardware"_ns,
    "prefer-software"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, HardwareAcceleration aArgument, JS::MutableHandle<JS::Value> aValue);


enum class CodecState : uint8_t {
  Unconfigured,
  Configured,
  Closed,
};

namespace binding_detail {
template <> struct EnumStrings<CodecState> {
  static constexpr nsLiteralCString Values[3] {
    "unconfigured"_ns,
    "configured"_ns,
    "closed"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, CodecState aArgument, JS::MutableHandle<JS::Value> aValue);


struct VideoDecoderConfig : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mCodec;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mCodedHeight;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mCodedWidth;
  MOZ_INIT_OUTSIDE_CTOR Optional<VideoColorSpaceInit> mColorSpace;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningMaybeSharedArrayBufferViewOrMaybeSharedArrayBuffer> mDescription;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDisplayAspectHeight;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDisplayAspectWidth;
  MOZ_INIT_OUTSIDE_CTOR HardwareAcceleration mHardwareAcceleration;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mOptimizeForLatency;

  VideoDecoderConfig();

  explicit inline VideoDecoderConfig(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  VideoDecoderConfig(VideoDecoderConfig&& aOther) = default;

private:
  VideoDecoderConfig(const VideoDecoderConfig&) = delete;
  VideoDecoderConfig& operator=(const VideoDecoderConfig&) = delete;

  static bool
  InitIds(JSContext* cx, VideoDecoderConfigAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastVideoDecoderConfig : public VideoDecoderConfig
{
  inline FastVideoDecoderConfig()
    : VideoDecoderConfig(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct VideoDecoderInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<WebCodecsErrorCallback> mError;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<VideoFrameOutputCallback> mOutput;

  VideoDecoderInit();

  explicit inline VideoDecoderInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  VideoDecoderInit(VideoDecoderInit&& aOther) = default;

private:
  VideoDecoderInit(const VideoDecoderInit&) = delete;
  VideoDecoderInit& operator=(const VideoDecoderInit&) = delete;

  static bool
  InitIds(JSContext* cx, VideoDecoderInitAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mError, "mError", aFlags);
    ImplCycleCollectionTraverse(aCallback, mOutput, "mOutput", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mError);
    ImplCycleCollectionUnlink(mOutput);
  }
};

namespace binding_detail {
struct FastVideoDecoderInit : public VideoDecoderInit
{
  inline FastVideoDecoderInit()
    : VideoDecoderInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class VideoFrameOutputCallback : public CallbackFunction
{
public:
  explicit inline VideoFrameOutputCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline VideoFrameOutputCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline VideoFrameOutputCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline VideoFrameOutputCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, VideoFrame& output, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "VideoFrameOutputCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, output, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(VideoFrame& output, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "VideoFrameOutputCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, output, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, VideoFrame& output, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, output, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(VideoFrame& output, const char* aExecutionReason = nullptr)
  {
    return Call(output, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const VideoFrameOutputCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, VideoFrame& output, ErrorResult& aRv);
};


namespace binding_detail {
class FastVideoFrameOutputCallback : public VideoFrameOutputCallback
{
public:
  explicit inline FastVideoFrameOutputCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : VideoFrameOutputCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    VideoFrameOutputCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    VideoFrameOutputCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class WebCodecsErrorCallback : public CallbackFunction
{
public:
  explicit inline WebCodecsErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline WebCodecsErrorCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline WebCodecsErrorCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline WebCodecsErrorCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, DOMException& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "WebCodecsErrorCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, error, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(DOMException& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "WebCodecsErrorCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, error, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, DOMException& error, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, error, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(DOMException& error, const char* aExecutionReason = nullptr)
  {
    return Call(error, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const WebCodecsErrorCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, DOMException& error, ErrorResult& aRv);
};


namespace binding_detail {
class FastWebCodecsErrorCallback : public WebCodecsErrorCallback
{
public:
  explicit inline FastWebCodecsErrorCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : WebCodecsErrorCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    WebCodecsErrorCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    WebCodecsErrorCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct VideoDecoderSupport : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<VideoDecoderConfig> mConfig;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mSupported;

  VideoDecoderSupport();

  explicit inline VideoDecoderSupport(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  VideoDecoderSupport(VideoDecoderSupport&& aOther) = default;

private:
  VideoDecoderSupport(const VideoDecoderSupport&) = delete;
  VideoDecoderSupport& operator=(const VideoDecoderSupport&) = delete;

  static bool
  InitIds(JSContext* cx, VideoDecoderSupportAtoms* atomsCache);

public:
  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastVideoDecoderSupport : public VideoDecoderSupport
{
  inline FastVideoDecoderSupport()
    : VideoDecoderSupport(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace VideoDecoder_Binding {

  typedef mozilla::dom::VideoDecoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::VideoDecoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::VideoDecoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace VideoDecoder_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::HardwareAcceleration>
{
  static constexpr dom::HardwareAcceleration value = dom::HardwareAcceleration::Prefer_software;

  static_assert(static_cast<uint8_t>(dom::HardwareAcceleration::No_preference) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::HardwareAcceleration>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::CodecState>
{
  static constexpr dom::CodecState value = dom::CodecState::Closed;

  static_assert(static_cast<uint8_t>(dom::CodecState::Unconfigured) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::CodecState>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_VIDEODECODERBINDING_H_
