#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSS2Properties = 885,
  CSSAnimation = 900,
  CSSConditionRule = 913,
  CSSContainerRule = 930,
  CSSCounterStyleRule = 947,
  CSSCustomPropertyRegisteredEvent = 967,
  CSSFontFaceRule = 1000,
  CSSFontFeatureValuesRule = 1016,
  CSSFontPaletteValuesRule = 1041,
  CSSGroupingRule = 1066,
  CSSImportRule = 1082,
  CSSKeyframeRule = 1096,
  CSSKeyframesRule = 1112,
  CSSLayerBlockRule = 1129,
  CSSLayerStatementRule = 1147,
  CSSMarginRule = 1169,
  CSSMediaRule = 1183,
  CSSMozDocumentRule = 1196,
  CSSNamespaceRule = 1215,
  CSSNestedDeclarations = 1232,
  CSSPageDescriptors = 1254,
  CSSPageRule = 1273,
  CSSPositionTryDescriptors = 1285,
  CSSPositionTryRule = 1311,
  CSSPropertyRule = 1330,
  CSSPseudoElement = 1346,
  CSSRule = 1363,
  CSSRuleList = 1371,
  CSSScopeRule = 1383,
  CSSStartingStyleRule = 1396,
  CSSStyleDeclaration = 1417,
  CSSStyleRule = 1437,
  CSSStyleSheet = 1450,
  CSSSupportsRule = 1464,
  CSSTransition = 1480,
  Cache = 1494,
  CacheStorage = 1500,
  CallbackDebuggerNotification = 1513,
  CanonicalBrowsingContext = 1542,
  CanvasCaptureMediaStream = 1567,
  CanvasGradient = 1592,
  CanvasPattern = 1607,
  CanvasRenderingContext2D = 1621,
  CaretPosition = 1646,
  CaretStateChangedEvent = 1660,
  ChannelMergerNode = 1683,
  ChannelSplitterNode = 1701,
  ChannelWrapper = 1721,
  CharacterData = 1736,
  CheckerboardReportService = 1750,
  ChildProcessMessageManager = 1776,
  ChildSHistory = 1803,
  ChromeMessageBroadcaster = 1817,
  ChromeMessageSender = 1842,
  ChromeNodeList = 1862,
  ChromeUtils = 1877,
  ChromeWorker = 1889,
  Client = 1902,
  Clients = 1909,
  Clipboard = 1917,
  ClipboardEvent = 1927,
  ClipboardItem = 1942,
  ClonedErrorHolder = 1956,
  CloseEvent = 1974,
  CloseWatcher = 1985,
  CommandEvent = 1998,
  Comment = 2011,
  CompositionEvent = 2019,
  CompressionStream = 2036,
  ConsoleInstance = 2054,
  ConstantSourceNode = 2070,
  ContentFrameMessageManager = 2089,
  ContentProcessMessageManager = 2116,
  ContentVisibilityAutoStateChangeEvent = 2145,
  ConvolverNode = 2183,
  CookieChangeEvent = 2197,
  CookieStore = 2215,
  CookieStoreManager = 2227,
  CountQueuingStrategy = 2246,
  CreateOfferRequest = 2267,
  Credential = 2286,
  CredentialsContainer = 2297,
  Crypto = 2318,
  CryptoKey = 2325,
  CustomElementRegistry = 2335,
  CustomEvent = 2357,
  CustomStateSet = 2369,
  DOMException = 2384,
  DOMImplementation = 2397,
  DOMLocalization = 2415,
  DOMMatrix = 2431,
  DOMMatrixReadOnly = 2441,
  DOMParser = 2459,
  DOMPoint = 2469,
  DOMPointReadOnly = 2478,
  DOMQuad = 2495,
  DOMRect = 2503,
  DOMRectList = 2511,
  DOMRectReadOnly = 2523,
  DOMStringList = 2539,
  DOMStringMap = 2553,
  DOMTokenList = 2566,
  DataTransfer = 2579,
  DataTransferItem = 2592,
  DataTransferItemList = 2609,
  DebuggerNotification = 2630,
  DebuggerNotificationObserver = 2651,
  DecompressionStream = 2680,
  DedicatedWorkerGlobalScope = 2700,
  DelayNode = 2727,
  DeprecationReportBody = 2737,
  DeviceAcceleration = 2759,
  DeviceLightEvent = 2778,
  DeviceMotionEvent = 2795,
  DeviceOrientationEvent = 2813,
  DeviceRotationRate = 2836,
  Directory = 2855,
  Document = 2865,
  DocumentFragment = 2874,
  DocumentL10n = 2891,
  DocumentTimeline = 2904,
  DocumentType = 2921,
  DominatorTree = 2934,
  DragEvent = 2948,
  DynamicsCompressorNode = 2958,
  EXT_blend_minmax = 2981,
  EXT_color_buffer_float = 2998,
  EXT_color_buffer_half_float = 3021,
  EXT_depth_clamp = 3049,
  EXT_disjoint_timer_query = 3065,
  EXT_float_blend = 3090,
  EXT_frag_depth = 3106,
  EXT_sRGB = 3121,
  EXT_shader_texture_lod = 3130,
  EXT_texture_compression_bptc = 3153,
  EXT_texture_compression_rgtc = 3182,
  EXT_texture_filter_anisotropic = 3211,
  EXT_texture_norm16 = 3242,
  Element = 3261,
  ElementInternals = 3269,
  EncodedAudioChunk = 3286,
  EncodedVideoChunk = 3304,
  ErrorEvent = 3322,
  Event = 3333,
  EventCallbackDebuggerNotification = 3339,
  EventCounts = 3373,
  EventSource = 3385,
  EventTarget = 3397,
  Exception = 3409,
  ExtendableCookieChangeEvent = 3419,
  ExtendableEvent = 3447,
  ExtendableMessageEvent = 3463,
  ExtensionAlarms = 3486,
  ExtensionBrowser = 3502,
  ExtensionBrowserSettings = 3519,
  ExtensionBrowserSettingsColorManagement = 3544,
  ExtensionDns = 3584,
  ExtensionEventManager = 3597,
  ExtensionMockAPI = 3619,
  ExtensionPort = 3636,
  ExtensionProxy = 3650,
  ExtensionRuntime = 3665,
  ExtensionScripting = 3682,
  ExtensionSetting = 3701,
  ExtensionTest = 3718,
  External = 3732,
  FeaturePolicy = 3741,
  FeaturePolicyViolationReportBody = 3755,
  FetchEvent = 3788,
  FetchObserver = 3799,
  File = 3813,
  FileList = 3818,
  FileReader = 3827,
  FileReaderSync = 3838,
  FileSystem = 3853,
  FileSystemDirectoryEntry = 3864,
  FileSystemDirectoryHandle = 3889,
  FileSystemDirectoryHandle_AsyncIterator = 3915,
  FileSystemDirectoryIterator = 3955,
  FileSystemDirectoryReader = 3983,
  FileSystemEntry = 4009,
  FileSystemFileEntry = 4025,
  FileSystemFileHandle = 4045,
  FileSystemHandle = 4066,
  FileSystemSyncAccessHandle = 4083,
  FileSystemWritableFileStream = 4110,
  Flex = 4139,
  FlexItemValues = 4144,
  FlexLineValues = 4159,
  FluentBundle = 4174,
  FluentBundleAsyncIterator = 4187,
  FluentBundleIterator = 4213,
  FluentPattern = 4234,
  FluentResource = 4248,
  FocusEvent = 4263,
  FontFace = 4274,
  FontFaceSet = 4283,
  FontFaceSetIterator = 4295,
  FontFaceSetLoadEvent = 4315,
  FormData = 4336,
  FormData_Iterator = 4345,
  FormDataEvent = 4363,
  FragmentDirective = 4377,
  FrameCrashedEvent = 4395,
  FrameLoader = 4413,
  GPU = 4425,
  GPUAdapter = 4429,
  GPUAdapterInfo = 4440,
  GPUBindGroup = 4455,
  GPUBindGroupLayout = 4468,
  GPUBuffer = 4487,
  GPUBufferUsage = 4497,
  GPUCanvasContext = 4512,
  GPUColorWrite = 4529,
  GPUCommandBuffer = 4543,
  GPUCommandEncoder = 4560,
  GPUCompilationInfo = 4578,
  GPUCompilationMessage = 4597,
  GPUComputePassEncoder = 4619,
  GPUComputePipeline = 4641,
  GPUDevice = 4660,
  GPUDeviceLostInfo = 4670,
  GPUError = 4688,
  GPUExternalTexture = 4697,
  GPUInternalError = 4716,
  GPUMapMode = 4733,
  GPUOutOfMemoryError = 4744,
  GPUPipelineLayout = 4764,
  GPUQuerySet = 4782,
  GPUQueue = 4794,
  GPURenderBundle = 4803,
  GPURenderBundleEncoder = 4819,
  GPURenderPassEncoder = 4842,
  GPURenderPipeline = 4863,
  GPUSampler = 4881,
  GPUShaderModule = 4892,
  GPUShaderStage = 4908,
  GPUSupportedFeatures = 4923,
  GPUSupportedLimits = 4944,
  GPUTexture = 4963,
  GPUTextureUsage = 4974,
  GPUTextureView = 4990,
  GPUUncapturedErrorEvent = 5005,
  GPUValidationError = 5029,
  GainNode = 5048,
  Gamepad = 5057,
  GamepadAxisMoveEvent = 5065,
  GamepadButton = 5086,
  GamepadButtonEvent = 5100,
  GamepadEvent = 5119,
  GamepadHapticActuator = 5132,
  GamepadLightIndicator = 5154,
  GamepadPose = 5176,
  GamepadServiceTest = 5188,
  GamepadTouch = 5207,
  Geolocation = 5220,
  GeolocationCoordinates = 5232,
  GeolocationPosition = 5255,
  GeolocationPositionError = 5275,
  GetUserMediaRequest = 5300,
  GleanBoolean = 5320,
  GleanCategory = 5333,
  GleanCounter = 5347,
  GleanCustomDistribution = 5360,
  GleanDatetime = 5384,
  GleanDenominator = 5398,
  GleanEvent = 5415,
  GleanImpl = 5426,
  GleanLabeled = 5436,
  GleanMemoryDistribution = 5449,
  GleanMetric = 5473,
  GleanNumerator = 5485,
  GleanObject = 5500,
  GleanPingsImpl = 5512,
  GleanQuantity = 5527,
  GleanRate = 5541,
  GleanString = 5551,
  GleanStringList = 5563,
  GleanText = 5579,
  GleanTimespan = 5589,
  GleanTimingDistribution = 5603,
  GleanUrl = 5627,
  GleanUuid = 5636,
  Grid = 5646,
  GridArea = 5651,
  GridDimension = 5660,
  GridLine = 5674,
  GridLines = 5683,
  GridTrack = 5693,
  GridTracks = 5703,
  HTMLAllCollection = 5714,
  HTMLAnchorElement = 5732,
  HTMLAreaElement = 5750,
  HTMLAudioElement = 5766,
  HTMLBRElement = 5783,
  HTMLBaseElement = 5797,
  HTMLBodyElement = 5813,
  HTMLButtonElement = 5829,
  HTMLCanvasElement = 5847,
  HTMLCollection = 5865,
  HTMLDListElement = 5880,
  HTMLDataElement = 5897,
  HTMLDataListElement = 5913,
  HTMLDetailsElement = 5933,
  HTMLDialogElement = 5952,
  HTMLDirectoryElement = 5970,
  HTMLDivElement = 5991,
  HTMLDocument = 6006,
  HTMLElement = 6019,
  HTMLEmbedElement = 6031,
  HTMLFieldSetElement = 6048,
  HTMLFontElement = 6068,
  HTMLFormControlsCollection = 6084,
  HTMLFormElement = 6111,
  HTMLFrameElement = 6127,
  HTMLFrameSetElement = 6144,
  HTMLHRElement = 6164,
  HTMLHeadElement = 6178,
  HTMLHeadingElement = 6194,
  HTMLHtmlElement = 6213,
  HTMLIFrameElement = 6229,
  HTMLImageElement = 6247,
  HTMLInputElement = 6264,
  HTMLLIElement = 6281,
  HTMLLabelElement = 6295,
  HTMLLegendElement = 6312,
  HTMLLinkElement = 6330,
  HTMLMapElement = 6346,
  HTMLMarqueeElement = 6361,
  HTMLMediaElement = 6380,
  HTMLMenuElement = 6397,
  HTMLMetaElement = 6413,
  HTMLMeterElement = 6429,
  HTMLModElement = 6446,
  HTMLOListElement = 6461,
  HTMLObjectElement = 6478,
  HTMLOptGroupElement = 6496,
  HTMLOptionElement = 6516,
  HTMLOptionsCollection = 6534,
  HTMLOutputElement = 6556,
  HTMLParagraphElement = 6574,
  HTMLParamElement = 6595,
  HTMLPictureElement = 6612,
  HTMLPreElement = 6631,
  HTMLProgressElement = 6646,
  HTMLQuoteElement = 6666,
  HTMLScriptElement = 6683,
  HTMLSelectElement = 6701,
  HTMLSlotElement = 6719,
  HTMLSourceElement = 6735,
  HTMLSpanElement = 6753,
  HTMLStyleElement = 6769,
  HTMLTableCaptionElement = 6786,
  HTMLTableCellElement = 6810,
  HTMLTableColElement = 6831,
  HTMLTableElement = 6851,
  HTMLTableRowElement = 6868,
  HTMLTableSectionElement = 6888,
  HTMLTemplateElement = 6912,
  HTMLTextAreaElement = 6932,
  HTMLTimeElement = 6952,
  HTMLTitleElement = 6968,
  HTMLTrackElement = 6985,
  HTMLUListElement = 7002,
  HTMLUnknownElement = 7019,
  HTMLVideoElement = 7038,
  HashChangeEvent = 7055,
  Headers = 7071,
  Headers_Iterator = 7079,
  HeapSnapshot = 7096,
  Highlight = 7109,
  HighlightRegistry = 7119,
  History = 7137,
  IDBCursor = 7145,
  IDBCursorWithValue = 7155,
  IDBDatabase = 7174,
  IDBFactory = 7186,
  IDBIndex = 7197,
  IDBKeyRange = 7206,
  IDBObjectStore = 7218,
  IDBOpenDBRequest = 7233,
  IDBRequest = 7250,
  IDBTransaction = 7261,
  IDBVersionChangeEvent = 7276,
  IIRFilterNode = 7298,
  IOUtils = 7312,
  IdentityCredential = 7320,
  IdleDeadline = 7339,
  Image = 7352,
  ImageBitmap = 7358,
  ImageBitmapRenderingContext = 7370,
  ImageCapture = 7398,
  ImageCaptureError = 7411,
  ImageCaptureErrorEvent = 7429,
  ImageData = 7452,
  ImageDecoder = 7462,
  ImageDocument = 7475,
  ImageTrack = 7489,
  ImageTrackList = 7500,
  InputEvent = 7515,
  InspectorCSSParser = 7526,
  InspectorFontFace = 7545,
  InspectorUtils = 7563,
  InstallTriggerImpl = 7578,
  IntersectionObserver = 7597,
  IntersectionObserverEntry = 7618,
  IntlUtils = 7644,
  InvokeEvent = 7654,
  JSProcessActorChild = 7666,
  JSProcessActorParent = 7686,
  JSWindowActorChild = 7707,
  JSWindowActorParent = 7726,
  KeyEvent = 7746,
  KeyboardEvent = 7755,
  KeyframeEffect = 7769,
  L10nFileSource = 7784,
  L10nOverlays = 7799,
  L10nRegistry = 7812,
  LargestContentfulPaint = 7825,
  LegacyMozTCPSocket = 7848,
  Localization = 7867,
  Location = 7880,
  Lock = 7889,
  LockManager = 7894,
  MIDIAccess = 7906,
  MIDIConnectionEvent = 7917,
  MIDIInput = 7937,
  MIDIInputMap = 7947,
  MIDIMessageEvent = 7960,
  MIDIOutput = 7977,
  MIDIOutputMap = 7988,
  MIDIPort = 8002,
  MLS = 8011,
  MLSGroupView = 8015,
  MOZ_debug = 8028,
  MatchGlob = 8038,
  MatchPattern = 8048,
  MatchPatternSet = 8061,
  MathMLElement = 8077,
  MediaCapabilities = 8091,
  MediaControlService = 8109,
  MediaController = 8129,
  MediaDeviceInfo = 8145,
  MediaDevices = 8161,
  MediaElementAudioSourceNode = 8174,
  MediaEncryptedEvent = 8202,
  MediaError = 8222,
  MediaKeyError = 8233,
  MediaKeyMessageEvent = 8247,
  MediaKeySession = 8268,
  MediaKeyStatusMap = 8284,
  MediaKeyStatusMap_Iterator = 8302,
  MediaKeySystemAccess = 8329,
  MediaKeys = 8350,
  MediaList = 8360,
  MediaMetadata = 8370,
  MediaQueryList = 8384,
  MediaQueryListEvent = 8399,
  MediaRecorder = 8419,
  MediaRecorderErrorEvent = 8433,
  MediaSession = 8457,
  MediaSource = 8470,
  MediaStream = 8482,
  MediaStreamAudioDestinationNode = 8494,
  MediaStreamAudioSourceNode = 8526,
  MediaStreamError = 8553,
  MediaStreamEvent = 8570,
  MediaStreamTrack = 8587,
  MediaStreamTrackAudioSourceNode = 8604,
  MediaStreamTrackEvent = 8636,
  MerchantValidationEvent = 8658,
  MessageBroadcaster = 8682,
  MessageChannel = 8701,
  MessageEvent = 8716,
  MessageListenerManager = 8729,
  MessagePort = 8752,
  MessageSender = 8764,
  MimeType = 8778,
  MimeTypeArray = 8787,
  MouseEvent = 8801,
  MouseScrollEvent = 8812,
  MozCanvasPrintState = 8829,
  MozDocumentMatcher = 8849,
  MozDocumentObserver = 8868,
  MozQueryInterface = 8888,
  MozSharedMap = 8906,
  MozSharedMap_Iterator = 8919,
  MozSharedMapChangeEvent = 8941,
  MozStorageAsyncStatementParams = 8965,
  MozStorageStatementParams = 8996,
  MozStorageStatementRow = 9022,
  MozWritableSharedMap = 9045,
  MutationEvent = 9066,
  MutationObserver = 9080,
  MutationRecord = 9097,
  NamedNodeMap = 9112,
  NavigateEvent = 9125,
  Navigation = 9139,
  NavigationActivation = 9150,
  NavigationCurrentEntryChangeEvent = 9171,
  NavigationDestination = 9205,
  NavigationHistoryEntry = 9227,
  NavigationPreloadManager = 9250,
  NavigationTransition = 9275,
  Navigator = 9296,
  NavigatorLogin = 9306,
  NetworkInformation = 9321,
  Node = 9340,
  NodeFilter = 9345,
  NodeIterator = 9356,
  NodeList = 9369,
  Notification = 9378,
  NotificationEvent = 9391,
  NotifyPaintEvent = 9409,
  OES_draw_buffers_indexed = 9426,
  OES_element_index_uint = 9451,
  OES_fbo_render_mipmap = 9474,
  OES_standard_derivatives = 9496,
  OES_texture_float = 9521,
  OES_texture_float_linear = 9539,
  OES_texture_half_float = 9564,
  OES_texture_half_float_linear = 9587,
  OES_vertex_array_object = 9617,
  OVR_multiview2 = 9641,
  OfflineAudioCompletionEvent = 9656,
  OfflineAudioContext = 9684,
  OffscreenCanvas = 9704,
  OffscreenCanvasRenderingContext2D = 9720,
  Option = 9754,
  OscillatorNode = 9761,
  PageTransitionEvent = 9776,
  PaintRequest = 9796,
  PaintRequestList = 9809,
  PaintWorkletGlobalScope = 9826,
  PannerNode = 9850,
  ParentProcessMessageManager = 9861,
  Path2D = 9889,
  PathUtils = 9896,
  PaymentAddress = 9906,
  PaymentMethodChangeEvent = 9921,
  PaymentRequest = 9946,
  PaymentRequestUpdateEvent = 9961,
  PaymentResponse = 9987,
  PeerConnectionImpl = 10003,
  PeerConnectionObserver = 10022,
  Performance = 10045,
  PerformanceEntry = 10057,
  PerformanceEntryEvent = 10074,
  PerformanceEventTiming = 10096,
  PerformanceMark = 10119,
  PerformanceMeasure = 10135,
  PerformanceNavigation = 10154,
  PerformanceNavigationTiming = 10176,
  PerformanceObserver = 10204,
  PerformanceObserverEntryList = 10224,
  PerformancePaintTiming = 10253,
  PerformanceResourceTiming = 10276,
  PerformanceServerTiming = 10302,
  PerformanceTiming = 10326,
  PeriodicWave = 10344,
  PermissionStatus = 10357,
  Permissions = 10374,
  PlacesBookmark = 10386,
  PlacesBookmarkAddition = 10401,
  PlacesBookmarkChanged = 10424,
  PlacesBookmarkGuid = 10446,
  PlacesBookmarkKeyword = 10465,
  PlacesBookmarkMoved = 10487,
  PlacesBookmarkRemoved = 10507,
  PlacesBookmarkTags = 10529,
  PlacesBookmarkTime = 10548,
  PlacesBookmarkTitle = 10567,
  PlacesBookmarkUrl = 10587,
  PlacesEvent = 10605,
  PlacesEventCounts = 10617,
  PlacesFavicon = 10635,
  PlacesHistoryCleared = 10649,
  PlacesObservers = 10670,
  PlacesPurgeCaches = 10686,
  PlacesRanking = 10704,
  PlacesVisit = 10718,
  PlacesVisitRemoved = 10730,
  PlacesVisitTitle = 10749,
  PlacesWeakCallbackWrapper = 10766,
  Plugin = 10792,
  PluginArray = 10799,
  PluginCrashedEvent = 10811,
  PointerEvent = 10830,
  PopStateEvent = 10843,
  PopupBlockedEvent = 10857,
  PopupPositionedEvent = 10875,
  PositionStateEvent = 10896,
  PrecompiledScript = 10915,
  PrivateAttribution = 10933,
  ProcessMessageManager = 10952,
  ProcessingInstruction = 10974,
  ProgressEvent = 10996,
  PromiseDebugging = 11010,
  PromiseNativeHandler = 11027,
  PromiseRejectionEvent = 11048,
  PublicKeyCredential = 11070,
  PushEvent = 11090,
  PushManager = 11100,
  PushManagerImpl = 11112,
  PushMessageData = 11128,
  PushSubscription = 11144,
  PushSubscriptionChangeEvent = 11161,
  PushSubscriptionOptions = 11189,
  RTCCertificate = 11213,
  RTCDTMFSender = 11228,
  RTCDTMFToneChangeEvent = 11242,
  RTCDataChannel = 11265,
  RTCDataChannelEvent = 11280,
  RTCDtlsTransport = 11300,
  RTCEncodedAudioFrame = 11317,
  RTCEncodedVideoFrame = 11338,
  RTCIceCandidate = 11359,
  RTCIceTransport = 11375,
  RTCIdentityProviderRegistrar = 11391,
  RTCPeerConnection = 11420,
  RTCPeerConnectionIceEvent = 11438,
  RTCPeerConnectionStatic = 11464,
  RTCRtpReceiver = 11488,
  RTCRtpScriptTransform = 11503,
  RTCRtpScriptTransformer = 11525,
  RTCRtpSender = 11549,
  RTCRtpTransceiver = 11562,
  RTCSctpTransport = 11580,
  RTCSessionDescription = 11597,
  RTCStatsReport = 11619,
  RTCTrackEvent = 11634,
  RTCTransformEvent = 11648,
  RadioNodeList = 11666,
  Range = 11680,
  ReadableByteStreamController = 11686,
  ReadableStream = 11715,
  ReadableStream_AsyncIterator = 11730,
  ReadableStreamBYOBReader = 11759,
  ReadableStreamBYOBRequest = 11784,
  ReadableStreamDefaultController = 11810,
  ReadableStreamDefaultReader = 11842,
  Report = 11870,
  ReportBody = 11877,
  ReportingObserver = 11888,
  Request = 11906,
  ResizeObserver = 11914,
  ResizeObserverEntry = 11929,
  ResizeObserverSize = 11949,
  Response = 11968,
  SVGAElement = 11977,
  SVGAngle = 11989,
  SVGAnimateElement = 11998,
  SVGAnimateMotionElement = 12016,
  SVGAnimateTransformElement = 12040,
  SVGAnimatedAngle = 12067,
  SVGAnimatedBoolean = 12084,
  SVGAnimatedEnumeration = 12103,
  SVGAnimatedInteger = 12126,
  SVGAnimatedLength = 12145,
  SVGAnimatedLengthList = 12163,
  SVGAnimatedNumber = 12185,
  SVGAnimatedNumberList = 12203,
  SVGAnimatedPreserveAspectRatio = 12225,
  SVGAnimatedRect = 12256,
  SVGAnimatedString = 12272,
  SVGAnimatedTransformList = 12290,
  SVGAnimationElement = 12315,
  SVGCircleElement = 12335,
  SVGClipPathElement = 12352,
  SVGComponentTransferFunctionElement = 12371,
  SVGDefsElement = 12407,
  SVGDescElement = 12422,
  SVGDiscardElement = 12437,
  SVGElement = 12455,
  SVGEllipseElement = 12466,
  SVGFEBlendElement = 12484,
  SVGFEColorMatrixElement = 12502,
  SVGFEComponentTransferElement = 12526,
  SVGFECompositeElement = 12556,
  SVGFEConvolveMatrixElement = 12578,
  SVGFEDiffuseLightingElement = 12605,
  SVGFEDisplacementMapElement = 12633,
  SVGFEDistantLightElement = 12661,
  SVGFEDropShadowElement = 12686,
  SVGFEFloodElement = 12709,
  SVGFEFuncAElement = 12727,
  SVGFEFuncBElement = 12745,
  SVGFEFuncGElement = 12763,
  SVGFEFuncRElement = 12781,
  SVGFEGaussianBlurElement = 12799,
  SVGFEImageElement = 12824,
  SVGFEMergeElement = 12842,
  SVGFEMergeNodeElement = 12860,
  SVGFEMorphologyElement = 12882,
  SVGFEOffsetElement = 12905,
  SVGFEPointLightElement = 12924,
  SVGFESpecularLightingElement = 12947,
  SVGFESpotLightElement = 12976,
  SVGFETileElement = 12998,
  SVGFETurbulenceElement = 13015,
  SVGFilterElement = 13038,
  SVGForeignObjectElement = 13055,
  SVGGElement = 13079,
  SVGGeometryElement = 13091,
  SVGGradientElement = 13110,
  SVGGraphicsElement = 13129,
  SVGImageElement = 13148,
  SVGLength = 13164,
  SVGLengthList = 13174,
  SVGLineElement = 13188,
  SVGLinearGradientElement = 13203,
  SVGMPathElement = 13228,
  SVGMarkerElement = 13244,
  SVGMaskElement = 13261,
  SVGMatrix = 13276,
  SVGMetadataElement = 13286,
  SVGNumber = 13305,
  SVGNumberList = 13315,
  SVGPathElement = 13329,
  SVGPathSegment = 13344,
  SVGPatternElement = 13359,
  SVGPoint = 13377,
  SVGPointList = 13386,
  SVGPolygonElement = 13399,
  SVGPolylineElement = 13417,
  SVGPreserveAspectRatio = 13436,
  SVGRadialGradientElement = 13459,
  SVGRect = 13484,
  SVGRectElement = 13492,
  SVGSVGElement = 13507,
  SVGScriptElement = 13521,
  SVGSetElement = 13538,
  SVGStopElement = 13552,
  SVGStringList = 13567,
  SVGStyleElement = 13581,
  SVGSwitchElement = 13597,
  SVGSymbolElement = 13614,
  SVGTSpanElement = 13631,
  SVGTextContentElement = 13647,
  SVGTextElement = 13669,
  SVGTextPathElement = 13684,
  SVGTextPositioningElement = 13703,
  SVGTitleElement = 13729,
  SVGTransform = 13745,
  SVGTransformList = 13758,
  SVGUnitTypes = 13775,
  SVGUseElement = 13788,
  SVGViewElement = 13802,
  Sanitizer = 13817,
  Scheduler = 13827,
  Screen = 13837,
  ScreenLuminance = 13844,
  ScreenOrientation = 13860,
  ScriptProcessorNode = 13878,
  ScrollAreaEvent = 13898,
  ScrollViewChangeEvent = 13914,
  SecurityPolicyViolationEvent = 13936,
  Selection = 13965,
  ServiceWorker = 13975,
  ServiceWorkerContainer = 13989,
  ServiceWorkerGlobalScope = 14012,
  ServiceWorkerRegistration = 14037,
  SessionStoreFormData = 14063,
  SessionStoreScrollData = 14084,
  SessionStoreUtils = 14107,
  ShadowRealmGlobalScope = 14125,
  ShadowRoot = 14148,
  SharedWorker = 14159,
  SharedWorkerGlobalScope = 14172,
  SimpleGestureEvent = 14196,
  SourceBuffer = 14215,
  SourceBufferList = 14228,
  SpeechGrammar = 14245,
  SpeechGrammarList = 14259,
  SpeechRecognition = 14277,
  SpeechRecognitionAlternative = 14295,
  SpeechRecognitionError = 14324,
  SpeechRecognitionEvent = 14347,
  SpeechRecognitionResult = 14370,
  SpeechRecognitionResultList = 14394,
  SpeechSynthesis = 14422,
  SpeechSynthesisErrorEvent = 14438,
  SpeechSynthesisEvent = 14464,
  SpeechSynthesisUtterance = 14485,
  SpeechSynthesisVoice = 14510,
  StaticRange = 14531,
  StereoPannerNode = 14543,
  Storage = 14560,
  StorageEvent = 14568,
  StorageManager = 14581,
  StreamFilter = 14596,
  StreamFilterDataEvent = 14609,
  StructuredCloneHolder = 14631,
  StructuredCloneTester = 14653,
  StyleSheet = 14675,
  StyleSheetApplicableStateChangeEvent = 14686,
  StyleSheetList = 14723,
  StyleSheetRemovedEvent = 14738,
  SubmitEvent = 14761,
  SubtleCrypto = 14773,
  SyncMessageSender = 14786,
  SyncReadFile = 14804,
  TCPServerSocket = 14817,
  TCPServerSocketEvent = 14833,
  TCPSocket = 14854,
  TCPSocketErrorEvent = 14864,
  TCPSocketEvent = 14884,
  TaskController = 14899,
  TaskPriorityChangeEvent = 14914,
  TaskSignal = 14938,
  TestUtils = 14949,
  TestingDeprecatedInterface = 14959,
  Text = 14986,
  TextClause = 14991,
  TextDecoder = 15002,
  TextDecoderStream = 15014,
  TextEncoder = 15032,
  TextEncoderStream = 15044,
  TextEvent = 15062,
  TextMetrics = 15072,
  TextTrack = 15084,
  TextTrackCue = 15094,
  TextTrackCueList = 15107,
  TextTrackList = 15124,
  TimeEvent = 15138,
  TimeRanges = 15148,
  ToggleEvent = 15159,
  Touch = 15171,
  TouchEvent = 15177,
  TouchList = 15188,
  TrackEvent = 15198,
  TransformStream = 15209,
  TransformStreamDefaultController = 15225,
  TransitionEvent = 15258,
  TreeColumn = 15274,
  TreeColumns = 15285,
  TreeContentView = 15297,
  TreeWalker = 15313,
  TrustedHTML = 15324,
  TrustedScript = 15336,
  TrustedScriptURL = 15350,
  TrustedTypePolicy = 15367,
  TrustedTypePolicyFactory = 15385,
  UDPMessageEvent = 15410,
  UDPSocket = 15426,
  UIEvent = 15436,
  URL = 15444,
  URLSearchParams = 15448,
  URLSearchParams_Iterator = 15464,
  UniFFIPointer = 15489,
  UniFFIScaffolding = 15503,
  UserActivation = 15521,
  UserInteraction = 15536,
  UserProximityEvent = 15552,
  VRDisplay = 15571,
  VRDisplayCapabilities = 15581,
  VRDisplayEvent = 15603,
  VREyeParameters = 15618,
  VRFieldOfView = 15634,
  VRFrameData = 15648,
  VRMockController = 15660,
  VRMockDisplay = 15677,
  VRPose = 15691,
  VRServiceTest = 15698,
  VRStageParameters = 15712,
  VTTCue = 15730,
  VTTRegion = 15737,
  ValidityState = 15747,
  VideoColorSpace = 15761,
  VideoDecoder = 15777,
  VideoEncoder = 15790,
  VideoFrame = 15803,
  VideoPlaybackQuality = 15814,
  VideoTrack = 15835,
  VideoTrackList = 15846,
  ViewTransition = 15861,
  VisualViewport = 15876,
  WEBGL_color_buffer_float = 15891,
  WEBGL_compressed_texture_astc = 15916,
  WEBGL_compressed_texture_etc = 15946,
  WEBGL_compressed_texture_etc1 = 15975,
  WEBGL_compressed_texture_pvrtc = 16005,
  WEBGL_compressed_texture_s3tc = 16036,
  WEBGL_compressed_texture_s3tc_srgb = 16066,
  WEBGL_debug_renderer_info = 16101,
  WEBGL_debug_shaders = 16127,
  WEBGL_depth_texture = 16147,
  WEBGL_draw_buffers = 16167,
  WEBGL_explicit_present = 16186,
  WEBGL_lose_context = 16209,
  WEBGL_provoking_vertex = 16228,
  WGSLLanguageFeatures = 16251,
  WakeLock = 16272,
  WakeLockSentinel = 16281,
  WaveShaperNode = 16298,
  WebExtensionContentScript = 16313,
  WebExtensionPolicy = 16339,
  WebGL2RenderingContext = 16358,
  WebGLActiveInfo = 16381,
  WebGLBuffer = 16397,
  WebGLContextEvent = 16409,
  WebGLFramebuffer = 16427,
  WebGLProgram = 16444,
  WebGLQuery = 16457,
  WebGLRenderbuffer = 16468,
  WebGLRenderingContext = 16486,
  WebGLSampler = 16508,
  WebGLShader = 16521,
  WebGLShaderPrecisionFormat = 16533,
  WebGLSync = 16560,
  WebGLTexture = 16570,
  WebGLTransformFeedback = 16583,
  WebGLUniformLocation = 16606,
  WebGLVertexArrayObject = 16627,
  WebKitCSSMatrix = 16650,
  WebSocket = 16666,
  WebTransport = 16676,
  WebTransportBidirectionalStream = 16689,
  WebTransportDatagramDuplexStream = 16721,
  WebTransportError = 16754,
  WebTransportReceiveStream = 16772,
  WebTransportSendStream = 16798,
  WebrtcGlobalInformation = 16821,
  WheelEvent = 16845,
  Window = 16856,
  WindowClient = 16863,
  WindowContext = 16876,
  WindowGlobalChild = 16890,
  WindowGlobalParent = 16908,
  WindowRoot = 16927,
  Worker = 16938,
  WorkerDebuggerGlobalScope = 16945,
  WorkerGlobalScope = 16971,
  WorkerLocation = 16989,
  WorkerNavigator = 17004,
  WorkerTestUtils = 17020,
  Worklet = 17036,
  WorkletGlobalScope = 17044,
  WritableStream = 17063,
  WritableStreamDefaultController = 17078,
  WritableStreamDefaultWriter = 17110,
  XMLDocument = 17138,
  XMLHttpRequest = 17150,
  XMLHttpRequestEventTarget = 17165,
  XMLHttpRequestUpload = 17191,
  XMLSerializer = 17212,
  XPathEvaluator = 17226,
  XPathExpression = 17241,
  XPathResult = 17257,
  XRBoundedReferenceSpace = 17269,
  XRFrame = 17293,
  XRInputSource = 17301,
  XRInputSourceArray = 17315,
  XRInputSourceEvent = 17334,
  XRInputSourcesChangeEvent = 17353,
  XRPose = 17379,
  XRReferenceSpace = 17386,
  XRReferenceSpaceEvent = 17403,
  XRRenderState = 17425,
  XRRigidTransform = 17439,
  XRSession = 17456,
  XRSessionEvent = 17466,
  XRSpace = 17481,
  XRSystem = 17489,
  XRView = 17498,
  XRViewerPose = 17505,
  XRViewport = 17518,
  XRWebGLLayer = 17529,
  XSLTProcessor = 17542,
  XULCommandEvent = 17556,
  XULElement = 17572,
  XULFrameElement = 17583,
  XULMenuElement = 17599,
  XULPopupElement = 17614,
  XULResizerElement = 17630,
  XULTextElement = 17648,
  XULTreeElement = 17663,
  console = 17678,
  webkitSpeechGrammar = 17686,
  webkitSpeechGrammarList = 17706,
  webkitSpeechRecognition = 17730,
  webkitURL = 17754,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
