/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.ACM;
import com.zeroc.Ice.ACMClose;
import com.zeroc.Ice.ACMHeartbeat;
import com.zeroc.Ice.ConnectionI;
import com.zeroc.IceInternal.ACMConfig;
import com.zeroc.IceInternal.ACMMonitor;
import com.zeroc.IceInternal.FactoryACMMonitor;
import com.zeroc.IceInternal.Time;
import com.zeroc.IceUtilInternal.Assert;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class ConnectionACMMonitor
implements ACMMonitor {
    private final FactoryACMMonitor _parent;
    private final ScheduledExecutorService _timer;
    private Future<?> _future;
    private final ACMConfig _config;
    private ConnectionI _connection;

    ConnectionACMMonitor(FactoryACMMonitor parent, ScheduledExecutorService timer, ACMConfig config) {
        this._parent = parent;
        this._timer = timer;
        this._config = config;
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._connection == null);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public synchronized void add(ConnectionI connection) {
        assert (this._connection == null);
        this._connection = connection;
        if (this._config.timeout > 0) {
            this._future = this._timer.scheduleAtFixedRate(() -> this.monitorConnection(), this._config.timeout / 2, this._config.timeout / 2, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void remove(ConnectionI connection) {
        assert (this._connection == connection);
        this._connection = null;
        if (this._config.timeout > 0) {
            this._future.cancel(false);
            this._future = null;
        }
    }

    @Override
    public void reap(ConnectionI connection) {
        this._parent.reap(connection);
    }

    @Override
    public ACMMonitor acm(OptionalInt timeout, Optional<ACMClose> close, Optional<ACMHeartbeat> heartbeat) {
        return this._parent.acm(timeout, close, heartbeat);
    }

    @Override
    public ACM getACM() {
        ACM acm = new ACM();
        acm.timeout = this._config.timeout / 1000;
        acm.close = this._config.close;
        acm.heartbeat = this._config.heartbeat;
        return acm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorConnection() {
        ConnectionI connection;
        ConnectionACMMonitor connectionACMMonitor = this;
        synchronized (connectionACMMonitor) {
            if (this._connection == null) {
                return;
            }
            connection = this._connection;
        }
        try {
            connection.monitor(Time.currentMonotonicTimeMillis(), this._config);
        }
        catch (Exception ex) {
            this._parent.handleException(ex);
        }
    }
}

