/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.directquery.transport.format;

import java.util.HashMap;
import lombok.Generated;
import org.opensearch.rest.RestRequest;
import org.opensearch.sql.directquery.rest.model.DirectQueryResourceType;
import org.opensearch.sql.directquery.rest.model.GetDirectQueryResourcesRequest;
import org.opensearch.sql.directquery.rest.model.WriteDirectQueryResourcesRequest;

public final class DirectQueryResourcesRequestConverter {
    public static GetDirectQueryResourcesRequest toGetDirectRestRequest(RestRequest restRequest) {
        GetDirectQueryResourcesRequest directQueryRequest = new GetDirectQueryResourcesRequest();
        directQueryRequest.setDataSource(restRequest.param("dataSource"));
        String path = restRequest.path();
        if (path.contains("/alertmanager/api/v2/")) {
            if (path.contains("/alerts/groups")) {
                directQueryRequest.setResourceType(DirectQueryResourceType.ALERTMANAGER_ALERT_GROUPS);
            } else {
                directQueryRequest.setResourceType(DirectQueryResourceType.fromString((String)("alertmanager_" + restRequest.param("resourceType"))));
            }
        } else {
            directQueryRequest.setResourceTypeFromString(restRequest.param("resourceType"));
            if (restRequest.param("resourceName") != null) {
                directQueryRequest.setResourceName(restRequest.param("resourceName"));
            }
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        for (String key : restRequest.params().keySet()) {
            if (restRequest.consumedParams().contains(key)) continue;
            queryParams.put(key, restRequest.param(key));
        }
        directQueryRequest.setQueryParams(queryParams);
        return directQueryRequest;
    }

    public static WriteDirectQueryResourcesRequest toWriteDirectRestRequest(RestRequest restRequest) {
        WriteDirectQueryResourcesRequest directQueryRequest = new WriteDirectQueryResourcesRequest();
        directQueryRequest.setDataSource(restRequest.param("dataSource"));
        String path = restRequest.path();
        if (path.contains("/alertmanager/api/v2/")) {
            if (path.contains("/alerts/groups")) {
                directQueryRequest.setResourceType(DirectQueryResourceType.ALERTMANAGER_ALERT_GROUPS);
            } else {
                directQueryRequest.setResourceType(DirectQueryResourceType.fromString((String)("alertmanager_" + restRequest.param("resourceType"))));
            }
        } else {
            directQueryRequest.setResourceTypeFromString(restRequest.param("resourceType"));
            if (restRequest.param("resourceName") != null) {
                directQueryRequest.setResourceName(restRequest.param("resourceName"));
            }
        }
        if (!restRequest.hasContent()) {
            throw new IllegalArgumentException("The write direct resource request must have a request in the body");
        }
        directQueryRequest.setRequest(restRequest.content().utf8ToString());
        return directQueryRequest;
    }

    @Generated
    private DirectQueryResourcesRequestConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

