/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.executor.protector;

import lombok.Generated;
import org.opensearch.sql.monitor.ResourceMonitor;
import org.opensearch.sql.opensearch.executor.protector.ExecutionProtector;
import org.opensearch.sql.opensearch.executor.protector.ResourceMonitorPlan;
import org.opensearch.sql.opensearch.planner.physical.ADOperator;
import org.opensearch.sql.opensearch.planner.physical.MLCommonsOperator;
import org.opensearch.sql.opensearch.planner.physical.MLOperator;
import org.opensearch.sql.opensearch.planner.physical.OpenSearchEvalOperator;
import org.opensearch.sql.planner.physical.AggregationOperator;
import org.opensearch.sql.planner.physical.CursorCloseOperator;
import org.opensearch.sql.planner.physical.DedupeOperator;
import org.opensearch.sql.planner.physical.EvalOperator;
import org.opensearch.sql.planner.physical.FilterOperator;
import org.opensearch.sql.planner.physical.LimitOperator;
import org.opensearch.sql.planner.physical.NestedOperator;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import org.opensearch.sql.planner.physical.ProjectOperator;
import org.opensearch.sql.planner.physical.RareTopNOperator;
import org.opensearch.sql.planner.physical.RemoveOperator;
import org.opensearch.sql.planner.physical.RenameOperator;
import org.opensearch.sql.planner.physical.SortOperator;
import org.opensearch.sql.planner.physical.TakeOrderedOperator;
import org.opensearch.sql.planner.physical.TrendlineOperator;
import org.opensearch.sql.planner.physical.ValuesOperator;
import org.opensearch.sql.planner.physical.WindowOperator;
import org.opensearch.sql.storage.TableScanOperator;

public class OpenSearchExecutionProtector
extends ExecutionProtector {
    private final ResourceMonitor resourceMonitor;

    @Override
    public PhysicalPlan protect(PhysicalPlan physicalPlan) {
        return (PhysicalPlan)physicalPlan.accept((PhysicalPlanNodeVisitor)this, null);
    }

    public PhysicalPlan visitCursorClose(CursorCloseOperator node, Object context) {
        return node;
    }

    public PhysicalPlan visitFilter(FilterOperator node, Object context) {
        return new FilterOperator(this.visitInput(node.getInput(), context), node.getConditions());
    }

    public PhysicalPlan visitAggregation(AggregationOperator node, Object context) {
        return new AggregationOperator(this.visitInput(node.getInput(), context), node.getAggregatorList(), node.getGroupByExprList());
    }

    public PhysicalPlan visitRareTopN(RareTopNOperator node, Object context) {
        return new RareTopNOperator(this.visitInput(node.getInput(), context), node.getCommandType(), node.getNoOfResults().intValue(), node.getFieldExprList(), node.getGroupByExprList());
    }

    public PhysicalPlan visitRename(RenameOperator node, Object context) {
        return new RenameOperator(this.visitInput(node.getInput(), context), node.getMapping());
    }

    public PhysicalPlan visitTableScan(TableScanOperator node, Object context) {
        return this.doProtect((PhysicalPlan)node);
    }

    public PhysicalPlan visitProject(ProjectOperator node, Object context) {
        return new ProjectOperator(this.visitInput(node.getInput(), context), node.getProjectList(), node.getNamedParseExpressions());
    }

    public PhysicalPlan visitRemove(RemoveOperator node, Object context) {
        return new RemoveOperator(this.visitInput(node.getInput(), context), node.getRemoveList());
    }

    public PhysicalPlan visitEval(EvalOperator node, Object context) {
        if (node instanceof OpenSearchEvalOperator) {
            OpenSearchEvalOperator evalOperator = (OpenSearchEvalOperator)node;
            return this.doProtect((PhysicalPlan)new OpenSearchEvalOperator(this.visitInput(evalOperator.getInput(), context), evalOperator.getExpressionList(), evalOperator.getNodeClient()));
        }
        return new EvalOperator(this.visitInput(node.getInput(), context), node.getExpressionList());
    }

    public PhysicalPlan visitNested(NestedOperator node, Object context) {
        return this.doProtect((PhysicalPlan)new NestedOperator(this.visitInput(node.getInput(), context), node.getFields(), node.getGroupedPathsAndFields()));
    }

    public PhysicalPlan visitDedupe(DedupeOperator node, Object context) {
        return new DedupeOperator(this.visitInput(node.getInput(), context), node.getDedupeList(), node.getAllowedDuplication(), node.getKeepEmpty(), node.getConsecutive());
    }

    public PhysicalPlan visitWindow(WindowOperator node, Object context) {
        return new WindowOperator(this.doProtect(this.visitInput(node.getInput(), context)), node.getWindowFunction(), node.getWindowDefinition());
    }

    public PhysicalPlan visitSort(SortOperator node, Object context) {
        return this.doProtect((PhysicalPlan)new SortOperator(this.visitInput(node.getInput(), context), node.getSortList()));
    }

    public PhysicalPlan visitTakeOrdered(TakeOrderedOperator node, Object context) {
        return this.doProtect((PhysicalPlan)new TakeOrderedOperator(this.visitInput(node.getInput(), context), node.getLimit(), node.getOffset(), node.getSortList()));
    }

    public PhysicalPlan visitValues(ValuesOperator node, Object context) {
        return node;
    }

    public PhysicalPlan visitLimit(LimitOperator node, Object context) {
        return new LimitOperator(this.visitInput(node.getInput(), context), node.getLimit(), node.getOffset());
    }

    public PhysicalPlan visitMLCommons(PhysicalPlan node, Object context) {
        MLCommonsOperator mlCommonsOperator = (MLCommonsOperator)node;
        return this.doProtect(new MLCommonsOperator(this.visitInput(mlCommonsOperator.getInput(), context), mlCommonsOperator.getAlgorithm(), mlCommonsOperator.getArguments(), mlCommonsOperator.getNodeClient()));
    }

    public PhysicalPlan visitAD(PhysicalPlan node, Object context) {
        ADOperator adOperator = (ADOperator)node;
        return this.doProtect(new ADOperator(this.visitInput(adOperator.getInput(), context), adOperator.getArguments(), adOperator.getNodeClient()));
    }

    public PhysicalPlan visitML(PhysicalPlan node, Object context) {
        MLOperator mlOperator = (MLOperator)node;
        return this.doProtect(new MLOperator(this.visitInput(mlOperator.getInput(), context), mlOperator.getArguments(), mlOperator.getNodeClient()));
    }

    public PhysicalPlan visitTrendline(TrendlineOperator node, Object context) {
        return this.doProtect((PhysicalPlan)new TrendlineOperator(this.visitInput(node.getInput(), context), node.getComputations()));
    }

    PhysicalPlan visitInput(PhysicalPlan node, Object context) {
        if (null == node) {
            return node;
        }
        return (PhysicalPlan)node.accept((PhysicalPlanNodeVisitor)this, context);
    }

    protected PhysicalPlan doProtect(PhysicalPlan node) {
        if (this.isProtected(node)) {
            return node;
        }
        return new ResourceMonitorPlan(node, this.resourceMonitor);
    }

    private boolean isProtected(PhysicalPlan node) {
        return node instanceof ResourceMonitorPlan;
    }

    @Generated
    public OpenSearchExecutionProtector(ResourceMonitor resourceMonitor) {
        this.resourceMonitor = resourceMonitor;
    }
}

