/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.Node;
import org.opensearch.sql.ast.expression.IntervalUnit;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.ast.expression.WindowBound;
import org.opensearch.sql.ast.expression.WindowFrame;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PPLHintUtils;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLFuncImpTable;

public interface PlanUtils {
    public static final String ROW_NUMBER_COLUMN_FOR_DEDUP = "_row_number_dedup_";
    public static final String ROW_NUMBER_COLUMN_FOR_RARE_TOP = "_row_number_rare_top_";
    public static final String ROW_NUMBER_COLUMN_FOR_MAIN = "_row_number_main_";
    public static final String ROW_NUMBER_COLUMN_FOR_SUBSEARCH = "_row_number_subsearch_";
    public static final String ROW_NUMBER_COLUMN_FOR_STREAMSTATS = "__stream_seq__";
    public static final String ROW_NUMBER_COLUMN_FOR_CHART = "_row_number_chart_";
    public static final String ROW_NUMBER_COLUMN_FOR_TRANSPOSE = "_row_number_transpose_";
    public static final Predicate<Aggregate> aggIgnoreNullBucket = PPLHintUtils::ignoreNullBucket;
    public static final Predicate<Aggregate> maybeTimeSpanAgg = agg -> agg.getGroupSet().stream().allMatch(group -> OpenSearchTypeFactory.isTimeBasedType(((RelDataTypeField)agg.getInput().getRowType().getFieldList().get(group)).getType()));

    public static SpanUnit intervalUnitToSpanUnit(IntervalUnit unit) {
        return switch (unit) {
            case IntervalUnit.MICROSECOND -> SpanUnit.MICROSECOND;
            case IntervalUnit.MILLISECOND -> SpanUnit.MILLISECOND;
            case IntervalUnit.SECOND -> SpanUnit.SECOND;
            case IntervalUnit.MINUTE -> SpanUnit.MINUTE;
            case IntervalUnit.HOUR -> SpanUnit.HOUR;
            case IntervalUnit.DAY -> SpanUnit.DAY;
            case IntervalUnit.WEEK -> SpanUnit.WEEK;
            case IntervalUnit.MONTH -> SpanUnit.MONTH;
            case IntervalUnit.QUARTER -> SpanUnit.QUARTER;
            case IntervalUnit.YEAR -> SpanUnit.YEAR;
            case IntervalUnit.UNKNOWN -> SpanUnit.UNKNOWN;
            default -> throw new UnsupportedOperationException("Unsupported interval unit: " + String.valueOf((Object)unit));
        };
    }

    public static IntervalUnit spanUnitToIntervalUnit(SpanUnit unit) {
        switch (unit) {
            case MICROSECOND: 
            case US: {
                return IntervalUnit.MICROSECOND;
            }
            case MILLISECOND: 
            case MS: {
                return IntervalUnit.MILLISECOND;
            }
            case SECOND: 
            case SECONDS: 
            case SEC: 
            case SECS: 
            case S: {
                return IntervalUnit.SECOND;
            }
            case MINUTE: 
            case MINUTES: 
            case MIN: 
            case MINS: 
            case m: {
                return IntervalUnit.MINUTE;
            }
            case HOUR: 
            case HOURS: 
            case HR: 
            case HRS: 
            case H: {
                return IntervalUnit.HOUR;
            }
            case DAY: 
            case DAYS: 
            case D: {
                return IntervalUnit.DAY;
            }
            case WEEK: 
            case WEEKS: 
            case W: {
                return IntervalUnit.WEEK;
            }
            case MONTH: 
            case MONTHS: 
            case MON: 
            case M: {
                return IntervalUnit.MONTH;
            }
            case QUARTER: 
            case QUARTERS: 
            case QTR: 
            case QTRS: 
            case Q: {
                return IntervalUnit.QUARTER;
            }
            case YEAR: 
            case YEARS: 
            case Y: {
                return IntervalUnit.YEAR;
            }
            case UNKNOWN: {
                return IntervalUnit.UNKNOWN;
            }
        }
        throw new UnsupportedOperationException("Unsupported span unit: " + String.valueOf((Object)unit));
    }

    public static RexNode makeOver(CalcitePlanContext context, BuiltinFunctionName functionName, RexNode field, List<RexNode> argList, List<RexNode> partitions, List<RexNode> orderKeys, @Nullable WindowFrame windowFrame) {
        if (windowFrame == null) {
            windowFrame = WindowFrame.rowsUnbounded();
        }
        boolean rows = windowFrame.getType() == WindowFrame.FrameType.ROWS;
        RexWindowBound lowerBound = PlanUtils.convert(context, windowFrame.getLower());
        RexWindowBound upperBound = PlanUtils.convert(context, windowFrame.getUpper());
        switch (functionName) {
            case AVG: {
                return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, new RexNode[]{PlanUtils.sumOver(context, field, partitions, rows, lowerBound, upperBound), context.relBuilder.cast(PlanUtils.countOver(context, field, partitions, rows, lowerBound, upperBound), SqlTypeName.DOUBLE)});
            }
            case STDDEV_POP: {
                return PlanUtils.variance(context, field, partitions, rows, lowerBound, upperBound, true, true);
            }
            case STDDEV_SAMP: {
                return PlanUtils.variance(context, field, partitions, rows, lowerBound, upperBound, false, true);
            }
            case VARPOP: {
                return PlanUtils.variance(context, field, partitions, rows, lowerBound, upperBound, true, false);
            }
            case VARSAMP: {
                return PlanUtils.variance(context, field, partitions, rows, lowerBound, upperBound, false, false);
            }
            case ROW_NUMBER: {
                return PlanUtils.withOver(context.relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]), partitions, orderKeys, true, lowerBound, upperBound);
            }
            case NTH_VALUE: {
                return PlanUtils.withOver(context.relBuilder.aggregateCall(SqlStdOperatorTable.NTH_VALUE, new RexNode[]{field, argList.get(0)}), partitions, orderKeys, true, lowerBound, upperBound);
            }
        }
        return PlanUtils.withOver(PlanUtils.makeAggCall(context, functionName, false, field, argList), partitions, orderKeys, rows, lowerBound, upperBound);
    }

    private static RexNode sumOver(CalcitePlanContext ctx, RexNode operation, List<RexNode> partitions, boolean rows, RexWindowBound lowerBound, RexWindowBound upperBound) {
        return PlanUtils.withOver(ctx.relBuilder.sum(operation), partitions, List.of(), rows, lowerBound, upperBound);
    }

    private static RexNode countOver(CalcitePlanContext ctx, RexNode operation, List<RexNode> partitions, boolean rows, RexWindowBound lowerBound, RexWindowBound upperBound) {
        return PlanUtils.withOver(ctx.relBuilder.count((Iterable)ImmutableList.of((Object)operation)), partitions, List.of(), rows, lowerBound, upperBound);
    }

    private static RexNode withOver(RelBuilder.AggCall aggCall, List<RexNode> partitions, List<RexNode> orderKeys, boolean rows, RexWindowBound lowerBound, RexWindowBound upperBound) {
        return ((RelBuilder.OverCall)aggCall.over().partitionBy(partitions).orderBy(orderKeys).let(c -> rows ? c.rowsBetween(lowerBound, upperBound) : c.rangeBetween(lowerBound, upperBound))).toRex();
    }

    private static RexNode variance(CalcitePlanContext ctx, RexNode operator, List<RexNode> partitions, boolean rows, RexWindowBound lowerBound, RexWindowBound upperBound, boolean biased, boolean sqrt) {
        RexNode div;
        RexNode denominator;
        RexNode argSquared = ctx.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{operator, operator});
        RexNode sumArgSquared = PlanUtils.sumOver(ctx, argSquared, partitions, rows, lowerBound, upperBound);
        RexNode sum = PlanUtils.sumOver(ctx, operator, partitions, rows, lowerBound, upperBound);
        RexNode sumSquared = ctx.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{sum, sum});
        RexNode count = PlanUtils.countOver(ctx, operator, partitions, rows, lowerBound, upperBound);
        RexNode countCast = ctx.relBuilder.cast(count, SqlTypeName.DOUBLE);
        RexNode avgSumSquared = ctx.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, new RexNode[]{sumSquared, countCast});
        RexNode diff = ctx.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{sumArgSquared, avgSumSquared});
        if (biased) {
            denominator = countCast;
        } else {
            RexLiteral one = ctx.relBuilder.literal(1);
            denominator = ctx.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{countCast, one});
        }
        RexNode result = div = ctx.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, new RexNode[]{diff, denominator});
        if (sqrt) {
            RexLiteral half = ctx.relBuilder.literal(0.5);
            result = ctx.relBuilder.call((SqlOperator)SqlStdOperatorTable.POWER, new RexNode[]{div, half});
        }
        return result;
    }

    public static RexWindowBound convert(CalcitePlanContext context, WindowBound windowBound) {
        if (windowBound instanceof WindowBound.UnboundedWindowBound) {
            WindowBound.UnboundedWindowBound unbounded = (WindowBound.UnboundedWindowBound)windowBound;
            if (unbounded.isPreceding()) {
                return RexWindowBounds.UNBOUNDED_PRECEDING;
            }
            return RexWindowBounds.UNBOUNDED_FOLLOWING;
        }
        if (windowBound instanceof WindowBound.CurrentRowWindowBound) {
            WindowBound.CurrentRowWindowBound current = (WindowBound.CurrentRowWindowBound)windowBound;
            return RexWindowBounds.CURRENT_ROW;
        }
        if (windowBound instanceof WindowBound.OffSetWindowBound) {
            WindowBound.OffSetWindowBound offset = (WindowBound.OffSetWindowBound)windowBound;
            if (offset.isPreceding()) {
                return RexWindowBounds.preceding((RexNode)context.relBuilder.literal(offset.getOffset()));
            }
            return RexWindowBounds.following((RexNode)context.relBuilder.literal(offset.getOffset()));
        }
        throw new UnsupportedOperationException("Unexpected window bound: " + String.valueOf(windowBound));
    }

    public static RelBuilder.AggCall makeAggCall(CalcitePlanContext context, BuiltinFunctionName functionName, boolean distinct, RexNode field, List<RexNode> argList) {
        return PPLFuncImpTable.INSTANCE.resolveAgg(functionName, distinct, field, argList, context);
    }

    public static List<RexInputRef> getInputRefs(RexNode node) {
        if (node == null) {
            return List.of();
        }
        final ArrayList<RexInputRef> inputRefs = new ArrayList<RexInputRef>();
        node.accept((RexVisitor)new RexVisitorImpl<Void>(true){

            public Void visitInputRef(RexInputRef inputRef) {
                if (!inputRefs.contains(inputRef)) {
                    inputRefs.add(inputRef);
                }
                return null;
            }
        });
        return inputRefs;
    }

    public static List<RexInputRef> getInputRefs(List<RexNode> nodes) {
        return nodes.stream().flatMap(node -> PlanUtils.getInputRefs(node).stream()).toList();
    }

    public static List<RexCall> getRexCall(RexNode node, final Predicate<RexCall> predicate) {
        final ArrayList<RexCall> list = new ArrayList<RexCall>();
        node.accept((RexVisitor)new RexVisitorImpl<Void>(true){

            public Void visitCall(RexCall inputCall) {
                if (predicate.test(inputCall)) {
                    if (!list.contains(inputCall)) {
                        list.add(inputCall);
                    }
                } else {
                    inputCall.getOperands().forEach(call -> call.accept((RexVisitor)this));
                }
                return null;
            }
        });
        return list;
    }

    public static List<RexInputRef> getInputRefsFromAggCall(List<RelBuilder.AggCall> aggCalls) {
        return aggCalls.stream().map(RelBuilder.AggCall::over).map(RelBuilder.OverCall::toRex).flatMap(rex -> PlanUtils.getInputRefs(rex).stream()).toList();
    }

    public static UnresolvedPlan getRelation(UnresolvedPlan node) {
        AbstractNodeVisitor<Relation, Object> relationVisitor = new AbstractNodeVisitor<Relation, Object>(){

            @Override
            public Relation visitRelation(Relation node, Object context) {
                return node;
            }
        };
        return node.getChild().getFirst().accept(relationVisitor, null);
    }

    public static RelOptTable findTable(RelNode root) {
        try {
            RelHomogeneousShuttle visitor = new RelHomogeneousShuttle(){

                public RelNode visit(TableScan scan) {
                    RelOptTable scanTable = scan.getTable();
                    throw new Util.FoundOne((Object)scanTable);
                }
            };
            root.accept((RelShuttle)visitor);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow((Throwable)e, null);
            return (RelOptTable)e.getNode();
        }
    }

    public static void transformPlanToAttachChild(UnresolvedPlan node, final UnresolvedPlan child) {
        AbstractNodeVisitor<Void, Object> leafVisitor = new AbstractNodeVisitor<Void, Object>(){

            @Override
            public Void visitChildren(Node node, Object context) {
                if (node.getChild() == null || node.getChild().isEmpty()) {
                    ((UnresolvedPlan)node).attach(child);
                } else {
                    node.getChild().forEach(child -> child.accept(this, context));
                }
                return null;
            }
        };
        node.accept(leafVisitor, null);
    }

    public static RexNode derefMapCall(RexNode rexNode) {
        RexCall call;
        if (rexNode instanceof RexCall && (call = (RexCall)rexNode).getOperator() == SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR) {
            return (RexNode)call.getOperands().get(1);
        }
        return rexNode;
    }

    public static boolean containsRowNumberDedup(RelNode node) {
        List fieldNames = node.getRowType().getFieldNames();
        return ((String)fieldNames.get(fieldNames.size() - 1)).equals(ROW_NUMBER_COLUMN_FOR_DEDUP);
    }

    public static boolean containsRowNumberRareTop(RelNode node) {
        return node.getRowType().getFieldNames().stream().anyMatch(ROW_NUMBER_COLUMN_FOR_RARE_TOP::equals);
    }

    public static List<RexWindow> getRexWindowFromProject(LogicalProject project) {
        final ArrayList<RexWindow> res = new ArrayList<RexWindow>();
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            public Void visitOver(RexOver over) {
                res.add(over.getWindow());
                return null;
            }
        };
        visitor.visitEach((Iterable)project.getProjects());
        return res;
    }

    public static List<Integer> getSelectColumns(List<RexNode> rexNodes) {
        final ArrayList<Integer> selectedColumns = new ArrayList<Integer>();
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            public Void visitInputRef(RexInputRef inputRef) {
                if (!selectedColumns.contains(inputRef.getIndex())) {
                    selectedColumns.add(inputRef.getIndex());
                }
                return null;
            }
        };
        visitor.visitEach(rexNodes);
        return selectedColumns;
    }

    public static boolean distinctProjectList(LogicalProject project) {
        HashSet rexSet = new HashSet();
        return project.getNamedProjects().stream().allMatch(rexSet::add);
    }

    public static boolean isLogicalSortLimit(LogicalSort sort) {
        return sort.fetch != null;
    }

    public static boolean containsRexCall(Project project) {
        return project.getProjects().stream().anyMatch(p -> p instanceof RexCall);
    }

    public static boolean sortByFieldsOnly(Sort sort) {
        return !sort.getCollation().getFieldCollations().isEmpty() && sort.fetch == null;
    }

    public static boolean sortReferencesExpr(Sort sort, Project project) {
        if (sort.getCollation().getFieldCollations().isEmpty()) {
            return false;
        }
        return sort.getCollation().getFieldCollations().stream().anyMatch(relFieldCollation -> project.getProjects().get(relFieldCollation.getFieldIndex()) instanceof RexCall);
    }

    public static String getActualSignature(List<RelDataType> argTypes) {
        return "[" + argTypes.stream().map(OpenSearchTypeFactory::convertRelDataTypeToExprType).map(Objects::toString).collect(Collectors.joining(",")) + "]";
    }

    public static boolean containsCorrelVariable(RexNode node) {
        try {
            node.accept((RexVisitor)new RexVisitorImpl<Void>(true){

                public Void visitCorrelVariable(RexCorrelVariable correlVar) {
                    throw new RuntimeException("Correl found");
                }
            });
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void replaceTop(RelBuilder relBuilder, RelNode relNode) {
        try {
            Method method = RelBuilder.class.getDeclaredMethod("replaceTop", RelNode.class);
            method.setAccessible(true);
            method.invoke((Object)relBuilder, relNode);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to invoke RelBuilder.replaceTop", e);
        }
    }

    @Nullable
    public static RexLiteral getObjectFromLiteralAgg(AggregateCall aggCall) {
        if (aggCall.getAggregation().kind == SqlKind.LITERAL_AGG) {
            return aggCall.rexList.stream().filter(rex -> rex instanceof RexLiteral).findAny().orElse(null);
        }
        return null;
    }

    public static Mapping mapping(List<RexNode> rexNodes, RelDataType schema) {
        return Mappings.target(PlanUtils.getSelectColumns(rexNodes), (int)schema.getFieldCount());
    }

    public static boolean mayBeFilterFromBucketNonNull(LogicalFilter filter) {
        RexCall rexCall;
        RexNode condition = filter.getCondition();
        return PlanUtils.isNotNullOnRef(condition) || condition instanceof RexCall && (rexCall = (RexCall)condition).getOperator().equals((Object)SqlStdOperatorTable.AND) && rexCall.getOperands().stream().allMatch(PlanUtils::isNotNullOnRef);
    }

    private static boolean isNotNullOnRef(RexNode rex) {
        RexCall rexCall;
        return rex instanceof RexCall && (rexCall = (RexCall)rex).isA(SqlKind.IS_NOT_NULL) && rexCall.getOperands().get(0) instanceof RexInputRef;
    }

    public static boolean isTimeSpan(RexNode rex) {
        RexLiteral unitLiteral;
        Object e;
        RexCall rexCall;
        return rex instanceof RexCall && (rexCall = (RexCall)rex).getKind() == SqlKind.OTHER_FUNCTION && rexCall.getOperator().getName().equalsIgnoreCase(BuiltinFunctionName.SPAN.name()) && rexCall.getOperands().size() == 3 && (e = rexCall.getOperands().get(2)) instanceof RexLiteral && (unitLiteral = (RexLiteral)e).getTypeName() != SqlTypeName.NULL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNotNullDerivedFromAgg(RexNode condition, Aggregate aggregate, @Nullable Project project, @Nullable List<Integer> otherMapping) {
        List<Integer> finalGroupRefList;
        Function<RexNode, Boolean> isNotNullFromAgg;
        boolean ignoreNullBucket = aggIgnoreNullBucket.test(aggregate);
        if (!ignoreNullBucket && project == null) {
            return false;
        }
        List<Integer> groupRefList = aggregate.getGroupSet().asList();
        if (project != null) {
            groupRefList = groupRefList.stream().map(project.getProjects()::get).filter(rex -> ignoreNullBucket || PlanUtils.isTimeSpan(rex)).flatMap(expr -> PlanUtils.getInputRefs(expr).stream()).map(RexSlot::getIndex).toList();
        }
        if (otherMapping != null) {
            groupRefList = groupRefList.stream().map(otherMapping::get).toList();
        }
        if ((isNotNullFromAgg = arg_0 -> PlanUtils.lambda$isNotNullDerivedFromAgg$10(finalGroupRefList = groupRefList, arg_0)).apply(condition) != false) return true;
        if (!(condition instanceof RexCall)) return false;
        RexCall rexCall = (RexCall)condition;
        if (rexCall.getOperator() != SqlStdOperatorTable.AND) return false;
        if (!rexCall.getOperands().stream().allMatch(isNotNullFromAgg::apply)) return false;
        return true;
    }

    public static void tryPruneRelNodes(RelOptRuleCall call) {
        RelOptPlanner relOptPlanner = call.getPlanner();
        if (relOptPlanner instanceof VolcanoPlanner) {
            VolcanoPlanner volcanoPlanner = (VolcanoPlanner)relOptPlanner;
            Arrays.stream(call.rels).takeWhile(rel -> rel.getConvention() == Convention.NONE && (rel == call.rels[0] || volcanoPlanner.getSubsetNonNull(rel).getParentRels().size() == 1)).forEach(arg_0 -> ((VolcanoPlanner)volcanoPlanner).prune(arg_0));
        }
    }

    private static /* synthetic */ Boolean lambda$isNotNullDerivedFromAgg$10(List finalGroupRefList, RexNode rex) {
        RexInputRef ref;
        Object patt0$temp;
        RexCall rexCall;
        return rex instanceof RexCall && (rexCall = (RexCall)rex).isA(SqlKind.IS_NOT_NULL) && (patt0$temp = rexCall.getOperands().get(0)) instanceof RexInputRef && finalGroupRefList.contains((ref = (RexInputRef)patt0$temp).getIndex());
    }
}

