﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/savingsplans/SavingsPlans_EXPORTS.h>
#include <aws/savingsplans/model/SavingsPlanOfferingPropertyKey.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SavingsPlans {
namespace Model {

/**
 * <p>Information about a Savings Plan offering property.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/SavingsPlanOfferingProperty">AWS
 * API Reference</a></p>
 */
class SavingsPlanOfferingProperty {
 public:
  AWS_SAVINGSPLANS_API SavingsPlanOfferingProperty() = default;
  AWS_SAVINGSPLANS_API SavingsPlanOfferingProperty(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAVINGSPLANS_API SavingsPlanOfferingProperty& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAVINGSPLANS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The property name.</p>
   */
  inline SavingsPlanOfferingPropertyKey GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  inline void SetName(SavingsPlanOfferingPropertyKey value) {
    m_nameHasBeenSet = true;
    m_name = value;
  }
  inline SavingsPlanOfferingProperty& WithName(SavingsPlanOfferingPropertyKey value) {
    SetName(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The property value.</p>
   */
  inline const Aws::String& GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  template <typename ValueT = Aws::String>
  void SetValue(ValueT&& value) {
    m_valueHasBeenSet = true;
    m_value = std::forward<ValueT>(value);
  }
  template <typename ValueT = Aws::String>
  SavingsPlanOfferingProperty& WithValue(ValueT&& value) {
    SetValue(std::forward<ValueT>(value));
    return *this;
  }
  ///@}
 private:
  SavingsPlanOfferingPropertyKey m_name{SavingsPlanOfferingPropertyKey::NOT_SET};

  Aws::String m_value;
  bool m_nameHasBeenSet = false;
  bool m_valueHasBeenSet = false;
};

}  // namespace Model
}  // namespace SavingsPlans
}  // namespace Aws
