﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-messaging/ChimeSDKMessagingRequest.h>
#include <aws/chime-sdk-messaging/ChimeSDKMessaging_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ChimeSDKMessaging {
namespace Model {

/**
 */
class DescribeChannelFlowRequest : public ChimeSDKMessagingRequest {
 public:
  AWS_CHIMESDKMESSAGING_API DescribeChannelFlowRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeChannelFlow"; }

  AWS_CHIMESDKMESSAGING_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ARN of the channel flow.</p>
   */
  inline const Aws::String& GetChannelFlowArn() const { return m_channelFlowArn; }
  inline bool ChannelFlowArnHasBeenSet() const { return m_channelFlowArnHasBeenSet; }
  template <typename ChannelFlowArnT = Aws::String>
  void SetChannelFlowArn(ChannelFlowArnT&& value) {
    m_channelFlowArnHasBeenSet = true;
    m_channelFlowArn = std::forward<ChannelFlowArnT>(value);
  }
  template <typename ChannelFlowArnT = Aws::String>
  DescribeChannelFlowRequest& WithChannelFlowArn(ChannelFlowArnT&& value) {
    SetChannelFlowArn(std::forward<ChannelFlowArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_channelFlowArn;
  bool m_channelFlowArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKMessaging
}  // namespace Aws
