/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.core.startup.base.LayerFactory;
import org.netbeans.core.startup.layers.Bundle;
import org.netbeans.core.startup.layers.LocalFileSystemEx;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.modules.PatchedPublic;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public final class SystemFileSystem
extends MultiFileSystem
implements FileChangeListener {
    static final long serialVersionUID = -7761052280240991668L;
    private static final String SYSTEM_NAME = "SystemFileSystem";
    private static final Logger LOG = Logger.getLogger(SystemFileSystem.class.getName());
    private ModuleLayeredFileSystem user;
    private ModuleLayeredFileSystem home;

    public static void registerMutex(Mutex mutex) {
        ModuleLayeredFileSystem.registerMutex(mutex);
    }

    private SystemFileSystem(FileSystem[] fileSystemArray) throws PropertyVetoException {
        super(fileSystemArray);
        this.user = (ModuleLayeredFileSystem)fileSystemArray[0];
        this.home = fileSystemArray.length > 1 ? (ModuleLayeredFileSystem)fileSystemArray[1] : null;
        this.setSystemName(SYSTEM_NAME);
        this.addFileChangeListener(this);
    }

    public String getDisplayName() {
        return Bundle.CTL_SystemFileSystem();
    }

    public ModuleLayeredFileSystem getInstallationLayer() {
        return this.home;
    }

    public ModuleLayeredFileSystem getUserLayer() {
        return this.user;
    }

    public final void setLayers(FileSystem[] fileSystemArray) throws IllegalArgumentException {
        HashSet<FileSystem> hashSet = new HashSet<FileSystem>();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (hashSet.contains(fileSystemArray[i])) {
                throw new IllegalArgumentException("Overlap in filesystem layers");
            }
            hashSet.add(fileSystemArray[i]);
        }
        this.setDelegates((FileSystem[])fileSystemArray.clone());
        this.firePropertyChange("layers", null, null);
    }

    public FileSystem[] getLayers() {
        return (FileSystem[])this.getDelegates().clone();
    }

    protected FileSystem createWritableOnForRename(String string, String string2) throws IOException {
        return this.createWritableOn(string);
    }

    protected FileSystem createWritableOn(String string) throws IOException {
        FileSystem[] fileSystemArray = this.getDelegates();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (fileSystemArray[i].isReadOnly()) continue;
            return fileSystemArray[i];
        }
        throw new IOException("No writable filesystems in our delegates");
    }

    protected Set<? extends FileSystem> createLocksOn(String string) throws IOException {
        LocalFileSystemEx.potentialLock(string);
        return super.createLocksOn(string);
    }

    @PatchedPublic
    static SystemFileSystem create(File file, File file2, File[] fileArray) throws PropertyVetoException, IOException {
        Object object;
        Object object2;
        Object object3;
        String string = System.getProperty("org.netbeans.core.systemfilesystem.custom");
        if (string != null) {
            try {
                object3 = Class.forName(string);
                object2 = object3.newInstance();
                object = (FileSystem)object2;
            }
            catch (Exception exception) {
                ModuleLayeredFileSystem.err.log(Level.WARNING, "Custom system file system writable layer init failed ", exception);
                object = FileUtil.createMemoryFileSystem();
            }
        } else if (file != null) {
            if (!file.exists()) {
                file.mkdirs();
            }
            object3 = new LocalFileSystemEx(true);
            object3.setRootDirectory(file);
            object = object3;
        } else {
            object = FileUtil.createMemoryFileSystem();
        }
        object3 = file2 == null || !file2.isDirectory() ? null : SystemFileSystem.createInstallHomeSystem(file2, fileArray, true, false).getUserLayer();
        object2 = new FileSystem[object3 == null ? 1 : 2];
        LayerFactory.Provider provider = (LayerFactory.Provider)Lookup.getDefault().lookup(LayerFactory.Provider.class);
        object2[0] = new ModuleLayeredFileSystem((FileSystem)object, true, new FileSystem[0], provider.create(false));
        if (object3 != null) {
            object2[1] = object3;
        }
        return new SystemFileSystem((FileSystem[])object2);
    }

    public static SystemFileSystem createInstallHomeSystem(File file, File[] fileArray, boolean bl, boolean bl2) throws IOException, PropertyVetoException {
        LayerFactory.Provider provider = (LayerFactory.Provider)Lookup.getDefault().lookup(LayerFactory.Provider.class);
        LocalFileSystem[] localFileSystemArray = new LocalFileSystem[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            localFileSystemArray[i] = new LocalFileSystemEx();
            localFileSystemArray[i].setRootDirectory(fileArray[i]);
            localFileSystemArray[i].setReadOnly(true);
        }
        LocalFileSystemEx localFileSystemEx = new LocalFileSystemEx();
        localFileSystemEx.setRootDirectory(file);
        localFileSystemEx.setReadOnly(bl);
        FileSystem[] fileSystemArray = new FileSystem[]{new ModuleLayeredFileSystem((FileSystem)localFileSystemEx, bl2, (FileSystem[])localFileSystemArray, provider.create(true))};
        return new SystemFileSystem(fileSystemArray);
    }

    public static SystemFileSystem createUserFileSystem(File file, ModuleLayeredFileSystem moduleLayeredFileSystem) throws IOException, PropertyVetoException {
        LayerFactory.Provider provider = (LayerFactory.Provider)Lookup.getDefault().lookup(LayerFactory.Provider.class);
        LocalFileSystemEx localFileSystemEx = new LocalFileSystemEx();
        localFileSystemEx.setRootDirectory(file);
        FileSystem[] fileSystemArray = new FileSystem[]{new ModuleLayeredFileSystem((FileSystem)localFileSystemEx, false, new FileSystem[0], provider.create(false)), moduleLayeredFileSystem};
        return new SystemFileSystem(fileSystemArray);
    }

    protected void notifyMigration(FileObject fileObject) {
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, fileObject, false, true));
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        SystemFileSystem.log("fileFolderCreated", fileEvent);
    }

    public void fileDataCreated(FileEvent fileEvent) {
        SystemFileSystem.log("fileDataCreated", fileEvent);
    }

    public void fileChanged(FileEvent fileEvent) {
        SystemFileSystem.log("fileChanged", fileEvent);
    }

    public void fileDeleted(FileEvent fileEvent) {
        SystemFileSystem.log("fileDeleted", fileEvent);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        SystemFileSystem.log("fileDeleted", (FileEvent)fileRenameEvent);
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        SystemFileSystem.log("fileAttributeChanged", (FileEvent)fileAttributeEvent);
    }

    private static void log(String string, FileEvent fileEvent) {
        if (LOG.isLoggable(Level.FINER)) {
            LogRecord logRecord = new LogRecord(Level.FINER, "LOG_FILE_EVENT");
            logRecord.setLoggerName(LOG.getName());
            logRecord.setParameters(new Object[]{string, fileEvent.getFile().getPath(), fileEvent.getFile(), fileEvent});
            logRecord.setResourceBundle(NbBundle.getBundle(SystemFileSystem.class));
            LOG.log(logRecord);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        new NotSerializableException("WARNING - SystemFileSystem is not designed to be serialized").printStackTrace();
        return new SingletonSerializer();
    }

    private static final class SingletonSerializer
    implements Serializable {
        private static final long serialVersionUID = 6436781994611L;

        SingletonSerializer() {
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                return FileUtil.getConfigRoot().getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                return null;
            }
        }
    }
}

