﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/imagebuilder/model/SeverityCounts.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace imagebuilder
{
namespace Model
{

  /**
   * <p>Includes counts of image and pipeline resource findings by
   * vulnerability.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/VulnerabilityIdAggregation">AWS
   * API Reference</a></p>
   */
  class VulnerabilityIdAggregation
  {
  public:
    AWS_IMAGEBUILDER_API VulnerabilityIdAggregation();
    AWS_IMAGEBUILDER_API VulnerabilityIdAggregation(Aws::Utils::Json::JsonView jsonValue);
    AWS_IMAGEBUILDER_API VulnerabilityIdAggregation& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_IMAGEBUILDER_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The vulnerability Id for this set of counts.</p>
     */
    inline const Aws::String& GetVulnerabilityId() const{ return m_vulnerabilityId; }

    /**
     * <p>The vulnerability Id for this set of counts.</p>
     */
    inline bool VulnerabilityIdHasBeenSet() const { return m_vulnerabilityIdHasBeenSet; }

    /**
     * <p>The vulnerability Id for this set of counts.</p>
     */
    inline void SetVulnerabilityId(const Aws::String& value) { m_vulnerabilityIdHasBeenSet = true; m_vulnerabilityId = value; }

    /**
     * <p>The vulnerability Id for this set of counts.</p>
     */
    inline void SetVulnerabilityId(Aws::String&& value) { m_vulnerabilityIdHasBeenSet = true; m_vulnerabilityId = std::move(value); }

    /**
     * <p>The vulnerability Id for this set of counts.</p>
     */
    inline void SetVulnerabilityId(const char* value) { m_vulnerabilityIdHasBeenSet = true; m_vulnerabilityId.assign(value); }

    /**
     * <p>The vulnerability Id for this set of counts.</p>
     */
    inline VulnerabilityIdAggregation& WithVulnerabilityId(const Aws::String& value) { SetVulnerabilityId(value); return *this;}

    /**
     * <p>The vulnerability Id for this set of counts.</p>
     */
    inline VulnerabilityIdAggregation& WithVulnerabilityId(Aws::String&& value) { SetVulnerabilityId(std::move(value)); return *this;}

    /**
     * <p>The vulnerability Id for this set of counts.</p>
     */
    inline VulnerabilityIdAggregation& WithVulnerabilityId(const char* value) { SetVulnerabilityId(value); return *this;}


    /**
     * <p>Counts by severity level for medium severity and higher level findings, plus
     * a total for all of the findings for the specified vulnerability.</p>
     */
    inline const SeverityCounts& GetSeverityCounts() const{ return m_severityCounts; }

    /**
     * <p>Counts by severity level for medium severity and higher level findings, plus
     * a total for all of the findings for the specified vulnerability.</p>
     */
    inline bool SeverityCountsHasBeenSet() const { return m_severityCountsHasBeenSet; }

    /**
     * <p>Counts by severity level for medium severity and higher level findings, plus
     * a total for all of the findings for the specified vulnerability.</p>
     */
    inline void SetSeverityCounts(const SeverityCounts& value) { m_severityCountsHasBeenSet = true; m_severityCounts = value; }

    /**
     * <p>Counts by severity level for medium severity and higher level findings, plus
     * a total for all of the findings for the specified vulnerability.</p>
     */
    inline void SetSeverityCounts(SeverityCounts&& value) { m_severityCountsHasBeenSet = true; m_severityCounts = std::move(value); }

    /**
     * <p>Counts by severity level for medium severity and higher level findings, plus
     * a total for all of the findings for the specified vulnerability.</p>
     */
    inline VulnerabilityIdAggregation& WithSeverityCounts(const SeverityCounts& value) { SetSeverityCounts(value); return *this;}

    /**
     * <p>Counts by severity level for medium severity and higher level findings, plus
     * a total for all of the findings for the specified vulnerability.</p>
     */
    inline VulnerabilityIdAggregation& WithSeverityCounts(SeverityCounts&& value) { SetSeverityCounts(std::move(value)); return *this;}

  private:

    Aws::String m_vulnerabilityId;
    bool m_vulnerabilityIdHasBeenSet = false;

    SeverityCounts m_severityCounts;
    bool m_severityCountsHasBeenSet = false;
  };

} // namespace Model
} // namespace imagebuilder
} // namespace Aws
