require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_SYSTM_H_)) {
    eval 'sub _SYS_SYSTM_H_ () {1;}' unless defined(&_SYS_SYSTM_H_);
    require 'sys/cdefs.ph';
    require 'machine/atomic.ph';
    require 'machine/cpufunc.ph';
    require 'sys/callout.ph';
    require 'sys/queue.ph';
    require 'sys/stdint.ph';
    eval("sub VM_GUEST_NO () { 0; }") unless defined(&VM_GUEST_NO);
    eval("sub VM_GUEST_VM () { 1; }") unless defined(&VM_GUEST_VM);
    eval("sub VM_GUEST_XEN () { 2; }") unless defined(&VM_GUEST_XEN);
    eval("sub VM_GUEST_HV () { 3; }") unless defined(&VM_GUEST_HV);
    eval("sub VM_GUEST_VMWARE () { 4; }") unless defined(&VM_GUEST_VMWARE);
    eval("sub VM_GUEST_KVM () { 5; }") unless defined(&VM_GUEST_KVM);
    eval("sub VM_GUEST_BHYVE () { 6; }") unless defined(&VM_GUEST_BHYVE);
    eval("sub VM_LAST () { 7; }") unless defined(&VM_LAST);
    if(defined(&WITNESS) || defined(&INVARIANT_SUPPORT)) {
	if(defined(&KASSERT_PANIC_OPTIONAL)) {
	} else {
	    eval 'sub kassert_panic () { &panic;}' unless defined(&kassert_panic);
	}
    }
    if(defined(&INVARIANTS)) {
	eval 'sub KASSERT {
	    my($exp,$msg) = @_;
    	    eval q( &do {  &if ( &__predict_false(!($exp)))  &kassert_panic $msg; }  &while (0));
	}' unless defined(&KASSERT);
	eval 'sub VNASSERT {
	    my($exp, $vp, $msg) = @_;
    	    eval q( &do {  &if ( &__predict_false(!($exp))) {  &vn_printf($vp, \\"VNASSERT failed\\\\n\\");  &kassert_panic $msg; } }  &while (0));
	}' unless defined(&VNASSERT);
    } else {
	eval 'sub KASSERT {
	    my($exp,$msg) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&KASSERT);
	eval 'sub VNASSERT {
	    my($exp, $vp, $msg) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&VNASSERT);
    }
    unless(defined(&CTASSERT)) {
	eval 'sub CTASSERT {
	    my($x) = @_;
    	    eval q( &_Static_assert($x, \\"compile-time assertion failed\\"));
	}' unless defined(&CTASSERT);
    }
    if(defined(&_KERNEL)) {
	require 'sys/param.ph';
	require 'sys/pcpu.ph';
	require 'sys/kpilite.ph';
    }
    eval 'sub ASSERT_ATOMIC_LOAD_PTR {
        my($var, $msg) = @_;
	    eval q( &KASSERT($sizeof{$var} == $sizeof{ &void }  && (( &uintptr_t)($var) & ($sizeof{ &void } - 1)) == 0, $msg));
    }' unless defined(&ASSERT_ATOMIC_LOAD_PTR);
    eval 'sub CRITICAL_ASSERT {
        my($td) = @_;
	    eval q( &KASSERT(($td)-> &td_critnest >= 1, (\\"Not in critical section\\")););
    }' unless defined(&CRITICAL_ASSERT);
    eval 'sub SCHEDULER_STOPPED_TD {
        my($td) = @_;
	    eval q(({  &MPASS(($td) ==  &curthread);  &__predict_false(($td)-> &td_stopsched); }));
    }' unless defined(&SCHEDULER_STOPPED_TD);
    eval 'sub SCHEDULER_STOPPED () {
        eval q( &SCHEDULER_STOPPED_TD( &curthread));
    }' unless defined(&SCHEDULER_STOPPED);
    eval 'sub __read_mostly () { &__section(".data.read_mostly");}' unless defined(&__read_mostly);
    eval 'sub __read_frequently () { &__section(".data.read_frequently");}' unless defined(&__read_frequently);
    eval 'sub __exclusive_cache_line () { &__aligned( &CACHE_LINE_SIZE)  &__section(".data.exclusive_cache_line");}' unless defined(&__exclusive_cache_line);
    if(defined(&__LP64__)) {
	eval 'sub IOSIZE_MAX () { &iosize_max();}' unless defined(&IOSIZE_MAX);
	eval 'sub DEVFS_IOSIZE_MAX () { &devfs_iosize_max();}' unless defined(&DEVFS_IOSIZE_MAX);
    } else {
	eval 'sub IOSIZE_MAX () { &SSIZE_MAX;}' unless defined(&IOSIZE_MAX);
	eval 'sub DEVFS_IOSIZE_MAX () { &SSIZE_MAX;}' unless defined(&DEVFS_IOSIZE_MAX);
    }
    eval 'sub HASH_NOWAIT () {0x1;}' unless defined(&HASH_NOWAIT);
    eval 'sub HASH_WAITOK () {0x2;}' unless defined(&HASH_WAITOK);
    if(defined(&KLD_MODULE) || defined(&KTR_CRITICAL) || !defined(&_KERNEL) || defined(&GENOFFSET)) {
	eval 'sub critical_enter () {
	    eval q( &critical_enter_KBI());
	}' unless defined(&critical_enter);
	eval 'sub critical_exit () {
	    eval q( &critical_exit_KBI());
	}' unless defined(&critical_exit);
    } else {
	eval 'sub critical_enter {
	    my($void) = @_;
    	    eval q({ \'struct thread_lite\' * &td;  &td =  &curthread;  ($td->{td_critnest})++;  &__compiler_membar(); });
	}' unless defined(&critical_enter);
	eval 'sub critical_exit {
	    my($void) = @_;
    	    eval q({ \'struct thread_lite\' * &td;  &td =  &curthread;  &KASSERT( ($td->{td_critnest}) != 0, (\\"critical_exit: td_critnest == 0\\"));  &__compiler_membar();  ($td->{td_critnest})--;  &__compiler_membar();  &if ( &__predict_false( ($td->{td_owepreempt})))  &critical_exit_preempt(); });
	}' unless defined(&critical_exit);
    }
    if(defined(&EARLY_PRINTF)) {
    }
    eval 'sub HD_COLUMN_MASK () {0xff;}' unless defined(&HD_COLUMN_MASK);
    eval 'sub HD_DELIM_MASK () {0xff00;}' unless defined(&HD_DELIM_MASK);
    eval 'sub HD_OMIT_COUNT () {(1<< 16);}' unless defined(&HD_OMIT_COUNT);
    eval 'sub HD_OMIT_HEX () {(1<< 17);}' unless defined(&HD_OMIT_HEX);
    eval 'sub HD_OMIT_CHARS () {(1<< 18);}' unless defined(&HD_OMIT_CHARS);
    eval 'sub ovbcopy {
        my($f, $t, $l) = @_;
	    eval q( &bcopy(($f), ($t), ($l)));
    }' unless defined(&ovbcopy);
    eval 'sub bcopy {
        my($from, $to, $len) = @_;
	    eval q( &__builtin_memmove(($to), ($from), ($len)));
    }' unless defined(&bcopy);
    eval 'sub bzero {
        my($buf, $len) = @_;
	    eval q( &__builtin_memset(($buf), 0, ($len)));
    }' unless defined(&bzero);
    eval 'sub bcmp {
        my($b1, $b2, $len) = @_;
	    eval q( &__builtin_memcmp(($b1), ($b2), ($len)));
    }' unless defined(&bcmp);
    eval 'sub memset {
        my($buf, $c, $len) = @_;
	    eval q( &__builtin_memset(($buf), ($c), ($len)));
    }' unless defined(&memset);
    eval 'sub memcpy {
        my($to, $from, $len) = @_;
	    eval q( &__builtin_memcpy(($to), ($from), ($len)));
    }' unless defined(&memcpy);
    eval 'sub memmove {
        my($dest, $src, $n) = @_;
	    eval q( &__builtin_memmove(($dest), ($src), ($n)));
    }' unless defined(&memmove);
    eval 'sub memcmp {
        my($b1, $b2, $len) = @_;
	    eval q( &__builtin_memcmp(($b1), ($b2), ($len)));
    }' unless defined(&memcmp);
    eval 'sub bzero_early {
        my($buf, $len) = @_;
	    eval q( &memset_early(($buf), 0, ($len)));
    }' unless defined(&bzero_early);
    eval 'sub bcopy_early {
        my($from, $to, $len) = @_;
	    eval q( &memmove_early(($to), ($from), ($len)));
    }' unless defined(&bcopy_early);
    eval 'sub GETENV_UNSIGNED () { &false;}' unless defined(&GETENV_UNSIGNED);
    eval 'sub GETENV_SIGNED () { &true;}' unless defined(&GETENV_SIGNED);
    if(defined(&APM_FIXUP_CALLTODO)) {
    }
    require 'sys/libkern.ph';
    eval 'sub CALLOUT_HANDLE_INITIALIZER {
        my($handle) = @_;
	    eval q({  &NULL });
    }' unless defined(&CALLOUT_HANDLE_INITIALIZER);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub splx {
        my($__unused) = @_;
	    eval q({ ; } \'int\'  &_sleep( &void *  &_Nonnull  &chan, \'struct lock_object\' * &lock, \'int\'  &pri,  &const \'char\' * &wmesg,  &sbintime_t  &sbt,  &sbintime_t  &pr, \'int\'  &flags);  &define  &msleep( &chan,  &mtx,  &pri,  &wmesg,  &timo)  &_sleep(( &chan), ( &mtx)-> &lock_object, ( &pri), ( &wmesg),  &tick_sbt * ( &timo), 0,  &C_HARDCLOCK)  &define  &msleep_sbt( &chan,  &mtx,  &pri,  &wmesg,  &bt,  &pr,  &flags)  &_sleep(( &chan), ( &mtx)-> &lock_object, ( &pri), ( &wmesg), ( &bt), ( &pr), ( &flags)) \'int\'  &msleep_spin_sbt( &void *  &_Nonnull  &chan, \'struct mtx\' * &mtx,  &const \'char\' * &wmesg,  &sbintime_t  &sbt,  &sbintime_t  &pr, \'int\'  &flags);  &define  &msleep_spin( &chan,  &mtx,  &wmesg,  &timo)  &msleep_spin_sbt(( &chan), ( &mtx), ( &wmesg),  &tick_sbt * ( &timo), 0,  &C_HARDCLOCK) \'int\'  &pause_sbt( &const \'char\' * &wmesg,  &sbintime_t  &sbt,  &sbintime_t  &pr, \'int\'  &flags);  &define  &pause( &wmesg,  &timo)  &pause_sbt(( &wmesg),  &tick_sbt * ( &timo), 0,  &C_HARDCLOCK)  &define  &pause_sig( &wmesg,  &timo)  &pause_sbt(( &wmesg),  &tick_sbt * ( &timo), 0,  &C_HARDCLOCK |  &C_CATCH)  &define  &tsleep( &chan,  &pri,  &wmesg,  &timo)  &_sleep(( &chan),  &NULL, ( &pri), ( &wmesg),  &tick_sbt * ( &timo), 0,  &C_HARDCLOCK)  &define  &tsleep_sbt( &chan,  &pri,  &wmesg,  &bt,  &pr,  &flags)  &_sleep(( &chan),  &NULL, ( &pri), ( &wmesg), ( &bt), ( &pr), ( &flags))  &void  &wakeup( &void *  &chan);  &void  &wakeup_one( &void *  &chan);  &void  &wakeup_any( &void *  &chan); \'struct cdev\';  &dev_t  &dev2udev(\'struct cdev\' * &x);  &const \'char\' * &devtoname(\'struct cdev\' * &cdev); \'int\'  &poll_no_poll(\'int\'  &events);  &void  &DELAY(\'int\'  &usec); \'struct root_hold_token\'; \'struct root_hold_token\' * &root_mount_hold( &const \'char\' * &identifier);  &void  &root_mount_rel(\'struct root_hold_token\' * &h); \'int\'  &root_mounted( &void); \'struct unrhdr\'; \'struct unrhdr\' * &new_unrhdr(\'int\'  &low, \'int\'  &high, \'struct mtx\' * &mutex);  &void  &init_unrhdr(\'struct unrhdr\' * &uh, \'int\'  &low, \'int\'  &high, \'struct mtx\' * &mutex);  &void  &delete_unrhdr(\'struct unrhdr\' * &uh);  &void  &clear_unrhdr(\'struct unrhdr\' * &uh);  &void  &clean_unrhdr(\'struct unrhdr\' * &uh);  &void  &clean_unrhdrl(\'struct unrhdr\' * &uh); \'int\'  &alloc_unr(\'struct unrhdr\' * &uh); \'int\'  &alloc_unr_specific(\'struct unrhdr\' * &uh, \'u_int\'  &item); \'int\'  &alloc_unrl(\'struct unrhdr\' * &uh);  &void  &free_unr(\'struct unrhdr\' * &uh, \'u_int\'  &item); \'struct unrhdr64\' {  &uint64_t  &counter; };);
    }' unless defined(&splx);
    eval 'sub new_unrhdr64 {
        my($unr64,$low) = @_;
	    eval q({  ($unr64->{counter}) = $low; });
    }' unless defined(&new_unrhdr64);
    if(defined(&UNR64_LOCKED)) {
    } else {
	eval 'sub alloc_unr64 {
	    my($unr64) = @_;
    	    eval q({ ( &atomic_fetchadd_64( ($unr64->{counter}), 1)); });
	}' unless defined(&alloc_unr64);
    }
    if(defined(&NO_OBSOLETE_CODE)) {
	eval 'sub __gone_ok {
	    my($m, $msg) = @_;
    	    eval q( &_Static_assert($m <  &P_OSREL_MAJOR( &__FreeBSD_version)), \\"Obsolete code\\" $msg););
	}' unless defined(&__gone_ok);
    } else {
	eval 'sub __gone_ok {
	    my($m, $msg) = @_;
    	    eval q();
	}' unless defined(&__gone_ok);
    }
    eval 'sub gone_in {
        my($major, $msg) = @_;
	    eval q( &__gone_ok($major, $msg)  &_gone_in($major, $msg));
    }' unless defined(&gone_in);
    eval 'sub gone_in_dev {
        my($dev, $major, $msg) = @_;
	    eval q( &__gone_ok($major, $msg)  &_gone_in_dev($dev, $major, $msg));
    }' unless defined(&gone_in_dev);
    eval 'sub gone_by_fcp101_dev {
        my($dev) = @_;
	    eval q( &gone_in_dev(($dev), 13, \\"see https://github.com/freebsd/fcp/blob/master/fcp-0101.md\\"));
    }' unless defined(&gone_by_fcp101_dev);
}
1;
