<?php

/*
    Copyright (C) 2017 Fabian Franz
    All rights reserved.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
    INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
    CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
    POSSIBILITY OF SUCH DAMAGE.
*/

function ospfd_enabled()
{
    $model = new \OPNsense\Quagga\OSPF();
    if ((string)$model->enabled == '1') {
        return true;
    }

    return false;
}

function frr_firewall($fw)
{
    if (ospfd_enabled()) {
        $ospf = new \OPNsense\Quagga\OSPF();
        foreach ($ospf->networks->network->__items as $network) {
            if ((string)$network->enabled == '1') {
                $fw->registerFilterRule(
                    1, /* priority */
                    array(
                        'ipprotocol'     => 'inet',
                        'protocol'       => 'ospf',
                        'statetype'      => 'keep',
                        'label'          => 'Pass OSPF (autogenerated)',
                        'from'           => $network->ipaddr . '/' . $network->netmask,
                        'to'             => '224.0.0.0/4',
                        'direction'      => 'in',
                        'type'           => 'pass',
                        'disablereplyto' => 1,
                        'quick'          => true
                    ),
                    null
                );
                $fw->registerFilterRule(
                    1, /* priority */
                    array(
                        'ipprotocol'     => 'inet',
                        'protocol'       => 'ospf',
                        'statetype'      => 'keep',
                        'label'          => 'Pass OSPF UNICAST (autogenerated)',
                        'from'           => $network->ipaddr . '/' . $network->netmask,
                        'to'             => '(self)',
                        'direction'      => 'in',
                        'type'           => 'pass',
                        'disablereplyto' => 1,
                        'quick'          => true
                    ),
                    null
                );
            }
        }
    }
}

function frr_services()
{
    global $config;

    $services = array();

    if (isset($config['OPNsense']['quagga']['general']['enabled']) &&
        $config['OPNsense']['quagga']['general']['enabled'] == 1) {
        $services[] = array(
            'description' => gettext('FRRouting Daemon'),
            'configd' => array(
                'restart' => array('quagga restart'),
                'start' => array('quagga start'),
                'stop' => array('quagga stop'),
            ),
            'name' => 'frr',
            'pidfile' => '/var/run/frr/zebra.pid'
        );
    }

    return $services;
}
