# $Revision$

#    SAM-QFS_notice_begin
#
#      Solaris 2.x Sun Storage & Archiving Management File System
#
#               Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
#
#               U.S. Government Rights - Commercial software. Government users are
#       subject to the Sun Microsystems, Inc. standard license agreement and applicable
#       provisions of the FAR and its supplements.
#
#       Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
#       are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
#       and other countries.
#
#    SAM-QFS_notice_end
#
#
#       LGPL NOTICE
#
#       This library is free software; you can redistribute it and/or
#       modify it under the terms of the GNU Lesser General Public
#       License as published by the Free Software Foundation; either
#       version 2.1 of the License, or (at your option) any later version.
#
#       This library is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#       Lesser General Public License for more details.
#
#       You should have received a copy of the GNU Lesser General Public
#       License along with this library; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#	linux.mk - definitions for a Linux build environment

MSGDEST = $(BASEDIR)/usr/share/locale/C/LC_MESSAGES

LINUX_KERNEL := $(shell uname -r)
LINUX_INCLUDE = /lib/modules/$(LINUX_KERNEL)/build/include
LINUX_CONFIG = /lib/modules/$(LINUX_KERNEL)/build/.config
LINUX_KERNEL_SAMFS = /lib/modules/$(LINUX_KERNEL)/kernel/fs/samfs

PROC = $(shell uname -m)

ATHLON=
CPU_CHECK := $(shell grep AMD /proc/cpuinfo)
ifdef CPU_CHECK
ifneq (x86_64, ${PROC})
ATHLON= _athlon
endif
endif
OS_CHECK := $(shell grep -is suse /etc/issue)
ifndef OS_CHECK
OSFLAGS= -DRHE_LINUX
export OS_TYPE=redhat${ATHLON}
else
OSFLAGS= -DSUSE_LINUX
export OS_TYPE=suse${ATHLON}
endif
OSFLAGS += -D${PROC}
ifeq (x86_64, ${PROC})
OSFLAGS += -D_ASM_X86_64_SIGCONTEXT_H -mno-red-zone
endif

OS_ARCH= $(OS)_$(OS_TYPE)_$(LINUX_KERNEL)_$(PROC)
export OS_ARCH

KERNEL_UNCLEAN=$(subst SMP,smp,$(LINUX_KERNEL))
export KERNEL_UNCLEAN
KERNEL_MAJOR= $(shell uname -r | cut -d- -f1 - | cut -d. -f2)
OSFLAGS += -DKERNEL_MAJOR=$(KERNEL_MAJOR)
KERNEL_MINOR= $(shell uname -r | cut -d- -f1 - | cut -d. -f3)
OSFLAGS += -DKERNEL_MINOR=$(KERNEL_MINOR)

LIBSO_OPT = -Wl,-R
STATIC_OPT = -Wl,-Bstatic
DYNAMIC_OPT = -Wl,-Bdynamic
SHARED_CFLAGS = -fPIC -shared
DEPCFLAGS = -I$(DEPTH)/include $(OSFLAGS) -I$(LINUX_INCLUDE)

CMDECHO = /bin/echo
CMDWHOAMI = /usr/bin/whoami
CMDMCS = echo mcs 

CC = /usr/bin/gcc
GCC = /usr/bin/gcc
LD = $(CC)
AWK = /bin/awk
PERL= $(shell which perl)
MAKEDEPEND = /usr/X11R6/bin/makedepend -Dlinux
LINT = echo lint
INSTALL = /usr/bin/install

#
# mcs definitions
#
MCSOPT = $(shell echo "-c -a '@(=)Copyright (c) `/bin/date +%Y`, Sun Microsystems, Inc.  All Rights Reserved' -a '@(=)Built `/bin/date +%D` by `$(CMDWHOAMI)` on `/bin/uname -n` `/bin/uname -s` `/bin/uname -r`.'" | /usr/bin/tr = '\043')
MCS = $(CMDMCS) $(MCSOPT)


