#ifndef	_SAMIOC_H
#define	_SAMIOC_H

#ifdef sun
#pragma ident "$Revision$"
#endif

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Definitions needed for the ioctl() interface that implements
 * the SAMFS system call.
 */

#ifdef	linux

#ifndef	__KERNEL__
#include <sys/ioctl.h>
#endif	/* __KERNEL__ */

struct sam_syscall_args {
	long cmd;
	void *buf;
	long size;
};

#define	SAMSYS_CDEV		"samsys"
#define	SAMSYS_CDEV_NAME	"/proc/fs/samfs/samsys"

/*
 * The major device number of /proc/fs/samfs/samsys
 * is dynamically assigned when it registers
 */
#define	SAMSYS_IOCTL		's'
#define	SAMSYS_IOC_NULL		_IO(SAMSYS_IOCTL, 0)
#define	SAMSYS_IOC_SAM_SYSCALL	_IO(SAMSYS_IOCTL, 1)

#else /* linux */

#define	SAMDEV			"/devices/pseudo/samioc@0:syscall"
#define	SAMDEV_CMD		0

struct sam_syscall_args {
	int	cmd;
	void	*buf;
	int	size;
};

#endif	/* linux */

#endif	/* _SAMIOC_H */
