/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.internal.ui.viewsupport.ColoredJavaElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.jdt.internal.ui.viewsupport.IRichLabelProvider;
import org.eclipse.jdt.junit.model.ITestCaseElement;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jdt.junit.model.ITestRunSession;
import org.eclipse.jdt.junit.model.ITestSuiteElement;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TestSessionLabelProvider
extends LabelProvider
implements IRichLabelProvider {
    private final TestRunnerViewPart fTestRunnerPart;
    private final int fLayoutMode;

    public TestSessionLabelProvider(TestRunnerViewPart testRunnerPart, int layoutMode) {
        this.fTestRunnerPart = testRunnerPart;
        this.fLayoutMode = layoutMode;
    }

    public ColoredString getRichTextLabel(Object element) {
        String label = this.getSimpleLabel(element);
        if (label == null) {
            return new ColoredString(element.toString());
        }
        ColoredString text = new ColoredString(label);
        if (this.fLayoutMode == 1) {
            String testKindDisplayName;
            if (((ITestElement)element).getParentContainer() instanceof ITestRunSession && (testKindDisplayName = this.fTestRunnerPart.getTestKindDisplayName()) != null) {
                String decorated = Messages.format(JUnitMessages.TestSessionLabelProvider_testName_JUnitVersion, new Object[]{label, testKindDisplayName});
                return ColoredJavaElementLabels.decorateColoredString((ColoredString)text, (String)decorated, (ColoredString.Style)ColoredJavaElementLabels.QUALIFIER_STYLE);
            }
        } else if (element instanceof ITestCaseElement) {
            String className = ((ITestCaseElement)element).getTestClassName();
            String decorated = Messages.format(JUnitMessages.TestSessionLabelProvider_testMethodName_className, new Object[]{label, className});
            return ColoredJavaElementLabels.decorateColoredString((ColoredString)text, (String)decorated, (ColoredString.Style)ColoredJavaElementLabels.QUALIFIER_STYLE);
        }
        return text;
    }

    private String getSimpleLabel(Object element) {
        if (element instanceof ITestCaseElement) {
            return ((ITestCaseElement)element).getTestMethodName();
        }
        if (element instanceof ITestSuiteElement) {
            return ((ITestSuiteElement)element).getSuiteTypeName();
        }
        return null;
    }

    public String getText(Object element) {
        String label = this.getSimpleLabel(element);
        if (label == null) {
            return element.toString();
        }
        if (this.fLayoutMode == 1) {
            String testKindDisplayName;
            if (((ITestElement)element).getParentContainer() instanceof ITestRunSession && (testKindDisplayName = this.fTestRunnerPart.getTestKindDisplayName()) != null) {
                return Messages.format(JUnitMessages.TestSessionLabelProvider_testName_JUnitVersion, new Object[]{label, testKindDisplayName});
            }
        } else if (element instanceof ITestCaseElement) {
            String className = ((ITestCaseElement)element).getTestClassName();
            return Messages.format(JUnitMessages.TestSessionLabelProvider_testMethodName_className, new Object[]{label, className});
        }
        return label;
    }

    public Image getImage(Object element) {
        if (element instanceof TestCaseElement) {
            TestCaseElement testCaseElement = (TestCaseElement)element;
            if (testCaseElement.isIgnored()) {
                return this.fTestRunnerPart.fTestIgnoredIcon;
            }
            TestElement.Status status = testCaseElement.getStatus();
            if (status.isNotRun()) {
                return this.fTestRunnerPart.fTestIcon;
            }
            if (status.isRunning()) {
                return this.fTestRunnerPart.fTestRunningIcon;
            }
            if (status.isError()) {
                return this.fTestRunnerPart.fTestErrorIcon;
            }
            if (status.isFailure()) {
                return this.fTestRunnerPart.fTestFailIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fTestOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        if (element instanceof TestSuiteElement) {
            TestElement.Status status = ((TestSuiteElement)element).getStatus();
            if (status.isNotRun()) {
                return this.fTestRunnerPart.fSuiteIcon;
            }
            if (status.isRunning()) {
                return this.fTestRunnerPart.fSuiteRunningIcon;
            }
            if (status.isError()) {
                return this.fTestRunnerPart.fSuiteErrorIcon;
            }
            if (status.isFailure()) {
                return this.fTestRunnerPart.fSuiteFailIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fSuiteOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        throw new IllegalArgumentException(String.valueOf(element));
    }
}

