/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.OccurrencesGroupKey;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.text.Match;

public class OccurrencesFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String IS_WRITEACCESS = "writeAccess";
    public static final String IS_VARIABLE = "variable";
    private CompilationUnit fRoot;
    private Name fSelectedNode;
    private IBinding fTarget;
    private List fUsages = new ArrayList();
    private List fWriteUsages = new ArrayList();
    private boolean fTargetIsStaticMethodImport;

    public OccurrencesFinder(IBinding target) {
        super(true);
        this.fTarget = target;
    }

    public OccurrencesFinder() {
        super(true);
    }

    public String initialize(CompilationUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, offset, length));
    }

    public String initialize(CompilationUnit root, ASTNode node) {
        if (!(node instanceof Name)) {
            return SearchMessages.OccurrencesFinder_no_element;
        }
        this.fRoot = root;
        this.fSelectedNode = (Name)node;
        this.fTarget = this.fSelectedNode.resolveBinding();
        if (this.fTarget == null) {
            return SearchMessages.OccurrencesFinder_no_binding;
        }
        this.fTarget = this.getBindingDeclaration(this.fTarget);
        this.fTargetIsStaticMethodImport = OccurrencesFinder.isStaticImport(this.fSelectedNode.getParent());
        return null;
    }

    public List perform() {
        this.fRoot.accept((ASTVisitor)this);
        return this.fUsages;
    }

    public void collectOccurrenceMatches(IJavaElement element, IDocument document, Collection resultingMatches) {
        boolean isVariable = this.fTarget instanceof IVariableBinding;
        HashMap<Integer, OccurrencesGroupKey> lineToGroup = new HashMap<Integer, OccurrencesGroupKey>();
        Iterator iter = this.fUsages.iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            int startPosition = node.getStartPosition();
            int length = node.getLength();
            try {
                boolean isWriteAccess = this.fWriteUsages.contains(node);
                int line = document.getLineOfOffset(startPosition);
                Integer lineInteger = new Integer(line);
                OccurrencesGroupKey groupKey = (OccurrencesGroupKey)lineToGroup.get(lineInteger);
                if (groupKey == null) {
                    IRegion region = document.getLineInformation(line);
                    String lineContents = document.get(region.getOffset(), region.getLength()).trim();
                    groupKey = new OccurrencesGroupKey(element, line, lineContents, isWriteAccess, isVariable);
                    lineToGroup.put(lineInteger, groupKey);
                } else if (isWriteAccess) {
                    groupKey.setWriteAccess(true);
                }
                Match match = new Match((Object)groupKey, startPosition, length);
                resultingMatches.add(match);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public String getJobLabel() {
        return SearchMessages.OccurrencesFinder_searchfor;
    }

    public String getElementName() {
        if (this.fSelectedNode != null) {
            return ASTNodes.asString((ASTNode)this.fSelectedNode);
        }
        return null;
    }

    public String getUnformattedPluralLabel() {
        return SearchMessages.OccurrencesFinder_label_plural;
    }

    public String getUnformattedSingularLabel() {
        return SearchMessages.OccurrencesFinder_label_singular;
    }

    public boolean visit(QualifiedName node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding && ((IVariableBinding)binding).isField()) {
            SimpleName name = node.getName();
            return !this.match((Name)name, this.fUsages, name.resolveBinding());
        }
        if (binding instanceof IMethodBinding && OccurrencesFinder.isStaticImport((ASTNode)node)) {
            SimpleName name = node.getName();
            return !this.matchStaticImport((Name)name, this.fUsages, (IMethodBinding)binding);
        }
        return !this.match((Name)node, this.fUsages, binding);
    }

    private static boolean isStaticImport(ASTNode node) {
        if (!(node instanceof QualifiedName)) {
            return false;
        }
        ASTNode parent = ((QualifiedName)node).getParent();
        return parent instanceof ImportDeclaration && ((ImportDeclaration)parent).isStatic();
    }

    public boolean visit(MethodInvocation node) {
        if (this.fTargetIsStaticMethodImport) {
            return !this.matchStaticImport((Name)node.getName(), this.fUsages, node.resolveMethodBinding());
        }
        return true;
    }

    public boolean visit(SimpleName node) {
        return !this.match((Name)node, this.fUsages, node.resolveBinding());
    }

    public boolean visit(ClassInstanceCreation node) {
        Type type = node.getType();
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getType();
        }
        if (type instanceof SimpleType) {
            Name name = ((SimpleType)type).getName();
            if (name instanceof QualifiedName) {
                name = ((QualifiedName)name).getName();
            }
            this.match(name, this.fUsages, (IBinding)node.resolveConstructorBinding());
        }
        return super.visit(node);
    }

    public boolean visit(Assignment node) {
        Expression lhs = node.getLeftHandSide();
        SimpleName name = this.getSimpleName(lhs);
        if (name != null) {
            this.match((Name)name, this.fWriteUsages, name.resolveBinding());
        }
        lhs.accept((ASTVisitor)this);
        node.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        this.match((Name)node.getName(), this.fWriteUsages, (IBinding)node.resolveBinding());
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (node.getParent().getNodeType() == 23 || node.getInitializer() != null) {
            this.match((Name)node.getName(), this.fWriteUsages, (IBinding)node.resolveBinding());
        }
        return super.visit(node);
    }

    public boolean visit(PrefixExpression node) {
        Expression operand;
        SimpleName name;
        PrefixExpression.Operator operator = node.getOperator();
        if ((operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) && (name = this.getSimpleName(operand = node.getOperand())) != null) {
            this.match((Name)name, this.fWriteUsages, name.resolveBinding());
        }
        return super.visit(node);
    }

    public boolean visit(PostfixExpression node) {
        Expression operand = node.getOperand();
        SimpleName name = this.getSimpleName(operand);
        if (name != null) {
            this.match((Name)name, this.fWriteUsages, name.resolveBinding());
        }
        return super.visit(node);
    }

    private boolean match(Name node, List result, IBinding binding) {
        if (binding != null && Bindings.equals(this.getBindingDeclaration(binding), this.fTarget)) {
            result.add(node);
            return true;
        }
        return false;
    }

    private boolean matchStaticImport(Name node, List result, IMethodBinding binding) {
        if (binding == null || node == null || !(this.fTarget instanceof IMethodBinding) || !Modifier.isStatic((int)binding.getModifiers())) {
            return false;
        }
        IMethodBinding targetMethodBinding = (IMethodBinding)this.fTarget;
        if ((this.fTargetIsStaticMethodImport || Modifier.isStatic((int)targetMethodBinding.getModifiers())) && targetMethodBinding.getDeclaringClass().getTypeDeclaration() == binding.getDeclaringClass().getTypeDeclaration() && node.getFullyQualifiedName().equals(targetMethodBinding.getName())) {
            result.add(node);
            return true;
        }
        return false;
    }

    private SimpleName getSimpleName(Expression expression) {
        if (expression instanceof SimpleName) {
            return (SimpleName)expression;
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).getName();
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getName();
        }
        return null;
    }

    private IBinding getBindingDeclaration(IBinding binding) {
        switch (binding.getKind()) {
            case 2: {
                return ((ITypeBinding)binding).getTypeDeclaration();
            }
            case 4: {
                return ((IMethodBinding)binding).getMethodDeclaration();
            }
            case 3: {
                return ((IVariableBinding)binding).getVariableDeclaration();
            }
        }
        return binding;
    }
}

