"use strict"
var os = require("os")

var hasUnicode = module.exports = function () {
  // Recent Win32 platforms (>XP) CAN support unicode in the console but
  // don't have to, and in non-english locales often use traditional local
  // code pages. There's no way, short of windows system calls or execing
  // the chcp command line program to figure this out. As such, we default
  // this to false and encourage your users to override it via config if
  // appropriate.
  if (os.type() == "Windows_NT") { return false }

  var isUTF8 = /[.]UTF-8/
  if (isUTF8.test(process.env.LC_ALL)
   || process.env.LC_CTYPE == 'UTF-8'
   || isUTF8.test(process.env.LANG)) {
    return true
  }

  return false
}
